/*
Copyright (c) 1994 - 2010, Lawrence Livermore National Security, LLC.
LLNL-CODE-425250.
All rights reserved.

This file is part of Silo. For details, see silo.llnl.gov.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the disclaimer below.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the disclaimer (as noted
     below) in the documentation and/or other materials provided with
     the distribution.
   * Neither the name of the LLNS/LLNL nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

THIS SOFTWARE  IS PROVIDED BY  THE COPYRIGHT HOLDERS  AND CONTRIBUTORS
"AS  IS" AND  ANY EXPRESS  OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT
LIMITED TO, THE IMPLIED  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A  PARTICULAR  PURPOSE ARE  DISCLAIMED.  IN  NO  EVENT SHALL  LAWRENCE
LIVERMORE  NATIONAL SECURITY, LLC,  THE U.S.  DEPARTMENT OF  ENERGY OR
CONTRIBUTORS BE LIABLE FOR  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR  CONSEQUENTIAL DAMAGES  (INCLUDING, BUT NOT  LIMITED TO,
PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS  OF USE,  DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER  IN CONTRACT, STRICT LIABILITY,  OR TORT (INCLUDING
NEGLIGENCE OR  OTHERWISE) ARISING IN  ANY WAY OUT  OF THE USE  OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This work was produced at Lawrence Livermore National Laboratory under
Contract No.  DE-AC52-07NA27344 with the DOE.

Neither the  United States Government nor  Lawrence Livermore National
Security, LLC nor any of  their employees, makes any warranty, express
or  implied,  or  assumes  any  liability or  responsibility  for  the
accuracy, completeness,  or usefulness of  any information, apparatus,
product, or  process disclosed, or  represents that its use  would not
infringe privately-owned rights.

Any reference herein to  any specific commercial products, process, or
services by trade name,  trademark, manufacturer or otherwise does not
necessarily  constitute or imply  its endorsement,  recommendation, or
favoring  by  the  United  States  Government  or  Lawrence  Livermore
National Security,  LLC. The views  and opinions of  authors expressed
herein do not necessarily state  or reflect those of the United States
Government or Lawrence Livermore National Security, LLC, and shall not
be used for advertising or product endorsement purposes.
*/

#include <math.h>
#include <string.h>
#include <stdio.h>
#include <silo.h>
#include <stdlib.h>     /* For exit() */
#include <std.c>

/*
 * Data describing the coordinates and zonelist to define a sphere
 * that approximates a globe.
 * 
 * Modifications:
 *    Hank Childs, Wed Feb 16 15:35:56 PST 2005
 *    Prisms and tets are inside out.  Correct them.
 *
 *    Mark C. Miller, Wed Sep  2 16:50:06 PDT 2009
 *    Added logic to free optlist and matnames to satisfy valgrind.
 */
double    coord0 [1093] = {
 -7.27139e-22,  -2.12868e-32,   3.90084e-21,   2.03636e-31,  -4.22923e-21, 
 -5.61463e-32,  -8.94688e-22,    2.3989e-31,   1.32639e-21,  -3.53601e-33, 
  1.82244e-21,             0,             0,      0.515028,      0.979642, 
      1.34836,       1.58509,       1.66667,       1.58509,       1.34836, 
     0.979642,      0.515028,       1.03006,       1.95928,       2.69672, 
      3.17019,       3.33333,       3.17019,       2.69672,       1.95928, 
      1.03006,       1.54508,       2.93893,       4.04508,       4.75528, 
            5,       4.75528,       4.04508,       2.93893,       1.54508, 
      2.06011,       3.91857,       5.39345,       6.34038,       6.66667, 
      6.34038,       5.39345,       3.91857,       2.06011,       2.57514, 
      4.89821,       6.74181,       7.92547,       8.33333,       7.92547, 
      6.74181,       4.89821,       2.57514,       3.09017,       5.87785, 
      8.09017,       9.51057,            10,       9.51057,       8.09017, 
      5.87785,       3.09017,      0.489821,      0.931695,       1.28237, 
      1.50751,       1.58509,       1.50751,       1.28237,      0.931695, 
     0.489821,      0.979642,       1.86339,       2.56474,       3.01503, 
      3.17019,       3.01503,       2.56474,       1.86339,      0.979642, 
      1.46946,       2.79508,        3.8471,       4.52254,       4.75528, 
      4.52254,        3.8471,       2.79508,       1.46946,       1.95928, 
      3.72678,       5.12947,       6.03006,       6.34038,       6.03006, 
      5.12947,       3.72678,       1.95928,       2.44911,       4.65847, 
      6.41184,       7.53757,       7.92547,       7.53757,       6.41184, 
      4.65847,       2.44911,       2.93893,       5.59017,       7.69421, 
      9.04508,       9.51057,       9.04508,       7.69421,       5.59017, 
      2.93893,      0.416667,      0.792547,       1.09085,       1.28237, 
      1.34836,       1.28237,       1.09085,      0.792547,      0.416667, 
     0.833333,       1.58509,       2.18169,       2.56474,       2.69672, 
      2.56474,       2.18169,       1.58509,      0.833333,          1.25, 
      2.37764,       3.27254,        3.8471,       4.04508,        3.8471, 
      3.27254,       2.37764,          1.25,       1.66667,       3.17019, 
      4.36339,       5.12947,       5.39345,       5.12947,       4.36339, 
      3.17019,       1.66667,       2.08333,       3.96274,       5.45424, 
      6.41184,       6.74181,       6.41184,       5.45424,       3.96274, 
      2.08333,           2.5,       4.75528,       6.54508,       7.69421, 
      8.09017,       7.69421,       6.54508,       4.75528,           2.5, 
     0.302726,      0.575819,      0.792547,      0.931695,      0.979642, 
     0.931695,      0.792547,      0.575819,      0.302726,      0.605452, 
      1.15164,       1.58509,       1.86339,       1.95928,       1.86339, 
      1.58509,       1.15164,      0.605452,      0.908178,       1.72746, 
      2.37764,       2.79508,       2.93893,       2.79508,       2.37764, 
      1.72746,      0.908178,        1.2109,       2.30328,       3.17019, 
      3.72678,       3.91857,       3.72678,       3.17019,       2.30328, 
       1.2109,       1.51363,        2.8791,       3.96274,       4.65847, 
      4.89821,       4.65847,       3.96274,        2.8791,       1.51363, 
      1.81636,       3.45492,       4.75528,       5.59017,       5.87785, 
      5.59017,       4.75528,       3.45492,       1.81636,      0.159153, 
     0.302726,      0.416667,      0.489821,      0.515028,      0.489821, 
     0.416667,      0.302726,      0.159153,      0.318305,      0.605452, 
     0.833333,      0.979642,       1.03006,      0.979642,      0.833333, 
     0.605452,      0.318305,      0.477458,      0.908178,          1.25, 
      1.46946,       1.54508,       1.46946,          1.25,      0.908178, 
     0.477458,       0.63661,        1.2109,       1.66667,       1.95928, 
      2.06011,       1.95928,       1.66667,        1.2109,       0.63661, 
     0.795763,       1.51363,       2.08333,       2.44911,       2.57514, 
      2.44911,       2.08333,       1.51363,      0.795763,      0.954915, 
      1.81636,           2.5,       2.93893,       3.09017,       2.93893, 
          2.5,       1.81636,      0.954915,             0,  -9.06379e-31, 
 -1.09754e-30,  -1.86724e-31,             0,   -4.2772e-21,             0, 
 -3.46033e-21,   6.87181e-21,   6.12232e-31,  -9.24877e-31,  -3.35981e-31, 
 -2.85803e-31,  -3.11316e-21,   1.09112e-21,   5.13077e-21,   1.76547e-21, 
 -7.01205e-21,  -2.75224e-31,  -6.92951e-31,   4.02766e-31,  -1.71307e-31, 
            0,   9.81009e-22,   5.76623e-21,   1.58731e-21,   6.30441e-21, 
  6.21749e-31,  -3.13084e-31,   5.68673e-32,   -5.8049e-31,  -3.95194e-21, 
 -1.10808e-21,   3.25657e-21,  -1.79292e-21,   8.90131e-21,   1.99331e-31, 
 -4.01497e-31,             0,  -3.10173e-31,   1.01359e-21,             0, 
 -8.35241e-22,  -1.14961e-21,  -6.84898e-21,             0,             0, 
            0,             0,             0,             0,             0, 
            0,             0,     -0.159153,     -0.302726,     -0.416667, 
    -0.489821,     -0.515028,     -0.489821,     -0.416667,     -0.302726, 
    -0.159153,     -0.318305,     -0.605452,     -0.833333,     -0.979642, 
     -1.03006,     -0.979642,     -0.833333,     -0.605452,     -0.318305, 
    -0.477458,     -0.908178,         -1.25,      -1.46946,      -1.54508, 
     -1.46946,         -1.25,     -0.908178,     -0.477458,      -0.63661, 
      -1.2109,      -1.66667,      -1.95928,      -2.06011,      -1.95928, 
     -1.66667,       -1.2109,      -0.63661,     -0.795763,      -1.51363, 
     -2.08333,      -2.44911,      -2.57514,      -2.44911,      -2.08333, 
     -1.51363,     -0.795763,     -0.954915,      -1.81636,          -2.5, 
     -2.93893,      -3.09017,      -2.93893,          -2.5,      -1.81636, 
    -0.954915,     -0.302726,     -0.575819,     -0.792547,     -0.931695, 
    -0.979642,     -0.931695,     -0.792547,     -0.575819,     -0.302726, 
    -0.605452,      -1.15164,      -1.58509,      -1.86339,      -1.95928, 
     -1.86339,      -1.58509,      -1.15164,     -0.605452,     -0.908178, 
     -1.72746,      -2.37764,      -2.79508,      -2.93893,      -2.79508, 
     -2.37764,      -1.72746,     -0.908178,       -1.2109,      -2.30328, 
     -3.17019,      -3.72678,      -3.91857,      -3.72678,      -3.17019, 
     -2.30328,       -1.2109,      -1.51363,       -2.8791,      -3.96274, 
     -4.65847,      -4.89821,      -4.65847,      -3.96274,       -2.8791, 
     -1.51363,      -1.81636,      -3.45492,      -4.75528,      -5.59017, 
     -5.87785,      -5.59017,      -4.75528,      -3.45492,      -1.81636, 
    -0.416667,     -0.792547,      -1.09085,      -1.28237,      -1.34836, 
     -1.28237,      -1.09085,     -0.792547,     -0.416667,     -0.833333, 
     -1.58509,      -2.18169,      -2.56474,      -2.69672,      -2.56474, 
     -2.18169,      -1.58509,     -0.833333,         -1.25,      -2.37764, 
     -3.27254,       -3.8471,      -4.04508,       -3.8471,      -3.27254, 
     -2.37764,         -1.25,      -1.66667,      -3.17019,      -4.36339, 
     -5.12947,      -5.39345,      -5.12947,      -4.36339,      -3.17019, 
     -1.66667,      -2.08333,      -3.96274,      -5.45424,      -6.41184, 
     -6.74181,      -6.41184,      -5.45424,      -3.96274,      -2.08333, 
         -2.5,      -4.75528,      -6.54508,      -7.69421,      -8.09017, 
     -7.69421,      -6.54508,      -4.75528,          -2.5,     -0.489821, 
    -0.931695,      -1.28237,      -1.50751,      -1.58509,      -1.50751, 
     -1.28237,     -0.931695,     -0.489821,     -0.979642,      -1.86339, 
     -2.56474,      -3.01503,      -3.17019,      -3.01503,      -2.56474, 
     -1.86339,     -0.979642,      -1.46946,      -2.79508,       -3.8471, 
     -4.52254,      -4.75528,      -4.52254,       -3.8471,      -2.79508, 
     -1.46946,      -1.95928,      -3.72678,      -5.12947,      -6.03006, 
     -6.34038,      -6.03006,      -5.12947,      -3.72678,      -1.95928, 
     -2.44911,      -4.65847,      -6.41184,      -7.53757,      -7.92547, 
     -7.53757,      -6.41184,      -4.65847,      -2.44911,      -2.93893, 
     -5.59017,      -7.69421,      -9.04508,      -9.51057,      -9.04508, 
     -7.69421,      -5.59017,      -2.93893,     -0.515028,     -0.979642, 
     -1.34836,      -1.58509,      -1.66667,      -1.58509,      -1.34836, 
    -0.979642,     -0.515028,      -1.03006,      -1.95928,      -2.69672, 
     -3.17019,      -3.33333,      -3.17019,      -2.69672,      -1.95928, 
     -1.03006,      -1.54508,      -2.93893,      -4.04508,      -4.75528, 
           -5,      -4.75528,      -4.04508,      -2.93893,      -1.54508, 
     -2.06011,      -3.91857,      -5.39345,      -6.34038,      -6.66667, 
     -6.34038,      -5.39345,      -3.91857,      -2.06011,      -2.57514, 
     -4.89821,      -6.74181,      -7.92547,      -8.33333,      -7.92547, 
     -6.74181,      -4.89821,      -2.57514,      -3.09017,      -5.87785, 
     -8.09017,      -9.51057,           -10,      -9.51057,      -8.09017, 
     -5.87785,      -3.09017,     -0.489821,     -0.931695,      -1.28237, 
     -1.50751,      -1.58509,      -1.50751,      -1.28237,     -0.931695, 
    -0.489821,     -0.979642,      -1.86339,      -2.56474,      -3.01503, 
     -3.17019,      -3.01503,      -2.56474,      -1.86339,     -0.979642, 
     -1.46946,      -2.79508,       -3.8471,      -4.52254,      -4.75528, 
     -4.52254,       -3.8471,      -2.79508,      -1.46946,      -1.95928, 
     -3.72678,      -5.12947,      -6.03006,      -6.34038,      -6.03006, 
     -5.12947,      -3.72678,      -1.95928,      -2.44911,      -4.65847, 
     -6.41184,      -7.53757,      -7.92547,      -7.53757,      -6.41184, 
     -4.65847,      -2.44911,      -2.93893,      -5.59017,      -7.69421, 
     -9.04508,      -9.51057,      -9.04508,      -7.69421,      -5.59017, 
     -2.93893,     -0.416667,     -0.792547,      -1.09085,      -1.28237, 
     -1.34836,      -1.28237,      -1.09085,     -0.792547,     -0.416667, 
    -0.833333,      -1.58509,      -2.18169,      -2.56474,      -2.69672, 
     -2.56474,      -2.18169,      -1.58509,     -0.833333,         -1.25, 
     -2.37764,      -3.27254,       -3.8471,      -4.04508,       -3.8471, 
     -3.27254,      -2.37764,         -1.25,      -1.66667,      -3.17019, 
     -4.36339,      -5.12947,      -5.39345,      -5.12947,      -4.36339, 
     -3.17019,      -1.66667,      -2.08333,      -3.96274,      -5.45424, 
     -6.41184,      -6.74181,      -6.41184,      -5.45424,      -3.96274, 
     -2.08333,          -2.5,      -4.75528,      -6.54508,      -7.69421, 
     -8.09017,      -7.69421,      -6.54508,      -4.75528,          -2.5, 
    -0.302726,     -0.575819,     -0.792547,     -0.931695,     -0.979642, 
    -0.931695,     -0.792547,     -0.575819,     -0.302726,     -0.605452, 
     -1.15164,      -1.58509,      -1.86339,      -1.95928,      -1.86339, 
     -1.58509,      -1.15164,     -0.605452,     -0.908178,      -1.72746, 
     -2.37764,      -2.79508,      -2.93893,      -2.79508,      -2.37764, 
     -1.72746,     -0.908178,       -1.2109,      -2.30328,      -3.17019, 
     -3.72678,      -3.91857,      -3.72678,      -3.17019,      -2.30328, 
      -1.2109,      -1.51363,       -2.8791,      -3.96274,      -4.65847, 
     -4.89821,      -4.65847,      -3.96274,       -2.8791,      -1.51363, 
     -1.81636,      -3.45492,      -4.75528,      -5.59017,      -5.87785, 
     -5.59017,      -4.75528,      -3.45492,      -1.81636,     -0.159153, 
    -0.302726,     -0.416667,     -0.489821,     -0.515028,     -0.489821, 
    -0.416667,     -0.302726,     -0.159153,     -0.318305,     -0.605452, 
    -0.833333,     -0.979642,      -1.03006,     -0.979642,     -0.833333, 
    -0.605452,     -0.318305,     -0.477458,     -0.908178,         -1.25, 
     -1.46946,      -1.54508,      -1.46946,         -1.25,     -0.908178, 
    -0.477458,      -0.63661,       -1.2109,      -1.66667,      -1.95928, 
     -2.06011,      -1.95928,      -1.66667,       -1.2109,      -0.63661, 
    -0.795763,      -1.51363,      -2.08333,      -2.44911,      -2.57514, 
     -2.44911,      -2.08333,      -1.51363,     -0.795763,     -0.954915, 
     -1.81636,          -2.5,      -2.93893,      -3.09017,      -2.93893, 
         -2.5,      -1.81636,     -0.954915,             0,   9.06379e-31, 
  1.09754e-30,   1.86724e-31,             0,    4.2772e-21,             0, 
  3.46033e-21,  -6.87181e-21,  -6.12232e-31,   9.24877e-31,   3.35981e-31, 
  2.85803e-31,   3.11316e-21,  -1.09112e-21,  -5.13077e-21,  -1.76547e-21, 
  7.01205e-21,   2.75224e-31,   6.92951e-31,  -4.02766e-31,   1.71307e-31, 
            0,  -9.81009e-22,  -5.76623e-21,  -1.58731e-21,  -6.30441e-21, 
 -6.21749e-31,   3.13084e-31,  -5.68673e-32,    5.8049e-31,   3.95194e-21, 
  1.10808e-21,  -3.25657e-21,   1.79292e-21,  -8.90131e-21,  -1.99331e-31, 
  4.01497e-31,             0,   3.10173e-31,  -1.01359e-21,             0, 
  8.35241e-22,   1.14961e-21,   6.84898e-21,             0,             0, 
            0,             0,             0,             0,             0, 
            0,             0,      0.159153,      0.302726,      0.416667, 
     0.489821,      0.515028,      0.489821,      0.416667,      0.302726, 
     0.159153,      0.318305,      0.605452,      0.833333,      0.979642, 
      1.03006,      0.979642,      0.833333,      0.605452,      0.318305, 
     0.477458,      0.908178,          1.25,       1.46946,       1.54508, 
      1.46946,          1.25,      0.908178,      0.477458,       0.63661, 
       1.2109,       1.66667,       1.95928,       2.06011,       1.95928, 
      1.66667,        1.2109,       0.63661,      0.795763,       1.51363, 
      2.08333,       2.44911,       2.57514,       2.44911,       2.08333, 
      1.51363,      0.795763,      0.954915,       1.81636,           2.5, 
      2.93893,       3.09017,       2.93893,           2.5,       1.81636, 
     0.954915,      0.302726,      0.575819,      0.792547,      0.931695, 
     0.979642,      0.931695,      0.792547,      0.575819,      0.302726, 
     0.605452,       1.15164,       1.58509,       1.86339,       1.95928, 
      1.86339,       1.58509,       1.15164,      0.605452,      0.908178, 
      1.72746,       2.37764,       2.79508,       2.93893,       2.79508, 
      2.37764,       1.72746,      0.908178,        1.2109,       2.30328, 
      3.17019,       3.72678,       3.91857,       3.72678,       3.17019, 
      2.30328,        1.2109,       1.51363,        2.8791,       3.96274, 
      4.65847,       4.89821,       4.65847,       3.96274,        2.8791, 
      1.51363,       1.81636,       3.45492,       4.75528,       5.59017, 
      5.87785,       5.59017,       4.75528,       3.45492,       1.81636, 
     0.416667,      0.792547,       1.09085,       1.28237,       1.34836, 
      1.28237,       1.09085,      0.792547,      0.416667,      0.833333, 
      1.58509,       2.18169,       2.56474,       2.69672,       2.56474, 
      2.18169,       1.58509,      0.833333,          1.25,       2.37764, 
      3.27254,        3.8471,       4.04508,        3.8471,       3.27254, 
      2.37764,          1.25,       1.66667,       3.17019,       4.36339, 
      5.12947,       5.39345,       5.12947,       4.36339,       3.17019, 
      1.66667,       2.08333,       3.96274,       5.45424,       6.41184, 
      6.74181,       6.41184,       5.45424,       3.96274,       2.08333, 
          2.5,       4.75528,       6.54508,       7.69421,       8.09017, 
      7.69421,       6.54508,       4.75528,           2.5,      0.489821, 
     0.931695,       1.28237,       1.50751,       1.58509,       1.50751, 
      1.28237,      0.931695,      0.489821,      0.979642,       1.86339, 
      2.56474,       3.01503,       3.17019,       3.01503,       2.56474, 
      1.86339,      0.979642,       1.46946,       2.79508,        3.8471, 
      4.52254,       4.75528,       4.52254,        3.8471,       2.79508, 
      1.46946,       1.95928,       3.72678,       5.12947,       6.03006, 
      6.34038,       6.03006,       5.12947,       3.72678,       1.95928, 
      2.44911,       4.65847,       6.41184,       7.53757,       7.92547, 
      7.53757,       6.41184,       4.65847,       2.44911,       2.93893, 
      5.59017,       7.69421,       9.04508,       9.51057,       9.04508, 
      7.69421,       5.59017,       2.93893, 
};

double    coord1 [1093] = {
  4.02723e-21,  -2.63823e-30,  -1.36529e-20,  -3.64509e-31,  -3.48289e-21, 
  9.21531e-32,  -5.81547e-21,   3.51562e-32,  -8.58993e-21,   5.11837e-31, 
  2.42993e-21,             0,             0,   9.56231e-31,   2.26595e-31, 
  1.23473e-30,   9.33622e-32,  -3.81362e-21,   6.14848e-21,  -7.85649e-22, 
  6.37998e-21,   2.47224e-20,    1.2149e-30,   7.70731e-31,   5.03972e-31, 
  5.71605e-31,  -2.33487e-21,   4.09171e-21,   2.40505e-21,   1.04825e-21, 
  3.30059e-20,   2.58022e-31,   3.46475e-32,   2.76902e-31,  -1.71307e-31, 
            0,   9.81009e-22,   3.17143e-21,   5.55557e-21,  -2.95519e-22, 
  3.40019e-31,   7.82711e-32,   2.55903e-31,   6.77239e-31,   7.90387e-22, 
  8.31062e-22,  -5.69901e-22,   2.63335e-21,   6.74552e-21,  -4.98329e-32, 
            0,   7.29261e-32,   2.17121e-31,   1.26698e-21,   7.10499e-22, 
 -1.04405e-21,  -2.87403e-22,   2.72889e-21,             0,             0, 
            0,             0,             0,             0,             0, 
            0,             0,      0.159153,      0.302726,      0.416667, 
     0.489821,      0.515028,      0.489821,      0.416667,      0.302726, 
     0.159153,      0.318305,      0.605452,      0.833333,      0.979642, 
      1.03006,      0.979642,      0.833333,      0.605452,      0.318305, 
     0.477458,      0.908178,          1.25,       1.46946,       1.54508, 
      1.46946,          1.25,      0.908178,      0.477458,       0.63661, 
       1.2109,       1.66667,       1.95928,       2.06011,       1.95928, 
      1.66667,        1.2109,       0.63661,      0.795763,       1.51363, 
      2.08333,       2.44911,       2.57514,       2.44911,       2.08333, 
      1.51363,      0.795763,      0.954915,       1.81636,           2.5, 
      2.93893,       3.09017,       2.93893,           2.5,       1.81636, 
     0.954915,      0.302726,      0.575819,      0.792547,      0.931695, 
     0.979642,      0.931695,      0.792547,      0.575819,      0.302726, 
     0.605452,       1.15164,       1.58509,       1.86339,       1.95928, 
      1.86339,       1.58509,       1.15164,      0.605452,      0.908178, 
      1.72746,       2.37764,       2.79508,       2.93893,       2.79508, 
      2.37764,       1.72746,      0.908178,        1.2109,       2.30328, 
      3.17019,       3.72678,       3.91857,       3.72678,       3.17019, 
      2.30328,        1.2109,       1.51363,        2.8791,       3.96274, 
      4.65847,       4.89821,       4.65847,       3.96274,        2.8791, 
      1.51363,       1.81636,       3.45492,       4.75528,       5.59017, 
      5.87785,       5.59017,       4.75528,       3.45492,       1.81636, 
     0.416667,      0.792547,       1.09085,       1.28237,       1.34836, 
      1.28237,       1.09085,      0.792547,      0.416667,      0.833333, 
      1.58509,       2.18169,       2.56474,       2.69672,       2.56474, 
      2.18169,       1.58509,      0.833333,          1.25,       2.37764, 
      3.27254,        3.8471,       4.04508,        3.8471,       3.27254, 
      2.37764,          1.25,       1.66667,       3.17019,       4.36339, 
      5.12947,       5.39345,       5.12947,       4.36339,       3.17019, 
      1.66667,       2.08333,       3.96274,       5.45424,       6.41184, 
      6.74181,       6.41184,       5.45424,       3.96274,       2.08333, 
          2.5,       4.75528,       6.54508,       7.69421,       8.09017, 
      7.69421,       6.54508,       4.75528,           2.5,      0.489821, 
     0.931695,       1.28237,       1.50751,       1.58509,       1.50751, 
      1.28237,      0.931695,      0.489821,      0.979642,       1.86339, 
      2.56474,       3.01503,       3.17019,       3.01503,       2.56474, 
      1.86339,      0.979642,       1.46946,       2.79508,        3.8471, 
      4.52254,       4.75528,       4.52254,        3.8471,       2.79508, 
      1.46946,       1.95928,       3.72678,       5.12947,       6.03006, 
      6.34038,       6.03006,       5.12947,       3.72678,       1.95928, 
      2.44911,       4.65847,       6.41184,       7.53757,       7.92547, 
      7.53757,       6.41184,       4.65847,       2.44911,       2.93893, 
      5.59017,       7.69421,       9.04508,       9.51057,       9.04508, 
      7.69421,       5.59017,       2.93893,      0.515028,      0.979642, 
      1.34836,       1.58509,       1.66667,       1.58509,       1.34836, 
     0.979642,      0.515028,       1.03006,       1.95928,       2.69672, 
      3.17019,       3.33333,       3.17019,       2.69672,       1.95928, 
      1.03006,       1.54508,       2.93893,       4.04508,       4.75528, 
            5,       4.75528,       4.04508,       2.93893,       1.54508, 
      2.06011,       3.91857,       5.39345,       6.34038,       6.66667, 
      6.34038,       5.39345,       3.91857,       2.06011,       2.57514, 
      4.89821,       6.74181,       7.92547,       8.33333,       7.92547, 
      6.74181,       4.89821,       2.57514,       3.09017,       5.87785, 
      8.09017,       9.51057,            10,       9.51057,       8.09017, 
      5.87785,       3.09017,      0.489821,      0.931695,       1.28237, 
      1.50751,       1.58509,       1.50751,       1.28237,      0.931695, 
     0.489821,      0.979642,       1.86339,       2.56474,       3.01503, 
      3.17019,       3.01503,       2.56474,       1.86339,      0.979642, 
      1.46946,       2.79508,        3.8471,       4.52254,       4.75528, 
      4.52254,        3.8471,       2.79508,       1.46946,       1.95928, 
      3.72678,       5.12947,       6.03006,       6.34038,       6.03006, 
      5.12947,       3.72678,       1.95928,       2.44911,       4.65847, 
      6.41184,       7.53757,       7.92547,       7.53757,       6.41184, 
      4.65847,       2.44911,       2.93893,       5.59017,       7.69421, 
      9.04508,       9.51057,       9.04508,       7.69421,       5.59017, 
      2.93893,      0.416667,      0.792547,       1.09085,       1.28237, 
      1.34836,       1.28237,       1.09085,      0.792547,      0.416667, 
     0.833333,       1.58509,       2.18169,       2.56474,       2.69672, 
      2.56474,       2.18169,       1.58509,      0.833333,          1.25, 
      2.37764,       3.27254,        3.8471,       4.04508,        3.8471, 
      3.27254,       2.37764,          1.25,       1.66667,       3.17019, 
      4.36339,       5.12947,       5.39345,       5.12947,       4.36339, 
      3.17019,       1.66667,       2.08333,       3.96274,       5.45424, 
      6.41184,       6.74181,       6.41184,       5.45424,       3.96274, 
      2.08333,           2.5,       4.75528,       6.54508,       7.69421, 
      8.09017,       7.69421,       6.54508,       4.75528,           2.5, 
     0.302726,      0.575819,      0.792547,      0.931695,      0.979642, 
     0.931695,      0.792547,      0.575819,      0.302726,      0.605452, 
      1.15164,       1.58509,       1.86339,       1.95928,       1.86339, 
      1.58509,       1.15164,      0.605452,      0.908178,       1.72746, 
      2.37764,       2.79508,       2.93893,       2.79508,       2.37764, 
      1.72746,      0.908178,        1.2109,       2.30328,       3.17019, 
      3.72678,       3.91857,       3.72678,       3.17019,       2.30328, 
       1.2109,       1.51363,        2.8791,       3.96274,       4.65847, 
      4.89821,       4.65847,       3.96274,        2.8791,       1.51363, 
      1.81636,       3.45492,       4.75528,       5.59017,       5.87785, 
      5.59017,       4.75528,       3.45492,       1.81636,      0.159153, 
     0.302726,      0.416667,      0.489821,      0.515028,      0.489821, 
     0.416667,      0.302726,      0.159153,      0.318305,      0.605452, 
     0.833333,      0.979642,       1.03006,      0.979642,      0.833333, 
     0.605452,      0.318305,      0.477458,      0.908178,          1.25, 
      1.46946,       1.54508,       1.46946,          1.25,      0.908178, 
     0.477458,       0.63661,        1.2109,       1.66667,       1.95928, 
      2.06011,       1.95928,       1.66667,        1.2109,       0.63661, 
     0.795763,       1.51363,       2.08333,       2.44911,       2.57514, 
      2.44911,       2.08333,       1.51363,      0.795763,      0.954915, 
      1.81636,           2.5,       2.93893,       3.09017,       2.93893, 
          2.5,       1.81636,      0.954915,  -4.19991e-30,             0, 
  8.78031e-31,   9.33622e-31,   3.05089e-21,   1.92474e-20,  -1.00563e-20, 
   2.0762e-20,  -2.06154e-20,   3.06116e-31,  -1.07902e-30,  -7.83956e-31, 
  1.90535e-31,  -4.66974e-21,   5.45561e-21,  -5.13077e-21,   1.76547e-21, 
            0,   5.50448e-31,  -6.92951e-31,  -1.00692e-31,   8.56534e-32, 
            0,   1.96202e-21,   1.15325e-20,  -3.17461e-21,    1.5761e-21, 
 -3.10874e-31,  -6.26169e-31,  -3.98071e-31,  -2.90245e-31,   1.58077e-21, 
 -4.98637e-21,   3.25657e-21,             0,             0,   5.97994e-31, 
 -5.01871e-31,   1.45852e-31,  -1.86104e-31,             0,             0, 
  8.35241e-22,             0,  -6.84898e-21,             0,             0, 
            0,             0,             0,             0,             0, 
            0,             0,     -0.159153,     -0.302726,     -0.416667, 
    -0.489821,     -0.515028,     -0.489821,     -0.416667,     -0.302726, 
    -0.159153,     -0.318305,     -0.605452,     -0.833333,     -0.979642, 
     -1.03006,     -0.979642,     -0.833333,     -0.605452,     -0.318305, 
    -0.477458,     -0.908178,         -1.25,      -1.46946,      -1.54508, 
     -1.46946,         -1.25,     -0.908178,     -0.477458,      -0.63661, 
      -1.2109,      -1.66667,      -1.95928,      -2.06011,      -1.95928, 
     -1.66667,       -1.2109,      -0.63661,     -0.795763,      -1.51363, 
     -2.08333,      -2.44911,      -2.57514,      -2.44911,      -2.08333, 
     -1.51363,     -0.795763,     -0.954915,      -1.81636,          -2.5, 
     -2.93893,      -3.09017,      -2.93893,          -2.5,      -1.81636, 
    -0.954915,     -0.302726,     -0.575819,     -0.792547,     -0.931695, 
    -0.979642,     -0.931695,     -0.792547,     -0.575819,     -0.302726, 
    -0.605452,      -1.15164,      -1.58509,      -1.86339,      -1.95928, 
     -1.86339,      -1.58509,      -1.15164,     -0.605452,     -0.908178, 
     -1.72746,      -2.37764,      -2.79508,      -2.93893,      -2.79508, 
     -2.37764,      -1.72746,     -0.908178,       -1.2109,      -2.30328, 
     -3.17019,      -3.72678,      -3.91857,      -3.72678,      -3.17019, 
     -2.30328,       -1.2109,      -1.51363,       -2.8791,      -3.96274, 
     -4.65847,      -4.89821,      -4.65847,      -3.96274,       -2.8791, 
     -1.51363,      -1.81636,      -3.45492,      -4.75528,      -5.59017, 
     -5.87785,      -5.59017,      -4.75528,      -3.45492,      -1.81636, 
    -0.416667,     -0.792547,      -1.09085,      -1.28237,      -1.34836, 
     -1.28237,      -1.09085,     -0.792547,     -0.416667,     -0.833333, 
     -1.58509,      -2.18169,      -2.56474,      -2.69672,      -2.56474, 
     -2.18169,      -1.58509,     -0.833333,         -1.25,      -2.37764, 
     -3.27254,       -3.8471,      -4.04508,       -3.8471,      -3.27254, 
     -2.37764,         -1.25,      -1.66667,      -3.17019,      -4.36339, 
     -5.12947,      -5.39345,      -5.12947,      -4.36339,      -3.17019, 
     -1.66667,      -2.08333,      -3.96274,      -5.45424,      -6.41184, 
     -6.74181,      -6.41184,      -5.45424,      -3.96274,      -2.08333, 
         -2.5,      -4.75528,      -6.54508,      -7.69421,      -8.09017, 
     -7.69421,      -6.54508,      -4.75528,          -2.5,     -0.489821, 
    -0.931695,      -1.28237,      -1.50751,      -1.58509,      -1.50751, 
     -1.28237,     -0.931695,     -0.489821,     -0.979642,      -1.86339, 
     -2.56474,      -3.01503,      -3.17019,      -3.01503,      -2.56474, 
     -1.86339,     -0.979642,      -1.46946,      -2.79508,       -3.8471, 
     -4.52254,      -4.75528,      -4.52254,       -3.8471,      -2.79508, 
     -1.46946,      -1.95928,      -3.72678,      -5.12947,      -6.03006, 
     -6.34038,      -6.03006,      -5.12947,      -3.72678,      -1.95928, 
     -2.44911,      -4.65847,      -6.41184,      -7.53757,      -7.92547, 
     -7.53757,      -6.41184,      -4.65847,      -2.44911,      -2.93893, 
     -5.59017,      -7.69421,      -9.04508,      -9.51057,      -9.04508, 
     -7.69421,      -5.59017,      -2.93893,     -0.515028,     -0.979642, 
     -1.34836,      -1.58509,      -1.66667,      -1.58509,      -1.34836, 
    -0.979642,     -0.515028,      -1.03006,      -1.95928,      -2.69672, 
     -3.17019,      -3.33333,      -3.17019,      -2.69672,      -1.95928, 
     -1.03006,      -1.54508,      -2.93893,      -4.04508,      -4.75528, 
           -5,      -4.75528,      -4.04508,      -2.93893,      -1.54508, 
     -2.06011,      -3.91857,      -5.39345,      -6.34038,      -6.66667, 
     -6.34038,      -5.39345,      -3.91857,      -2.06011,      -2.57514, 
     -4.89821,      -6.74181,      -7.92547,      -8.33333,      -7.92547, 
     -6.74181,      -4.89821,      -2.57514,      -3.09017,      -5.87785, 
     -8.09017,      -9.51057,           -10,      -9.51057,      -8.09017, 
     -5.87785,      -3.09017,     -0.489821,     -0.931695,      -1.28237, 
     -1.50751,      -1.58509,      -1.50751,      -1.28237,     -0.931695, 
    -0.489821,     -0.979642,      -1.86339,      -2.56474,      -3.01503, 
     -3.17019,      -3.01503,      -2.56474,      -1.86339,     -0.979642, 
     -1.46946,      -2.79508,       -3.8471,      -4.52254,      -4.75528, 
     -4.52254,       -3.8471,      -2.79508,      -1.46946,      -1.95928, 
     -3.72678,      -5.12947,      -6.03006,      -6.34038,      -6.03006, 
     -5.12947,      -3.72678,      -1.95928,      -2.44911,      -4.65847, 
     -6.41184,      -7.53757,      -7.92547,      -7.53757,      -6.41184, 
     -4.65847,      -2.44911,      -2.93893,      -5.59017,      -7.69421, 
     -9.04508,      -9.51057,      -9.04508,      -7.69421,      -5.59017, 
     -2.93893,     -0.416667,     -0.792547,      -1.09085,      -1.28237, 
     -1.34836,      -1.28237,      -1.09085,     -0.792547,     -0.416667, 
    -0.833333,      -1.58509,      -2.18169,      -2.56474,      -2.69672, 
     -2.56474,      -2.18169,      -1.58509,     -0.833333,         -1.25, 
     -2.37764,      -3.27254,       -3.8471,      -4.04508,       -3.8471, 
     -3.27254,      -2.37764,         -1.25,      -1.66667,      -3.17019, 
     -4.36339,      -5.12947,      -5.39345,      -5.12947,      -4.36339, 
     -3.17019,      -1.66667,      -2.08333,      -3.96274,      -5.45424, 
     -6.41184,      -6.74181,      -6.41184,      -5.45424,      -3.96274, 
     -2.08333,          -2.5,      -4.75528,      -6.54508,      -7.69421, 
     -8.09017,      -7.69421,      -6.54508,      -4.75528,          -2.5, 
    -0.302726,     -0.575819,     -0.792547,     -0.931695,     -0.979642, 
    -0.931695,     -0.792547,     -0.575819,     -0.302726,     -0.605452, 
     -1.15164,      -1.58509,      -1.86339,      -1.95928,      -1.86339, 
     -1.58509,      -1.15164,     -0.605452,     -0.908178,      -1.72746, 
     -2.37764,      -2.79508,      -2.93893,      -2.79508,      -2.37764, 
     -1.72746,     -0.908178,       -1.2109,      -2.30328,      -3.17019, 
     -3.72678,      -3.91857,      -3.72678,      -3.17019,      -2.30328, 
      -1.2109,      -1.51363,       -2.8791,      -3.96274,      -4.65847, 
     -4.89821,      -4.65847,      -3.96274,       -2.8791,      -1.51363, 
     -1.81636,      -3.45492,      -4.75528,      -5.59017,      -5.87785, 
     -5.59017,      -4.75528,      -3.45492,      -1.81636,     -0.159153, 
    -0.302726,     -0.416667,     -0.489821,     -0.515028,     -0.489821, 
    -0.416667,     -0.302726,     -0.159153,     -0.318305,     -0.605452, 
    -0.833333,     -0.979642,      -1.03006,     -0.979642,     -0.833333, 
    -0.605452,     -0.318305,     -0.477458,     -0.908178,         -1.25, 
     -1.46946,      -1.54508,      -1.46946,         -1.25,     -0.908178, 
    -0.477458,      -0.63661,       -1.2109,      -1.66667,      -1.95928, 
     -2.06011,      -1.95928,      -1.66667,       -1.2109,      -0.63661, 
    -0.795763,      -1.51363,      -2.08333,      -2.44911,      -2.57514, 
     -2.44911,      -2.08333,      -1.51363,     -0.795763,     -0.954915, 
     -1.81636,          -2.5,      -2.93893,      -3.09017,      -2.93893, 
         -2.5,      -1.81636,     -0.954915, 
};

double    coord2 [1093] = {
  6.15051e-05,       1.66667,      -1.66667,       3.33333,      -3.33333, 
            5,            -5,       6.66667,      -6.66667,       8.33333, 
     -8.33333,            10,           -10,       1.58509,       1.34836, 
     0.979642,      0.515028,   0.000180844,     -0.515028,     -0.979642, 
     -1.34836,      -1.58509,       3.17019,       2.69672,       1.95928, 
      1.03006,   9.62788e-05,      -1.03006,      -1.95928,      -2.69672, 
     -3.17019,       4.75528,       4.04508,       2.93893,       1.54508, 
   6.4922e-05,      -1.54508,      -2.93893,      -4.04508,      -4.75528, 
      6.34038,       5.39345,       3.91857,       2.06011,   4.88877e-05, 
     -2.06011,      -3.91857,      -5.39345,      -6.34038,       7.92547, 
      6.74181,       4.89821,       2.57514,   3.91832e-05,      -2.57514, 
     -4.89821,      -6.74181,      -7.92547,       9.51057,       8.09017, 
      5.87785,       3.09017,   7.10543e-14,      -3.09017,      -5.87785, 
     -8.09017,      -9.51057,       1.58509,       1.34836,      0.979642, 
     0.515028,   0.000180844,     -0.515028,     -0.979642,      -1.34836, 
     -1.58509,       3.17019,       2.69672,       1.95928,       1.03006, 
  9.62788e-05,      -1.03006,      -1.95928,      -2.69672,      -3.17019, 
      4.75528,       4.04508,       2.93893,       1.54508,    6.4922e-05, 
     -1.54508,      -2.93893,      -4.04508,      -4.75528,       6.34038, 
      5.39345,       3.91857,       2.06011,   4.88877e-05,      -2.06011, 
     -3.91857,      -5.39345,      -6.34038,       7.92547,       6.74181, 
      4.89821,       2.57514,   3.91832e-05,      -2.57514,      -4.89821, 
     -6.74181,      -7.92547,       9.51057,       8.09017,       5.87785, 
      3.09017,   7.10543e-14,      -3.09017,      -5.87785,      -8.09017, 
     -9.51057,       1.58509,       1.34836,      0.979642,      0.515028, 
  0.000180844,     -0.515028,     -0.979642,      -1.34836,      -1.58509, 
      3.17019,       2.69672,       1.95928,       1.03006,   9.62788e-05, 
     -1.03006,      -1.95928,      -2.69672,      -3.17019,       4.75528, 
      4.04508,       2.93893,       1.54508,    6.4922e-05,      -1.54508, 
     -2.93893,      -4.04508,      -4.75528,       6.34038,       5.39345, 
      3.91857,       2.06011,   4.88877e-05,      -2.06011,      -3.91857, 
     -5.39345,      -6.34038,       7.92547,       6.74181,       4.89821, 
      2.57514,   3.91832e-05,      -2.57514,      -4.89821,      -6.74181, 
     -7.92547,       9.51057,       8.09017,       5.87785,       3.09017, 
  7.10543e-14,      -3.09017,      -5.87785,      -8.09017,      -9.51057, 
      1.58509,       1.34836,      0.979642,      0.515028,   0.000180844, 
    -0.515028,     -0.979642,      -1.34836,      -1.58509,       3.17019, 
      2.69672,       1.95928,       1.03006,   9.62788e-05,      -1.03006, 
     -1.95928,      -2.69672,      -3.17019,       4.75528,       4.04508, 
      2.93893,       1.54508,    6.4922e-05,      -1.54508,      -2.93893, 
     -4.04508,      -4.75528,       6.34038,       5.39345,       3.91857, 
      2.06011,   4.88877e-05,      -2.06011,      -3.91857,      -5.39345, 
     -6.34038,       7.92547,       6.74181,       4.89821,       2.57514, 
  3.91832e-05,      -2.57514,      -4.89821,      -6.74181,      -7.92547, 
      9.51057,       8.09017,       5.87785,       3.09017,   7.10543e-14, 
     -3.09017,      -5.87785,      -8.09017,      -9.51057,       1.58509, 
      1.34836,      0.979642,      0.515028,   0.000180844,     -0.515028, 
    -0.979642,      -1.34836,      -1.58509,       3.17019,       2.69672, 
      1.95928,       1.03006,   9.62788e-05,      -1.03006,      -1.95928, 
     -2.69672,      -3.17019,       4.75528,       4.04508,       2.93893, 
      1.54508,    6.4922e-05,      -1.54508,      -2.93893,      -4.04508, 
     -4.75528,       6.34038,       5.39345,       3.91857,       2.06011, 
  4.88877e-05,      -2.06011,      -3.91857,      -5.39345,      -6.34038, 
      7.92547,       6.74181,       4.89821,       2.57514,   3.91832e-05, 
     -2.57514,      -4.89821,      -6.74181,      -7.92547,       9.51057, 
      8.09017,       5.87785,       3.09017,   7.10543e-14,      -3.09017, 
     -5.87785,      -8.09017,      -9.51057,       1.58509,       1.34836, 
     0.979642,      0.515028,   0.000180844,     -0.515028,     -0.979642, 
     -1.34836,      -1.58509,       3.17019,       2.69672,       1.95928, 
      1.03006,   9.62788e-05,      -1.03006,      -1.95928,      -2.69672, 
     -3.17019,       4.75528,       4.04508,       2.93893,       1.54508, 
   6.4922e-05,      -1.54508,      -2.93893,      -4.04508,      -4.75528, 
      6.34038,       5.39345,       3.91857,       2.06011,   4.88877e-05, 
     -2.06011,      -3.91857,      -5.39345,      -6.34038,       7.92547, 
      6.74181,       4.89821,       2.57514,   3.91832e-05,      -2.57514, 
     -4.89821,      -6.74181,      -7.92547,       9.51057,       8.09017, 
      5.87785,       3.09017,   7.10543e-14,      -3.09017,      -5.87785, 
     -8.09017,      -9.51057,       1.58509,       1.34836,      0.979642, 
     0.515028,   0.000180844,     -0.515028,     -0.979642,      -1.34836, 
     -1.58509,       3.17019,       2.69672,       1.95928,       1.03006, 
  9.62788e-05,      -1.03006,      -1.95928,      -2.69672,      -3.17019, 
      4.75528,       4.04508,       2.93893,       1.54508,    6.4922e-05, 
     -1.54508,      -2.93893,      -4.04508,      -4.75528,       6.34038, 
      5.39345,       3.91857,       2.06011,   4.88877e-05,      -2.06011, 
     -3.91857,      -5.39345,      -6.34038,       7.92547,       6.74181, 
      4.89821,       2.57514,   3.91832e-05,      -2.57514,      -4.89821, 
     -6.74181,      -7.92547,       9.51057,       8.09017,       5.87785, 
      3.09017,   7.10543e-14,      -3.09017,      -5.87785,      -8.09017, 
     -9.51057,       1.58509,       1.34836,      0.979642,      0.515028, 
  0.000180844,     -0.515028,     -0.979642,      -1.34836,      -1.58509, 
      3.17019,       2.69672,       1.95928,       1.03006,   9.62788e-05, 
     -1.03006,      -1.95928,      -2.69672,      -3.17019,       4.75528, 
      4.04508,       2.93893,       1.54508,    6.4922e-05,      -1.54508, 
     -2.93893,      -4.04508,      -4.75528,       6.34038,       5.39345, 
      3.91857,       2.06011,   4.88877e-05,      -2.06011,      -3.91857, 
     -5.39345,      -6.34038,       7.92547,       6.74181,       4.89821, 
      2.57514,   3.91832e-05,      -2.57514,      -4.89821,      -6.74181, 
     -7.92547,       9.51057,       8.09017,       5.87785,       3.09017, 
  7.10543e-14,      -3.09017,      -5.87785,      -8.09017,      -9.51057, 
      1.58509,       1.34836,      0.979642,      0.515028,   0.000180844, 
    -0.515028,     -0.979642,      -1.34836,      -1.58509,       3.17019, 
      2.69672,       1.95928,       1.03006,   9.62788e-05,      -1.03006, 
     -1.95928,      -2.69672,      -3.17019,       4.75528,       4.04508, 
      2.93893,       1.54508,    6.4922e-05,      -1.54508,      -2.93893, 
     -4.04508,      -4.75528,       6.34038,       5.39345,       3.91857, 
      2.06011,   4.88877e-05,      -2.06011,      -3.91857,      -5.39345, 
     -6.34038,       7.92547,       6.74181,       4.89821,       2.57514, 
  3.91832e-05,      -2.57514,      -4.89821,      -6.74181,      -7.92547, 
      9.51057,       8.09017,       5.87785,       3.09017,   7.10543e-14, 
     -3.09017,      -5.87785,      -8.09017,      -9.51057,       1.58509, 
      1.34836,      0.979642,      0.515028,   0.000180844,     -0.515028, 
    -0.979642,      -1.34836,      -1.58509,       3.17019,       2.69672, 
      1.95928,       1.03006,   9.62788e-05,      -1.03006,      -1.95928, 
     -2.69672,      -3.17019,       4.75528,       4.04508,       2.93893, 
      1.54508,    6.4922e-05,      -1.54508,      -2.93893,      -4.04508, 
     -4.75528,       6.34038,       5.39345,       3.91857,       2.06011, 
  4.88877e-05,      -2.06011,      -3.91857,      -5.39345,      -6.34038, 
      7.92547,       6.74181,       4.89821,       2.57514,   3.91832e-05, 
     -2.57514,      -4.89821,      -6.74181,      -7.92547,       9.51057, 
      8.09017,       5.87785,       3.09017,   7.10543e-14,      -3.09017, 
     -5.87785,      -8.09017,      -9.51057,       1.58509,       1.34836, 
     0.979642,      0.515028,   0.000180844,     -0.515028,     -0.979642, 
     -1.34836,      -1.58509,       3.17019,       2.69672,       1.95928, 
      1.03006,   9.62788e-05,      -1.03006,      -1.95928,      -2.69672, 
     -3.17019,       4.75528,       4.04508,       2.93893,       1.54508, 
   6.4922e-05,      -1.54508,      -2.93893,      -4.04508,      -4.75528, 
      6.34038,       5.39345,       3.91857,       2.06011,   4.88877e-05, 
     -2.06011,      -3.91857,      -5.39345,      -6.34038,       7.92547, 
      6.74181,       4.89821,       2.57514,   3.91832e-05,      -2.57514, 
     -4.89821,      -6.74181,      -7.92547,       9.51057,       8.09017, 
      5.87785,       3.09017,   7.10543e-14,      -3.09017,      -5.87785, 
     -8.09017,      -9.51057,       1.58509,       1.34836,      0.979642, 
     0.515028,   0.000180844,     -0.515028,     -0.979642,      -1.34836, 
     -1.58509,       3.17019,       2.69672,       1.95928,       1.03006, 
  9.62788e-05,      -1.03006,      -1.95928,      -2.69672,      -3.17019, 
      4.75528,       4.04508,       2.93893,       1.54508,    6.4922e-05, 
     -1.54508,      -2.93893,      -4.04508,      -4.75528,       6.34038, 
      5.39345,       3.91857,       2.06011,   4.88877e-05,      -2.06011, 
     -3.91857,      -5.39345,      -6.34038,       7.92547,       6.74181, 
      4.89821,       2.57514,   3.91832e-05,      -2.57514,      -4.89821, 
     -6.74181,      -7.92547,       9.51057,       8.09017,       5.87785, 
      3.09017,   7.10543e-14,      -3.09017,      -5.87785,      -8.09017, 
     -9.51057,       1.58509,       1.34836,      0.979642,      0.515028, 
  0.000180844,     -0.515028,     -0.979642,      -1.34836,      -1.58509, 
      3.17019,       2.69672,       1.95928,       1.03006,   9.62788e-05, 
     -1.03006,      -1.95928,      -2.69672,      -3.17019,       4.75528, 
      4.04508,       2.93893,       1.54508,    6.4922e-05,      -1.54508, 
     -2.93893,      -4.04508,      -4.75528,       6.34038,       5.39345, 
      3.91857,       2.06011,   4.88877e-05,      -2.06011,      -3.91857, 
     -5.39345,      -6.34038,       7.92547,       6.74181,       4.89821, 
      2.57514,   3.91832e-05,      -2.57514,      -4.89821,      -6.74181, 
     -7.92547,       9.51057,       8.09017,       5.87785,       3.09017, 
  7.10543e-14,      -3.09017,      -5.87785,      -8.09017,      -9.51057, 
      1.58509,       1.34836,      0.979642,      0.515028,   0.000180844, 
    -0.515028,     -0.979642,      -1.34836,      -1.58509,       3.17019, 
      2.69672,       1.95928,       1.03006,   9.62788e-05,      -1.03006, 
     -1.95928,      -2.69672,      -3.17019,       4.75528,       4.04508, 
      2.93893,       1.54508,    6.4922e-05,      -1.54508,      -2.93893, 
     -4.04508,      -4.75528,       6.34038,       5.39345,       3.91857, 
      2.06011,   4.88877e-05,      -2.06011,      -3.91857,      -5.39345, 
     -6.34038,       7.92547,       6.74181,       4.89821,       2.57514, 
  3.91832e-05,      -2.57514,      -4.89821,      -6.74181,      -7.92547, 
      9.51057,       8.09017,       5.87785,       3.09017,   7.10543e-14, 
     -3.09017,      -5.87785,      -8.09017,      -9.51057,       1.58509, 
      1.34836,      0.979642,      0.515028,   0.000180844,     -0.515028, 
    -0.979642,      -1.34836,      -1.58509,       3.17019,       2.69672, 
      1.95928,       1.03006,   9.62788e-05,      -1.03006,      -1.95928, 
     -2.69672,      -3.17019,       4.75528,       4.04508,       2.93893, 
      1.54508,    6.4922e-05,      -1.54508,      -2.93893,      -4.04508, 
     -4.75528,       6.34038,       5.39345,       3.91857,       2.06011, 
  4.88877e-05,      -2.06011,      -3.91857,      -5.39345,      -6.34038, 
      7.92547,       6.74181,       4.89821,       2.57514,   3.91832e-05, 
     -2.57514,      -4.89821,      -6.74181,      -7.92547,       9.51057, 
      8.09017,       5.87785,       3.09017,   7.10543e-14,      -3.09017, 
     -5.87785,      -8.09017,      -9.51057,       1.58509,       1.34836, 
     0.979642,      0.515028,   0.000180844,     -0.515028,     -0.979642, 
     -1.34836,      -1.58509,       3.17019,       2.69672,       1.95928, 
      1.03006,   9.62788e-05,      -1.03006,      -1.95928,      -2.69672, 
     -3.17019,       4.75528,       4.04508,       2.93893,       1.54508, 
   6.4922e-05,      -1.54508,      -2.93893,      -4.04508,      -4.75528, 
      6.34038,       5.39345,       3.91857,       2.06011,   4.88877e-05, 
     -2.06011,      -3.91857,      -5.39345,      -6.34038,       7.92547, 
      6.74181,       4.89821,       2.57514,   3.91832e-05,      -2.57514, 
     -4.89821,      -6.74181,      -7.92547,       9.51057,       8.09017, 
      5.87785,       3.09017,   7.10543e-14,      -3.09017,      -5.87785, 
     -8.09017,      -9.51057,       1.58509,       1.34836,      0.979642, 
     0.515028,   0.000180844,     -0.515028,     -0.979642,      -1.34836, 
     -1.58509,       3.17019,       2.69672,       1.95928,       1.03006, 
  9.62788e-05,      -1.03006,      -1.95928,      -2.69672,      -3.17019, 
      4.75528,       4.04508,       2.93893,       1.54508,    6.4922e-05, 
     -1.54508,      -2.93893,      -4.04508,      -4.75528,       6.34038, 
      5.39345,       3.91857,       2.06011,   4.88877e-05,      -2.06011, 
     -3.91857,      -5.39345,      -6.34038,       7.92547,       6.74181, 
      4.89821,       2.57514,   3.91832e-05,      -2.57514,      -4.89821, 
     -6.74181,      -7.92547,       9.51057,       8.09017,       5.87785, 
      3.09017,   7.10543e-14,      -3.09017,      -5.87785,      -8.09017, 
     -9.51057,       1.58509,       1.34836,      0.979642,      0.515028, 
  0.000180844,     -0.515028,     -0.979642,      -1.34836,      -1.58509, 
      3.17019,       2.69672,       1.95928,       1.03006,   9.62788e-05, 
     -1.03006,      -1.95928,      -2.69672,      -3.17019,       4.75528, 
      4.04508,       2.93893,       1.54508,    6.4922e-05,      -1.54508, 
     -2.93893,      -4.04508,      -4.75528,       6.34038,       5.39345, 
      3.91857,       2.06011,   4.88877e-05,      -2.06011,      -3.91857, 
     -5.39345,      -6.34038,       7.92547,       6.74181,       4.89821, 
      2.57514,   3.91832e-05,      -2.57514,      -4.89821,      -6.74181, 
     -7.92547,       9.51057,       8.09017,       5.87785,       3.09017, 
  7.10543e-14,      -3.09017,      -5.87785,      -8.09017,      -9.51057, 
      1.58509,       1.34836,      0.979642,      0.515028,   0.000180844, 
    -0.515028,     -0.979642,      -1.34836,      -1.58509,       3.17019, 
      2.69672,       1.95928,       1.03006,   9.62788e-05,      -1.03006, 
     -1.95928,      -2.69672,      -3.17019,       4.75528,       4.04508, 
      2.93893,       1.54508,    6.4922e-05,      -1.54508,      -2.93893, 
     -4.04508,      -4.75528,       6.34038,       5.39345,       3.91857, 
      2.06011,   4.88877e-05,      -2.06011,      -3.91857,      -5.39345, 
     -6.34038,       7.92547,       6.74181,       4.89821,       2.57514, 
  3.91832e-05,      -2.57514,      -4.89821,      -6.74181,      -7.92547, 
      9.51057,       8.09017,       5.87785,       3.09017,   7.10543e-14, 
     -3.09017,      -5.87785,      -8.09017,      -9.51057,       1.58509, 
      1.34836,      0.979642,      0.515028,   0.000180844,     -0.515028, 
    -0.979642,      -1.34836,      -1.58509,       3.17019,       2.69672, 
      1.95928,       1.03006,   9.62788e-05,      -1.03006,      -1.95928, 
     -2.69672,      -3.17019,       4.75528,       4.04508,       2.93893, 
      1.54508,    6.4922e-05,      -1.54508,      -2.93893,      -4.04508, 
     -4.75528,       6.34038,       5.39345,       3.91857,       2.06011, 
  4.88877e-05,      -2.06011,      -3.91857,      -5.39345,      -6.34038, 
      7.92547,       6.74181,       4.89821,       2.57514,   3.91832e-05, 
     -2.57514,      -4.89821,      -6.74181,      -7.92547,       9.51057, 
      8.09017,       5.87785,       3.09017,   7.10543e-14,      -3.09017, 
     -5.87785,      -8.09017,      -9.51057, 
};

int       znodelist [8560] = {
   /* --------------------- Size 4 ------------------- */

   /* 10 */
   1,    0,   13,   67,
   1,    0,   67,  121,
   1,    0,  121,  175,
   1,    0,  175,  229,
   1,    0,  229,  283,
   1,    0,  283,  337,
   1,    0,  337,  391,
   1,    0,  391,  445,
   1,    0,  445,  499,
   1,    0,  499,  553,

   /* 20 */
   1,    0,  553,  607,
   1,    0,  607,  661,
   1,    0,  661,  715,
   1,    0,  715,  769,
   1,    0,  769,  823,
   1,    0,  823,  877,
   1,    0,  877,  931,
   1,    0,  931,  985,
   1,    0,  985, 1039,
   1,    0, 1039,   13,

   /* 30 */
   0,    2,   21,   75,
   0,    2,   75,  129,
   0,    2,  129,  183,
   0,    2,  183,  237,
   0,    2,  237,  291,
   0,    2,  291,  345,
   0,    2,  345,  399,
   0,    2,  399,  453,
   0,    2,  453,  507,
   0,    2,  507,  561,

   /* 40 */
   0,    2,  561,  615,
   0,    2,  615,  669,
   0,    2,  669,  723,
   0,    2,  723,  777,
   0,    2,  777,  831,
   0,    2,  831,  885,
   0,    2,  885,  939,
   0,    2,  939,  993,
   0,    2,  993, 1047,
   0,    2, 1047,   21,

   /* --------------------- Size 6 ------------------- */

   /* 10 */
    13,   22,    3,    1,   67,   76,
    67,   76,    3,    1,  121,  130,
   121,  130,    3,    1,  175,  184,
   175,  184,    3,    1,  229,  238,
   229,  238,    3,    1,  283,  292,
   283,  292,    3,    1,  337,  346,
   337,  346,    3,    1,  391,  400,
   391,  400,    3,    1,  445,  454,
   445,  454,    3,    1,  499,  508,
   499,  508,    3,    1,  553,  562,

   /* 20 */
   553,  562,    3,    1,  607,  616,
   607,  616,    3,    1,  661,  670,
   661,  670,    3,    1,  715,  724,
   715,  724,    3,    1,  769,  778,
   769,  778,    3,    1,  823,  832,
   823,  832,    3,    1,  877,  886,
   877,  886,    3,    1,  931,  940,
   931,  940,    3,    1,  985,  994,
   985,  994,    3,    1, 1039, 1048,
  1039, 1048,    3,    1,   13,   22,

   /* 30 */
    22,   31,    5,    3,   76,   85,
    76,   85,    5,    3,  130,  139,
   130,  139,    5,    3,  184,  193,
   184,  193,    5,    3,  238,  247,
   238,  247,    5,    3,  292,  301,
   292,  301,    5,    3,  346,  355,
   346,  355,    5,    3,  400,  409,
   400,  409,    5,    3,  454,  463,
   454,  463,    5,    3,  508,  517,
   508,  517,    5,    3,  562,  571,

   /* 40 */
   562,  571,    5,    3,  616,  625,
   616,  625,    5,    3,  670,  679,
   670,  679,    5,    3,  724,  733,
   724,  733,    5,    3,  778,  787,
   778,  787,    5,    3,  832,  841,
   832,  841,    5,    3,  886,  895,
   886,  895,    5,    3,  940,  949,
   940,  949,    5,    3,  994, 1003,
   994, 1003,    5,    3, 1048, 1057,
  1048, 1057,    5,    3,   22,   31,

   /* 50 */
    31,   40,    7,    5,   85,   94,
    85,   94,    7,    5,  139,  148,
   139,  148,    7,    5,  193,  202,
   193,  202,    7,    5,  247,  256,
   247,  256,    7,    5,  301,  310,
   301,  310,    7,    5,  355,  364,
   355,  364,    7,    5,  409,  418,
   409,  418,    7,    5,  463,  472,
   463,  472,    7,    5,  517,  526,
   517,  526,    7,    5,  571,  580,

   /* 60 */
   571,  580,    7,    5,  625,  634,
   625,  634,    7,    5,  679,  688,
   679,  688,    7,    5,  733,  742,
   733,  742,    7,    5,  787,  796,
   787,  796,    7,    5,  841,  850,
   841,  850,    7,    5,  895,  904,
   895,  904,    7,    5,  949,  958,
   949,  958,    7,    5, 1003, 1012,
  1003, 1012,    7,    5, 1057, 1066,
  1057, 1066,    7,    5,   31,   40,

   /* 70 */
    40,   49,    9,    7,   94,  103,
    94,  103,    9,    7,  148,  157,
   148,  157,    9,    7,  202,  211,
   202,  211,    9,    7,  256,  265,
   256,  265,    9,    7,  310,  319,
   310,  319,    9,    7,  364,  373,
   364,  373,    9,    7,  418,  427,
   418,  427,    9,    7,  472,  481,
   472,  481,    9,    7,  526,  535,
   526,  535,    9,    7,  580,  589,

   /* 80 */
   580,  589,    9,    7,  634,  643,
   634,  643,    9,    7,  688,  697,
   688,  697,    9,    7,  742,  751,
   742,  751,    9,    7,  796,  805,
   796,  805,    9,    7,  850,  859,
   850,  859,    9,    7,  904,  913,
   904,  913,    9,    7,  958,  967,
   958,  967,    9,    7, 1012, 1021,
  1012, 1021,    9,    7, 1066, 1075,
  1066, 1075,    9,    7,   40,   49,

   /* 90 */
    49,   58,   11,    9,  103,  112,
   103,  112,   11,    9,  157,  166,
   157,  166,   11,    9,  211,  220,
   211,  220,   11,    9,  265,  274,
   265,  274,   11,    9,  319,  328,
   319,  328,   11,    9,  373,  382,
   373,  382,   11,    9,  427,  436,
   427,  436,   11,    9,  481,  490,
   481,  490,   11,    9,  535,  544,
   535,  544,   11,    9,  589,  598,

   /* 100 */
   589,  598,   11,    9,  643,  652,
   643,  652,   11,    9,  697,  706,
   697,  706,   11,    9,  751,  760,
   751,  760,   11,    9,  805,  814,
   805,  814,   11,    9,  859,  868,
   859,  868,   11,    9,  913,  922,
   913,  922,   11,    9,  967,  976,
   967,  976,   11,    9, 1021, 1030,
  1021, 1030,   11,    9, 1075, 1084,
  1075, 1084,   11,    9,   49,   58,

   /* 110 */
    30,   21,    2,    4,   84,   75,
    84,   75,    2,    4,  138,  129,
   138,  129,    2,    4,  192,  183,
   192,  183,    2,    4,  246,  237,
   246,  237,    2,    4,  300,  291,
   300,  291,    2,    4,  354,  345,
   354,  345,    2,    4,  408,  399,
   408,  399,    2,    4,  462,  453,
   462,  453,    2,    4,  516,  507,
   516,  507,    2,    4,  570,  561,

   /* 120 */
   570,  561,    2,    4,  624,  615,
   624,  615,    2,    4,  678,  669,
   678,  669,    2,    4,  732,  723,
   732,  723,    2,    4,  786,  777,
   786,  777,    2,    4,  840,  831,
   840,  831,    2,    4,  894,  885,
   894,  885,    2,    4,  948,  939,
   948,  939,    2,    4, 1002,  993,
  1002,  993,    2,    4, 1056, 1047,
  1056, 1047,    2,    4,   30,   21,

   /* 130 */
    39,   30,    4,    6,   93,   84,
    93,   84,    4,    6,  147,  138,
   147,  138,    4,    6,  201,  192,
   201,  192,    4,    6,  255,  246,
   255,  246,    4,    6,  309,  300,
   309,  300,    4,    6,  363,  354,
   363,  354,    4,    6,  417,  408,
   417,  408,    4,    6,  471,  462,
   471,  462,    4,    6,  525,  516,
   525,  516,    4,    6,  579,  570,

   /* 140 */
   579,  570,    4,    6,  633,  624,
   633,  624,    4,    6,  687,  678,
   687,  678,    4,    6,  741,  732,
   741,  732,    4,    6,  795,  786,
   795,  786,    4,    6,  849,  840,
   849,  840,    4,    6,  903,  894,
   903,  894,    4,    6,  957,  948,
   957,  948,    4,    6, 1011, 1002,
  1011, 1002,    4,    6, 1065, 1056,
  1065, 1056,    4,    6,   39,   30,

   /* 150 */
    48,   39,    6,    8,  102,   93,
   102,   93,    6,    8,  156,  147,
   156,  147,    6,    8,  210,  201,
   210,  201,    6,    8,  264,  255,
   264,  255,    6,    8,  318,  309,
   318,  309,    6,    8,  372,  363,
   372,  363,    6,    8,  426,  417,
   426,  417,    6,    8,  480,  471,
   480,  471,    6,    8,  534,  525,
   534,  525,    6,    8,  588,  579,

   /* 160 */
   588,  579,    6,    8,  642,  633,
   642,  633,    6,    8,  696,  687,
   696,  687,    6,    8,  750,  741,
   750,  741,    6,    8,  804,  795,
   804,  795,    6,    8,  858,  849,
   858,  849,    6,    8,  912,  903,
   912,  903,    6,    8,  966,  957,
   966,  957,    6,    8, 1020, 1011,
  1020, 1011,    6,    8, 1074, 1065,
  1074, 1065,    6,    8,   48,   39,

   /* 170 */
    57,   48,    8,   10,  111,  102,
   111,  102,    8,   10,  165,  156,
   165,  156,    8,   10,  219,  210,
   219,  210,    8,   10,  273,  264,
   273,  264,    8,   10,  327,  318,
   327,  318,    8,   10,  381,  372,
   381,  372,    8,   10,  435,  426,
   435,  426,    8,   10,  489,  480,
   489,  480,    8,   10,  543,  534,
   543,  534,    8,   10,  597,  588,

   /* 180 */
   597,  588,    8,   10,  651,  642,
   651,  642,    8,   10,  705,  696,
   705,  696,    8,   10,  759,  750,
   759,  750,    8,   10,  813,  804,
   813,  804,    8,   10,  867,  858,
   867,  858,    8,   10,  921,  912,
   921,  912,    8,   10,  975,  966,
   975,  966,    8,   10, 1029, 1020,
  1029, 1020,    8,   10, 1083, 1074,
  1083, 1074,    8,   10,   57,   48,

   /* 190 */
    66,   57,   10,   12,  120,  111,
   120,  111,   10,   12,  174,  165,
   174,  165,   10,   12,  228,  219,
   228,  219,   10,   12,  282,  273,
   282,  273,   10,   12,  336,  327,
   336,  327,   10,   12,  390,  381,
   390,  381,   10,   12,  444,  435,
   444,  435,   10,   12,  498,  489,
   498,  489,   10,   12,  552,  543,
   552,  543,   10,   12,  606,  597,

   /* 200 */
   606,  597,   10,   12,  660,  651,
   660,  651,   10,   12,  714,  705,
   714,  705,   10,   12,  768,  759,
   768,  759,   10,   12,  822,  813,
   822,  813,   10,   12,  876,  867,
   876,  867,   10,   12,  930,  921,
   930,  921,   10,   12,  984,  975,
   984,  975,   10,   12, 1038, 1029,
  1038, 1029,   10,   12, 1092, 1083,
  1092, 1083,   10,   12,   66,   57,

   /* --------------------- Size 5 ------------------- */

   /* 10 */
    67,   13,   14,   68,    0,
   121,   67,   68,  122,    0,
   175,  121,  122,  176,    0,
   229,  175,  176,  230,    0,
   283,  229,  230,  284,    0,
   337,  283,  284,  338,    0,
   391,  337,  338,  392,    0,
   445,  391,  392,  446,    0,
   499,  445,  446,  500,    0,
   553,  499,  500,  554,    0,

   /* 20 */
   607,  553,  554,  608,    0,
   661,  607,  608,  662,    0,
   715,  661,  662,  716,    0,
   769,  715,  716,  770,    0,
   823,  769,  770,  824,    0,
   877,  823,  824,  878,    0,
   931,  877,  878,  932,    0,
   985,  931,  932,  986,    0,
  1039,  985,  986, 1040,    0,
    13, 1039, 1040,   14,    0,

   /* 30 */
    68,   14,   15,   69,    0,
   122,   68,   69,  123,    0,
   176,  122,  123,  177,    0,
   230,  176,  177,  231,    0,
   284,  230,  231,  285,    0,
   338,  284,  285,  339,    0,
   392,  338,  339,  393,    0,
   446,  392,  393,  447,    0,
   500,  446,  447,  501,    0,
   554,  500,  501,  555,    0,

   /* 40 */
   608,  554,  555,  609,    0,
   662,  608,  609,  663,    0,
   716,  662,  663,  717,    0,
   770,  716,  717,  771,    0,
   824,  770,  771,  825,    0,
   878,  824,  825,  879,    0,
   932,  878,  879,  933,    0,
   986,  932,  933,  987,    0,
  1040,  986,  987, 1041,    0,
    14, 1040, 1041,   15,    0,

   /* 50 */
    69,   15,   16,   70,    0,
   123,   69,   70,  124,    0,
   177,  123,  124,  178,    0,
   231,  177,  178,  232,    0,
   285,  231,  232,  286,    0,
   339,  285,  286,  340,    0,
   393,  339,  340,  394,    0,
   447,  393,  394,  448,    0,
   501,  447,  448,  502,    0,
   555,  501,  502,  556,    0,

   /* 60 */
   609,  555,  556,  610,    0,
   663,  609,  610,  664,    0,
   717,  663,  664,  718,    0,
   771,  717,  718,  772,    0,
   825,  771,  772,  826,    0,
   879,  825,  826,  880,    0,
   933,  879,  880,  934,    0,
   987,  933,  934,  988,    0,
  1041,  987,  988, 1042,    0,
    15, 1041, 1042,   16,    0,

   /* 70 */
    70,   16,   17,   71,    0,
   124,   70,   71,  125,    0,
   178,  124,  125,  179,    0,
   232,  178,  179,  233,    0,
   286,  232,  233,  287,    0,
   340,  286,  287,  341,    0,
   394,  340,  341,  395,    0,
   448,  394,  395,  449,    0,
   502,  448,  449,  503,    0,
   556,  502,  503,  557,    0,

   /* 80 */
   610,  556,  557,  611,    0,
   664,  610,  611,  665,    0,
   718,  664,  665,  719,    0,
   772,  718,  719,  773,    0,
   826,  772,  773,  827,    0,
   880,  826,  827,  881,    0,
   934,  880,  881,  935,    0,
   988,  934,  935,  989,    0,
  1042,  988,  989, 1043,    0,
    16, 1042, 1043,   17,    0,

   /* 90 */
    71,   17,   18,   72,    0,
   125,   71,   72,  126,    0,
   179,  125,  126,  180,    0,
   233,  179,  180,  234,    0,
   287,  233,  234,  288,    0,
   341,  287,  288,  342,    0,
   395,  341,  342,  396,    0,
   449,  395,  396,  450,    0,
   503,  449,  450,  504,    0,
   557,  503,  504,  558,    0,

   /* 100 */
   611,  557,  558,  612,    0,
   665,  611,  612,  666,    0,
   719,  665,  666,  720,    0,
   773,  719,  720,  774,    0,
   827,  773,  774,  828,    0,
   881,  827,  828,  882,    0,
   935,  881,  882,  936,    0,
   989,  935,  936,  990,    0,
  1043,  989,  990, 1044,    0,
    17, 1043, 1044,   18,    0,

   /* 110 */
    72,   18,   19,   73,    0,
   126,   72,   73,  127,    0,
   180,  126,  127,  181,    0,
   234,  180,  181,  235,    0,
   288,  234,  235,  289,    0,
   342,  288,  289,  343,    0,
   396,  342,  343,  397,    0,
   450,  396,  397,  451,    0,
   504,  450,  451,  505,    0,
   558,  504,  505,  559,    0,

   /* 120 */
   612,  558,  559,  613,    0,
   666,  612,  613,  667,    0,
   720,  666,  667,  721,    0,
   774,  720,  721,  775,    0,
   828,  774,  775,  829,    0,
   882,  828,  829,  883,    0,
   936,  882,  883,  937,    0,
   990,  936,  937,  991,    0,
  1044,  990,  991, 1045,    0,
    18, 1044, 1045,   19,    0,

   /* 130 */
    73,   19,   20,   74,    0,
   127,   73,   74,  128,    0,
   181,  127,  128,  182,    0,
   235,  181,  182,  236,    0,
   289,  235,  236,  290,    0,
   343,  289,  290,  344,    0,
   397,  343,  344,  398,    0,
   451,  397,  398,  452,    0,
   505,  451,  452,  506,    0,
   559,  505,  506,  560,    0,

   /* 140 */
   613,  559,  560,  614,    0,
   667,  613,  614,  668,    0,
   721,  667,  668,  722,    0,
   775,  721,  722,  776,    0,
   829,  775,  776,  830,    0,
   883,  829,  830,  884,    0,
   937,  883,  884,  938,    0,
   991,  937,  938,  992,    0,
  1045,  991,  992, 1046,    0,
    19, 1045, 1046,   20,    0,

   /* 150 */
    74,   20,   21,   75,    0,
   128,   74,   75,  129,    0,
   182,  128,  129,  183,    0,
   236,  182,  183,  237,    0,
   290,  236,  237,  291,    0,
   344,  290,  291,  345,    0,
   398,  344,  345,  399,    0,
   452,  398,  399,  453,    0,
   506,  452,  453,  507,    0,
   560,  506,  507,  561,    0,

   /* 160 */
   614,  560,  561,  615,    0,
   668,  614,  615,  669,    0,
   722,  668,  669,  723,    0,
   776,  722,  723,  777,    0,
   830,  776,  777,  831,    0,
   884,  830,  831,  885,    0,
   938,  884,  885,  939,    0,
   992,  938,  939,  993,    0,
  1046,  992,  993, 1047,    0,
    20, 1046, 1047,   21,    0,

   /* --------------------- Size 8 ------------------- */
  22,   23,   14,   13,   76,   77,   68,   67,   76,   77,   68,   67, 
 130,  131,  122,  121,  130,  131,  122,  121,  184,  185,  176,  175, 
 184,  185,  176,  175,  238,  239,  230,  229,  238,  239,  230,  229, 
 292,  293,  284,  283,  292,  293,  284,  283,  346,  347,  338,  337, 
 346,  347,  338,  337,  400,  401,  392,  391,  400,  401,  392,  391, 
 454,  455,  446,  445,  454,  455,  446,  445,  508,  509,  500,  499, 
 508,  509,  500,  499,  562,  563,  554,  553,  562,  563,  554,  553, 
 616,  617,  608,  607,  616,  617,  608,  607,  670,  671,  662,  661, 
 670,  671,  662,  661,  724,  725,  716,  715,  724,  725,  716,  715, 
 778,  779,  770,  769,  778,  779,  770,  769,  832,  833,  824,  823, 
 832,  833,  824,  823,  886,  887,  878,  877,  886,  887,  878,  877, 
 940,  941,  932,  931,  940,  941,  932,  931,  994,  995,  986,  985, 
 994,  995,  986,  985, 1048, 1049, 1040, 1039, 1048, 1049, 1040, 1039, 
  22,   23,   14,   13,   31,   32,   23,   22,   85,   86,   77,   76, 
  85,   86,   77,   76,  139,  140,  131,  130,  139,  140,  131,  130, 
 193,  194,  185,  184,  193,  194,  185,  184,  247,  248,  239,  238, 
 247,  248,  239,  238,  301,  302,  293,  292,  301,  302,  293,  292, 
 355,  356,  347,  346,  355,  356,  347,  346,  409,  410,  401,  400, 
 409,  410,  401,  400,  463,  464,  455,  454,  463,  464,  455,  454, 
 517,  518,  509,  508,  517,  518,  509,  508,  571,  572,  563,  562, 
 571,  572,  563,  562,  625,  626,  617,  616,  625,  626,  617,  616, 
 679,  680,  671,  670,  679,  680,  671,  670,  733,  734,  725,  724, 
 733,  734,  725,  724,  787,  788,  779,  778,  787,  788,  779,  778, 
 841,  842,  833,  832,  841,  842,  833,  832,  895,  896,  887,  886, 
 895,  896,  887,  886,  949,  950,  941,  940,  949,  950,  941,  940, 
1003, 1004,  995,  994, 1003, 1004,  995,  994, 1057, 1058, 1049, 1048, 
1057, 1058, 1049, 1048,   31,   32,   23,   22,   40,   41,   32,   31, 
  94,   95,   86,   85,   94,   95,   86,   85,  148,  149,  140,  139, 
 148,  149,  140,  139,  202,  203,  194,  193,  202,  203,  194,  193, 
 256,  257,  248,  247,  256,  257,  248,  247,  310,  311,  302,  301, 
 310,  311,  302,  301,  364,  365,  356,  355,  364,  365,  356,  355, 
 418,  419,  410,  409,  418,  419,  410,  409,  472,  473,  464,  463, 
 472,  473,  464,  463,  526,  527,  518,  517,  526,  527,  518,  517, 
 580,  581,  572,  571,  580,  581,  572,  571,  634,  635,  626,  625, 
 634,  635,  626,  625,  688,  689,  680,  679,  688,  689,  680,  679, 
 742,  743,  734,  733,  742,  743,  734,  733,  796,  797,  788,  787, 
 796,  797,  788,  787,  850,  851,  842,  841,  850,  851,  842,  841, 
 904,  905,  896,  895,  904,  905,  896,  895,  958,  959,  950,  949, 
 958,  959,  950,  949, 1012, 1013, 1004, 1003, 1012, 1013, 1004, 1003, 
1066, 1067, 1058, 1057, 1066, 1067, 1058, 1057,   40,   41,   32,   31, 
  49,   50,   41,   40,  103,  104,   95,   94,  103,  104,   95,   94, 
 157,  158,  149,  148,  157,  158,  149,  148,  211,  212,  203,  202, 
 211,  212,  203,  202,  265,  266,  257,  256,  265,  266,  257,  256, 
 319,  320,  311,  310,  319,  320,  311,  310,  373,  374,  365,  364, 
 373,  374,  365,  364,  427,  428,  419,  418,  427,  428,  419,  418, 
 481,  482,  473,  472,  481,  482,  473,  472,  535,  536,  527,  526, 
 535,  536,  527,  526,  589,  590,  581,  580,  589,  590,  581,  580, 
 643,  644,  635,  634,  643,  644,  635,  634,  697,  698,  689,  688, 
 697,  698,  689,  688,  751,  752,  743,  742,  751,  752,  743,  742, 
 805,  806,  797,  796,  805,  806,  797,  796,  859,  860,  851,  850, 
 859,  860,  851,  850,  913,  914,  905,  904,  913,  914,  905,  904, 
 967,  968,  959,  958,  967,  968,  959,  958, 1021, 1022, 1013, 1012, 
1021, 1022, 1013, 1012, 1075, 1076, 1067, 1066, 1075, 1076, 1067, 1066, 
  49,   50,   41,   40,   58,   59,   50,   49,  112,  113,  104,  103, 
 112,  113,  104,  103,  166,  167,  158,  157,  166,  167,  158,  157, 
 220,  221,  212,  211,  220,  221,  212,  211,  274,  275,  266,  265, 
 274,  275,  266,  265,  328,  329,  320,  319,  328,  329,  320,  319, 
 382,  383,  374,  373,  382,  383,  374,  373,  436,  437,  428,  427, 
 436,  437,  428,  427,  490,  491,  482,  481,  490,  491,  482,  481, 
 544,  545,  536,  535,  544,  545,  536,  535,  598,  599,  590,  589, 
 598,  599,  590,  589,  652,  653,  644,  643,  652,  653,  644,  643, 
 706,  707,  698,  697,  706,  707,  698,  697,  760,  761,  752,  751, 
 760,  761,  752,  751,  814,  815,  806,  805,  814,  815,  806,  805, 
 868,  869,  860,  859,  868,  869,  860,  859,  922,  923,  914,  913, 
 922,  923,  914,  913,  976,  977,  968,  967,  976,  977,  968,  967, 
1030, 1031, 1022, 1021, 1030, 1031, 1022, 1021, 1084, 1085, 1076, 1075, 
1084, 1085, 1076, 1075,   58,   59,   50,   49,   23,   24,   15,   14, 
  77,   78,   69,   68,   77,   78,   69,   68,  131,  132,  123,  122, 
 131,  132,  123,  122,  185,  186,  177,  176,  185,  186,  177,  176, 
 239,  240,  231,  230,  239,  240,  231,  230,  293,  294,  285,  284, 
 293,  294,  285,  284,  347,  348,  339,  338,  347,  348,  339,  338, 
 401,  402,  393,  392,  401,  402,  393,  392,  455,  456,  447,  446, 
 455,  456,  447,  446,  509,  510,  501,  500,  509,  510,  501,  500, 
 563,  564,  555,  554,  563,  564,  555,  554,  617,  618,  609,  608, 
 617,  618,  609,  608,  671,  672,  663,  662,  671,  672,  663,  662, 
 725,  726,  717,  716,  725,  726,  717,  716,  779,  780,  771,  770, 
 779,  780,  771,  770,  833,  834,  825,  824,  833,  834,  825,  824, 
 887,  888,  879,  878,  887,  888,  879,  878,  941,  942,  933,  932, 
 941,  942,  933,  932,  995,  996,  987,  986,  995,  996,  987,  986, 
1049, 1050, 1041, 1040, 1049, 1050, 1041, 1040,   23,   24,   15,   14, 
  32,   33,   24,   23,   86,   87,   78,   77,   86,   87,   78,   77, 
 140,  141,  132,  131,  140,  141,  132,  131,  194,  195,  186,  185, 
 194,  195,  186,  185,  248,  249,  240,  239,  248,  249,  240,  239, 
 302,  303,  294,  293,  302,  303,  294,  293,  356,  357,  348,  347, 
 356,  357,  348,  347,  410,  411,  402,  401,  410,  411,  402,  401, 
 464,  465,  456,  455,  464,  465,  456,  455,  518,  519,  510,  509, 
 518,  519,  510,  509,  572,  573,  564,  563,  572,  573,  564,  563, 
 626,  627,  618,  617,  626,  627,  618,  617,  680,  681,  672,  671, 
 680,  681,  672,  671,  734,  735,  726,  725,  734,  735,  726,  725, 
 788,  789,  780,  779,  788,  789,  780,  779,  842,  843,  834,  833, 
 842,  843,  834,  833,  896,  897,  888,  887,  896,  897,  888,  887, 
 950,  951,  942,  941,  950,  951,  942,  941, 1004, 1005,  996,  995, 
1004, 1005,  996,  995, 1058, 1059, 1050, 1049, 1058, 1059, 1050, 1049, 
  32,   33,   24,   23,   41,   42,   33,   32,   95,   96,   87,   86, 
  95,   96,   87,   86,  149,  150,  141,  140,  149,  150,  141,  140, 
 203,  204,  195,  194,  203,  204,  195,  194,  257,  258,  249,  248, 
 257,  258,  249,  248,  311,  312,  303,  302,  311,  312,  303,  302, 
 365,  366,  357,  356,  365,  366,  357,  356,  419,  420,  411,  410, 
 419,  420,  411,  410,  473,  474,  465,  464,  473,  474,  465,  464, 
 527,  528,  519,  518,  527,  528,  519,  518,  581,  582,  573,  572, 
 581,  582,  573,  572,  635,  636,  627,  626,  635,  636,  627,  626, 
 689,  690,  681,  680,  689,  690,  681,  680,  743,  744,  735,  734, 
 743,  744,  735,  734,  797,  798,  789,  788,  797,  798,  789,  788, 
 851,  852,  843,  842,  851,  852,  843,  842,  905,  906,  897,  896, 
 905,  906,  897,  896,  959,  960,  951,  950,  959,  960,  951,  950, 
1013, 1014, 1005, 1004, 1013, 1014, 1005, 1004, 1067, 1068, 1059, 1058, 
1067, 1068, 1059, 1058,   41,   42,   33,   32,   50,   51,   42,   41, 
 104,  105,   96,   95,  104,  105,   96,   95,  158,  159,  150,  149, 
 158,  159,  150,  149,  212,  213,  204,  203,  212,  213,  204,  203, 
 266,  267,  258,  257,  266,  267,  258,  257,  320,  321,  312,  311, 
 320,  321,  312,  311,  374,  375,  366,  365,  374,  375,  366,  365, 
 428,  429,  420,  419,  428,  429,  420,  419,  482,  483,  474,  473, 
 482,  483,  474,  473,  536,  537,  528,  527,  536,  537,  528,  527, 
 590,  591,  582,  581,  590,  591,  582,  581,  644,  645,  636,  635, 
 644,  645,  636,  635,  698,  699,  690,  689,  698,  699,  690,  689, 
 752,  753,  744,  743,  752,  753,  744,  743,  806,  807,  798,  797, 
 806,  807,  798,  797,  860,  861,  852,  851,  860,  861,  852,  851, 
 914,  915,  906,  905,  914,  915,  906,  905,  968,  969,  960,  959, 
 968,  969,  960,  959, 1022, 1023, 1014, 1013, 1022, 1023, 1014, 1013, 
1076, 1077, 1068, 1067, 1076, 1077, 1068, 1067,   50,   51,   42,   41, 
  59,   60,   51,   50,  113,  114,  105,  104,  113,  114,  105,  104, 
 167,  168,  159,  158,  167,  168,  159,  158,  221,  222,  213,  212, 
 221,  222,  213,  212,  275,  276,  267,  266,  275,  276,  267,  266, 
 329,  330,  321,  320,  329,  330,  321,  320,  383,  384,  375,  374, 
 383,  384,  375,  374,  437,  438,  429,  428,  437,  438,  429,  428, 
 491,  492,  483,  482,  491,  492,  483,  482,  545,  546,  537,  536, 
 545,  546,  537,  536,  599,  600,  591,  590,  599,  600,  591,  590, 
 653,  654,  645,  644,  653,  654,  645,  644,  707,  708,  699,  698, 
 707,  708,  699,  698,  761,  762,  753,  752,  761,  762,  753,  752, 
 815,  816,  807,  806,  815,  816,  807,  806,  869,  870,  861,  860, 
 869,  870,  861,  860,  923,  924,  915,  914,  923,  924,  915,  914, 
 977,  978,  969,  968,  977,  978,  969,  968, 1031, 1032, 1023, 1022, 
1031, 1032, 1023, 1022, 1085, 1086, 1077, 1076, 1085, 1086, 1077, 1076, 
  59,   60,   51,   50,   24,   25,   16,   15,   78,   79,   70,   69, 
  78,   79,   70,   69,  132,  133,  124,  123,  132,  133,  124,  123, 
 186,  187,  178,  177,  186,  187,  178,  177,  240,  241,  232,  231, 
 240,  241,  232,  231,  294,  295,  286,  285,  294,  295,  286,  285, 
 348,  349,  340,  339,  348,  349,  340,  339,  402,  403,  394,  393, 
 402,  403,  394,  393,  456,  457,  448,  447,  456,  457,  448,  447, 
 510,  511,  502,  501,  510,  511,  502,  501,  564,  565,  556,  555, 
 564,  565,  556,  555,  618,  619,  610,  609,  618,  619,  610,  609, 
 672,  673,  664,  663,  672,  673,  664,  663,  726,  727,  718,  717, 
 726,  727,  718,  717,  780,  781,  772,  771,  780,  781,  772,  771, 
 834,  835,  826,  825,  834,  835,  826,  825,  888,  889,  880,  879, 
 888,  889,  880,  879,  942,  943,  934,  933,  942,  943,  934,  933, 
 996,  997,  988,  987,  996,  997,  988,  987, 1050, 1051, 1042, 1041, 
1050, 1051, 1042, 1041,   24,   25,   16,   15,   33,   34,   25,   24, 
  87,   88,   79,   78,   87,   88,   79,   78,  141,  142,  133,  132, 
 141,  142,  133,  132,  195,  196,  187,  186,  195,  196,  187,  186, 
 249,  250,  241,  240,  249,  250,  241,  240,  303,  304,  295,  294, 
 303,  304,  295,  294,  357,  358,  349,  348,  357,  358,  349,  348, 
 411,  412,  403,  402,  411,  412,  403,  402,  465,  466,  457,  456, 
 465,  466,  457,  456,  519,  520,  511,  510,  519,  520,  511,  510, 
 573,  574,  565,  564,  573,  574,  565,  564,  627,  628,  619,  618, 
 627,  628,  619,  618,  681,  682,  673,  672,  681,  682,  673,  672, 
 735,  736,  727,  726,  735,  736,  727,  726,  789,  790,  781,  780, 
 789,  790,  781,  780,  843,  844,  835,  834,  843,  844,  835,  834, 
 897,  898,  889,  888,  897,  898,  889,  888,  951,  952,  943,  942, 
 951,  952,  943,  942, 1005, 1006,  997,  996, 1005, 1006,  997,  996, 
1059, 1060, 1051, 1050, 1059, 1060, 1051, 1050,   33,   34,   25,   24, 
  42,   43,   34,   33,   96,   97,   88,   87,   96,   97,   88,   87, 
 150,  151,  142,  141,  150,  151,  142,  141,  204,  205,  196,  195, 
 204,  205,  196,  195,  258,  259,  250,  249,  258,  259,  250,  249, 
 312,  313,  304,  303,  312,  313,  304,  303,  366,  367,  358,  357, 
 366,  367,  358,  357,  420,  421,  412,  411,  420,  421,  412,  411, 
 474,  475,  466,  465,  474,  475,  466,  465,  528,  529,  520,  519, 
 528,  529,  520,  519,  582,  583,  574,  573,  582,  583,  574,  573, 
 636,  637,  628,  627,  636,  637,  628,  627,  690,  691,  682,  681, 
 690,  691,  682,  681,  744,  745,  736,  735,  744,  745,  736,  735, 
 798,  799,  790,  789,  798,  799,  790,  789,  852,  853,  844,  843, 
 852,  853,  844,  843,  906,  907,  898,  897,  906,  907,  898,  897, 
 960,  961,  952,  951,  960,  961,  952,  951, 1014, 1015, 1006, 1005, 
1014, 1015, 1006, 1005, 1068, 1069, 1060, 1059, 1068, 1069, 1060, 1059, 
  42,   43,   34,   33,   51,   52,   43,   42,  105,  106,   97,   96, 
 105,  106,   97,   96,  159,  160,  151,  150,  159,  160,  151,  150, 
 213,  214,  205,  204,  213,  214,  205,  204,  267,  268,  259,  258, 
 267,  268,  259,  258,  321,  322,  313,  312,  321,  322,  313,  312, 
 375,  376,  367,  366,  375,  376,  367,  366,  429,  430,  421,  420, 
 429,  430,  421,  420,  483,  484,  475,  474,  483,  484,  475,  474, 
 537,  538,  529,  528,  537,  538,  529,  528,  591,  592,  583,  582, 
 591,  592,  583,  582,  645,  646,  637,  636,  645,  646,  637,  636, 
 699,  700,  691,  690,  699,  700,  691,  690,  753,  754,  745,  744, 
 753,  754,  745,  744,  807,  808,  799,  798,  807,  808,  799,  798, 
 861,  862,  853,  852,  861,  862,  853,  852,  915,  916,  907,  906, 
 915,  916,  907,  906,  969,  970,  961,  960,  969,  970,  961,  960, 
1023, 1024, 1015, 1014, 1023, 1024, 1015, 1014, 1077, 1078, 1069, 1068, 
1077, 1078, 1069, 1068,   51,   52,   43,   42,   60,   61,   52,   51, 
 114,  115,  106,  105,  114,  115,  106,  105,  168,  169,  160,  159, 
 168,  169,  160,  159,  222,  223,  214,  213,  222,  223,  214,  213, 
 276,  277,  268,  267,  276,  277,  268,  267,  330,  331,  322,  321, 
 330,  331,  322,  321,  384,  385,  376,  375,  384,  385,  376,  375, 
 438,  439,  430,  429,  438,  439,  430,  429,  492,  493,  484,  483, 
 492,  493,  484,  483,  546,  547,  538,  537,  546,  547,  538,  537, 
 600,  601,  592,  591,  600,  601,  592,  591,  654,  655,  646,  645, 
 654,  655,  646,  645,  708,  709,  700,  699,  708,  709,  700,  699, 
 762,  763,  754,  753,  762,  763,  754,  753,  816,  817,  808,  807, 
 816,  817,  808,  807,  870,  871,  862,  861,  870,  871,  862,  861, 
 924,  925,  916,  915,  924,  925,  916,  915,  978,  979,  970,  969, 
 978,  979,  970,  969, 1032, 1033, 1024, 1023, 1032, 1033, 1024, 1023, 
1086, 1087, 1078, 1077, 1086, 1087, 1078, 1077,   60,   61,   52,   51, 
  25,   26,   17,   16,   79,   80,   71,   70,   79,   80,   71,   70, 
 133,  134,  125,  124,  133,  134,  125,  124,  187,  188,  179,  178, 
 187,  188,  179,  178,  241,  242,  233,  232,  241,  242,  233,  232, 
 295,  296,  287,  286,  295,  296,  287,  286,  349,  350,  341,  340, 
 349,  350,  341,  340,  403,  404,  395,  394,  403,  404,  395,  394, 
 457,  458,  449,  448,  457,  458,  449,  448,  511,  512,  503,  502, 
 511,  512,  503,  502,  565,  566,  557,  556,  565,  566,  557,  556, 
 619,  620,  611,  610,  619,  620,  611,  610,  673,  674,  665,  664, 
 673,  674,  665,  664,  727,  728,  719,  718,  727,  728,  719,  718, 
 781,  782,  773,  772,  781,  782,  773,  772,  835,  836,  827,  826, 
 835,  836,  827,  826,  889,  890,  881,  880,  889,  890,  881,  880, 
 943,  944,  935,  934,  943,  944,  935,  934,  997,  998,  989,  988, 
 997,  998,  989,  988, 1051, 1052, 1043, 1042, 1051, 1052, 1043, 1042, 
  25,   26,   17,   16,   34,   35,   26,   25,   88,   89,   80,   79, 
  88,   89,   80,   79,  142,  143,  134,  133,  142,  143,  134,  133, 
 196,  197,  188,  187,  196,  197,  188,  187,  250,  251,  242,  241, 
 250,  251,  242,  241,  304,  305,  296,  295,  304,  305,  296,  295, 
 358,  359,  350,  349,  358,  359,  350,  349,  412,  413,  404,  403, 
 412,  413,  404,  403,  466,  467,  458,  457,  466,  467,  458,  457, 
 520,  521,  512,  511,  520,  521,  512,  511,  574,  575,  566,  565, 
 574,  575,  566,  565,  628,  629,  620,  619,  628,  629,  620,  619, 
 682,  683,  674,  673,  682,  683,  674,  673,  736,  737,  728,  727, 
 736,  737,  728,  727,  790,  791,  782,  781,  790,  791,  782,  781, 
 844,  845,  836,  835,  844,  845,  836,  835,  898,  899,  890,  889, 
 898,  899,  890,  889,  952,  953,  944,  943,  952,  953,  944,  943, 
1006, 1007,  998,  997, 1006, 1007,  998,  997, 1060, 1061, 1052, 1051, 
1060, 1061, 1052, 1051,   34,   35,   26,   25,   43,   44,   35,   34, 
  97,   98,   89,   88,   97,   98,   89,   88,  151,  152,  143,  142, 
 151,  152,  143,  142,  205,  206,  197,  196,  205,  206,  197,  196, 
 259,  260,  251,  250,  259,  260,  251,  250,  313,  314,  305,  304, 
 313,  314,  305,  304,  367,  368,  359,  358,  367,  368,  359,  358, 
 421,  422,  413,  412,  421,  422,  413,  412,  475,  476,  467,  466, 
 475,  476,  467,  466,  529,  530,  521,  520,  529,  530,  521,  520, 
 583,  584,  575,  574,  583,  584,  575,  574,  637,  638,  629,  628, 
 637,  638,  629,  628,  691,  692,  683,  682,  691,  692,  683,  682, 
 745,  746,  737,  736,  745,  746,  737,  736,  799,  800,  791,  790, 
 799,  800,  791,  790,  853,  854,  845,  844,  853,  854,  845,  844, 
 907,  908,  899,  898,  907,  908,  899,  898,  961,  962,  953,  952, 
 961,  962,  953,  952, 1015, 1016, 1007, 1006, 1015, 1016, 1007, 1006, 
1069, 1070, 1061, 1060, 1069, 1070, 1061, 1060,   43,   44,   35,   34, 
  52,   53,   44,   43,  106,  107,   98,   97,  106,  107,   98,   97, 
 160,  161,  152,  151,  160,  161,  152,  151,  214,  215,  206,  205, 
 214,  215,  206,  205,  268,  269,  260,  259,  268,  269,  260,  259, 
 322,  323,  314,  313,  322,  323,  314,  313,  376,  377,  368,  367, 
 376,  377,  368,  367,  430,  431,  422,  421,  430,  431,  422,  421, 
 484,  485,  476,  475,  484,  485,  476,  475,  538,  539,  530,  529, 
 538,  539,  530,  529,  592,  593,  584,  583,  592,  593,  584,  583, 
 646,  647,  638,  637,  646,  647,  638,  637,  700,  701,  692,  691, 
 700,  701,  692,  691,  754,  755,  746,  745,  754,  755,  746,  745, 
 808,  809,  800,  799,  808,  809,  800,  799,  862,  863,  854,  853, 
 862,  863,  854,  853,  916,  917,  908,  907,  916,  917,  908,  907, 
 970,  971,  962,  961,  970,  971,  962,  961, 1024, 1025, 1016, 1015, 
1024, 1025, 1016, 1015, 1078, 1079, 1070, 1069, 1078, 1079, 1070, 1069, 
  52,   53,   44,   43,   61,   62,   53,   52,  115,  116,  107,  106, 
 115,  116,  107,  106,  169,  170,  161,  160,  169,  170,  161,  160, 
 223,  224,  215,  214,  223,  224,  215,  214,  277,  278,  269,  268, 
 277,  278,  269,  268,  331,  332,  323,  322,  331,  332,  323,  322, 
 385,  386,  377,  376,  385,  386,  377,  376,  439,  440,  431,  430, 
 439,  440,  431,  430,  493,  494,  485,  484,  493,  494,  485,  484, 
 547,  548,  539,  538,  547,  548,  539,  538,  601,  602,  593,  592, 
 601,  602,  593,  592,  655,  656,  647,  646,  655,  656,  647,  646, 
 709,  710,  701,  700,  709,  710,  701,  700,  763,  764,  755,  754, 
 763,  764,  755,  754,  817,  818,  809,  808,  817,  818,  809,  808, 
 871,  872,  863,  862,  871,  872,  863,  862,  925,  926,  917,  916, 
 925,  926,  917,  916,  979,  980,  971,  970,  979,  980,  971,  970, 
1033, 1034, 1025, 1024, 1033, 1034, 1025, 1024, 1087, 1088, 1079, 1078, 
1087, 1088, 1079, 1078,   61,   62,   53,   52,   26,   27,   18,   17, 
  80,   81,   72,   71,   80,   81,   72,   71,  134,  135,  126,  125, 
 134,  135,  126,  125,  188,  189,  180,  179,  188,  189,  180,  179, 
 242,  243,  234,  233,  242,  243,  234,  233,  296,  297,  288,  287, 
 296,  297,  288,  287,  350,  351,  342,  341,  350,  351,  342,  341, 
 404,  405,  396,  395,  404,  405,  396,  395,  458,  459,  450,  449, 
 458,  459,  450,  449,  512,  513,  504,  503,  512,  513,  504,  503, 
 566,  567,  558,  557,  566,  567,  558,  557,  620,  621,  612,  611, 
 620,  621,  612,  611,  674,  675,  666,  665,  674,  675,  666,  665, 
 728,  729,  720,  719,  728,  729,  720,  719,  782,  783,  774,  773, 
 782,  783,  774,  773,  836,  837,  828,  827,  836,  837,  828,  827, 
 890,  891,  882,  881,  890,  891,  882,  881,  944,  945,  936,  935, 
 944,  945,  936,  935,  998,  999,  990,  989,  998,  999,  990,  989, 
1052, 1053, 1044, 1043, 1052, 1053, 1044, 1043,   26,   27,   18,   17, 
  35,   36,   27,   26,   89,   90,   81,   80,   89,   90,   81,   80, 
 143,  144,  135,  134,  143,  144,  135,  134,  197,  198,  189,  188, 
 197,  198,  189,  188,  251,  252,  243,  242,  251,  252,  243,  242, 
 305,  306,  297,  296,  305,  306,  297,  296,  359,  360,  351,  350, 
 359,  360,  351,  350,  413,  414,  405,  404,  413,  414,  405,  404, 
 467,  468,  459,  458,  467,  468,  459,  458,  521,  522,  513,  512, 
 521,  522,  513,  512,  575,  576,  567,  566,  575,  576,  567,  566, 
 629,  630,  621,  620,  629,  630,  621,  620,  683,  684,  675,  674, 
 683,  684,  675,  674,  737,  738,  729,  728,  737,  738,  729,  728, 
 791,  792,  783,  782,  791,  792,  783,  782,  845,  846,  837,  836, 
 845,  846,  837,  836,  899,  900,  891,  890,  899,  900,  891,  890, 
 953,  954,  945,  944,  953,  954,  945,  944, 1007, 1008,  999,  998, 
1007, 1008,  999,  998, 1061, 1062, 1053, 1052, 1061, 1062, 1053, 1052, 
  35,   36,   27,   26,   44,   45,   36,   35,   98,   99,   90,   89, 
  98,   99,   90,   89,  152,  153,  144,  143,  152,  153,  144,  143, 
 206,  207,  198,  197,  206,  207,  198,  197,  260,  261,  252,  251, 
 260,  261,  252,  251,  314,  315,  306,  305,  314,  315,  306,  305, 
 368,  369,  360,  359,  368,  369,  360,  359,  422,  423,  414,  413, 
 422,  423,  414,  413,  476,  477,  468,  467,  476,  477,  468,  467, 
 530,  531,  522,  521,  530,  531,  522,  521,  584,  585,  576,  575, 
 584,  585,  576,  575,  638,  639,  630,  629,  638,  639,  630,  629, 
 692,  693,  684,  683,  692,  693,  684,  683,  746,  747,  738,  737, 
 746,  747,  738,  737,  800,  801,  792,  791,  800,  801,  792,  791, 
 854,  855,  846,  845,  854,  855,  846,  845,  908,  909,  900,  899, 
 908,  909,  900,  899,  962,  963,  954,  953,  962,  963,  954,  953, 
1016, 1017, 1008, 1007, 1016, 1017, 1008, 1007, 1070, 1071, 1062, 1061, 
1070, 1071, 1062, 1061,   44,   45,   36,   35,   53,   54,   45,   44, 
 107,  108,   99,   98,  107,  108,   99,   98,  161,  162,  153,  152, 
 161,  162,  153,  152,  215,  216,  207,  206,  215,  216,  207,  206, 
 269,  270,  261,  260,  269,  270,  261,  260,  323,  324,  315,  314, 
 323,  324,  315,  314,  377,  378,  369,  368,  377,  378,  369,  368, 
 431,  432,  423,  422,  431,  432,  423,  422,  485,  486,  477,  476, 
 485,  486,  477,  476,  539,  540,  531,  530,  539,  540,  531,  530, 
 593,  594,  585,  584,  593,  594,  585,  584,  647,  648,  639,  638, 
 647,  648,  639,  638,  701,  702,  693,  692,  701,  702,  693,  692, 
 755,  756,  747,  746,  755,  756,  747,  746,  809,  810,  801,  800, 
 809,  810,  801,  800,  863,  864,  855,  854,  863,  864,  855,  854, 
 917,  918,  909,  908,  917,  918,  909,  908,  971,  972,  963,  962, 
 971,  972,  963,  962, 1025, 1026, 1017, 1016, 1025, 1026, 1017, 1016, 
1079, 1080, 1071, 1070, 1079, 1080, 1071, 1070,   53,   54,   45,   44, 
  62,   63,   54,   53,  116,  117,  108,  107,  116,  117,  108,  107, 
 170,  171,  162,  161,  170,  171,  162,  161,  224,  225,  216,  215, 
 224,  225,  216,  215,  278,  279,  270,  269,  278,  279,  270,  269, 
 332,  333,  324,  323,  332,  333,  324,  323,  386,  387,  378,  377, 
 386,  387,  378,  377,  440,  441,  432,  431,  440,  441,  432,  431, 
 494,  495,  486,  485,  494,  495,  486,  485,  548,  549,  540,  539, 
 548,  549,  540,  539,  602,  603,  594,  593,  602,  603,  594,  593, 
 656,  657,  648,  647,  656,  657,  648,  647,  710,  711,  702,  701, 
 710,  711,  702,  701,  764,  765,  756,  755,  764,  765,  756,  755, 
 818,  819,  810,  809,  818,  819,  810,  809,  872,  873,  864,  863, 
 872,  873,  864,  863,  926,  927,  918,  917,  926,  927,  918,  917, 
 980,  981,  972,  971,  980,  981,  972,  971, 1034, 1035, 1026, 1025, 
1034, 1035, 1026, 1025, 1088, 1089, 1080, 1079, 1088, 1089, 1080, 1079, 
  62,   63,   54,   53,   27,   28,   19,   18,   81,   82,   73,   72, 
  81,   82,   73,   72,  135,  136,  127,  126,  135,  136,  127,  126, 
 189,  190,  181,  180,  189,  190,  181,  180,  243,  244,  235,  234, 
 243,  244,  235,  234,  297,  298,  289,  288,  297,  298,  289,  288, 
 351,  352,  343,  342,  351,  352,  343,  342,  405,  406,  397,  396, 
 405,  406,  397,  396,  459,  460,  451,  450,  459,  460,  451,  450, 
 513,  514,  505,  504,  513,  514,  505,  504,  567,  568,  559,  558, 
 567,  568,  559,  558,  621,  622,  613,  612,  621,  622,  613,  612, 
 675,  676,  667,  666,  675,  676,  667,  666,  729,  730,  721,  720, 
 729,  730,  721,  720,  783,  784,  775,  774,  783,  784,  775,  774, 
 837,  838,  829,  828,  837,  838,  829,  828,  891,  892,  883,  882, 
 891,  892,  883,  882,  945,  946,  937,  936,  945,  946,  937,  936, 
 999, 1000,  991,  990,  999, 1000,  991,  990, 1053, 1054, 1045, 1044, 
1053, 1054, 1045, 1044,   27,   28,   19,   18,   36,   37,   28,   27, 
  90,   91,   82,   81,   90,   91,   82,   81,  144,  145,  136,  135, 
 144,  145,  136,  135,  198,  199,  190,  189,  198,  199,  190,  189, 
 252,  253,  244,  243,  252,  253,  244,  243,  306,  307,  298,  297, 
 306,  307,  298,  297,  360,  361,  352,  351,  360,  361,  352,  351, 
 414,  415,  406,  405,  414,  415,  406,  405,  468,  469,  460,  459, 
 468,  469,  460,  459,  522,  523,  514,  513,  522,  523,  514,  513, 
 576,  577,  568,  567,  576,  577,  568,  567,  630,  631,  622,  621, 
 630,  631,  622,  621,  684,  685,  676,  675,  684,  685,  676,  675, 
 738,  739,  730,  729,  738,  739,  730,  729,  792,  793,  784,  783, 
 792,  793,  784,  783,  846,  847,  838,  837,  846,  847,  838,  837, 
 900,  901,  892,  891,  900,  901,  892,  891,  954,  955,  946,  945, 
 954,  955,  946,  945, 1008, 1009, 1000,  999, 1008, 1009, 1000,  999, 
1062, 1063, 1054, 1053, 1062, 1063, 1054, 1053,   36,   37,   28,   27, 
  45,   46,   37,   36,   99,  100,   91,   90,   99,  100,   91,   90, 
 153,  154,  145,  144,  153,  154,  145,  144,  207,  208,  199,  198, 
 207,  208,  199,  198,  261,  262,  253,  252,  261,  262,  253,  252, 
 315,  316,  307,  306,  315,  316,  307,  306,  369,  370,  361,  360, 
 369,  370,  361,  360,  423,  424,  415,  414,  423,  424,  415,  414, 
 477,  478,  469,  468,  477,  478,  469,  468,  531,  532,  523,  522, 
 531,  532,  523,  522,  585,  586,  577,  576,  585,  586,  577,  576, 
 639,  640,  631,  630,  639,  640,  631,  630,  693,  694,  685,  684, 
 693,  694,  685,  684,  747,  748,  739,  738,  747,  748,  739,  738, 
 801,  802,  793,  792,  801,  802,  793,  792,  855,  856,  847,  846, 
 855,  856,  847,  846,  909,  910,  901,  900,  909,  910,  901,  900, 
 963,  964,  955,  954,  963,  964,  955,  954, 1017, 1018, 1009, 1008, 
1017, 1018, 1009, 1008, 1071, 1072, 1063, 1062, 1071, 1072, 1063, 1062, 
  45,   46,   37,   36,   54,   55,   46,   45,  108,  109,  100,   99, 
 108,  109,  100,   99,  162,  163,  154,  153,  162,  163,  154,  153, 
 216,  217,  208,  207,  216,  217,  208,  207,  270,  271,  262,  261, 
 270,  271,  262,  261,  324,  325,  316,  315,  324,  325,  316,  315, 
 378,  379,  370,  369,  378,  379,  370,  369,  432,  433,  424,  423, 
 432,  433,  424,  423,  486,  487,  478,  477,  486,  487,  478,  477, 
 540,  541,  532,  531,  540,  541,  532,  531,  594,  595,  586,  585, 
 594,  595,  586,  585,  648,  649,  640,  639,  648,  649,  640,  639, 
 702,  703,  694,  693,  702,  703,  694,  693,  756,  757,  748,  747, 
 756,  757,  748,  747,  810,  811,  802,  801,  810,  811,  802,  801, 
 864,  865,  856,  855,  864,  865,  856,  855,  918,  919,  910,  909, 
 918,  919,  910,  909,  972,  973,  964,  963,  972,  973,  964,  963, 
1026, 1027, 1018, 1017, 1026, 1027, 1018, 1017, 1080, 1081, 1072, 1071, 
1080, 1081, 1072, 1071,   54,   55,   46,   45,   63,   64,   55,   54, 
 117,  118,  109,  108,  117,  118,  109,  108,  171,  172,  163,  162, 
 171,  172,  163,  162,  225,  226,  217,  216,  225,  226,  217,  216, 
 279,  280,  271,  270,  279,  280,  271,  270,  333,  334,  325,  324, 
 333,  334,  325,  324,  387,  388,  379,  378,  387,  388,  379,  378, 
 441,  442,  433,  432,  441,  442,  433,  432,  495,  496,  487,  486, 
 495,  496,  487,  486,  549,  550,  541,  540,  549,  550,  541,  540, 
 603,  604,  595,  594,  603,  604,  595,  594,  657,  658,  649,  648, 
 657,  658,  649,  648,  711,  712,  703,  702,  711,  712,  703,  702, 
 765,  766,  757,  756,  765,  766,  757,  756,  819,  820,  811,  810, 
 819,  820,  811,  810,  873,  874,  865,  864,  873,  874,  865,  864, 
 927,  928,  919,  918,  927,  928,  919,  918,  981,  982,  973,  972, 
 981,  982,  973,  972, 1035, 1036, 1027, 1026, 1035, 1036, 1027, 1026, 
1089, 1090, 1081, 1080, 1089, 1090, 1081, 1080,   63,   64,   55,   54, 
  28,   29,   20,   19,   82,   83,   74,   73,   82,   83,   74,   73, 
 136,  137,  128,  127,  136,  137,  128,  127,  190,  191,  182,  181, 
 190,  191,  182,  181,  244,  245,  236,  235,  244,  245,  236,  235, 
 298,  299,  290,  289,  298,  299,  290,  289,  352,  353,  344,  343, 
 352,  353,  344,  343,  406,  407,  398,  397,  406,  407,  398,  397, 
 460,  461,  452,  451,  460,  461,  452,  451,  514,  515,  506,  505, 
 514,  515,  506,  505,  568,  569,  560,  559,  568,  569,  560,  559, 
 622,  623,  614,  613,  622,  623,  614,  613,  676,  677,  668,  667, 
 676,  677,  668,  667,  730,  731,  722,  721,  730,  731,  722,  721, 
 784,  785,  776,  775,  784,  785,  776,  775,  838,  839,  830,  829, 
 838,  839,  830,  829,  892,  893,  884,  883,  892,  893,  884,  883, 
 946,  947,  938,  937,  946,  947,  938,  937, 1000, 1001,  992,  991, 
1000, 1001,  992,  991, 1054, 1055, 1046, 1045, 1054, 1055, 1046, 1045, 
  28,   29,   20,   19,   37,   38,   29,   28,   91,   92,   83,   82, 
  91,   92,   83,   82,  145,  146,  137,  136,  145,  146,  137,  136, 
 199,  200,  191,  190,  199,  200,  191,  190,  253,  254,  245,  244, 
 253,  254,  245,  244,  307,  308,  299,  298,  307,  308,  299,  298, 
 361,  362,  353,  352,  361,  362,  353,  352,  415,  416,  407,  406, 
 415,  416,  407,  406,  469,  470,  461,  460,  469,  470,  461,  460, 
 523,  524,  515,  514,  523,  524,  515,  514,  577,  578,  569,  568, 
 577,  578,  569,  568,  631,  632,  623,  622,  631,  632,  623,  622, 
 685,  686,  677,  676,  685,  686,  677,  676,  739,  740,  731,  730, 
 739,  740,  731,  730,  793,  794,  785,  784,  793,  794,  785,  784, 
 847,  848,  839,  838,  847,  848,  839,  838,  901,  902,  893,  892, 
 901,  902,  893,  892,  955,  956,  947,  946,  955,  956,  947,  946, 
1009, 1010, 1001, 1000, 1009, 1010, 1001, 1000, 1063, 1064, 1055, 1054, 
1063, 1064, 1055, 1054,   37,   38,   29,   28,   46,   47,   38,   37, 
 100,  101,   92,   91,  100,  101,   92,   91,  154,  155,  146,  145, 
 154,  155,  146,  145,  208,  209,  200,  199,  208,  209,  200,  199, 
 262,  263,  254,  253,  262,  263,  254,  253,  316,  317,  308,  307, 
 316,  317,  308,  307,  370,  371,  362,  361,  370,  371,  362,  361, 
 424,  425,  416,  415,  424,  425,  416,  415,  478,  479,  470,  469, 
 478,  479,  470,  469,  532,  533,  524,  523,  532,  533,  524,  523, 
 586,  587,  578,  577,  586,  587,  578,  577,  640,  641,  632,  631, 
 640,  641,  632,  631,  694,  695,  686,  685,  694,  695,  686,  685, 
 748,  749,  740,  739,  748,  749,  740,  739,  802,  803,  794,  793, 
 802,  803,  794,  793,  856,  857,  848,  847,  856,  857,  848,  847, 
 910,  911,  902,  901,  910,  911,  902,  901,  964,  965,  956,  955, 
 964,  965,  956,  955, 1018, 1019, 1010, 1009, 1018, 1019, 1010, 1009, 
1072, 1073, 1064, 1063, 1072, 1073, 1064, 1063,   46,   47,   38,   37, 
  55,   56,   47,   46,  109,  110,  101,  100,  109,  110,  101,  100, 
 163,  164,  155,  154,  163,  164,  155,  154,  217,  218,  209,  208, 
 217,  218,  209,  208,  271,  272,  263,  262,  271,  272,  263,  262, 
 325,  326,  317,  316,  325,  326,  317,  316,  379,  380,  371,  370, 
 379,  380,  371,  370,  433,  434,  425,  424,  433,  434,  425,  424, 
 487,  488,  479,  478,  487,  488,  479,  478,  541,  542,  533,  532, 
 541,  542,  533,  532,  595,  596,  587,  586,  595,  596,  587,  586, 
 649,  650,  641,  640,  649,  650,  641,  640,  703,  704,  695,  694, 
 703,  704,  695,  694,  757,  758,  749,  748,  757,  758,  749,  748, 
 811,  812,  803,  802,  811,  812,  803,  802,  865,  866,  857,  856, 
 865,  866,  857,  856,  919,  920,  911,  910,  919,  920,  911,  910, 
 973,  974,  965,  964,  973,  974,  965,  964, 1027, 1028, 1019, 1018, 
1027, 1028, 1019, 1018, 1081, 1082, 1073, 1072, 1081, 1082, 1073, 1072, 
  55,   56,   47,   46,   64,   65,   56,   55,  118,  119,  110,  109, 
 118,  119,  110,  109,  172,  173,  164,  163,  172,  173,  164,  163, 
 226,  227,  218,  217,  226,  227,  218,  217,  280,  281,  272,  271, 
 280,  281,  272,  271,  334,  335,  326,  325,  334,  335,  326,  325, 
 388,  389,  380,  379,  388,  389,  380,  379,  442,  443,  434,  433, 
 442,  443,  434,  433,  496,  497,  488,  487,  496,  497,  488,  487, 
 550,  551,  542,  541,  550,  551,  542,  541,  604,  605,  596,  595, 
 604,  605,  596,  595,  658,  659,  650,  649,  658,  659,  650,  649, 
 712,  713,  704,  703,  712,  713,  704,  703,  766,  767,  758,  757, 
 766,  767,  758,  757,  820,  821,  812,  811,  820,  821,  812,  811, 
 874,  875,  866,  865,  874,  875,  866,  865,  928,  929,  920,  919, 
 928,  929,  920,  919,  982,  983,  974,  973,  982,  983,  974,  973, 
1036, 1037, 1028, 1027, 1036, 1037, 1028, 1027, 1090, 1091, 1082, 1081, 
1090, 1091, 1082, 1081,   64,   65,   56,   55,   29,   30,   21,   20, 
  83,   84,   75,   74,   83,   84,   75,   74,  137,  138,  129,  128, 
 137,  138,  129,  128,  191,  192,  183,  182,  191,  192,  183,  182, 
 245,  246,  237,  236,  245,  246,  237,  236,  299,  300,  291,  290, 
 299,  300,  291,  290,  353,  354,  345,  344,  353,  354,  345,  344, 
 407,  408,  399,  398,  407,  408,  399,  398,  461,  462,  453,  452, 
 461,  462,  453,  452,  515,  516,  507,  506,  515,  516,  507,  506, 
 569,  570,  561,  560,  569,  570,  561,  560,  623,  624,  615,  614, 
 623,  624,  615,  614,  677,  678,  669,  668,  677,  678,  669,  668, 
 731,  732,  723,  722,  731,  732,  723,  722,  785,  786,  777,  776, 
 785,  786,  777,  776,  839,  840,  831,  830,  839,  840,  831,  830, 
 893,  894,  885,  884,  893,  894,  885,  884,  947,  948,  939,  938, 
 947,  948,  939,  938, 1001, 1002,  993,  992, 1001, 1002,  993,  992, 
1055, 1056, 1047, 1046, 1055, 1056, 1047, 1046,   29,   30,   21,   20, 
  38,   39,   30,   29,   92,   93,   84,   83,   92,   93,   84,   83, 
 146,  147,  138,  137,  146,  147,  138,  137,  200,  201,  192,  191, 
 200,  201,  192,  191,  254,  255,  246,  245,  254,  255,  246,  245, 
 308,  309,  300,  299,  308,  309,  300,  299,  362,  363,  354,  353, 
 362,  363,  354,  353,  416,  417,  408,  407,  416,  417,  408,  407, 
 470,  471,  462,  461,  470,  471,  462,  461,  524,  525,  516,  515, 
 524,  525,  516,  515,  578,  579,  570,  569,  578,  579,  570,  569, 
 632,  633,  624,  623,  632,  633,  624,  623,  686,  687,  678,  677, 
 686,  687,  678,  677,  740,  741,  732,  731,  740,  741,  732,  731, 
 794,  795,  786,  785,  794,  795,  786,  785,  848,  849,  840,  839, 
 848,  849,  840,  839,  902,  903,  894,  893,  902,  903,  894,  893, 
 956,  957,  948,  947,  956,  957,  948,  947, 1010, 1011, 1002, 1001, 
1010, 1011, 1002, 1001, 1064, 1065, 1056, 1055, 1064, 1065, 1056, 1055, 
  38,   39,   30,   29,   47,   48,   39,   38,  101,  102,   93,   92, 
 101,  102,   93,   92,  155,  156,  147,  146,  155,  156,  147,  146, 
 209,  210,  201,  200,  209,  210,  201,  200,  263,  264,  255,  254, 
 263,  264,  255,  254,  317,  318,  309,  308,  317,  318,  309,  308, 
 371,  372,  363,  362,  371,  372,  363,  362,  425,  426,  417,  416, 
 425,  426,  417,  416,  479,  480,  471,  470,  479,  480,  471,  470, 
 533,  534,  525,  524,  533,  534,  525,  524,  587,  588,  579,  578, 
 587,  588,  579,  578,  641,  642,  633,  632,  641,  642,  633,  632, 
 695,  696,  687,  686,  695,  696,  687,  686,  749,  750,  741,  740, 
 749,  750,  741,  740,  803,  804,  795,  794,  803,  804,  795,  794, 
 857,  858,  849,  848,  857,  858,  849,  848,  911,  912,  903,  902, 
 911,  912,  903,  902,  965,  966,  957,  956,  965,  966,  957,  956, 
1019, 1020, 1011, 1010, 1019, 1020, 1011, 1010, 1073, 1074, 1065, 1064, 
1073, 1074, 1065, 1064,   47,   48,   39,   38,   56,   57,   48,   47, 
 110,  111,  102,  101,  110,  111,  102,  101,  164,  165,  156,  155, 
 164,  165,  156,  155,  218,  219,  210,  209,  218,  219,  210,  209, 
 272,  273,  264,  263,  272,  273,  264,  263,  326,  327,  318,  317, 
 326,  327,  318,  317,  380,  381,  372,  371,  380,  381,  372,  371, 
 434,  435,  426,  425,  434,  435,  426,  425,  488,  489,  480,  479, 
 488,  489,  480,  479,  542,  543,  534,  533,  542,  543,  534,  533, 
 596,  597,  588,  587,  596,  597,  588,  587,  650,  651,  642,  641, 
 650,  651,  642,  641,  704,  705,  696,  695,  704,  705,  696,  695, 
 758,  759,  750,  749,  758,  759,  750,  749,  812,  813,  804,  803, 
 812,  813,  804,  803,  866,  867,  858,  857,  866,  867,  858,  857, 
 920,  921,  912,  911,  920,  921,  912,  911,  974,  975,  966,  965, 
 974,  975,  966,  965, 1028, 1029, 1020, 1019, 1028, 1029, 1020, 1019, 
1082, 1083, 1074, 1073, 1082, 1083, 1074, 1073,   56,   57,   48,   47, 
  65,   66,   57,   56,  119,  120,  111,  110,  119,  120,  111,  110, 
 173,  174,  165,  164,  173,  174,  165,  164,  227,  228,  219,  218, 
 227,  228,  219,  218,  281,  282,  273,  272,  281,  282,  273,  272, 
 335,  336,  327,  326,  335,  336,  327,  326,  389,  390,  381,  380, 
 389,  390,  381,  380,  443,  444,  435,  434,  443,  444,  435,  434, 
 497,  498,  489,  488,  497,  498,  489,  488,  551,  552,  543,  542, 
 551,  552,  543,  542,  605,  606,  597,  596,  605,  606,  597,  596, 
 659,  660,  651,  650,  659,  660,  651,  650,  713,  714,  705,  704, 
 713,  714,  705,  704,  767,  768,  759,  758,  767,  768,  759,  758, 
 821,  822,  813,  812,  821,  822,  813,  812,  875,  876,  867,  866, 
 875,  876,  867,  866,  929,  930,  921,  920,  929,  930,  921,  920, 
 983,  984,  975,  974,  983,  984,  975,  974, 1037, 1038, 1029, 1028, 
1037, 1038, 1029, 1028, 1091, 1092, 1083, 1082, 1091, 1092, 1083, 1082, 
  65,   66,   57,   56, 
};

int       matlist[1200];
double    u[1093];
double    v[1093];
double    w[1093];
double    t[1200];      /* Zone-centered */

/***********************************************************************
 *
 * Purpose:  Test the DBCalcExternalFacelist routine with all the
 *           ucd shapes.
 *
 * Programmer:  Eric Brugger
 * Date:        January 8, 1996
 *
 * Input arguments:
 *
 * Output arguments:
 *
 * Input/Output arguments:
 *
 * Notes:
 *
 * Modifications:
 *    Eric Brugger, Thu Jan 11 11:56:29 PST 1996
 *    I modified the routine to also create some scalars.
 *
 *    Sean Ahern, Tue Mar 31 17:47:24 PST 1998
 *    Changed the globe coordinates and varibles to type double.
 *
 *    Sean Ahern, Tue Mar 31 17:51:44 PST 1998
 *    Reformatted whitespace.
 *
 *    Robb Matzke, 1999-04-09
 *    Added argument parsing to control the driver which is used.
 *
 *    Jeremy Meredith, Thu Mar 23 13:25:12 PST 2000
 *    The prisms were backwards.  I flipped them (above in the nodelist).
 *
 **********************************************************************/
int
main(int argc, char *argv[])
{
    int             i, j, k;
    int             mat;
    int             cycle = 0;
    float           time = 0.;
    int             nzones = 1200;
    int             nnodes = 1093;
    int             ndims = 3;
    int             lznodelist = 8560;
    int             origin = 0;
    int             nzshapes = 4;
    int             zshapecnt[4] = {40, 200, 160, 800};
    int             zshapesize[4] = {4, 6, 5, 8};
    char           *coordnames[3] = {"xcoords", "ycoords", "zcoords"};
    int             dims[3] = {1200, 1, 1};
    int             nmat = 4;
    int             matnos[4] = {1, 2, 3, 4};
    DBfile         *dbfile;
    DBfacelist     *fl;
    DBoptlist      *optlist;
    double         *coords[3];
    char	   *filename = "globe.pdb";
    int		    driver = DB_PDB;
    int             show_all_errors = FALSE;
    char **matnames;

    /* Parse command-line */
    for (i=1; i<argc; i++) {
	if (!strncmp(argv[i], "DB_PDB",6)) {
	    driver = StringToDriver(argv[i]);
	    filename = "globe.pdb";
	} else if (!strncmp(argv[i], "DB_HDF5", 7)) {
	    driver = StringToDriver(argv[i]);
	    filename = "globe.h5";
        } else if (!strcmp(argv[i], "show-all-errors")) {
            show_all_errors = 1;
	} else if (argv[i][0] != '\0') {
	    fprintf(stderr, "%s: ignored argument `%s'\n", argv[0], argv[i]);
	}
    }
    
    if (show_all_errors) DBShowErrors(DB_ALL_AND_DRVR, 0);

    DBSetDeprecateWarnings(0);
    printf("Creating test file \"%s\".\n", filename);
    dbfile = DBCreate(filename, DB_CLOBBER, DB_LOCAL,
                      "unstructured mesh of globe", driver);

    /* 
     * Create the velocity component arrays.
     */
    for (i = 0; i < 1093; i++)
    {
        u[i] = coord1[i];
        v[i] = -coord0[i];
        w[i] = 0.;
    }

    /* 
     * Create a material array where each shape type is a different
     * material.
     */
    k = 0;
    for (i = 0; i < nzshapes; i++)
    {
        switch (zshapesize[i])
        {
        case 4:
            mat = 1;
            break;
        case 5:
            mat = 2;
            break;
        case 6:
            mat = 3;
            break;
        case 8:
            mat = 4;
            break;
        default:
            mat = 4;
            break;
        }
        for (j = 0; j < zshapecnt[i]; j++)
            matlist[k++] = mat;
    }

    {
        char var[] = "mesh mesh1;pseudocolor u";
        i = sizeof(var);
        DBWrite(dbfile, "_meshtvinfo", var, &i, 1, DB_CHAR);
    }

    {
        char var[] = "vel vector {u,v,w};speed scalar sqrt(u*u+v*v+w*w)";
        i = sizeof(var);
        DBWrite(dbfile, "_meshtv_defvars", var, &i, 1, DB_CHAR);
    }

    /* 
     * Create a zonelist that describes a mesh that looks like a
     * globe and then call DBCalcExternalFacelist to calculate
     * the face list that goes with it.
     */
    DBPutZonelist(dbfile, "zl", nzones, ndims, znodelist, lznodelist, origin,
                  zshapesize, zshapecnt, nzshapes);

    fl = DBCalcExternalFacelist(znodelist, nnodes, origin, zshapesize,
                                zshapecnt, nzshapes, matlist, 1);

    DBPutFacelist(dbfile, "fl", fl->nfaces, fl->ndims, fl->nodelist,
                  fl->lnodelist, fl->origin, fl->zoneno, fl->shapesize,
                  fl->shapecnt, fl->nshapes, fl->types, fl->typelist,
                  fl->ntypes);

    DBFreeFacelist(fl);

    coords[0] = coord0;
    coords[1] = coord1;
    coords[2] = coord2;

    optlist = DBMakeOptlist(10);
    DBAddOption(optlist, DBOPT_CYCLE, &cycle);
    DBAddOption(optlist, DBOPT_TIME, &time);

    for(i=0;i<1200;i++)
    {
        t[i] = i;
    }

    DBPutUcdmesh(dbfile, "mesh1", ndims, (DBCAS_t) coordnames,
        coords, nnodes, nzones, "zl", "fl", DB_DOUBLE, optlist);

    matnames = (char**)malloc(sizeof(char*)*4);
    matnames[0] = strdup("Inner poles");
    matnames[1] = strdup("Core");
    matnames[2] = strdup("Outer poles");
    matnames[3] = strdup("Mantle");
    DBAddOption(optlist, DBOPT_MATNAMES, matnames);
    DBPutMaterial(dbfile, "mat1", "mesh1", nmat, matnos, matlist, dims, ndims,
                  NULL, NULL, NULL, NULL, 0, DB_FLOAT, optlist);

    DBPutUcdvar1(dbfile, "u", "mesh1", (void *)u, nnodes, NULL, 0,
                 DB_DOUBLE, DB_NODECENT, optlist);

    DBPutUcdvar1(dbfile, "v", "mesh1", (void *)v, nnodes, NULL, 0,
                 DB_DOUBLE, DB_NODECENT, optlist);

    DBPutUcdvar1(dbfile, "w", "mesh1", (void *)w, nnodes, NULL, 0,
                 DB_DOUBLE, DB_NODECENT, optlist);

    DBPutUcdvar1(dbfile, "t", "mesh1", (void *)t, nzones, NULL, 0,
                 DB_DOUBLE, DB_ZONECENT, optlist);

    DBClose(dbfile);

    DBFreeOptlist(optlist);
    for (i = 0; i < 4; i++)
        free(matnames[i]);
    free(matnames);

    CleanupDriverStuff();
    return(0);
}
