#define XERR
#include "loop.ih"

// size_t g_err = 14;

    // by iterate.cc

void Loop::genCases(size_t iter, size_t nCases)
{
    CSVTable dataTable = headerData(iter);

    bool showAll = not d_options.specificAges() and d_options.lastCase() == 0;

                                        // perform 'nCases' simulations
    for (size_t d_caseIdx = 0; d_caseIdx != nCases; ++d_caseIdx)
    {
        g_log.caseIdx(d_caseIdx);
        caseInit();             // initialize the data for this case

        screening();        // no action unless screening rounds are specified

        postScreen();

        if (dataTable.stream() and (showAll or d_caseIdx + 1 == nCases))
        {
            d_tumor.checkDeath(d_naturalDeathAge);
            writeData(dataTable, d_caseIdx);
        }
    }

    dataTable << hline();
}

// In the original womanloop function a test is performed whether the
// woman has died or not. This test is superfluous because if the woman enters
// postScreen with status PRESENT then in postScreen the status either changes
// to NATURAL_POST or SELF_POST.
