#!/bin/sh
 
case $# in
  0)
    echo "mkt1enc.sh ENCFILE..."
    exit 1
    ;;
esac


for F in $* 
do

  case $# in
    --help|-help)
      echo "mkt1enc.sh ENCFILE..."
      exit 1
      ;;
  esac

  PSENCFILE=$F
  T1ENCFILE=`echo $PSENCFILE | sed 's|.*/\([^/]*\)|\1|' | sed 's|.enc$|.enc|`

  echo "$PSENCFILE ==> $T1ENCFILE"

  if [ -f $T1ENCFILE ] ; then
    echo "Error: $T1ENCFILE exists." >&2
    exit 1;
  fi

  touch $T1ENCFILE

  echo "# $T1ENCFILE: an encoding vector file for T1Lib."  >>$T1ENCFILE
  echo "# Generated by mkt1enc.sh from $PSENCFILE."        >>$T1ENCFILE
  cat $PSENCFILE \
  | sed 's/%.*//' \
  | tr ' ' '\n' \
  | sed 's/[ ]*$//' | grep -v '^$' \
  | grep -v "\[" | grep -v "\]" | grep -v '^def$' \
  | sed 's|^/||' \
  | awk 'BEGIN { chr = 0; }   
         //    { if (NR == 1){ 
                   printf("Encoding=%s\n", $1); 
                  } else {
                   printf("%-50s/* %02x */\n", $0, chr); 
                   chr++;
                  }
               }' \
  | cat >>$T1ENCFILE
 
done
