
#include <ctype.h> 
#include <fli.h>
#include <stdio.h>
#include <string.h>

void fli_parse_helpfile (int index)
{
    register FL_FORM
	*form = fli_help_browser [index].form;
    register FL_OBJECT
	*indexwin = fli_help_browser [index].indexbrowser,
	*contentswin = fli_help_browser [index].contentsbrowser;
    char
	buf [1025];
    register char
	*entry,
	*cp;
    register int
	i,
	sorted;
    register FILE
	*f = fli_help_browser [index].f;

    /* don't display right now */ 
    fl_freeze_form (form);

    /* read lines matching [entry] with spaces before the first [ */ 
    while (1)
    {
	fgets (buf, 1024, f);
	if (feof (f) || ! isspace (buf [0]) || ! (entry = strchr (buf, '[')))
	    break;
	strcpy (entry, entry + 1);
	if (! (cp = strchr (entry, ']')) )
	    break;
	*cp = '\0';

	/* put whole entry line into contents */ 
	fl_add_browser_line (contentswin, buf);
	/* put line without leading spaces into index */ 
	fl_add_browser_line (indexwin, entry);
    }

    /* re-sort index window */
    sorted = 0;
    while (! sorted)
    {
	sorted = 1;
	for (i = 2; i <= fl_get_browser_maxline (indexwin); i++)
	{
	    register char const
		*one = fl_get_browser_line (indexwin, i - 1),
		*two = fl_get_browser_line (indexwin, i);
	    if (strcasecmp (one, two) > 0)
	    {
		char
		    buf [1024];
		strcpy (buf, one);
		fl_replace_browser_line (indexwin, i - 1, two);
		fl_replace_browser_line (indexwin, i, buf);

		sorted = 0;
	    }
	}
    }

    /* show the form now */ 
    fl_set_browser_topline (contentswin, 1);
    fl_set_browser_topline (indexwin, 1);
    fl_unfreeze_form (form);
}
