# include file to test index and table statstics for specific storage engine
# requires includer set the default strorage engine for the session

# Bug 602047 (wrong rows_read value)

FLUSH INDEX_STATISTICS;
FLUSH TABLE_STATISTICS;

SET @userstat_old= @@userstat;
SET GLOBAL userstat=ON;

--disable_ps2_protocol
CREATE TABLE t1 (id int(10), PRIMARY KEY (id));
INSERT INTO t1 VALUES (1),(2),(3),(4),(5),(6),(7),(8),(9),(10);
SELECT COUNT(*) FROM t1; 
SELECT ROWS_READ FROM INFORMATION_SCHEMA.TABLE_STATISTICS WHERE TABLE_NAME='t1';
SELECT ROWS_READ FROM INFORMATION_SCHEMA.INDEX_STATISTICS WHERE TABLE_NAME='t1';

# Test that FLUSH clears one table but not another

FLUSH TABLE_STATISTICS;

SELECT ROWS_READ FROM INFORMATION_SCHEMA.TABLE_STATISTICS WHERE TABLE_NAME='t1';
SELECT ROWS_READ FROM INFORMATION_SCHEMA.INDEX_STATISTICS WHERE TABLE_NAME='t1';

# Test that FLUSH clears both tables now

FLUSH INDEX_STATISTICS;

SELECT ROWS_READ FROM INFORMATION_SCHEMA.INDEX_STATISTICS WHERE TABLE_NAME='t1';

# Test that stats are collected after the FLUSH again

SELECT COUNT(*) FROM t1; 
SELECT ROWS_READ FROM INFORMATION_SCHEMA.TABLE_STATISTICS WHERE TABLE_NAME='t1';
SELECT ROWS_READ FROM INFORMATION_SCHEMA.INDEX_STATISTICS WHERE TABLE_NAME='t1';
--enable_ps2_protocol

DROP TABLE t1;

# Bug 1183625 (handler::update_global_table_stats crash).

CREATE TABLE t2 (c1 INT UNSIGNED);

ALTER TABLE t2 MODIFY c1 FLOAT;

SELECT * FROM INFORMATION_SCHEMA.TABLE_STATISTICS WHERE TABLE_NAME='t2';

DROP TABLE t2;

# Bug 1183625 (handler::update_global_table_stats crash).

CREATE TABLE t2 (c1 INT UNSIGNED);

ALTER TABLE t2 MODIFY c1 FLOAT;

SELECT * FROM INFORMATION_SCHEMA.TABLE_STATISTICS WHERE TABLE_NAME='t2';

DROP TABLE t2;

SET GLOBAL userstat= @userstat_old;
