/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.io;

import com.mysql.cj.api.io.PacketSender;
import com.mysql.cj.core.util.StringUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class DebugBufferingPacketSender
implements PacketSender {
    private PacketSender packetSender;
    private List<StringBuilder> packetDebugBuffer;
    private int maxPacketDumpLength = 1024;
    private static final int DEBUG_MSG_LEN = 64;

    public DebugBufferingPacketSender(PacketSender packetSender, List<StringBuilder> packetDebugBuffer) {
        this.packetSender = packetSender;
        this.packetDebugBuffer = packetDebugBuffer;
    }

    public void setMaxPacketDumpLength(int maxPacketDumpLength) {
        this.maxPacketDumpLength = maxPacketDumpLength;
    }

    private void pushPacketToDebugBuffer(byte[] packet, int packetLen) {
        int bytesToDump = Math.min(this.maxPacketDumpLength, packetLen);
        String packetPayload = StringUtils.dumpAsHex(packet, bytesToDump);
        StringBuilder packetDump = new StringBuilder(68 + packetPayload.length());
        packetDump.append("Client ");
        packetDump.append(Arrays.toString(packet));
        packetDump.append("--------------------> Server\n");
        packetDump.append("\nPacket payload:\n\n");
        packetDump.append(packetPayload);
        if (packetLen > this.maxPacketDumpLength) {
            packetDump.append("\nNote: Packet of " + packetLen + " bytes truncated to " + this.maxPacketDumpLength + " bytes.\n");
        }
        this.packetDebugBuffer.add(packetDump);
    }

    @Override
    public void send(byte[] packet, int packetLen, byte packetSequence) throws IOException {
        this.pushPacketToDebugBuffer(packet, packetLen);
        this.packetSender.send(packet, packetLen, packetSequence);
    }
}

