//---------------------------------------------------------------------------//
// Copyright (c) 2015 Jakub Szuppe <j.szuppe@gmail.com>
//
// Distributed under the Boost Software License, Version 1.0
// See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt
//
// See http://boostorg.github.com/compute for more information.
//---------------------------------------------------------------------------//

#include <algorithm>
#include <iostream>
#include <vector>

#include "perf.hpp"

// Max integer that can be generated by rand_int() function.
int rand_int_max = 25;

int rand_int()
{
    return static_cast<int>((rand() / double(RAND_MAX)) * rand_int_max);
}

int main(int argc, char *argv[])
{
    perf_parse_args(argc, argv);
    std::cout << "size: " << PERF_N << std::endl;

    // create vector of random numbers on the host
    std::vector<int> host_vector(PERF_N);
    std::generate(host_vector.begin(), host_vector.end(), rand_int);

    // trying to find element that isn't in vector (worst-case scenario)
    int wanted = rand_int_max + 1;

    // result
    std::vector<int>::iterator host_result_it;

    perf_timer t;
    for(size_t trial = 0; trial < PERF_TRIALS; trial++){
        t.start();
        host_result_it = std::find(host_vector.begin(), host_vector.end(), wanted);
        t.stop();
    }
    std::cout << "time: " << t.min_time() / 1e6 << " ms" << std::endl;

    // verify
    if(host_result_it != host_vector.end()){
        std::cout << "ERROR: "
                  << "host_result_iterator != "
                  << "host_vector.end()"
                  << std::endl;
        return -1;
    }

    return 0;
}
