/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Activity;
import android.content.Context;
import android.os.SystemClock;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.ViewFetcher;

class DialogUtils {
    private final ActivityUtils activityUtils;
    private final ViewFetcher viewFetcher;
    private final Sleeper sleeper;
    private static final int TIMEOUT_DIALOG_TO_CLOSE = 1000;
    private final int MINISLEEP = 200;

    public DialogUtils(ActivityUtils activityUtils, ViewFetcher viewFetcher, Sleeper sleeper) {
        this.activityUtils = activityUtils;
        this.viewFetcher = viewFetcher;
        this.sleeper = sleeper;
    }

    public boolean waitForDialogToClose(long timeout) {
        this.waitForDialogToOpen(1000L, false);
        long endTime = SystemClock.uptimeMillis() + timeout;
        while (SystemClock.uptimeMillis() < endTime) {
            if (!this.isDialogOpen()) {
                return true;
            }
            this.sleeper.sleep(200);
        }
        return false;
    }

    public boolean waitForDialogToOpen(long timeout, boolean sleepFirst) {
        long endTime = SystemClock.uptimeMillis() + timeout;
        if (sleepFirst) {
            this.sleeper.sleepMini();
        }
        while (SystemClock.uptimeMillis() < endTime) {
            if (this.isDialogOpen()) {
                return true;
            }
            this.sleeper.sleepMini();
        }
        return false;
    }

    private boolean isDialogOpen() {
        Activity activity = this.activityUtils.getCurrentActivity(false);
        View view = this.viewFetcher.getRecentDecorView(this.viewFetcher.getWindowDecorViews());
        Context viewContext = null;
        if (view != null) {
            viewContext = view.getContext();
        }
        if (viewContext instanceof ContextThemeWrapper) {
            ContextThemeWrapper ctw = (ContextThemeWrapper)viewContext;
            viewContext = ctw.getBaseContext();
        }
        Activity activityContext = activity;
        Context activityBaseContext = activity.getBaseContext();
        return (activityContext.equals(viewContext) || activityBaseContext.equals(viewContext)) && view != activity.getWindow().getDecorView();
    }

    public void hideSoftKeyboard(EditText editText, boolean shouldSleepFirst, boolean shouldSleepAfter) {
        EditText freshestEditText;
        Activity activity = this.activityUtils.getCurrentActivity(shouldSleepFirst);
        InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
        if (editText != null) {
            inputMethodManager.hideSoftInputFromWindow(editText.getWindowToken(), 0);
            return;
        }
        View focusedView = activity.getCurrentFocus();
        if (!(focusedView instanceof EditText) && (freshestEditText = this.viewFetcher.getFreshestView(this.viewFetcher.getCurrentViews(EditText.class))) != null) {
            focusedView = freshestEditText;
        }
        if (focusedView != null) {
            inputMethodManager.hideSoftInputFromWindow(focusedView.getWindowToken(), 0);
        }
        if (shouldSleepAfter) {
            this.sleeper.sleep();
        }
    }
}

