# Provider Policies

This page documents any policies, terms of use and rate limits that apply to
a given service provider. If you notice an out-of-date, incorrect or missing
link, please open an issue or merge request as soon as possible.

## Google

The policies here apply to the `google` provider, including recommended and
required authentication practices.

### OAuth 2.0

* [OAuth 2.0 Policies](https://developers.google.com/identity/protocols/oauth2/policies)
* [OAuth 2.0 for Mobile & Desktop Apps](https://developers.google.com/identity/protocols/oauth2/native-app)

### Rate Limits

* [OAuth Application Rate Limits](https://support.google.com/cloud/answer/9028764)
* [OAuth Application: Request Increase to New User Authorization Limit](https://support.google.com/code/contact/oauth_quota_increase)

### Policy Changes

* [Upcoming security changes to Google's OAuth 2.0 authorization endpoint in embedded webviews](https://developers.googleblog.com/2021/06/upcoming-security-changes-to-googles-oauth-2.0-authorization-endpoint.html)

## Microsoft

This policy applies to the GNOME Foundation's Entra account microsoft@gnome.org,
not the user accounts registered with the "GNOME" application client ID.

* [Microsoft Entra service limits and restrictions](https://learn.microsoft.com/entra/identity/users/directory-service-limits-restrictions)

### Rate Limits

These policies apply to user accounts and request rates.

* Microsoft 365 Personal (formerly Office365) (`windows_live`)
  * [Exchange Online limits](https://learn.microsoft.com/en-us/office365/servicedescriptions/exchange-online-service-description/exchange-online-limits)
* Microsoft 365 Graph (`ms_graph`)
  * [Microsoft Graph service-specific throttling limits](https://learn.microsoft.com/graph/throttling-limits)

