// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv32 -target-feature +experimental-zbt -emit-llvm %s -o - \
// RUN:     | FileCheck %s  -check-prefix=RV32ZBT

// RV32ZBT-LABEL: @fsl(
// RV32ZBT-NEXT:  entry:
// RV32ZBT-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV32ZBT-NEXT:    [[RS2_ADDR:%.*]] = alloca i32, align 4
// RV32ZBT-NEXT:    [[RS3_ADDR:%.*]] = alloca i32, align 4
// RV32ZBT-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV32ZBT-NEXT:    store i32 [[RS2:%.*]], i32* [[RS2_ADDR]], align 4
// RV32ZBT-NEXT:    store i32 [[RS3:%.*]], i32* [[RS3_ADDR]], align 4
// RV32ZBT-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV32ZBT-NEXT:    [[TMP1:%.*]] = load i32, i32* [[RS2_ADDR]], align 4
// RV32ZBT-NEXT:    [[TMP2:%.*]] = load i32, i32* [[RS3_ADDR]], align 4
// RV32ZBT-NEXT:    [[TMP3:%.*]] = call i32 @llvm.riscv.fsl.i32(i32 [[TMP0]], i32 [[TMP1]], i32 [[TMP2]])
// RV32ZBT-NEXT:    ret i32 [[TMP3]]
//
int fsl(int rs1, int rs2, int rs3) {
  return __builtin_riscv_fsl_32(rs1, rs2, rs3);
}

// RV32ZBT-LABEL: @fsr(
// RV32ZBT-NEXT:  entry:
// RV32ZBT-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV32ZBT-NEXT:    [[RS2_ADDR:%.*]] = alloca i32, align 4
// RV32ZBT-NEXT:    [[RS3_ADDR:%.*]] = alloca i32, align 4
// RV32ZBT-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV32ZBT-NEXT:    store i32 [[RS2:%.*]], i32* [[RS2_ADDR]], align 4
// RV32ZBT-NEXT:    store i32 [[RS3:%.*]], i32* [[RS3_ADDR]], align 4
// RV32ZBT-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV32ZBT-NEXT:    [[TMP1:%.*]] = load i32, i32* [[RS2_ADDR]], align 4
// RV32ZBT-NEXT:    [[TMP2:%.*]] = load i32, i32* [[RS3_ADDR]], align 4
// RV32ZBT-NEXT:    [[TMP3:%.*]] = call i32 @llvm.riscv.fsr.i32(i32 [[TMP0]], i32 [[TMP1]], i32 [[TMP2]])
// RV32ZBT-NEXT:    ret i32 [[TMP3]]
//
int fsr(int rs1, int rs2, int rs3) {
  return __builtin_riscv_fsr_32(rs1, rs2, rs3);
}

// RV32ZBT-LABEL: @fsri(
// RV32ZBT-NEXT:  entry:
// RV32ZBT-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV32ZBT-NEXT:    [[RS2_ADDR:%.*]] = alloca i32, align 4
// RV32ZBT-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV32ZBT-NEXT:    store i32 [[RS2:%.*]], i32* [[RS2_ADDR]], align 4
// RV32ZBT-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV32ZBT-NEXT:    [[TMP1:%.*]] = load i32, i32* [[RS2_ADDR]], align 4
// RV32ZBT-NEXT:    [[TMP2:%.*]] = call i32 @llvm.riscv.fsr.i32(i32 [[TMP0]], i32 [[TMP1]], i32 15)
// RV32ZBT-NEXT:    ret i32 [[TMP2]]
//
int fsri(int rs1, int rs2) {
  return __builtin_riscv_fsr_32(rs1, rs2, 15);
}
