#include <glib.h>
#include <glib/gstdio.h>
#include "unity-webapps-application-collector.h"
#include "unity-webapps-application-manifest.h"
#include "unity-webapps-local-available-application.h"
#include "unity-webapps-debug.h"

static GMainLoop *main_loop = NULL;

int
main (int argc, gchar **argv)
{
  UnityWebappsApplicationCollector *collector;
  GHashTable *applications_by_name;
  GList *applications, *l;

  g_type_init ();
  
  unity_webapps_debug_initialize_flags();
  
  collector = unity_webapps_application_collector_new_with_default_path ();
  unity_webapps_application_collector_search_path (collector);
  
  applications_by_name = unity_webapps_application_collector_get_applications (collector);
  applications = g_hash_table_get_values (applications_by_name);
  
  for (l = applications; l != NULL; l = l->next)
    {
      UnityWebappsLocalAvailableApplication *app;
      
      app = (UnityWebappsLocalAvailableApplication *)l->data;
      
      g_printf("Found application: %s \n", 
	       unity_webapps_application_manifest_get_name (unity_webapps_local_available_application_get_manifest (app)));
    }
  
  g_list_free (applications);
  
  return 0;
}
