# Error index {#error-index}

<!--
NOTE: This file has been generated automatically by “update-message-registry.py”.
      Do not edit manually!
-->

This page lists the warnings and errors generated by xkbcommon.
There are currently 74 entries.

@todo The documentation of the log messages is a work in progress.

## Index {#error-code-list}

| Code      | Identifier                   | Description | Type |
| --------- | ---------------------------- | ----------- | ---- |
| [XKB-034] | `malformed-number-literal` | Warn on malformed number literals | Error |
| [XKB-043] | `conflicting-key-type-preserve-entries` | Conflicting “preserve” entries in a key type | Warning |
| [XKB-052] | `integer-overflow` | The result of the operation is not mathematically correct | Error |
| [XKB-060] | `unsupported-modifier-mask` | Warn on unsupported modifier mask | Error |
| [XKB-077] | `expected-array-entry` | Expected an array entry, but the index is missing | Error |
| [XKB-082] | `invalid-numeric-keysym` | Invalid numeric keysym | Error |
| [XKB-101] | `illegal-keycode-alias` | Illegal keycode alias with the name of a real key | Warning |
| [XKB-107] | `unrecognized-keysym` | Warn on unrecognized keysyms | Warning |
| [XKB-123] | `undeclared-virtual-modifier` | A virtual modifier is used before being declared | Error |
| [XKB-134] | `insufficient-buffer-size` | A buffer has an insufficient size | Error |
| [XKB-150] | `wrong-statement-type` | The type of the statement is not allowed in the context | Error |
| [XKB-161] | `invalid-path` | The given path is invalid | Error |
| [XKB-172] | `unsupported-geometry-section` | Geometry sections are not supported | Warning |
| [XKB-183] | `cannot-infer-key-type` | Warn if no key type can be inferred | Warning |
| [XKB-193] | `invalid-escape-sequence` | Invalid escape sequence in a string | Warning |
| [XKB-195] | `illegal-key-type-preserve-result` | The result of a key type “preserve” entry must be a subset of its input modifiers. | Warning |
| [XKB-203] | `invalid-include-statement` | Syntax error in the include statement | Error |
| [XKB-206] | `invalid-modmap-entry` | A modmap entry is invalid | Error |
| [XKB-237] | `unsupported-group-index` | Warn when a group index is not supported | Error |
| [XKB-239] | `conflicting-key-type-level-names` | The name of a key type level is defined multiple times. | Warning |
| [XKB-254] | `invalid-set-default-statement` | Invalid statement setting default values | Error |
| [XKB-266] | `conflicting-key-type-map-entry` | Conflicting “map” entries in type definition | Warning |
| [XKB-286] | `undefined-key-type` | Warn if using an undefined key type | Warning |
| [XKB-301] | `deprecated-keysym` | A keysym has been deprecated: consider using an alternative keysym | Warning |
| [XKB-302] | `deprecated-keysym-name` | A keysym name has been deprecated: use the corresponding canonical name instead | Warning |
| [XKB-305] | `non-base-group-name` | Warn if a group name was defined for group other than the first one | Warning |
| [XKB-312] | `unsupported-shift-level` | Warn when a shift level is not supported | Error |
| [XKB-338] | `included-file-not-found` | Could not find a file used in an include statement | Error |
| [XKB-345] | `unknown-operator` | Use of an operator that is unknown and thus unsupported | Error |
| [XKB-362] | `unsupported-legacy-action` | Use of a legacy X11 action that is not supported | Warning |
| [XKB-378] | `duplicate-entry` | An entry is duplicated and will be ignored | Warning |
| [XKB-386] | `recursive-include` | Included files form cycle | Error |
| [XKB-407] | `conflicting-key-type-definitions` | Conflicting definitions of a key type | Warning |
| [XKB-428] | `global-defaults-wrong-scope` | A global defaults statement is in a wrong scope and should be moved | Error |
| [XKB-433] | `missing-default-section` | Missing default section in included file | Warning |
| [XKB-461] | `conflicting-key-symbol` | Warn if there are conflicting keysyms while merging keys | Warning |
| [XKB-478] | `invalid-operation` | The operation is invalid in the context | Error |
| [XKB-489] | `numeric-keysym` | Warn on numeric keysym (other than 0-9) | Warning |
| [XKB-516] | `extra-symbols-ignored` | <span class="todo">TODO:</span> add description | Warning |
| [XKB-523] | `conflicting-key-name` | Conflicting definitions of a key name or alias | Warning |
| [XKB-542] | `invalid-file-encoding` | Invalid file encoding | Error |
| [XKB-550] | `allocation-error` | Cannot allocate memory | Error |
| [XKB-563] | `invalid-action-field` | Unknown or unsupported action field | Error |
| [XKB-578] | `wrong-field-type` | Warn when a field has not the expected type | Error |
| [XKB-595] | `cannot-resolve-rmlvo` | Cannot resolve a given (Rules, Model, Layout, Variant, Options) configuration | Error |
| [XKB-607] | `invalid-unicode-escape-sequence` | Invalid Unicode escape sequence | Warning |
| [XKB-623] | `invalid-real-modifier` | Invalid _real_ modifier | Error |
| [XKB-639] | `unknown-default-field` | Cannot set default value to a an unknown field | Error |
| [XKB-645] | `unknown-char-escape-sequence` | Warn on unknown escape sequence in string literal | Warning |
| [XKB-661] | `invalid-included-file` | The target file of an include statement could not be processed | Error |
| [XKB-679] | `invalid-compose-locale` | Invalid locale for Compose | Error |
| [XKB-685] | `invalid-compose-syntax` | The Compose file syntax is invalid and the entry cannot be parsed | Error |
| [XKB-693] | `incompatible-actions-and-keysyms-count` | A level has a different number of keysyms and actions | Error |
| [XKB-700] | `multiple-groups-at-once` | Warn if a key defines multiple groups at once | Warning |
| [XKB-711] | `unsupported-symbols-field` | A legacy X11 symbol field is not supported | Warning |
| [XKB-742] | `incompatible-keymap-text-format` | The keymap has features unsupported in the target format | Error |
| [XKB-762] | `rules-invalid-layout-index-percent-expansion` | Cannot expand `%%i`: missing layout or variant in MLVO rule fields | Error |
| [XKB-769] | `invalid-xkb-syntax` | The XKB syntax is invalid and the file cannot be parsed | Error |
| [XKB-770] | `undefined-keycode` | Reference to an undefined keycode | Warning |
| [XKB-784] | `invalid-expression-type` | An expression has not the expected type | Error |
| [XKB-796] | `invalid-value` | A value is invalid and will be ignored | Error |
| [XKB-800] | `conflicting-modmap` | Warn if there are conflicting modmap definitions | Warning |
| [XKB-812] | `unknown-field` | A field is unknown and will be ignored | Error |
| [XKB-822] | `keymap-compilation-failed` | Keymap compilation failed | Error |
| [XKB-844] | `unknown-action-type` | Unknown action type | Error |
| [XKB-883] | `conflicting-key-action` | Warn if there are conflicting actions while merging keys | Warning |
| [XKB-893] | `conflicting-key-type-merging-groups` | Warn if there are conflicting key types while merging groups | Warning |
| [XKB-901] | `conflicting-key-symbols-entry` | Conflicting symbols entry for a key | Error |
| [XKB-903] | `missing-symbols-group-name-index` | Missing group index in a group name entry | Warning |
| [XKB-935] | `conflicting-key-fields` | Warn if there are conflicting fields while merging keys | Warning |
| [XKB-949] | `invalid-identifier` | An identifier is used but is not built-in | Error |
| [XKB-965] | `unresolved-keymap-symbol` | Warn if using a symbol not defined in the keymap | Warning |
| [XKB-967] | `invalid-rules-syntax` | The rules syntax is invalid and the file cannot be parsed | Error |
| [XKB-971] | `undeclared-modifiers-in-key-type` | Some modifiers used in a key type “map” or “preserve” entry are not declared | Warning |

## Details

### XKB-034 – Malformed number literal {#XKB-034}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Warn on malformed number literals</dd>
</dl>

xkbcommon can parse the following number literal formats:

- *decimal integer:* 1, 123, etc.
- *decimal floating-point number:* 1.23, etc.
- *hexadecimal integer:* prefixed with “0x”: 0x123, 0xff, 0xAB, etc.


### XKB-043 – Conflicting key type preserve entries {#XKB-043}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Conflicting “preserve” entries in a key type</dd>
</dl>

### XKB-052 – Integer overflow {#XKB-052}

<dl>
  <dt>Since</dt><dd>1.10.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>The result of the operation is not mathematically correct</dd>
</dl>

The result of the operation is not representable in the corresponding
datatype and overflowed.


### XKB-060 – Unsupported modifier mask {#XKB-060}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Warn on unsupported modifier mask</dd>
</dl>

### XKB-077 – Expected array entry {#XKB-077}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Expected an array entry, but the index is missing</dd>
</dl>

### XKB-082 – Invalid numeric keysym {#XKB-082}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Invalid numeric keysym</dd>
</dl>

Keysyms are 32-bit integers with the 3 most significant bits always set to
zero. Thus valid keysyms are in the range `0 .. 0x1fffffff` = @ref XKB_KEYSYM_MAX.

See: Appendix A [“KEYSYM Encoding”][encoding] of the X Window System Protocol.

[encoding]: https://www.x.org/releases/current/doc/xproto/x11protocol.html#keysym_encoding

@see keysyms


### XKB-101 – Illegal keycode alias {#XKB-101}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Illegal keycode alias with the name of a real key</dd>
</dl>

### XKB-107 – Unrecognized keysym {#XKB-107}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Warn on unrecognized keysyms</dd>
</dl>

xkbcommon replaces keysyms it does not recognize by the keysym `NoSymbol`.

You may find the list of supported keysyms in
`include/xkbcommon/xkbcommon-keysyms.h`.


#### Examples

<details>
  <summary>Unrecognized keysym “`coma`”</summary>

**Error message:**

```
xkbcommon: WARNING: [XKB-107] de:31:20: unrecognized keysym "coma"
```

xkbcommon does not recognize the keysym “`coma`”. It is most probably
a typo for “<code>com<em>m</em>a</code>”.
See: `XKB_KEY_comma` in `include/xkbcommon/xkbcommon-keysyms.h`.

**Fix:**
  <div class="example-container">
    <div class="example">
      <div class="example-inner">
        <div class="example-title">Before</div>
```c
key <AB08> {[ coma, semicolon, periodcentered, multiply ]};
```
</div>
    </div>
    <div class="example">
      <div class="example-inner">
        <div class="example-title">After</div>
```c
key <AB08> {[ comma, semicolon, periodcentered, multiply ]};
```
</div>
    </div>
  </div>
</details>

### XKB-123 – Undeclared virtual modifier {#XKB-123}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>A virtual modifier is used before being declared</dd>
</dl>

### XKB-134 – Insufficient buffer size {#XKB-134}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>A buffer has an insufficient size</dd>
</dl>

### XKB-150 – Wrong statement type {#XKB-150}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>The type of the statement is not allowed in the context</dd>
</dl>

### XKB-161 – Invalid path {#XKB-161}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>The given path is invalid</dd>
</dl>

### XKB-172 – Unsupported geometry section {#XKB-172}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Geometry sections are not supported</dd>
</dl>

### XKB-183 – Cannot infer key type {#XKB-183}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Warn if no key type can be inferred</dd>
</dl>

### XKB-193 – Invalid escape sequence {#XKB-193}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Invalid escape sequence in a string</dd>
</dl>

### XKB-195 – Illegal key type preserve result {#XKB-195}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>The result of a key type “preserve” entry must be a subset of its input modifiers.</dd>
</dl>

### XKB-203 – Invalid include statement {#XKB-203}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Syntax error in the include statement</dd>
</dl>

### XKB-206 – Invalid modmap entry {#XKB-206}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>A modmap entry is invalid</dd>
</dl>

### XKB-237 – Unsupported group index {#XKB-237}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Warn when a group index is not supported</dd>
</dl>

xkbcommon supports different *group index* ranges, depending of the target
*keymap format*:
- `::XKB_KEYMAP_FORMAT_TEXT_V1`: 1..4
- `::XKB_KEYMAP_FORMAT_TEXT_V2`: 1..32


### XKB-239 – Conflicting key type level names {#XKB-239}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>The name of a key type level is defined multiple times.</dd>
</dl>

### XKB-254 – Invalid set default statement {#XKB-254}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Invalid statement setting default values</dd>
</dl>

### XKB-266 – Conflicting key type map entry {#XKB-266}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Conflicting “map” entries in type definition</dd>
</dl>

### XKB-286 – Undefined key type {#XKB-286}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Warn if using an undefined key type</dd>
</dl>

### XKB-301 – Deprecated keysym {#XKB-301}

<dl>
  <dt>Since</dt><dd>1.8.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>A keysym has been deprecated: consider using an alternative keysym</dd>
</dl>

Some keysyms have ambiguous meaning. It is advised to migrate to an alternative keysym
if possible, as deprecated keysyms may be removed in the future. Consider using Unicode
keysyms (`Unnnn`) if relevant.


### XKB-302 – Deprecated keysym name {#XKB-302}

<dl>
  <dt>Since</dt><dd>1.8.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>A keysym name has been deprecated: use the corresponding canonical name instead</dd>
</dl>

Some keysym names have typos, unconventional names or are historical aliases.
Please consider migrating to the reference name reported in the warning message.


### XKB-305 – Non base group name {#XKB-305}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Warn if a group name was defined for group other than the first one</dd>
</dl>

### XKB-312 – Unsupported shift level {#XKB-312}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Warn when a shift level is not supported</dd>
</dl>

Shift levels are _one_-indexed. xkbcommon supports two formats of shift levels:
as numbers and as identifiers `LevelN`, where `N` is in the range (1..8).


### XKB-338 – Included file not found {#XKB-338}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Could not find a file used in an include statement</dd>
</dl>

### XKB-345 – Unknown operator {#XKB-345}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Use of an operator that is unknown and thus unsupported</dd>
</dl>

### XKB-362 – Unsupported legacy action {#XKB-362}

<dl>
  <dt>Since</dt><dd>1.10.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Use of a legacy X11 action that is not supported</dd>
</dl>

This action will be treated as `NoAction()`. See @ref unsupported-legacy-x11-actions ""
for further information.


### XKB-378 – Duplicate entry {#XKB-378}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>An entry is duplicated and will be ignored</dd>
</dl>

### XKB-386 – Recursive include {#XKB-386}

<dl>
  <dt>Since</dt><dd>1.7.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Included files form cycle</dd>
</dl>

### XKB-407 – Conflicting key type definitions {#XKB-407}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Conflicting definitions of a key type</dd>
</dl>

The given key type is defined multiple times, but only one definition is kept.


### XKB-428 – Global defaults wrong scope {#XKB-428}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>A global defaults statement is in a wrong scope and should be moved</dd>
</dl>

#### Examples

<details>
  <summary>Default key type in key statement</summary>

**Error message:**

```
xkbcommon: ERROR: [XKB-428] Cannot set global defaults for "type" element
within a key statement: move statements to the global file scope.
Assignment to "key.type" ignored.
```

**Fix:**
  <div class="example-container">
    <div class="example">
      <div class="example-inner">
        <div class="example-title">Before</div>
```c
key <AE01> {
    key.type = "FOUR_LEVEL_SEMIALPHABETIC",
    symbols = [q, Q, at]
};
```
</div>
    </div>
    <div class="example">
      <div class="example-inner">
        <div class="example-title">After</div>
```c
// Either put default key type in global file scope
key.type = "FOUR_LEVEL_SEMIALPHABETIC";
key <AE01> { [q, Q, at] };
// or use a local setting (unqualified, i.e. without `key.`)
key <AE01> {
    type = "FOUR_LEVEL_SEMIALPHABETIC",
    symbols = [ q, Q, at ]
};
```
</div>
    </div>
  </div>
</details>

### XKB-433 – Missing default section {#XKB-433}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Missing default section in included file</dd>
</dl>

When using an include statement, the included file may contains multiple sections.
The include statement may specify the name of the section to include, or leave it
unspecified. In the latter case, the included file must then define a *default* section.
The present warning is shown when no default section is defined.

To solve this, either fix the include statement by specifying the exact section to
include, or declare a default section in the included file.


### XKB-461 – Conflicting key symbol {#XKB-461}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Warn if there are conflicting keysyms while merging keys</dd>
</dl>

### XKB-478 – Invalid operation {#XKB-478}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>The operation is invalid in the context</dd>
</dl>

### XKB-489 – Numeric keysym {#XKB-489}

<dl>
  <dt>Since</dt><dd>1.6.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Warn on numeric keysym (other than 0-9)</dd>
</dl>

Numeric keysyms are not human-friendly. Use the corresponding named keysym
or Unicode keysym, if available.


#### Examples

<details>
  <summary>Hexadecimal keysym `0x1001ed0`</summary>

**Error message:**

```
xkbcommon: WARNING: [XKB-489] numeric keysym "0x1001ed0"
```

**Fix:**
  <div class="example-container">
    <div class="example">
      <div class="example-inner">
        <div class="example-title">Before</div>
```c
key <AE01> { [ 0x1001ed0] };
```
</div>
    </div>
    <div class="example">
      <div class="example-inner">
        <div class="example-title">After</div>
```c
// Preferred form: human-friendly
key <AE01> { [ Ocircumflexacute ] };
// or
key <AE01> { [ U1ED0 ] };
```
</div>
    </div>
  </div>
</details>

### XKB-516 – Extra symbols ignored {#XKB-516}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd><span class="todo">TODO:</span> add description</dd>
</dl>

### XKB-523 – Conflicting key name {#XKB-523}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Conflicting definitions of a key name or alias</dd>
</dl>

### XKB-542 – Invalid file encoding {#XKB-542}

<dl>
  <dt>Since</dt><dd>1.7.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Invalid file encoding</dd>
</dl>

### XKB-550 – Allocation error {#XKB-550}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Cannot allocate memory</dd>
</dl>

### XKB-563 – Invalid action field {#XKB-563}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Unknown or unsupported action field</dd>
</dl>

### XKB-578 – Wrong field type {#XKB-578}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Warn when a field has not the expected type</dd>
</dl>

### XKB-595 – Cannot resolve rmlvo {#XKB-595}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Cannot resolve a given (Rules, Model, Layout, Variant, Options) configuration</dd>
</dl>

### XKB-607 – Invalid unicode escape sequence {#XKB-607}

<dl>
  <dt>Since</dt><dd>1.9.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Invalid Unicode escape sequence</dd>
</dl>

xkbcommon support the Unicode sequence `\u{NNNN}`, where `NNNN` denotes a
Unicode code point in hexadecimal format in the range `1‥0x10ffff`.


### XKB-623 – Invalid real modifier {#XKB-623}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Invalid _real_ modifier</dd>
</dl>

### XKB-639 – Unknown default field {#XKB-639}

<dl>
  <dt>Since</dt><dd>1.10.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Cannot set default value to a an unknown field</dd>
</dl>

### XKB-645 – Unknown char escape sequence {#XKB-645}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Warn on unknown escape sequence in string literal</dd>
</dl>

xkbcommon support the following escape sequences in string literals:

| Escape sequence | Corresponding character                                    |
| --------------- | ---------------------------------------------------------- |
| `\b`            | `U+0008` Backspace                                         |
| `\t`            | `U+0009` Character tabulation                              |
| `\n`            | `U+000A` Line feed                                         |
| `\v`            | `U+000B` Vertical tabulation                               |
| `\f`            | `U+000C` Form feed                                         |
| `\r`            | `U+000D` Carriage return                                   |
| `\e`            | `U+001B` Escape                                            |
| `\\`            | `U+005C` Backslash                                         |
| `\"`            | `U+0022` Double quote                                      |
| `\NNNN`         | _Octal_ escape, `NNNN` in range `1‥0o377`                  |
| `\u{NNNN}`      | _Unicode_ hexadecimal escape, `NNNN` in range `1‥0x10ffff` |


### XKB-661 – Invalid included file {#XKB-661}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>The target file of an include statement could not be processed</dd>
</dl>

### XKB-679 – Invalid compose locale {#XKB-679}

<dl>
  <dt>Since</dt><dd>1.12.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Invalid locale for Compose</dd>
</dl>

The locale is either invalid (not installed on the system) or not registered
in the X11 Compose registry.


### XKB-685 – Invalid compose syntax {#XKB-685}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>The Compose file syntax is invalid and the entry cannot be parsed</dd>
</dl>

### XKB-693 – Incompatible actions and keysyms count {#XKB-693}

<dl>
  <dt>Since</dt><dd>1.8.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>A level has a different number of keysyms and actions</dd>
</dl>

A level must have exactly the same number of keysyms and actions.


### XKB-700 – Multiple groups at once {#XKB-700}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Warn if a key defines multiple groups at once</dd>
</dl>

### XKB-711 – Unsupported symbols field {#XKB-711}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>A legacy X11 symbol field is not supported</dd>
</dl>

### XKB-742 – Incompatible keymap text format {#XKB-742}

<dl>
  <dt>Since</dt><dd>1.11.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>The keymap has features unsupported in the target format</dd>
</dl>

See @ref keymap-support "" for further details.


### XKB-762 – Rules invalid layout index percent expansion {#XKB-762}

<dl>
  <dt>Since</dt><dd>1.11.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Cannot expand `%%i`: missing layout or variant in MLVO rule fields</dd>
</dl>

In a @ref rule-file-format "rules file", `%%i` denotes the index of the
matched layout. It can only be used in the [KcCGST] value of the rule if the
layout or variant is defined in the [MLVO] fields of the rule header.
Otherwise the rule is always discarded.

To fix the error, either remove the `:%%i` specifier or add a the relevant
[MLVO] field, e.g. `layout[any]`.

[KcCGST]: @ref KcCGST-intro
[MLVO]: @ref RMLVO-intro


### XKB-769 – Invalid xkb syntax {#XKB-769}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>The XKB syntax is invalid and the file cannot be parsed</dd>
</dl>

See @ref keymap-text-format-v1-v2 "" for further details.


### XKB-770 – Undefined keycode {#XKB-770}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Reference to an undefined keycode</dd>
</dl>

### XKB-784 – Invalid expression type {#XKB-784}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>An expression has not the expected type</dd>
</dl>

### XKB-796 – Invalid value {#XKB-796}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>A value is invalid and will be ignored</dd>
</dl>

### XKB-800 – Conflicting modmap {#XKB-800}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Warn if there are conflicting modmap definitions</dd>
</dl>

@todo detailed explanation and examples


### XKB-812 – Unknown field {#XKB-812}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>A field is unknown and will be ignored</dd>
</dl>

### XKB-822 – Keymap compilation failed {#XKB-822}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Keymap compilation failed</dd>
</dl>

### XKB-844 – Unknown action type {#XKB-844}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Unknown action type</dd>
</dl>

See @ref key-actions "" for the list of supported actions.


### XKB-883 – Conflicting key action {#XKB-883}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Warn if there are conflicting actions while merging keys</dd>
</dl>

### XKB-893 – Conflicting key type merging groups {#XKB-893}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Warn if there are conflicting key types while merging groups</dd>
</dl>

### XKB-901 – Conflicting key symbols entry {#XKB-901}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>Conflicting symbols entry for a key</dd>
</dl>

### XKB-903 – Missing symbols group name index {#XKB-903}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Missing group index in a group name entry</dd>
</dl>

### XKB-935 – Conflicting key fields {#XKB-935}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Warn if there are conflicting fields while merging keys</dd>
</dl>

### XKB-949 – Invalid identifier {#XKB-949}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>An identifier is used but is not built-in</dd>
</dl>

### XKB-965 – Unresolved keymap symbol {#XKB-965}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Warn if using a symbol not defined in the keymap</dd>
</dl>

### XKB-967 – Invalid rules syntax {#XKB-967}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Error</dd>
  <dt>Summary</dt><dd>The rules syntax is invalid and the file cannot be parsed</dd>
</dl>

See @ref rule-file-format "" for further information.


### XKB-971 – Undeclared modifiers in key type {#XKB-971}

<dl>
  <dt>Since</dt><dd>1.0.0</dd>
  <dt>Type</dt><dd>Warning</dd>
  <dt>Summary</dt><dd>Some modifiers used in a key type “map” or “preserve” entry are not declared</dd>
</dl>

The modifiers used in `map` or `preserve` entries should be declared using the entry
`modifiers` in the key type.


[XKB-034]: @ref XKB-034
[XKB-043]: @ref XKB-043
[XKB-052]: @ref XKB-052
[XKB-060]: @ref XKB-060
[XKB-077]: @ref XKB-077
[XKB-082]: @ref XKB-082
[XKB-101]: @ref XKB-101
[XKB-107]: @ref XKB-107
[XKB-123]: @ref XKB-123
[XKB-134]: @ref XKB-134
[XKB-150]: @ref XKB-150
[XKB-161]: @ref XKB-161
[XKB-172]: @ref XKB-172
[XKB-183]: @ref XKB-183
[XKB-193]: @ref XKB-193
[XKB-195]: @ref XKB-195
[XKB-203]: @ref XKB-203
[XKB-206]: @ref XKB-206
[XKB-237]: @ref XKB-237
[XKB-239]: @ref XKB-239
[XKB-254]: @ref XKB-254
[XKB-266]: @ref XKB-266
[XKB-286]: @ref XKB-286
[XKB-301]: @ref XKB-301
[XKB-302]: @ref XKB-302
[XKB-305]: @ref XKB-305
[XKB-312]: @ref XKB-312
[XKB-338]: @ref XKB-338
[XKB-345]: @ref XKB-345
[XKB-362]: @ref XKB-362
[XKB-378]: @ref XKB-378
[XKB-386]: @ref XKB-386
[XKB-407]: @ref XKB-407
[XKB-428]: @ref XKB-428
[XKB-433]: @ref XKB-433
[XKB-461]: @ref XKB-461
[XKB-478]: @ref XKB-478
[XKB-489]: @ref XKB-489
[XKB-516]: @ref XKB-516
[XKB-523]: @ref XKB-523
[XKB-542]: @ref XKB-542
[XKB-550]: @ref XKB-550
[XKB-563]: @ref XKB-563
[XKB-578]: @ref XKB-578
[XKB-595]: @ref XKB-595
[XKB-607]: @ref XKB-607
[XKB-623]: @ref XKB-623
[XKB-639]: @ref XKB-639
[XKB-645]: @ref XKB-645
[XKB-661]: @ref XKB-661
[XKB-679]: @ref XKB-679
[XKB-685]: @ref XKB-685
[XKB-693]: @ref XKB-693
[XKB-700]: @ref XKB-700
[XKB-711]: @ref XKB-711
[XKB-742]: @ref XKB-742
[XKB-762]: @ref XKB-762
[XKB-769]: @ref XKB-769
[XKB-770]: @ref XKB-770
[XKB-784]: @ref XKB-784
[XKB-796]: @ref XKB-796
[XKB-800]: @ref XKB-800
[XKB-812]: @ref XKB-812
[XKB-822]: @ref XKB-822
[XKB-844]: @ref XKB-844
[XKB-883]: @ref XKB-883
[XKB-893]: @ref XKB-893
[XKB-901]: @ref XKB-901
[XKB-903]: @ref XKB-903
[XKB-935]: @ref XKB-935
[XKB-949]: @ref XKB-949
[XKB-965]: @ref XKB-965
[XKB-967]: @ref XKB-967
[XKB-971]: @ref XKB-971
