// -*- mode: js; js-indent-level: 4; indent-tabs-mode: nil -*-
var Cu = Components.utils;
var Ci = Components.interfaces;
var Cc = Components.classes;
var Cr = Components.results;

Cu.import("resource://unity/unity-webapps.js");
Cu.import("resource://unity/l10n.js");

const XUL_NS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";

function UnityPrefs(window) {
    this._init(window);
}

UnityPrefs.prototype = {
    _init: function(window) {
        var prefwindow = window.document.getElementById('BrowserPreferences');

        if (!prefwindow)
            return;

        this.window = window;
        this.domains = null;
        var uwa = new UnityWebapps();

        var mainPane = window.document.getElementById('paneMain');

        var hbox = window.document.createElementNS(XUL_NS, 'hbox');

        var groupbox = window.document.createElementNS(XUL_NS, 'groupbox');
        groupbox.setAttribute("flex", "1");
        groupbox.setAttribute("orient", "horizontal");
        hbox.appendChild(groupbox);

        var label = window.document.createElement('caption');
        label.setAttribute("label", l10n.formatMessage('prefs.integration'));
        groupbox.appendChild(label);

        var checkbox = window.document.createElement('checkbox');
        checkbox.setAttribute("label", l10n.formatMessage('prefs.enabled'));
        checkbox.addEventListener('command', function () {
            uwa.permissions_set_integration_allowed(checkbox.getAttribute('checked') == "true");
        }, true);
        checkbox.setAttribute("flex", "1");

        checkbox.setAttribute("checked", uwa.permissions_is_integration_allowed() == 1);
        groupbox.appendChild(checkbox);

        var button = window.document.createElementNS(XUL_NS, 'button');
        button.setAttribute("label", l10n.formatMessage('prefs.exceptions'));
        button.addEventListener('click', this._showDialog.bind(this), true);
        groupbox.appendChild(button);

        mainPane.appendChild(hbox);
    },

    _showDialog: function() {
        this.window.document.documentElement.openWindow("Browser:Permissions", "chrome://unity/content/exceptions.xul", "");
    }
};

var EXPORTED_SYMBOLS = [ "UnityPrefs" ];
