/* This file is generated by venus-protocol git-e05ae158. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_QUEUE_H
#define VN_PROTOCOL_RENDERER_QUEUE_H

#include "vn_protocol_renderer_structs.h"

/* struct VkDeviceGroupSubmitInfo chain */

static inline void *
vn_decode_VkDeviceGroupSubmitInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDeviceGroupSubmitInfo_self_temp(struct vn_cs_decoder *dec, VkDeviceGroupSubmitInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->waitSemaphoreCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->waitSemaphoreCount);
        val->pWaitSemaphoreDeviceIndices = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pWaitSemaphoreDeviceIndices) * array_size);
        if (!val->pWaitSemaphoreDeviceIndices) return;
        vn_decode_uint32_t_array(dec, (uint32_t *)val->pWaitSemaphoreDeviceIndices, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        val->pWaitSemaphoreDeviceIndices = NULL;
    }
    vn_decode_uint32_t(dec, &val->commandBufferCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->commandBufferCount);
        val->pCommandBufferDeviceMasks = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pCommandBufferDeviceMasks) * array_size);
        if (!val->pCommandBufferDeviceMasks) return;
        vn_decode_uint32_t_array(dec, (uint32_t *)val->pCommandBufferDeviceMasks, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        val->pCommandBufferDeviceMasks = NULL;
    }
    vn_decode_uint32_t(dec, &val->signalSemaphoreCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->signalSemaphoreCount);
        val->pSignalSemaphoreDeviceIndices = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pSignalSemaphoreDeviceIndices) * array_size);
        if (!val->pSignalSemaphoreDeviceIndices) return;
        vn_decode_uint32_t_array(dec, (uint32_t *)val->pSignalSemaphoreDeviceIndices, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        val->pSignalSemaphoreDeviceIndices = NULL;
    }
}

static inline void
vn_decode_VkDeviceGroupSubmitInfo_temp(struct vn_cs_decoder *dec, VkDeviceGroupSubmitInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceGroupSubmitInfo_pnext_temp(dec);
    vn_decode_VkDeviceGroupSubmitInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceGroupSubmitInfo_handle_self(VkDeviceGroupSubmitInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->waitSemaphoreCount */
    /* skip val->pWaitSemaphoreDeviceIndices */
    /* skip val->commandBufferCount */
    /* skip val->pCommandBufferDeviceMasks */
    /* skip val->signalSemaphoreCount */
    /* skip val->pSignalSemaphoreDeviceIndices */
}

static inline void
vn_replace_VkDeviceGroupSubmitInfo_handle(VkDeviceGroupSubmitInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO:
            vn_replace_VkDeviceGroupSubmitInfo_handle_self((VkDeviceGroupSubmitInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkProtectedSubmitInfo chain */

static inline void *
vn_decode_VkProtectedSubmitInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkProtectedSubmitInfo_self_temp(struct vn_cs_decoder *dec, VkProtectedSubmitInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->protectedSubmit);
}

static inline void
vn_decode_VkProtectedSubmitInfo_temp(struct vn_cs_decoder *dec, VkProtectedSubmitInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkProtectedSubmitInfo_pnext_temp(dec);
    vn_decode_VkProtectedSubmitInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkProtectedSubmitInfo_handle_self(VkProtectedSubmitInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->protectedSubmit */
}

static inline void
vn_replace_VkProtectedSubmitInfo_handle(VkProtectedSubmitInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO:
            vn_replace_VkProtectedSubmitInfo_handle_self((VkProtectedSubmitInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkTimelineSemaphoreSubmitInfo chain */

static inline void *
vn_decode_VkTimelineSemaphoreSubmitInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkTimelineSemaphoreSubmitInfo_self_temp(struct vn_cs_decoder *dec, VkTimelineSemaphoreSubmitInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->waitSemaphoreValueCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->waitSemaphoreValueCount);
        val->pWaitSemaphoreValues = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pWaitSemaphoreValues) * array_size);
        if (!val->pWaitSemaphoreValues) return;
        vn_decode_uint64_t_array(dec, (uint64_t *)val->pWaitSemaphoreValues, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        val->pWaitSemaphoreValues = NULL;
    }
    vn_decode_uint32_t(dec, &val->signalSemaphoreValueCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->signalSemaphoreValueCount);
        val->pSignalSemaphoreValues = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pSignalSemaphoreValues) * array_size);
        if (!val->pSignalSemaphoreValues) return;
        vn_decode_uint64_t_array(dec, (uint64_t *)val->pSignalSemaphoreValues, array_size);
    } else {
        vn_decode_array_size(dec, 0);
        val->pSignalSemaphoreValues = NULL;
    }
}

static inline void
vn_decode_VkTimelineSemaphoreSubmitInfo_temp(struct vn_cs_decoder *dec, VkTimelineSemaphoreSubmitInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkTimelineSemaphoreSubmitInfo_pnext_temp(dec);
    vn_decode_VkTimelineSemaphoreSubmitInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkTimelineSemaphoreSubmitInfo_handle_self(VkTimelineSemaphoreSubmitInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->waitSemaphoreValueCount */
    /* skip val->pWaitSemaphoreValues */
    /* skip val->signalSemaphoreValueCount */
    /* skip val->pSignalSemaphoreValues */
}

static inline void
vn_replace_VkTimelineSemaphoreSubmitInfo_handle(VkTimelineSemaphoreSubmitInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO:
            vn_replace_VkTimelineSemaphoreSubmitInfo_handle_self((VkTimelineSemaphoreSubmitInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkSubmitInfo chain */

static inline void *
vn_decode_VkSubmitInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkDeviceGroupSubmitInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkSubmitInfo_pnext_temp(dec);
            vn_decode_VkDeviceGroupSubmitInfo_self_temp(dec, (VkDeviceGroupSubmitInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkProtectedSubmitInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkSubmitInfo_pnext_temp(dec);
            vn_decode_VkProtectedSubmitInfo_self_temp(dec, (VkProtectedSubmitInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkTimelineSemaphoreSubmitInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkSubmitInfo_pnext_temp(dec);
            vn_decode_VkTimelineSemaphoreSubmitInfo_self_temp(dec, (VkTimelineSemaphoreSubmitInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkSubmitInfo_self_temp(struct vn_cs_decoder *dec, VkSubmitInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->waitSemaphoreCount);
    if (vn_peek_array_size(dec)) {
        val->pWaitSemaphores = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pWaitSemaphores) * val->waitSemaphoreCount);
        if (!val->pWaitSemaphores) return;
        vn_decode_array_size(dec, val->waitSemaphoreCount);
        for (uint32_t i = 0; i < val->waitSemaphoreCount; i++)
            vn_decode_VkSemaphore_lookup(dec, &((VkSemaphore *)val->pWaitSemaphores)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pWaitSemaphores = NULL;
    }
    if (vn_peek_array_size(dec)) {
        val->pWaitDstStageMask = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pWaitDstStageMask) * val->waitSemaphoreCount);
        if (!val->pWaitDstStageMask) return;
        vn_decode_array_size(dec, val->waitSemaphoreCount);
        for (uint32_t i = 0; i < val->waitSemaphoreCount; i++)
            vn_decode_VkFlags(dec, &((VkPipelineStageFlags *)val->pWaitDstStageMask)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pWaitDstStageMask = NULL;
    }
    vn_decode_uint32_t(dec, &val->commandBufferCount);
    if (vn_peek_array_size(dec)) {
        val->pCommandBuffers = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pCommandBuffers) * val->commandBufferCount);
        if (!val->pCommandBuffers) return;
        vn_decode_array_size(dec, val->commandBufferCount);
        for (uint32_t i = 0; i < val->commandBufferCount; i++)
            vn_decode_VkCommandBuffer_lookup(dec, &((VkCommandBuffer *)val->pCommandBuffers)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pCommandBuffers = NULL;
    }
    vn_decode_uint32_t(dec, &val->signalSemaphoreCount);
    if (vn_peek_array_size(dec)) {
        val->pSignalSemaphores = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pSignalSemaphores) * val->signalSemaphoreCount);
        if (!val->pSignalSemaphores) return;
        vn_decode_array_size(dec, val->signalSemaphoreCount);
        for (uint32_t i = 0; i < val->signalSemaphoreCount; i++)
            vn_decode_VkSemaphore_lookup(dec, &((VkSemaphore *)val->pSignalSemaphores)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pSignalSemaphores = NULL;
    }
}

static inline void
vn_decode_VkSubmitInfo_temp(struct vn_cs_decoder *dec, VkSubmitInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_SUBMIT_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkSubmitInfo_pnext_temp(dec);
    vn_decode_VkSubmitInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkSubmitInfo_handle_self(VkSubmitInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->waitSemaphoreCount */
    if (val->pWaitSemaphores) {
       for (uint32_t i = 0; i < val->waitSemaphoreCount; i++)
            vn_replace_VkSemaphore_handle(&((VkSemaphore *)val->pWaitSemaphores)[i]);
    }
    /* skip val->pWaitDstStageMask */
    /* skip val->commandBufferCount */
    if (val->pCommandBuffers) {
       for (uint32_t i = 0; i < val->commandBufferCount; i++)
            vn_replace_VkCommandBuffer_handle(&((VkCommandBuffer *)val->pCommandBuffers)[i]);
    }
    /* skip val->signalSemaphoreCount */
    if (val->pSignalSemaphores) {
       for (uint32_t i = 0; i < val->signalSemaphoreCount; i++)
            vn_replace_VkSemaphore_handle(&((VkSemaphore *)val->pSignalSemaphores)[i]);
    }
}

static inline void
vn_replace_VkSubmitInfo_handle(VkSubmitInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SUBMIT_INFO:
            vn_replace_VkSubmitInfo_handle_self((VkSubmitInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO:
            vn_replace_VkDeviceGroupSubmitInfo_handle_self((VkDeviceGroupSubmitInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO:
            vn_replace_VkProtectedSubmitInfo_handle_self((VkProtectedSubmitInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO:
            vn_replace_VkTimelineSemaphoreSubmitInfo_handle_self((VkTimelineSemaphoreSubmitInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkSparseMemoryBind */

static inline void
vn_decode_VkSparseMemoryBind_temp(struct vn_cs_decoder *dec, VkSparseMemoryBind *val)
{
    vn_decode_VkDeviceSize(dec, &val->resourceOffset);
    vn_decode_VkDeviceSize(dec, &val->size);
    vn_decode_VkDeviceMemory_lookup(dec, &val->memory);
    vn_decode_VkDeviceSize(dec, &val->memoryOffset);
    vn_decode_VkFlags(dec, &val->flags);
}

static inline void
vn_replace_VkSparseMemoryBind_handle(VkSparseMemoryBind *val)
{
    /* skip val->resourceOffset */
    /* skip val->size */
    vn_replace_VkDeviceMemory_handle(&val->memory);
    /* skip val->memoryOffset */
    /* skip val->flags */
}

/* struct VkSparseBufferMemoryBindInfo */

static inline void
vn_decode_VkSparseBufferMemoryBindInfo_temp(struct vn_cs_decoder *dec, VkSparseBufferMemoryBindInfo *val)
{
    vn_decode_VkBuffer_lookup(dec, &val->buffer);
    vn_decode_uint32_t(dec, &val->bindCount);
    if (vn_peek_array_size(dec)) {
        val->pBinds = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pBinds) * val->bindCount);
        if (!val->pBinds) return;
        vn_decode_array_size(dec, val->bindCount);
        for (uint32_t i = 0; i < val->bindCount; i++)
            vn_decode_VkSparseMemoryBind_temp(dec, &((VkSparseMemoryBind *)val->pBinds)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pBinds = NULL;
    }
}

static inline void
vn_replace_VkSparseBufferMemoryBindInfo_handle(VkSparseBufferMemoryBindInfo *val)
{
    vn_replace_VkBuffer_handle(&val->buffer);
    /* skip val->bindCount */
    if (val->pBinds) {
       for (uint32_t i = 0; i < val->bindCount; i++)
            vn_replace_VkSparseMemoryBind_handle(&((VkSparseMemoryBind *)val->pBinds)[i]);
    }
}

/* struct VkSparseImageOpaqueMemoryBindInfo */

static inline void
vn_decode_VkSparseImageOpaqueMemoryBindInfo_temp(struct vn_cs_decoder *dec, VkSparseImageOpaqueMemoryBindInfo *val)
{
    vn_decode_VkImage_lookup(dec, &val->image);
    vn_decode_uint32_t(dec, &val->bindCount);
    if (vn_peek_array_size(dec)) {
        val->pBinds = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pBinds) * val->bindCount);
        if (!val->pBinds) return;
        vn_decode_array_size(dec, val->bindCount);
        for (uint32_t i = 0; i < val->bindCount; i++)
            vn_decode_VkSparseMemoryBind_temp(dec, &((VkSparseMemoryBind *)val->pBinds)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pBinds = NULL;
    }
}

static inline void
vn_replace_VkSparseImageOpaqueMemoryBindInfo_handle(VkSparseImageOpaqueMemoryBindInfo *val)
{
    vn_replace_VkImage_handle(&val->image);
    /* skip val->bindCount */
    if (val->pBinds) {
       for (uint32_t i = 0; i < val->bindCount; i++)
            vn_replace_VkSparseMemoryBind_handle(&((VkSparseMemoryBind *)val->pBinds)[i]);
    }
}

/* struct VkSparseImageMemoryBind */

static inline void
vn_decode_VkSparseImageMemoryBind_temp(struct vn_cs_decoder *dec, VkSparseImageMemoryBind *val)
{
    vn_decode_VkImageSubresource_temp(dec, &val->subresource);
    vn_decode_VkOffset3D_temp(dec, &val->offset);
    vn_decode_VkExtent3D_temp(dec, &val->extent);
    vn_decode_VkDeviceMemory_lookup(dec, &val->memory);
    vn_decode_VkDeviceSize(dec, &val->memoryOffset);
    vn_decode_VkFlags(dec, &val->flags);
}

static inline void
vn_replace_VkSparseImageMemoryBind_handle(VkSparseImageMemoryBind *val)
{
    vn_replace_VkImageSubresource_handle(&val->subresource);
    vn_replace_VkOffset3D_handle(&val->offset);
    vn_replace_VkExtent3D_handle(&val->extent);
    vn_replace_VkDeviceMemory_handle(&val->memory);
    /* skip val->memoryOffset */
    /* skip val->flags */
}

/* struct VkSparseImageMemoryBindInfo */

static inline void
vn_decode_VkSparseImageMemoryBindInfo_temp(struct vn_cs_decoder *dec, VkSparseImageMemoryBindInfo *val)
{
    vn_decode_VkImage_lookup(dec, &val->image);
    vn_decode_uint32_t(dec, &val->bindCount);
    if (vn_peek_array_size(dec)) {
        val->pBinds = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pBinds) * val->bindCount);
        if (!val->pBinds) return;
        vn_decode_array_size(dec, val->bindCount);
        for (uint32_t i = 0; i < val->bindCount; i++)
            vn_decode_VkSparseImageMemoryBind_temp(dec, &((VkSparseImageMemoryBind *)val->pBinds)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pBinds = NULL;
    }
}

static inline void
vn_replace_VkSparseImageMemoryBindInfo_handle(VkSparseImageMemoryBindInfo *val)
{
    vn_replace_VkImage_handle(&val->image);
    /* skip val->bindCount */
    if (val->pBinds) {
       for (uint32_t i = 0; i < val->bindCount; i++)
            vn_replace_VkSparseImageMemoryBind_handle(&((VkSparseImageMemoryBind *)val->pBinds)[i]);
    }
}

/* struct VkDeviceGroupBindSparseInfo chain */

static inline void *
vn_decode_VkDeviceGroupBindSparseInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDeviceGroupBindSparseInfo_self_temp(struct vn_cs_decoder *dec, VkDeviceGroupBindSparseInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->resourceDeviceIndex);
    vn_decode_uint32_t(dec, &val->memoryDeviceIndex);
}

static inline void
vn_decode_VkDeviceGroupBindSparseInfo_temp(struct vn_cs_decoder *dec, VkDeviceGroupBindSparseInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceGroupBindSparseInfo_pnext_temp(dec);
    vn_decode_VkDeviceGroupBindSparseInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceGroupBindSparseInfo_handle_self(VkDeviceGroupBindSparseInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->resourceDeviceIndex */
    /* skip val->memoryDeviceIndex */
}

static inline void
vn_replace_VkDeviceGroupBindSparseInfo_handle(VkDeviceGroupBindSparseInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO:
            vn_replace_VkDeviceGroupBindSparseInfo_handle_self((VkDeviceGroupBindSparseInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkBindSparseInfo chain */

static inline void *
vn_decode_VkBindSparseInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkDeviceGroupBindSparseInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkBindSparseInfo_pnext_temp(dec);
            vn_decode_VkDeviceGroupBindSparseInfo_self_temp(dec, (VkDeviceGroupBindSparseInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkTimelineSemaphoreSubmitInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkBindSparseInfo_pnext_temp(dec);
            vn_decode_VkTimelineSemaphoreSubmitInfo_self_temp(dec, (VkTimelineSemaphoreSubmitInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkBindSparseInfo_self_temp(struct vn_cs_decoder *dec, VkBindSparseInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->waitSemaphoreCount);
    if (vn_peek_array_size(dec)) {
        val->pWaitSemaphores = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pWaitSemaphores) * val->waitSemaphoreCount);
        if (!val->pWaitSemaphores) return;
        vn_decode_array_size(dec, val->waitSemaphoreCount);
        for (uint32_t i = 0; i < val->waitSemaphoreCount; i++)
            vn_decode_VkSemaphore_lookup(dec, &((VkSemaphore *)val->pWaitSemaphores)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pWaitSemaphores = NULL;
    }
    vn_decode_uint32_t(dec, &val->bufferBindCount);
    if (vn_peek_array_size(dec)) {
        val->pBufferBinds = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pBufferBinds) * val->bufferBindCount);
        if (!val->pBufferBinds) return;
        vn_decode_array_size(dec, val->bufferBindCount);
        for (uint32_t i = 0; i < val->bufferBindCount; i++)
            vn_decode_VkSparseBufferMemoryBindInfo_temp(dec, &((VkSparseBufferMemoryBindInfo *)val->pBufferBinds)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pBufferBinds = NULL;
    }
    vn_decode_uint32_t(dec, &val->imageOpaqueBindCount);
    if (vn_peek_array_size(dec)) {
        val->pImageOpaqueBinds = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pImageOpaqueBinds) * val->imageOpaqueBindCount);
        if (!val->pImageOpaqueBinds) return;
        vn_decode_array_size(dec, val->imageOpaqueBindCount);
        for (uint32_t i = 0; i < val->imageOpaqueBindCount; i++)
            vn_decode_VkSparseImageOpaqueMemoryBindInfo_temp(dec, &((VkSparseImageOpaqueMemoryBindInfo *)val->pImageOpaqueBinds)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pImageOpaqueBinds = NULL;
    }
    vn_decode_uint32_t(dec, &val->imageBindCount);
    if (vn_peek_array_size(dec)) {
        val->pImageBinds = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pImageBinds) * val->imageBindCount);
        if (!val->pImageBinds) return;
        vn_decode_array_size(dec, val->imageBindCount);
        for (uint32_t i = 0; i < val->imageBindCount; i++)
            vn_decode_VkSparseImageMemoryBindInfo_temp(dec, &((VkSparseImageMemoryBindInfo *)val->pImageBinds)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pImageBinds = NULL;
    }
    vn_decode_uint32_t(dec, &val->signalSemaphoreCount);
    if (vn_peek_array_size(dec)) {
        val->pSignalSemaphores = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pSignalSemaphores) * val->signalSemaphoreCount);
        if (!val->pSignalSemaphores) return;
        vn_decode_array_size(dec, val->signalSemaphoreCount);
        for (uint32_t i = 0; i < val->signalSemaphoreCount; i++)
            vn_decode_VkSemaphore_lookup(dec, &((VkSemaphore *)val->pSignalSemaphores)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        val->pSignalSemaphores = NULL;
    }
}

static inline void
vn_decode_VkBindSparseInfo_temp(struct vn_cs_decoder *dec, VkBindSparseInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_BIND_SPARSE_INFO);

    val->sType = stype;
    val->pNext = vn_decode_VkBindSparseInfo_pnext_temp(dec);
    vn_decode_VkBindSparseInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkBindSparseInfo_handle_self(VkBindSparseInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->waitSemaphoreCount */
    if (val->pWaitSemaphores) {
       for (uint32_t i = 0; i < val->waitSemaphoreCount; i++)
            vn_replace_VkSemaphore_handle(&((VkSemaphore *)val->pWaitSemaphores)[i]);
    }
    /* skip val->bufferBindCount */
    if (val->pBufferBinds) {
       for (uint32_t i = 0; i < val->bufferBindCount; i++)
            vn_replace_VkSparseBufferMemoryBindInfo_handle(&((VkSparseBufferMemoryBindInfo *)val->pBufferBinds)[i]);
    }
    /* skip val->imageOpaqueBindCount */
    if (val->pImageOpaqueBinds) {
       for (uint32_t i = 0; i < val->imageOpaqueBindCount; i++)
            vn_replace_VkSparseImageOpaqueMemoryBindInfo_handle(&((VkSparseImageOpaqueMemoryBindInfo *)val->pImageOpaqueBinds)[i]);
    }
    /* skip val->imageBindCount */
    if (val->pImageBinds) {
       for (uint32_t i = 0; i < val->imageBindCount; i++)
            vn_replace_VkSparseImageMemoryBindInfo_handle(&((VkSparseImageMemoryBindInfo *)val->pImageBinds)[i]);
    }
    /* skip val->signalSemaphoreCount */
    if (val->pSignalSemaphores) {
       for (uint32_t i = 0; i < val->signalSemaphoreCount; i++)
            vn_replace_VkSemaphore_handle(&((VkSemaphore *)val->pSignalSemaphores)[i]);
    }
}

static inline void
vn_replace_VkBindSparseInfo_handle(VkBindSparseInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_BIND_SPARSE_INFO:
            vn_replace_VkBindSparseInfo_handle_self((VkBindSparseInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO:
            vn_replace_VkDeviceGroupBindSparseInfo_handle_self((VkDeviceGroupBindSparseInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO:
            vn_replace_VkTimelineSemaphoreSubmitInfo_handle_self((VkTimelineSemaphoreSubmitInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

static inline void vn_decode_vkQueueSubmit_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkQueueSubmit *args)
{
    vn_decode_VkQueue_lookup(dec, &args->queue);
    vn_decode_uint32_t(dec, &args->submitCount);
    if (vn_peek_array_size(dec)) {
        args->pSubmits = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pSubmits) * args->submitCount);
        if (!args->pSubmits) return;
        vn_decode_array_size(dec, args->submitCount);
        for (uint32_t i = 0; i < args->submitCount; i++)
            vn_decode_VkSubmitInfo_temp(dec, &((VkSubmitInfo *)args->pSubmits)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pSubmits = NULL;
    }
    vn_decode_VkFence_lookup(dec, &args->fence);
}

static inline void vn_replace_vkQueueSubmit_args_handle(struct vn_command_vkQueueSubmit *args)
{
    vn_replace_VkQueue_handle(&args->queue);
    /* skip args->submitCount */
    if (args->pSubmits) {
       for (uint32_t i = 0; i < args->submitCount; i++)
            vn_replace_VkSubmitInfo_handle(&((VkSubmitInfo *)args->pSubmits)[i]);
    }
    vn_replace_VkFence_handle(&args->fence);
}

static inline void vn_encode_vkQueueSubmit_reply(struct vn_cs_encoder *enc, const struct vn_command_vkQueueSubmit *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkQueueSubmit_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->queue */
    /* skip args->submitCount */
    /* skip args->pSubmits */
    /* skip args->fence */
}

static inline void vn_decode_vkQueueWaitIdle_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkQueueWaitIdle *args)
{
    vn_decode_VkQueue_lookup(dec, &args->queue);
}

static inline void vn_replace_vkQueueWaitIdle_args_handle(struct vn_command_vkQueueWaitIdle *args)
{
    vn_replace_VkQueue_handle(&args->queue);
}

static inline void vn_encode_vkQueueWaitIdle_reply(struct vn_cs_encoder *enc, const struct vn_command_vkQueueWaitIdle *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkQueueWaitIdle_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->queue */
}

static inline void vn_decode_vkQueueBindSparse_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkQueueBindSparse *args)
{
    vn_decode_VkQueue_lookup(dec, &args->queue);
    vn_decode_uint32_t(dec, &args->bindInfoCount);
    if (vn_peek_array_size(dec)) {
        args->pBindInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pBindInfo) * args->bindInfoCount);
        if (!args->pBindInfo) return;
        vn_decode_array_size(dec, args->bindInfoCount);
        for (uint32_t i = 0; i < args->bindInfoCount; i++)
            vn_decode_VkBindSparseInfo_temp(dec, &((VkBindSparseInfo *)args->pBindInfo)[i]);
    } else {
        vn_decode_array_size(dec, 0);
        args->pBindInfo = NULL;
    }
    vn_decode_VkFence_lookup(dec, &args->fence);
}

static inline void vn_replace_vkQueueBindSparse_args_handle(struct vn_command_vkQueueBindSparse *args)
{
    vn_replace_VkQueue_handle(&args->queue);
    /* skip args->bindInfoCount */
    if (args->pBindInfo) {
       for (uint32_t i = 0; i < args->bindInfoCount; i++)
            vn_replace_VkBindSparseInfo_handle(&((VkBindSparseInfo *)args->pBindInfo)[i]);
    }
    vn_replace_VkFence_handle(&args->fence);
}

static inline void vn_encode_vkQueueBindSparse_reply(struct vn_cs_encoder *enc, const struct vn_command_vkQueueBindSparse *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkQueueBindSparse_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->queue */
    /* skip args->bindInfoCount */
    /* skip args->pBindInfo */
    /* skip args->fence */
}

static inline void vn_dispatch_vkQueueSubmit(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkQueueSubmit args;

    if (!ctx->dispatch_vkQueueSubmit) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkQueueSubmit_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkQueueSubmit(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkQueueSubmit returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkQueueSubmit_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkQueueWaitIdle(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkQueueWaitIdle args;

    if (!ctx->dispatch_vkQueueWaitIdle) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkQueueWaitIdle_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkQueueWaitIdle(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkQueueWaitIdle returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkQueueWaitIdle_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkQueueBindSparse(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkQueueBindSparse args;

    if (!ctx->dispatch_vkQueueBindSparse) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkQueueBindSparse_args_temp(ctx->decoder, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkQueueBindSparse(ctx, &args);

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && args.ret < VK_SUCCESS) {
        switch (args.ret) {
        case VK_ERROR_FORMAT_NOT_SUPPORTED:
            break;
        default:
            vn_dispatch_debug_log(ctx, "vkQueueBindSparse returned %d", args.ret);
            break;
        }
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder) && (flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT))
       vn_encode_vkQueueBindSparse_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

#endif /* VN_PROTOCOL_RENDERER_QUEUE_H */
