// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: pkg/agentcfg/agentcfg.proto

package agentcfg

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on PathCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *PathCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PathCF with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in PathCFMultiError, or nil if none found.
func (m *PathCF) ValidateAll() error {
	return m.validate(true)
}

func (m *PathCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetGlob()) < 1 {
		err := PathCFValidationError{
			field:  "Glob",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return PathCFMultiError(errors)
	}

	return nil
}

// PathCFMultiError is an error wrapping multiple validation errors returned by
// PathCF.ValidateAll() if the designated constraints aren't met.
type PathCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PathCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PathCFMultiError) AllErrors() []error { return m }

// PathCFValidationError is the validation error returned by PathCF.Validate if
// the designated constraints aren't met.
type PathCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PathCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PathCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PathCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PathCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PathCFValidationError) ErrorName() string { return "PathCFValidationError" }

// Error satisfies the builtin error interface
func (e PathCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPathCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PathCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PathCFValidationError{}

// Validate checks the field values on ManifestProjectCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ManifestProjectCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ManifestProjectCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ManifestProjectCFMultiError, or nil if none found.
func (m *ManifestProjectCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ManifestProjectCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for DefaultNamespace

	for idx, item := range m.GetPaths() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ManifestProjectCFValidationError{
						field:  fmt.Sprintf("Paths[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ManifestProjectCFValidationError{
						field:  fmt.Sprintf("Paths[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ManifestProjectCFValidationError{
					field:  fmt.Sprintf("Paths[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetReconcileTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ManifestProjectCFValidationError{
					field:  "ReconcileTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ManifestProjectCFValidationError{
					field:  "ReconcileTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetReconcileTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ManifestProjectCFValidationError{
				field:  "ReconcileTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if _, ok := _ManifestProjectCF_DryRunStrategy_InLookup[m.GetDryRunStrategy()]; !ok {
		err := ManifestProjectCFValidationError{
			field:  "DryRunStrategy",
			reason: "value must be in list [ none client server]",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetPruneTimeout()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ManifestProjectCFValidationError{
					field:  "PruneTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ManifestProjectCFValidationError{
					field:  "PruneTimeout",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPruneTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ManifestProjectCFValidationError{
				field:  "PruneTimeout",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if _, ok := _ManifestProjectCF_PrunePropagationPolicy_InLookup[m.GetPrunePropagationPolicy()]; !ok {
		err := ManifestProjectCFValidationError{
			field:  "PrunePropagationPolicy",
			reason: "value must be in list [ orphan background foreground]",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if _, ok := _ManifestProjectCF_InventoryPolicy_InLookup[m.GetInventoryPolicy()]; !ok {
		err := ManifestProjectCFValidationError{
			field:  "InventoryPolicy",
			reason: "value must be in list [ must_match adopt_if_no_inventory adopt_all]",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetRef()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ManifestProjectCFValidationError{
					field:  "Ref",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ManifestProjectCFValidationError{
					field:  "Ref",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRef()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ManifestProjectCFValidationError{
				field:  "Ref",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	switch v := m.PruneOneof.(type) {
	case *ManifestProjectCF_Prune:
		if v == nil {
			err := ManifestProjectCFValidationError{
				field:  "PruneOneof",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Prune
	default:
		_ = v // ensures v is used
	}

	if m.Id != nil {

		if len(m.GetId()) < 1 {
			err := ManifestProjectCFValidationError{
				field:  "Id",
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return ManifestProjectCFMultiError(errors)
	}

	return nil
}

// ManifestProjectCFMultiError is an error wrapping multiple validation errors
// returned by ManifestProjectCF.ValidateAll() if the designated constraints
// aren't met.
type ManifestProjectCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ManifestProjectCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ManifestProjectCFMultiError) AllErrors() []error { return m }

// ManifestProjectCFValidationError is the validation error returned by
// ManifestProjectCF.Validate if the designated constraints aren't met.
type ManifestProjectCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ManifestProjectCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ManifestProjectCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ManifestProjectCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ManifestProjectCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ManifestProjectCFValidationError) ErrorName() string {
	return "ManifestProjectCFValidationError"
}

// Error satisfies the builtin error interface
func (e ManifestProjectCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sManifestProjectCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ManifestProjectCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ManifestProjectCFValidationError{}

var _ManifestProjectCF_DryRunStrategy_InLookup = map[string]struct{}{
	"":       {},
	"none":   {},
	"client": {},
	"server": {},
}

var _ManifestProjectCF_PrunePropagationPolicy_InLookup = map[string]struct{}{
	"":           {},
	"orphan":     {},
	"background": {},
	"foreground": {},
}

var _ManifestProjectCF_InventoryPolicy_InLookup = map[string]struct{}{
	"":                      {},
	"must_match":            {},
	"adopt_if_no_inventory": {},
	"adopt_all":             {},
}

// Validate checks the field values on GitRefCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GitRefCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GitRefCF with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in GitRefCFMultiError, or nil
// if none found.
func (m *GitRefCF) ValidateAll() error {
	return m.validate(true)
}

func (m *GitRefCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofRefPresent := false
	switch v := m.Ref.(type) {
	case *GitRefCF_Tag:
		if v == nil {
			err := GitRefCFValidationError{
				field:  "Ref",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRefPresent = true

		if len(m.GetTag()) < 1 {
			err := GitRefCFValidationError{
				field:  "Tag",
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *GitRefCF_Branch:
		if v == nil {
			err := GitRefCFValidationError{
				field:  "Ref",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRefPresent = true

		if len(m.GetBranch()) < 1 {
			err := GitRefCFValidationError{
				field:  "Branch",
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *GitRefCF_Commit:
		if v == nil {
			err := GitRefCFValidationError{
				field:  "Ref",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRefPresent = true

		if len(m.GetCommit()) < 1 {
			err := GitRefCFValidationError{
				field:  "Commit",
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofRefPresent {
		err := GitRefCFValidationError{
			field:  "Ref",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return GitRefCFMultiError(errors)
	}

	return nil
}

// GitRefCFMultiError is an error wrapping multiple validation errors returned
// by GitRefCF.ValidateAll() if the designated constraints aren't met.
type GitRefCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GitRefCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GitRefCFMultiError) AllErrors() []error { return m }

// GitRefCFValidationError is the validation error returned by
// GitRefCF.Validate if the designated constraints aren't met.
type GitRefCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GitRefCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GitRefCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GitRefCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GitRefCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GitRefCFValidationError) ErrorName() string { return "GitRefCFValidationError" }

// Error satisfies the builtin error interface
func (e GitRefCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGitRefCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GitRefCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GitRefCFValidationError{}

// Validate checks the field values on ChartProjectSourceCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ChartProjectSourceCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ChartProjectSourceCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ChartProjectSourceCFMultiError, or nil if none found.
func (m *ChartProjectSourceCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ChartProjectSourceCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetId()) < 1 {
		err := ChartProjectSourceCFValidationError{
			field:  "Id",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Path

	if all {
		switch v := interface{}(m.GetRef()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ChartProjectSourceCFValidationError{
					field:  "Ref",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ChartProjectSourceCFValidationError{
					field:  "Ref",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRef()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ChartProjectSourceCFValidationError{
				field:  "Ref",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ChartProjectSourceCFMultiError(errors)
	}

	return nil
}

// ChartProjectSourceCFMultiError is an error wrapping multiple validation
// errors returned by ChartProjectSourceCF.ValidateAll() if the designated
// constraints aren't met.
type ChartProjectSourceCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ChartProjectSourceCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ChartProjectSourceCFMultiError) AllErrors() []error { return m }

// ChartProjectSourceCFValidationError is the validation error returned by
// ChartProjectSourceCF.Validate if the designated constraints aren't met.
type ChartProjectSourceCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ChartProjectSourceCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ChartProjectSourceCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ChartProjectSourceCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ChartProjectSourceCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ChartProjectSourceCFValidationError) ErrorName() string {
	return "ChartProjectSourceCFValidationError"
}

// Error satisfies the builtin error interface
func (e ChartProjectSourceCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sChartProjectSourceCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ChartProjectSourceCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ChartProjectSourceCFValidationError{}

// Validate checks the field values on ChartSourceCF with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ChartSourceCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ChartSourceCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ChartSourceCFMultiError, or
// nil if none found.
func (m *ChartSourceCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ChartSourceCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofSourcePresent := false
	switch v := m.Source.(type) {
	case *ChartSourceCF_Project:
		if v == nil {
			err := ChartSourceCFValidationError{
				field:  "Source",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofSourcePresent = true

		if m.GetProject() == nil {
			err := ChartSourceCFValidationError{
				field:  "Project",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetProject()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ChartSourceCFValidationError{
						field:  "Project",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ChartSourceCFValidationError{
						field:  "Project",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetProject()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ChartSourceCFValidationError{
					field:  "Project",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofSourcePresent {
		err := ChartSourceCFValidationError{
			field:  "Source",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ChartSourceCFMultiError(errors)
	}

	return nil
}

// ChartSourceCFMultiError is an error wrapping multiple validation errors
// returned by ChartSourceCF.ValidateAll() if the designated constraints
// aren't met.
type ChartSourceCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ChartSourceCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ChartSourceCFMultiError) AllErrors() []error { return m }

// ChartSourceCFValidationError is the validation error returned by
// ChartSourceCF.Validate if the designated constraints aren't met.
type ChartSourceCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ChartSourceCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ChartSourceCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ChartSourceCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ChartSourceCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ChartSourceCFValidationError) ErrorName() string { return "ChartSourceCFValidationError" }

// Error satisfies the builtin error interface
func (e ChartSourceCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sChartSourceCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ChartSourceCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ChartSourceCFValidationError{}

// Validate checks the field values on ChartCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ChartCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ChartCF with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in ChartCFMultiError, or nil if none found.
func (m *ChartCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ChartCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetReleaseName()) < 1 {
		err := ChartCFValidationError{
			field:  "ReleaseName",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetSource() == nil {
		err := ChartCFValidationError{
			field:  "Source",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetSource()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ChartCFValidationError{
					field:  "Source",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ChartCFValidationError{
					field:  "Source",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSource()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ChartCFValidationError{
				field:  "Source",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetValues() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ChartCFValidationError{
						field:  fmt.Sprintf("Values[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ChartCFValidationError{
						field:  fmt.Sprintf("Values[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ChartCFValidationError{
					field:  fmt.Sprintf("Values[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if m.Namespace != nil {

		if len(m.GetNamespace()) < 1 {
			err := ChartCFValidationError{
				field:  "Namespace",
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if m.MaxHistory != nil {

		if m.GetMaxHistory() <= 0 {
			err := ChartCFValidationError{
				field:  "MaxHistory",
				reason: "value must be greater than 0",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return ChartCFMultiError(errors)
	}

	return nil
}

// ChartCFMultiError is an error wrapping multiple validation errors returned
// by ChartCF.ValidateAll() if the designated constraints aren't met.
type ChartCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ChartCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ChartCFMultiError) AllErrors() []error { return m }

// ChartCFValidationError is the validation error returned by ChartCF.Validate
// if the designated constraints aren't met.
type ChartCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ChartCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ChartCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ChartCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ChartCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ChartCFValidationError) ErrorName() string { return "ChartCFValidationError" }

// Error satisfies the builtin error interface
func (e ChartCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sChartCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ChartCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ChartCFValidationError{}

// Validate checks the field values on ChartValuesFileCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ChartValuesFileCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ChartValuesFileCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ChartValuesFileCFMultiError, or nil if none found.
func (m *ChartValuesFileCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ChartValuesFileCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetRef()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ChartValuesFileCFValidationError{
					field:  "Ref",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ChartValuesFileCFValidationError{
					field:  "Ref",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRef()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ChartValuesFileCFValidationError{
				field:  "Ref",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetFile()) < 1 {
		err := ChartValuesFileCFValidationError{
			field:  "File",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.ProjectId != nil {

		if len(m.GetProjectId()) < 1 {
			err := ChartValuesFileCFValidationError{
				field:  "ProjectId",
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return ChartValuesFileCFMultiError(errors)
	}

	return nil
}

// ChartValuesFileCFMultiError is an error wrapping multiple validation errors
// returned by ChartValuesFileCF.ValidateAll() if the designated constraints
// aren't met.
type ChartValuesFileCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ChartValuesFileCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ChartValuesFileCFMultiError) AllErrors() []error { return m }

// ChartValuesFileCFValidationError is the validation error returned by
// ChartValuesFileCF.Validate if the designated constraints aren't met.
type ChartValuesFileCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ChartValuesFileCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ChartValuesFileCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ChartValuesFileCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ChartValuesFileCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ChartValuesFileCFValidationError) ErrorName() string {
	return "ChartValuesFileCFValidationError"
}

// Error satisfies the builtin error interface
func (e ChartValuesFileCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sChartValuesFileCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ChartValuesFileCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ChartValuesFileCFValidationError{}

// Validate checks the field values on ChartValuesUrlCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ChartValuesUrlCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ChartValuesUrlCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ChartValuesUrlCFMultiError, or nil if none found.
func (m *ChartValuesUrlCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ChartValuesUrlCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if uri, err := url.Parse(m.GetUrl()); err != nil {
		err = ChartValuesUrlCFValidationError{
			field:  "Url",
			reason: "value must be a valid URI",
			cause:  err,
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	} else if !uri.IsAbs() {
		err := ChartValuesUrlCFValidationError{
			field:  "Url",
			reason: "value must be absolute",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if d := m.GetPollPeriod(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = ChartValuesUrlCFValidationError{
				field:  "PollPeriod",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := ChartValuesUrlCFValidationError{
					field:  "PollPeriod",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if m.MaxFileSize != nil {

		if m.GetMaxFileSize() <= 0 {
			err := ChartValuesUrlCFValidationError{
				field:  "MaxFileSize",
				reason: "value must be greater than 0",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return ChartValuesUrlCFMultiError(errors)
	}

	return nil
}

// ChartValuesUrlCFMultiError is an error wrapping multiple validation errors
// returned by ChartValuesUrlCF.ValidateAll() if the designated constraints
// aren't met.
type ChartValuesUrlCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ChartValuesUrlCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ChartValuesUrlCFMultiError) AllErrors() []error { return m }

// ChartValuesUrlCFValidationError is the validation error returned by
// ChartValuesUrlCF.Validate if the designated constraints aren't met.
type ChartValuesUrlCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ChartValuesUrlCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ChartValuesUrlCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ChartValuesUrlCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ChartValuesUrlCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ChartValuesUrlCFValidationError) ErrorName() string { return "ChartValuesUrlCFValidationError" }

// Error satisfies the builtin error interface
func (e ChartValuesUrlCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sChartValuesUrlCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ChartValuesUrlCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ChartValuesUrlCFValidationError{}

// Validate checks the field values on ChartValuesCF with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ChartValuesCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ChartValuesCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ChartValuesCFMultiError, or
// nil if none found.
func (m *ChartValuesCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ChartValuesCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofFromPresent := false
	switch v := m.From.(type) {
	case *ChartValuesCF_Inline:
		if v == nil {
			err := ChartValuesCFValidationError{
				field:  "From",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofFromPresent = true

		if m.GetInline() == nil {
			err := ChartValuesCFValidationError{
				field:  "Inline",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetInline()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ChartValuesCFValidationError{
						field:  "Inline",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ChartValuesCFValidationError{
						field:  "Inline",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetInline()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ChartValuesCFValidationError{
					field:  "Inline",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ChartValuesCF_File:
		if v == nil {
			err := ChartValuesCFValidationError{
				field:  "From",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofFromPresent = true

		if m.GetFile() == nil {
			err := ChartValuesCFValidationError{
				field:  "File",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetFile()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ChartValuesCFValidationError{
						field:  "File",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ChartValuesCFValidationError{
						field:  "File",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetFile()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ChartValuesCFValidationError{
					field:  "File",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ChartValuesCF_Url:
		if v == nil {
			err := ChartValuesCFValidationError{
				field:  "From",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofFromPresent = true

		if m.GetUrl() == nil {
			err := ChartValuesCFValidationError{
				field:  "Url",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUrl()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ChartValuesCFValidationError{
						field:  "Url",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ChartValuesCFValidationError{
						field:  "Url",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUrl()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ChartValuesCFValidationError{
					field:  "Url",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofFromPresent {
		err := ChartValuesCFValidationError{
			field:  "From",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ChartValuesCFMultiError(errors)
	}

	return nil
}

// ChartValuesCFMultiError is an error wrapping multiple validation errors
// returned by ChartValuesCF.ValidateAll() if the designated constraints
// aren't met.
type ChartValuesCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ChartValuesCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ChartValuesCFMultiError) AllErrors() []error { return m }

// ChartValuesCFValidationError is the validation error returned by
// ChartValuesCF.Validate if the designated constraints aren't met.
type ChartValuesCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ChartValuesCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ChartValuesCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ChartValuesCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ChartValuesCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ChartValuesCFValidationError) ErrorName() string { return "ChartValuesCFValidationError" }

// Error satisfies the builtin error interface
func (e ChartValuesCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sChartValuesCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ChartValuesCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ChartValuesCFValidationError{}

// Validate checks the field values on GitopsCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GitopsCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GitopsCF with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in GitopsCFMultiError, or nil
// if none found.
func (m *GitopsCF) ValidateAll() error {
	return m.validate(true)
}

func (m *GitopsCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetManifestProjects() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GitopsCFValidationError{
						field:  fmt.Sprintf("ManifestProjects[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GitopsCFValidationError{
						field:  fmt.Sprintf("ManifestProjects[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GitopsCFValidationError{
					field:  fmt.Sprintf("ManifestProjects[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetCharts() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GitopsCFValidationError{
						field:  fmt.Sprintf("Charts[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GitopsCFValidationError{
						field:  fmt.Sprintf("Charts[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GitopsCFValidationError{
					field:  fmt.Sprintf("Charts[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return GitopsCFMultiError(errors)
	}

	return nil
}

// GitopsCFMultiError is an error wrapping multiple validation errors returned
// by GitopsCF.ValidateAll() if the designated constraints aren't met.
type GitopsCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GitopsCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GitopsCFMultiError) AllErrors() []error { return m }

// GitopsCFValidationError is the validation error returned by
// GitopsCF.Validate if the designated constraints aren't met.
type GitopsCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GitopsCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GitopsCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GitopsCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GitopsCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GitopsCFValidationError) ErrorName() string { return "GitopsCFValidationError" }

// Error satisfies the builtin error interface
func (e GitopsCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGitopsCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GitopsCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GitopsCFValidationError{}

// Validate checks the field values on ObservabilityCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ObservabilityCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ObservabilityCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ObservabilityCFMultiError, or nil if none found.
func (m *ObservabilityCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ObservabilityCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetLogging()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ObservabilityCFValidationError{
					field:  "Logging",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ObservabilityCFValidationError{
					field:  "Logging",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetLogging()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ObservabilityCFValidationError{
				field:  "Logging",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ObservabilityCFMultiError(errors)
	}

	return nil
}

// ObservabilityCFMultiError is an error wrapping multiple validation errors
// returned by ObservabilityCF.ValidateAll() if the designated constraints
// aren't met.
type ObservabilityCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ObservabilityCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ObservabilityCFMultiError) AllErrors() []error { return m }

// ObservabilityCFValidationError is the validation error returned by
// ObservabilityCF.Validate if the designated constraints aren't met.
type ObservabilityCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ObservabilityCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ObservabilityCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ObservabilityCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ObservabilityCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ObservabilityCFValidationError) ErrorName() string { return "ObservabilityCFValidationError" }

// Error satisfies the builtin error interface
func (e ObservabilityCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sObservabilityCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ObservabilityCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ObservabilityCFValidationError{}

// Validate checks the field values on LoggingCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *LoggingCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on LoggingCF with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in LoggingCFMultiError, or nil
// if none found.
func (m *LoggingCF) ValidateAll() error {
	return m.validate(true)
}

func (m *LoggingCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Level

	if m.GrpcLevel != nil {
		// no validation rules for GrpcLevel
	}

	if len(errors) > 0 {
		return LoggingCFMultiError(errors)
	}

	return nil
}

// LoggingCFMultiError is an error wrapping multiple validation errors returned
// by LoggingCF.ValidateAll() if the designated constraints aren't met.
type LoggingCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m LoggingCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m LoggingCFMultiError) AllErrors() []error { return m }

// LoggingCFValidationError is the validation error returned by
// LoggingCF.Validate if the designated constraints aren't met.
type LoggingCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LoggingCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LoggingCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LoggingCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LoggingCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LoggingCFValidationError) ErrorName() string { return "LoggingCFValidationError" }

// Error satisfies the builtin error interface
func (e LoggingCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLoggingCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LoggingCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LoggingCFValidationError{}

// Validate checks the field values on CiAccessCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *CiAccessCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CiAccessCF with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in CiAccessCFMultiError, or
// nil if none found.
func (m *CiAccessCF) ValidateAll() error {
	return m.validate(true)
}

func (m *CiAccessCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetProjects() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, CiAccessCFValidationError{
						field:  fmt.Sprintf("Projects[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, CiAccessCFValidationError{
						field:  fmt.Sprintf("Projects[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return CiAccessCFValidationError{
					field:  fmt.Sprintf("Projects[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetGroups() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, CiAccessCFValidationError{
						field:  fmt.Sprintf("Groups[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, CiAccessCFValidationError{
						field:  fmt.Sprintf("Groups[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return CiAccessCFValidationError{
					field:  fmt.Sprintf("Groups[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return CiAccessCFMultiError(errors)
	}

	return nil
}

// CiAccessCFMultiError is an error wrapping multiple validation errors
// returned by CiAccessCF.ValidateAll() if the designated constraints aren't met.
type CiAccessCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CiAccessCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CiAccessCFMultiError) AllErrors() []error { return m }

// CiAccessCFValidationError is the validation error returned by
// CiAccessCF.Validate if the designated constraints aren't met.
type CiAccessCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CiAccessCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CiAccessCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CiAccessCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CiAccessCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CiAccessCFValidationError) ErrorName() string { return "CiAccessCFValidationError" }

// Error satisfies the builtin error interface
func (e CiAccessCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCiAccessCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CiAccessCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CiAccessCFValidationError{}

// Validate checks the field values on CiAccessProjectCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *CiAccessProjectCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CiAccessProjectCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// CiAccessProjectCFMultiError, or nil if none found.
func (m *CiAccessProjectCF) ValidateAll() error {
	return m.validate(true)
}

func (m *CiAccessProjectCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetId()) < 1 {
		err := CiAccessProjectCFValidationError{
			field:  "Id",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for DefaultNamespace

	if all {
		switch v := interface{}(m.GetAccessAs()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CiAccessProjectCFValidationError{
					field:  "AccessAs",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CiAccessProjectCFValidationError{
					field:  "AccessAs",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAccessAs()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CiAccessProjectCFValidationError{
				field:  "AccessAs",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetEnvironments() {
		_, _ = idx, item

		if len(item) < 1 {
			err := CiAccessProjectCFValidationError{
				field:  fmt.Sprintf("Environments[%v]", idx),
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return CiAccessProjectCFMultiError(errors)
	}

	return nil
}

// CiAccessProjectCFMultiError is an error wrapping multiple validation errors
// returned by CiAccessProjectCF.ValidateAll() if the designated constraints
// aren't met.
type CiAccessProjectCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CiAccessProjectCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CiAccessProjectCFMultiError) AllErrors() []error { return m }

// CiAccessProjectCFValidationError is the validation error returned by
// CiAccessProjectCF.Validate if the designated constraints aren't met.
type CiAccessProjectCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CiAccessProjectCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CiAccessProjectCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CiAccessProjectCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CiAccessProjectCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CiAccessProjectCFValidationError) ErrorName() string {
	return "CiAccessProjectCFValidationError"
}

// Error satisfies the builtin error interface
func (e CiAccessProjectCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCiAccessProjectCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CiAccessProjectCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CiAccessProjectCFValidationError{}

// Validate checks the field values on CiAccessGroupCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *CiAccessGroupCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CiAccessGroupCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// CiAccessGroupCFMultiError, or nil if none found.
func (m *CiAccessGroupCF) ValidateAll() error {
	return m.validate(true)
}

func (m *CiAccessGroupCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetId()) < 1 {
		err := CiAccessGroupCFValidationError{
			field:  "Id",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for DefaultNamespace

	if all {
		switch v := interface{}(m.GetAccessAs()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CiAccessGroupCFValidationError{
					field:  "AccessAs",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CiAccessGroupCFValidationError{
					field:  "AccessAs",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAccessAs()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CiAccessGroupCFValidationError{
				field:  "AccessAs",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetEnvironments() {
		_, _ = idx, item

		if len(item) < 1 {
			err := CiAccessGroupCFValidationError{
				field:  fmt.Sprintf("Environments[%v]", idx),
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return CiAccessGroupCFMultiError(errors)
	}

	return nil
}

// CiAccessGroupCFMultiError is an error wrapping multiple validation errors
// returned by CiAccessGroupCF.ValidateAll() if the designated constraints
// aren't met.
type CiAccessGroupCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CiAccessGroupCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CiAccessGroupCFMultiError) AllErrors() []error { return m }

// CiAccessGroupCFValidationError is the validation error returned by
// CiAccessGroupCF.Validate if the designated constraints aren't met.
type CiAccessGroupCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CiAccessGroupCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CiAccessGroupCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CiAccessGroupCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CiAccessGroupCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CiAccessGroupCFValidationError) ErrorName() string { return "CiAccessGroupCFValidationError" }

// Error satisfies the builtin error interface
func (e CiAccessGroupCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCiAccessGroupCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CiAccessGroupCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CiAccessGroupCFValidationError{}

// Validate checks the field values on CiAccessAsCF with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *CiAccessAsCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CiAccessAsCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in CiAccessAsCFMultiError, or
// nil if none found.
func (m *CiAccessAsCF) ValidateAll() error {
	return m.validate(true)
}

func (m *CiAccessAsCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofAsPresent := false
	switch v := m.As.(type) {
	case *CiAccessAsCF_Agent:
		if v == nil {
			err := CiAccessAsCFValidationError{
				field:  "As",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofAsPresent = true

		if m.GetAgent() == nil {
			err := CiAccessAsCFValidationError{
				field:  "Agent",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetAgent()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, CiAccessAsCFValidationError{
						field:  "Agent",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, CiAccessAsCFValidationError{
						field:  "Agent",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetAgent()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return CiAccessAsCFValidationError{
					field:  "Agent",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *CiAccessAsCF_Impersonate:
		if v == nil {
			err := CiAccessAsCFValidationError{
				field:  "As",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofAsPresent = true

		if m.GetImpersonate() == nil {
			err := CiAccessAsCFValidationError{
				field:  "Impersonate",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetImpersonate()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, CiAccessAsCFValidationError{
						field:  "Impersonate",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, CiAccessAsCFValidationError{
						field:  "Impersonate",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetImpersonate()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return CiAccessAsCFValidationError{
					field:  "Impersonate",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *CiAccessAsCF_CiJob:
		if v == nil {
			err := CiAccessAsCFValidationError{
				field:  "As",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofAsPresent = true

		if m.GetCiJob() == nil {
			err := CiAccessAsCFValidationError{
				field:  "CiJob",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetCiJob()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, CiAccessAsCFValidationError{
						field:  "CiJob",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, CiAccessAsCFValidationError{
						field:  "CiJob",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetCiJob()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return CiAccessAsCFValidationError{
					field:  "CiJob",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofAsPresent {
		err := CiAccessAsCFValidationError{
			field:  "As",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return CiAccessAsCFMultiError(errors)
	}

	return nil
}

// CiAccessAsCFMultiError is an error wrapping multiple validation errors
// returned by CiAccessAsCF.ValidateAll() if the designated constraints aren't met.
type CiAccessAsCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CiAccessAsCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CiAccessAsCFMultiError) AllErrors() []error { return m }

// CiAccessAsCFValidationError is the validation error returned by
// CiAccessAsCF.Validate if the designated constraints aren't met.
type CiAccessAsCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CiAccessAsCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CiAccessAsCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CiAccessAsCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CiAccessAsCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CiAccessAsCFValidationError) ErrorName() string { return "CiAccessAsCFValidationError" }

// Error satisfies the builtin error interface
func (e CiAccessAsCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCiAccessAsCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CiAccessAsCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CiAccessAsCFValidationError{}

// Validate checks the field values on CiAccessAsAgentCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *CiAccessAsAgentCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CiAccessAsAgentCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// CiAccessAsAgentCFMultiError, or nil if none found.
func (m *CiAccessAsAgentCF) ValidateAll() error {
	return m.validate(true)
}

func (m *CiAccessAsAgentCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return CiAccessAsAgentCFMultiError(errors)
	}

	return nil
}

// CiAccessAsAgentCFMultiError is an error wrapping multiple validation errors
// returned by CiAccessAsAgentCF.ValidateAll() if the designated constraints
// aren't met.
type CiAccessAsAgentCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CiAccessAsAgentCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CiAccessAsAgentCFMultiError) AllErrors() []error { return m }

// CiAccessAsAgentCFValidationError is the validation error returned by
// CiAccessAsAgentCF.Validate if the designated constraints aren't met.
type CiAccessAsAgentCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CiAccessAsAgentCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CiAccessAsAgentCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CiAccessAsAgentCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CiAccessAsAgentCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CiAccessAsAgentCFValidationError) ErrorName() string {
	return "CiAccessAsAgentCFValidationError"
}

// Error satisfies the builtin error interface
func (e CiAccessAsAgentCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCiAccessAsAgentCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CiAccessAsAgentCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CiAccessAsAgentCFValidationError{}

// Validate checks the field values on CiAccessAsCiJobCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *CiAccessAsCiJobCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CiAccessAsCiJobCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// CiAccessAsCiJobCFMultiError, or nil if none found.
func (m *CiAccessAsCiJobCF) ValidateAll() error {
	return m.validate(true)
}

func (m *CiAccessAsCiJobCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return CiAccessAsCiJobCFMultiError(errors)
	}

	return nil
}

// CiAccessAsCiJobCFMultiError is an error wrapping multiple validation errors
// returned by CiAccessAsCiJobCF.ValidateAll() if the designated constraints
// aren't met.
type CiAccessAsCiJobCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CiAccessAsCiJobCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CiAccessAsCiJobCFMultiError) AllErrors() []error { return m }

// CiAccessAsCiJobCFValidationError is the validation error returned by
// CiAccessAsCiJobCF.Validate if the designated constraints aren't met.
type CiAccessAsCiJobCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CiAccessAsCiJobCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CiAccessAsCiJobCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CiAccessAsCiJobCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CiAccessAsCiJobCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CiAccessAsCiJobCFValidationError) ErrorName() string {
	return "CiAccessAsCiJobCFValidationError"
}

// Error satisfies the builtin error interface
func (e CiAccessAsCiJobCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCiAccessAsCiJobCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CiAccessAsCiJobCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CiAccessAsCiJobCFValidationError{}

// Validate checks the field values on CiAccessAsImpersonateCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *CiAccessAsImpersonateCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CiAccessAsImpersonateCF with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// CiAccessAsImpersonateCFMultiError, or nil if none found.
func (m *CiAccessAsImpersonateCF) ValidateAll() error {
	return m.validate(true)
}

func (m *CiAccessAsImpersonateCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetUsername()) < 1 {
		err := CiAccessAsImpersonateCFValidationError{
			field:  "Username",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetGroups() {
		_, _ = idx, item

		if len(item) < 1 {
			err := CiAccessAsImpersonateCFValidationError{
				field:  fmt.Sprintf("Groups[%v]", idx),
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	// no validation rules for Uid

	for idx, item := range m.GetExtra() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, CiAccessAsImpersonateCFValidationError{
						field:  fmt.Sprintf("Extra[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, CiAccessAsImpersonateCFValidationError{
						field:  fmt.Sprintf("Extra[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return CiAccessAsImpersonateCFValidationError{
					field:  fmt.Sprintf("Extra[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return CiAccessAsImpersonateCFMultiError(errors)
	}

	return nil
}

// CiAccessAsImpersonateCFMultiError is an error wrapping multiple validation
// errors returned by CiAccessAsImpersonateCF.ValidateAll() if the designated
// constraints aren't met.
type CiAccessAsImpersonateCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CiAccessAsImpersonateCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CiAccessAsImpersonateCFMultiError) AllErrors() []error { return m }

// CiAccessAsImpersonateCFValidationError is the validation error returned by
// CiAccessAsImpersonateCF.Validate if the designated constraints aren't met.
type CiAccessAsImpersonateCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CiAccessAsImpersonateCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CiAccessAsImpersonateCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CiAccessAsImpersonateCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CiAccessAsImpersonateCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CiAccessAsImpersonateCFValidationError) ErrorName() string {
	return "CiAccessAsImpersonateCFValidationError"
}

// Error satisfies the builtin error interface
func (e CiAccessAsImpersonateCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCiAccessAsImpersonateCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CiAccessAsImpersonateCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CiAccessAsImpersonateCFValidationError{}

// Validate checks the field values on ExtraKeyValCF with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ExtraKeyValCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ExtraKeyValCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ExtraKeyValCFMultiError, or
// nil if none found.
func (m *ExtraKeyValCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ExtraKeyValCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetKey()) < 1 {
		err := ExtraKeyValCFValidationError{
			field:  "Key",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetVal()) < 1 {
		err := ExtraKeyValCFValidationError{
			field:  "Val",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetVal() {
		_, _ = idx, item

		if len(item) < 1 {
			err := ExtraKeyValCFValidationError{
				field:  fmt.Sprintf("Val[%v]", idx),
				reason: "value length must be at least 1 bytes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return ExtraKeyValCFMultiError(errors)
	}

	return nil
}

// ExtraKeyValCFMultiError is an error wrapping multiple validation errors
// returned by ExtraKeyValCF.ValidateAll() if the designated constraints
// aren't met.
type ExtraKeyValCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ExtraKeyValCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ExtraKeyValCFMultiError) AllErrors() []error { return m }

// ExtraKeyValCFValidationError is the validation error returned by
// ExtraKeyValCF.Validate if the designated constraints aren't met.
type ExtraKeyValCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ExtraKeyValCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ExtraKeyValCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ExtraKeyValCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ExtraKeyValCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ExtraKeyValCFValidationError) ErrorName() string { return "ExtraKeyValCFValidationError" }

// Error satisfies the builtin error interface
func (e ExtraKeyValCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sExtraKeyValCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ExtraKeyValCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ExtraKeyValCFValidationError{}

// Validate checks the field values on UserAccessCF with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *UserAccessCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UserAccessCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in UserAccessCFMultiError, or
// nil if none found.
func (m *UserAccessCF) ValidateAll() error {
	return m.validate(true)
}

func (m *UserAccessCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetAccessAs()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UserAccessCFValidationError{
					field:  "AccessAs",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UserAccessCFValidationError{
					field:  "AccessAs",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAccessAs()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UserAccessCFValidationError{
				field:  "AccessAs",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetProjects() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UserAccessCFValidationError{
						field:  fmt.Sprintf("Projects[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UserAccessCFValidationError{
						field:  fmt.Sprintf("Projects[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UserAccessCFValidationError{
					field:  fmt.Sprintf("Projects[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetGroups() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UserAccessCFValidationError{
						field:  fmt.Sprintf("Groups[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UserAccessCFValidationError{
						field:  fmt.Sprintf("Groups[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UserAccessCFValidationError{
					field:  fmt.Sprintf("Groups[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return UserAccessCFMultiError(errors)
	}

	return nil
}

// UserAccessCFMultiError is an error wrapping multiple validation errors
// returned by UserAccessCF.ValidateAll() if the designated constraints aren't met.
type UserAccessCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UserAccessCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UserAccessCFMultiError) AllErrors() []error { return m }

// UserAccessCFValidationError is the validation error returned by
// UserAccessCF.Validate if the designated constraints aren't met.
type UserAccessCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UserAccessCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UserAccessCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UserAccessCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UserAccessCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UserAccessCFValidationError) ErrorName() string { return "UserAccessCFValidationError" }

// Error satisfies the builtin error interface
func (e UserAccessCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUserAccessCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UserAccessCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UserAccessCFValidationError{}

// Validate checks the field values on UserAccessProjectCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *UserAccessProjectCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UserAccessProjectCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// UserAccessProjectCFMultiError, or nil if none found.
func (m *UserAccessProjectCF) ValidateAll() error {
	return m.validate(true)
}

func (m *UserAccessProjectCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetId()) < 1 {
		err := UserAccessProjectCFValidationError{
			field:  "Id",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return UserAccessProjectCFMultiError(errors)
	}

	return nil
}

// UserAccessProjectCFMultiError is an error wrapping multiple validation
// errors returned by UserAccessProjectCF.ValidateAll() if the designated
// constraints aren't met.
type UserAccessProjectCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UserAccessProjectCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UserAccessProjectCFMultiError) AllErrors() []error { return m }

// UserAccessProjectCFValidationError is the validation error returned by
// UserAccessProjectCF.Validate if the designated constraints aren't met.
type UserAccessProjectCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UserAccessProjectCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UserAccessProjectCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UserAccessProjectCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UserAccessProjectCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UserAccessProjectCFValidationError) ErrorName() string {
	return "UserAccessProjectCFValidationError"
}

// Error satisfies the builtin error interface
func (e UserAccessProjectCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUserAccessProjectCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UserAccessProjectCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UserAccessProjectCFValidationError{}

// Validate checks the field values on UserAccessGroupCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *UserAccessGroupCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UserAccessGroupCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// UserAccessGroupCFMultiError, or nil if none found.
func (m *UserAccessGroupCF) ValidateAll() error {
	return m.validate(true)
}

func (m *UserAccessGroupCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetId()) < 1 {
		err := UserAccessGroupCFValidationError{
			field:  "Id",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return UserAccessGroupCFMultiError(errors)
	}

	return nil
}

// UserAccessGroupCFMultiError is an error wrapping multiple validation errors
// returned by UserAccessGroupCF.ValidateAll() if the designated constraints
// aren't met.
type UserAccessGroupCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UserAccessGroupCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UserAccessGroupCFMultiError) AllErrors() []error { return m }

// UserAccessGroupCFValidationError is the validation error returned by
// UserAccessGroupCF.Validate if the designated constraints aren't met.
type UserAccessGroupCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UserAccessGroupCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UserAccessGroupCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UserAccessGroupCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UserAccessGroupCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UserAccessGroupCFValidationError) ErrorName() string {
	return "UserAccessGroupCFValidationError"
}

// Error satisfies the builtin error interface
func (e UserAccessGroupCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUserAccessGroupCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UserAccessGroupCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UserAccessGroupCFValidationError{}

// Validate checks the field values on UserAccessAsCF with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *UserAccessAsCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UserAccessAsCF with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in UserAccessAsCFMultiError,
// or nil if none found.
func (m *UserAccessAsCF) ValidateAll() error {
	return m.validate(true)
}

func (m *UserAccessAsCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofAsPresent := false
	switch v := m.As.(type) {
	case *UserAccessAsCF_Agent:
		if v == nil {
			err := UserAccessAsCFValidationError{
				field:  "As",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofAsPresent = true

		if m.GetAgent() == nil {
			err := UserAccessAsCFValidationError{
				field:  "Agent",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetAgent()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UserAccessAsCFValidationError{
						field:  "Agent",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UserAccessAsCFValidationError{
						field:  "Agent",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetAgent()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UserAccessAsCFValidationError{
					field:  "Agent",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *UserAccessAsCF_User:
		if v == nil {
			err := UserAccessAsCFValidationError{
				field:  "As",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofAsPresent = true

		if m.GetUser() == nil {
			err := UserAccessAsCFValidationError{
				field:  "User",
				reason: "value is required",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUser()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UserAccessAsCFValidationError{
						field:  "User",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UserAccessAsCFValidationError{
						field:  "User",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUser()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UserAccessAsCFValidationError{
					field:  "User",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofAsPresent {
		err := UserAccessAsCFValidationError{
			field:  "As",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return UserAccessAsCFMultiError(errors)
	}

	return nil
}

// UserAccessAsCFMultiError is an error wrapping multiple validation errors
// returned by UserAccessAsCF.ValidateAll() if the designated constraints
// aren't met.
type UserAccessAsCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UserAccessAsCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UserAccessAsCFMultiError) AllErrors() []error { return m }

// UserAccessAsCFValidationError is the validation error returned by
// UserAccessAsCF.Validate if the designated constraints aren't met.
type UserAccessAsCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UserAccessAsCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UserAccessAsCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UserAccessAsCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UserAccessAsCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UserAccessAsCFValidationError) ErrorName() string { return "UserAccessAsCFValidationError" }

// Error satisfies the builtin error interface
func (e UserAccessAsCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUserAccessAsCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UserAccessAsCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UserAccessAsCFValidationError{}

// Validate checks the field values on UserAccessAsAgentCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *UserAccessAsAgentCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UserAccessAsAgentCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// UserAccessAsAgentCFMultiError, or nil if none found.
func (m *UserAccessAsAgentCF) ValidateAll() error {
	return m.validate(true)
}

func (m *UserAccessAsAgentCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return UserAccessAsAgentCFMultiError(errors)
	}

	return nil
}

// UserAccessAsAgentCFMultiError is an error wrapping multiple validation
// errors returned by UserAccessAsAgentCF.ValidateAll() if the designated
// constraints aren't met.
type UserAccessAsAgentCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UserAccessAsAgentCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UserAccessAsAgentCFMultiError) AllErrors() []error { return m }

// UserAccessAsAgentCFValidationError is the validation error returned by
// UserAccessAsAgentCF.Validate if the designated constraints aren't met.
type UserAccessAsAgentCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UserAccessAsAgentCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UserAccessAsAgentCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UserAccessAsAgentCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UserAccessAsAgentCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UserAccessAsAgentCFValidationError) ErrorName() string {
	return "UserAccessAsAgentCFValidationError"
}

// Error satisfies the builtin error interface
func (e UserAccessAsAgentCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUserAccessAsAgentCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UserAccessAsAgentCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UserAccessAsAgentCFValidationError{}

// Validate checks the field values on UserAccessAsUserCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *UserAccessAsUserCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UserAccessAsUserCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// UserAccessAsUserCFMultiError, or nil if none found.
func (m *UserAccessAsUserCF) ValidateAll() error {
	return m.validate(true)
}

func (m *UserAccessAsUserCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return UserAccessAsUserCFMultiError(errors)
	}

	return nil
}

// UserAccessAsUserCFMultiError is an error wrapping multiple validation errors
// returned by UserAccessAsUserCF.ValidateAll() if the designated constraints
// aren't met.
type UserAccessAsUserCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UserAccessAsUserCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UserAccessAsUserCFMultiError) AllErrors() []error { return m }

// UserAccessAsUserCFValidationError is the validation error returned by
// UserAccessAsUserCF.Validate if the designated constraints aren't met.
type UserAccessAsUserCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UserAccessAsUserCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UserAccessAsUserCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UserAccessAsUserCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UserAccessAsUserCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UserAccessAsUserCFValidationError) ErrorName() string {
	return "UserAccessAsUserCFValidationError"
}

// Error satisfies the builtin error interface
func (e UserAccessAsUserCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUserAccessAsUserCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UserAccessAsUserCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UserAccessAsUserCFValidationError{}

// Validate checks the field values on ContainerScanningCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ContainerScanningCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ContainerScanningCF with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ContainerScanningCFMultiError, or nil if none found.
func (m *ContainerScanningCF) ValidateAll() error {
	return m.validate(true)
}

func (m *ContainerScanningCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetVulnerabilityReport()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ContainerScanningCFValidationError{
					field:  "VulnerabilityReport",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ContainerScanningCFValidationError{
					field:  "VulnerabilityReport",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetVulnerabilityReport()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ContainerScanningCFValidationError{
				field:  "VulnerabilityReport",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(m.GetCadence()) < 1 {
		err := ContainerScanningCFValidationError{
			field:  "Cadence",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetResourceRequirements()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ContainerScanningCFValidationError{
					field:  "ResourceRequirements",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ContainerScanningCFValidationError{
					field:  "ResourceRequirements",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetResourceRequirements()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ContainerScanningCFValidationError{
				field:  "ResourceRequirements",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ContainerScanningCFMultiError(errors)
	}

	return nil
}

// ContainerScanningCFMultiError is an error wrapping multiple validation
// errors returned by ContainerScanningCF.ValidateAll() if the designated
// constraints aren't met.
type ContainerScanningCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ContainerScanningCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ContainerScanningCFMultiError) AllErrors() []error { return m }

// ContainerScanningCFValidationError is the validation error returned by
// ContainerScanningCF.Validate if the designated constraints aren't met.
type ContainerScanningCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ContainerScanningCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ContainerScanningCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ContainerScanningCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ContainerScanningCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ContainerScanningCFValidationError) ErrorName() string {
	return "ContainerScanningCFValidationError"
}

// Error satisfies the builtin error interface
func (e ContainerScanningCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sContainerScanningCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ContainerScanningCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ContainerScanningCFValidationError{}

// Validate checks the field values on VulnerabilityReport with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *VulnerabilityReport) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on VulnerabilityReport with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// VulnerabilityReportMultiError, or nil if none found.
func (m *VulnerabilityReport) ValidateAll() error {
	return m.validate(true)
}

func (m *VulnerabilityReport) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetFilters() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, VulnerabilityReportValidationError{
						field:  fmt.Sprintf("Filters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, VulnerabilityReportValidationError{
						field:  fmt.Sprintf("Filters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VulnerabilityReportValidationError{
					field:  fmt.Sprintf("Filters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return VulnerabilityReportMultiError(errors)
	}

	return nil
}

// VulnerabilityReportMultiError is an error wrapping multiple validation
// errors returned by VulnerabilityReport.ValidateAll() if the designated
// constraints aren't met.
type VulnerabilityReportMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m VulnerabilityReportMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m VulnerabilityReportMultiError) AllErrors() []error { return m }

// VulnerabilityReportValidationError is the validation error returned by
// VulnerabilityReport.Validate if the designated constraints aren't met.
type VulnerabilityReportValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e VulnerabilityReportValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e VulnerabilityReportValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e VulnerabilityReportValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e VulnerabilityReportValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e VulnerabilityReportValidationError) ErrorName() string {
	return "VulnerabilityReportValidationError"
}

// Error satisfies the builtin error interface
func (e VulnerabilityReportValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sVulnerabilityReport.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = VulnerabilityReportValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = VulnerabilityReportValidationError{}

// Validate checks the field values on ContainerScanningFilter with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ContainerScanningFilter) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ContainerScanningFilter with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ContainerScanningFilterMultiError, or nil if none found.
func (m *ContainerScanningFilter) ValidateAll() error {
	return m.validate(true)
}

func (m *ContainerScanningFilter) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return ContainerScanningFilterMultiError(errors)
	}

	return nil
}

// ContainerScanningFilterMultiError is an error wrapping multiple validation
// errors returned by ContainerScanningFilter.ValidateAll() if the designated
// constraints aren't met.
type ContainerScanningFilterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ContainerScanningFilterMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ContainerScanningFilterMultiError) AllErrors() []error { return m }

// ContainerScanningFilterValidationError is the validation error returned by
// ContainerScanningFilter.Validate if the designated constraints aren't met.
type ContainerScanningFilterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ContainerScanningFilterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ContainerScanningFilterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ContainerScanningFilterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ContainerScanningFilterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ContainerScanningFilterValidationError) ErrorName() string {
	return "ContainerScanningFilterValidationError"
}

// Error satisfies the builtin error interface
func (e ContainerScanningFilterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sContainerScanningFilter.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ContainerScanningFilterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ContainerScanningFilterValidationError{}

// Validate checks the field values on ResourceRequirements with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ResourceRequirements) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ResourceRequirements with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ResourceRequirementsMultiError, or nil if none found.
func (m *ResourceRequirements) ValidateAll() error {
	return m.validate(true)
}

func (m *ResourceRequirements) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetLimits()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ResourceRequirementsValidationError{
					field:  "Limits",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ResourceRequirementsValidationError{
					field:  "Limits",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetLimits()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ResourceRequirementsValidationError{
				field:  "Limits",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRequests()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ResourceRequirementsValidationError{
					field:  "Requests",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ResourceRequirementsValidationError{
					field:  "Requests",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRequests()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ResourceRequirementsValidationError{
				field:  "Requests",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ResourceRequirementsMultiError(errors)
	}

	return nil
}

// ResourceRequirementsMultiError is an error wrapping multiple validation
// errors returned by ResourceRequirements.ValidateAll() if the designated
// constraints aren't met.
type ResourceRequirementsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ResourceRequirementsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ResourceRequirementsMultiError) AllErrors() []error { return m }

// ResourceRequirementsValidationError is the validation error returned by
// ResourceRequirements.Validate if the designated constraints aren't met.
type ResourceRequirementsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ResourceRequirementsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ResourceRequirementsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ResourceRequirementsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ResourceRequirementsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ResourceRequirementsValidationError) ErrorName() string {
	return "ResourceRequirementsValidationError"
}

// Error satisfies the builtin error interface
func (e ResourceRequirementsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sResourceRequirements.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ResourceRequirementsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ResourceRequirementsValidationError{}

// Validate checks the field values on Resource with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Resource) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Resource with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ResourceMultiError, or nil
// if none found.
func (m *Resource) ValidateAll() error {
	return m.validate(true)
}

func (m *Resource) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Cpu

	// no validation rules for Memory

	if len(errors) > 0 {
		return ResourceMultiError(errors)
	}

	return nil
}

// ResourceMultiError is an error wrapping multiple validation errors returned
// by Resource.ValidateAll() if the designated constraints aren't met.
type ResourceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ResourceMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ResourceMultiError) AllErrors() []error { return m }

// ResourceValidationError is the validation error returned by
// Resource.Validate if the designated constraints aren't met.
type ResourceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ResourceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ResourceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ResourceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ResourceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ResourceValidationError) ErrorName() string { return "ResourceValidationError" }

// Error satisfies the builtin error interface
func (e ResourceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sResource.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ResourceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ResourceValidationError{}

// Validate checks the field values on ConfigurationFile with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ConfigurationFile) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ConfigurationFile with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ConfigurationFileMultiError, or nil if none found.
func (m *ConfigurationFile) ValidateAll() error {
	return m.validate(true)
}

func (m *ConfigurationFile) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetGitops()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Gitops",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Gitops",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGitops()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "Gitops",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetObservability()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Observability",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Observability",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetObservability()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "Observability",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetCiAccess()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "CiAccess",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "CiAccess",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCiAccess()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "CiAccess",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetContainerScanning()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "ContainerScanning",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "ContainerScanning",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContainerScanning()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "ContainerScanning",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetUserAccess()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "UserAccess",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "UserAccess",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUserAccess()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "UserAccess",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRemoteDevelopment()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "RemoteDevelopment",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "RemoteDevelopment",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRemoteDevelopment()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "RemoteDevelopment",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetFlux()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Flux",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ConfigurationFileValidationError{
					field:  "Flux",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetFlux()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ConfigurationFileValidationError{
				field:  "Flux",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ConfigurationFileMultiError(errors)
	}

	return nil
}

// ConfigurationFileMultiError is an error wrapping multiple validation errors
// returned by ConfigurationFile.ValidateAll() if the designated constraints
// aren't met.
type ConfigurationFileMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ConfigurationFileMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ConfigurationFileMultiError) AllErrors() []error { return m }

// ConfigurationFileValidationError is the validation error returned by
// ConfigurationFile.Validate if the designated constraints aren't met.
type ConfigurationFileValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ConfigurationFileValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ConfigurationFileValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ConfigurationFileValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ConfigurationFileValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ConfigurationFileValidationError) ErrorName() string {
	return "ConfigurationFileValidationError"
}

// Error satisfies the builtin error interface
func (e ConfigurationFileValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConfigurationFile.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ConfigurationFileValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ConfigurationFileValidationError{}

// Validate checks the field values on AgentConfiguration with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *AgentConfiguration) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AgentConfiguration with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AgentConfigurationMultiError, or nil if none found.
func (m *AgentConfiguration) ValidateAll() error {
	return m.validate(true)
}

func (m *AgentConfiguration) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetGitops()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AgentConfigurationValidationError{
					field:  "Gitops",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AgentConfigurationValidationError{
					field:  "Gitops",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetGitops()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentConfigurationValidationError{
				field:  "Gitops",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetObservability()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AgentConfigurationValidationError{
					field:  "Observability",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AgentConfigurationValidationError{
					field:  "Observability",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetObservability()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentConfigurationValidationError{
				field:  "Observability",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for AgentId

	// no validation rules for ProjectId

	if all {
		switch v := interface{}(m.GetCiAccess()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AgentConfigurationValidationError{
					field:  "CiAccess",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AgentConfigurationValidationError{
					field:  "CiAccess",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCiAccess()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentConfigurationValidationError{
				field:  "CiAccess",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetContainerScanning()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AgentConfigurationValidationError{
					field:  "ContainerScanning",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AgentConfigurationValidationError{
					field:  "ContainerScanning",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContainerScanning()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentConfigurationValidationError{
				field:  "ContainerScanning",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for ProjectPath

	if all {
		switch v := interface{}(m.GetRemoteDevelopment()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AgentConfigurationValidationError{
					field:  "RemoteDevelopment",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AgentConfigurationValidationError{
					field:  "RemoteDevelopment",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRemoteDevelopment()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentConfigurationValidationError{
				field:  "RemoteDevelopment",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetFlux()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AgentConfigurationValidationError{
					field:  "Flux",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AgentConfigurationValidationError{
					field:  "Flux",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetFlux()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AgentConfigurationValidationError{
				field:  "Flux",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for GitlabExternalUrl

	if len(errors) > 0 {
		return AgentConfigurationMultiError(errors)
	}

	return nil
}

// AgentConfigurationMultiError is an error wrapping multiple validation errors
// returned by AgentConfiguration.ValidateAll() if the designated constraints
// aren't met.
type AgentConfigurationMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AgentConfigurationMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AgentConfigurationMultiError) AllErrors() []error { return m }

// AgentConfigurationValidationError is the validation error returned by
// AgentConfiguration.Validate if the designated constraints aren't met.
type AgentConfigurationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AgentConfigurationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AgentConfigurationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AgentConfigurationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AgentConfigurationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AgentConfigurationValidationError) ErrorName() string {
	return "AgentConfigurationValidationError"
}

// Error satisfies the builtin error interface
func (e AgentConfigurationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAgentConfiguration.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AgentConfigurationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AgentConfigurationValidationError{}

// Validate checks the field values on RemoteCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RemoteCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RemoteCF with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RemoteCFMultiError, or nil
// if none found.
func (m *RemoteCF) ValidateAll() error {
	return m.validate(true)
}

func (m *RemoteCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Enabled

	// no validation rules for DnsZone

	if d := m.GetPartialSyncInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = RemoteCFValidationError{
				field:  "PartialSyncInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := RemoteCFValidationError{
					field:  "PartialSyncInterval",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if d := m.GetFullSyncInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = RemoteCFValidationError{
				field:  "FullSyncInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := RemoteCFValidationError{
					field:  "FullSyncInterval",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if len(errors) > 0 {
		return RemoteCFMultiError(errors)
	}

	return nil
}

// RemoteCFMultiError is an error wrapping multiple validation errors returned
// by RemoteCF.ValidateAll() if the designated constraints aren't met.
type RemoteCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RemoteCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RemoteCFMultiError) AllErrors() []error { return m }

// RemoteCFValidationError is the validation error returned by
// RemoteCF.Validate if the designated constraints aren't met.
type RemoteCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RemoteCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RemoteCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RemoteCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RemoteCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RemoteCFValidationError) ErrorName() string { return "RemoteCFValidationError" }

// Error satisfies the builtin error interface
func (e RemoteCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRemoteCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RemoteCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RemoteCFValidationError{}

// Validate checks the field values on FluxCF with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *FluxCF) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on FluxCF with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in FluxCFMultiError, or nil if none found.
func (m *FluxCF) ValidateAll() error {
	return m.validate(true)
}

func (m *FluxCF) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for WebhookReceiverUrl

	if len(errors) > 0 {
		return FluxCFMultiError(errors)
	}

	return nil
}

// FluxCFMultiError is an error wrapping multiple validation errors returned by
// FluxCF.ValidateAll() if the designated constraints aren't met.
type FluxCFMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m FluxCFMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m FluxCFMultiError) AllErrors() []error { return m }

// FluxCFValidationError is the validation error returned by FluxCF.Validate if
// the designated constraints aren't met.
type FluxCFValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FluxCFValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FluxCFValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FluxCFValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FluxCFValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FluxCFValidationError) ErrorName() string { return "FluxCFValidationError" }

// Error satisfies the builtin error interface
func (e FluxCFValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFluxCF.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FluxCFValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FluxCFValidationError{}
