/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.commandline;

import java.util.List;
import org.broadinstitute.gatk.utils.Utils;
import org.broadinstitute.gatk.utils.commandline.ArgumentException;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatch;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatchSite;
import org.broadinstitute.gatk.utils.commandline.ArgumentMatchValue;

class UnmatchedArgumentException
extends ArgumentException {
    public UnmatchedArgumentException(ArgumentMatch invalidValues) {
        super(UnmatchedArgumentException.formatArguments(invalidValues));
    }

    private static String formatArguments(ArgumentMatch invalidValues) {
        StringBuilder sb = new StringBuilder();
        for (ArgumentMatchSite site : invalidValues.sites.keySet()) {
            for (ArgumentMatchValue value : (List)invalidValues.sites.get(site)) {
                switch (site.getSource().getType()) {
                    case CommandLine: {
                        sb.append(String.format("%nInvalid argument value '%s' at position %d.", value.asString(), site.getIndex()));
                        break;
                    }
                    case Provider: {
                        sb.append(String.format("%nInvalid argument value '%s' in %s at position %d.", value.asString(), site.getSource().getDescription(), site.getIndex()));
                        break;
                    }
                    default: {
                        throw new RuntimeException(String.format("Unexpected argument match source type: %s", new Object[]{site.getSource().getType()}));
                    }
                }
                if (value.asString() == null || !Utils.dupString(' ', value.asString().length()).equals(value.asString())) continue;
                sb.append("  Please make sure any line continuation backslashes on your command line are not followed by whitespace.");
            }
        }
        return sb.toString();
    }
}

