#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Orwell 1
# send your bug reports to contact@dotslashplay.it
###

script_version=20231109.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='orwell-1'
GAME_NAME='Orwell'

ARCHIVE_BASE_2_NAME='orwell_1_4_7424_39231.sh'
ARCHIVE_BASE_2_MD5='8ac1915d9de7532717730b7f33a544b9'
ARCHIVE_BASE_2_SIZE='570000'
ARCHIVE_BASE_2_VERSION='1.4.7424.gog39231'
ARCHIVE_BASE_2_URL='https://www.gog.com/game/orwell'

ARCHIVE_BASE_1_NAME='orwell_en_1_21_21014.sh'
ARCHIVE_BASE_1_MD5='8fcd84cd3989175d1da377c78e1b4ff2'
ARCHIVE_BASE_1_SIZE='360000'
ARCHIVE_BASE_1_VERSION='1.21-gog21014'

ARCHIVE_BASE_0_NAME='gog_orwell_2.0.0.1.sh'
ARCHIVE_BASE_0_MD5='471470546952015fce024bdcb5431a07'
ARCHIVE_BASE_0_SIZE='630000'
ARCHIVE_BASE_0_VERSION='1.1-gog2.0.0.1'

UNITY3D_NAME='Orwell'
UNITY3D_PLUGINS='
ScreenSelector.so'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_DOC_DATA_FILES='
*.txt'

FAKE_HOME_PERSISTENT_DIRECTORIES='
My Games/Orwell'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libz.so.1'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Check for the presence of optional extra archives

## The original game icon is not provided by the GOG installer for Orwell 1.4.
## Other archives can use the default icon paht for Unity3D games.
case "$(context_archive)" in
	('ARCHIVE_BASE_2')
		ARCHIVE_OPTIONAL_ICONS_NAME='orwell-1_icons.tar.gz'
		ARCHIVE_OPTIONAL_ICONS_MD5='acb6711e5f6b26828097b2828f74e522'
		ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/games/orwell-1/'
		archive_initialize_optional \
			'ARCHIVE_ICONS' \
			'ARCHIVE_OPTIONAL_ICONS'
	;;
esac

# Extract game data

archive_extraction_default
## TODO: The library should provide a function to check if a given optional archive has been provided.
if [ -n "$(archive_path 'ARCHIVE_ICONS' 2>/dev/null || true)" ]; then
	archive_extraction 'ARCHIVE_ICONS'
fi

# Include game data

## The original game icon is not provided by the GOG installer for Orwell 1.4.
## Other archives can use the default icon path for Unity3D games.
## TODO: The library should provide a function to check if a given optional archive has been provided.
if [ -n "$(archive_path 'ARCHIVE_ICONS' 2>/dev/null || true)" ]; then
	CONTENT_ICONS_DATA_PATH='.'
	CONTENT_ICONS_DATA_FILES='
	128x128'
	content_inclusion 'ICONS_DATA' 'PKG_DATA' "$(path_icons)"
else
	case "$(context_archive)" in
		('ARCHIVE_BASE_2')
			APP_MAIN_ICON='../support/icon.png'
		;;
	esac
	PKG='PKG_DATA'
	icons_inclusion
fi
content_inclusion_default

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
