/*
 * progdefs.h -- PROGS structures: Generated by HCC. Do not
 * modify unless you know what you are doing.
 * $Id: progdefs.h 4950 2012-09-15 08:12:19Z sezero $
 *
 * Copyright (C) 1996-1997  Id Software, Inc.
 * Copyright (C) 1997-1998  Raven Software Corp.
 * Copyright (C) 2005-2012  O.Sezer <sezero@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __PROGDEFS_H
#define __PROGDEFS_H

/* progs from hw releases older than v0.14 (0.12?) do NOT have Siege
 * support, including the lack of the "siege_team" member in
 * entvars_t, therefore siege_team must be accessed carefully.
 *
 * progs from hw-0.09 (AFAIK, the initial hw release) is ancient.
 * there is no hwprogs.dat but progs.dat and progs2.dat. it is
 * much more close to h2-v1.11 progs and has no praevus mission
 * pack support either, therefore four classes only. it has no
 * has_portals and gravity members in its entvars_t.
 */

/* hexenworld v0.09 progdefs: */
typedef struct
{	int	pad[28];
	int	self;
	int	other;
	int	world;
	float	time;
	float	frametime;
	int	newmis;
	float	force_retouch;
	string_t	mapname;
	string_t	startspot;
	float	deathmatch;
	float	randomclass;
	float	damageScale;
	/* meleeDamScale and shyRespawn
	 * not in v0.09. */
	/* spartanPrint not in v0.11 */
	float	manaScale;
	float	tomeMode;
	float	tomeRespawn;
	float	w2Respawn;
	float	altRespawn;
	float	fixedLevel;
	float	autoItems;
	float	dmMode;
	/* easyFourth and patternRunner
	 * not in v0.09. */
	float	coop;
	float	teamplay;
	float	serverflags;
	float	total_secrets;
	float	total_monsters;
	float	found_secrets;
	float	killed_monsters;
	float	chunk_cnt;
	float	done_precache;
	float	parm1;
	float	parm2;
	float	parm4;
	float	parm5;
	float	parm6;
	float	parm7;
	float	parm8;
	float	parm9;
	float	parm10;
	float	parm11;
	float	parm12;
	float	parm13;
	float	parm14;
	float	parm15;
	float	parm16;
	string_t	parm3;
	vec3_t	v_forward;
	vec3_t	v_up;
	vec3_t	v_right;
	float	trace_allsolid;
	float	trace_startsolid;
	float	trace_fraction;
	vec3_t	trace_endpos;
	vec3_t	trace_plane_normal;
	float	trace_plane_dist;
	int	trace_ent;
	float	trace_inopen;
	float	trace_inwater;
	int	msg_entity;
	float	cycle_wrapped;
	float	crouch_cnt;
	float	modelindex_assassin;
	float	modelindex_crusader;
	float	modelindex_paladin;
	float	modelindex_necromancer;
	float	modelindex_sheep;
	float	num_players;
	float	exp_mult;
	/* max_players, defLosses and attLosses
	 * are for Siege:  not in v0.11. */
	func_t	main;
	func_t	StartFrame;
	func_t	PlayerPreThink;
	func_t	PlayerPostThink;
	func_t	ClientKill;
	func_t	ClientConnect;
	func_t	PutClientInServer;
	func_t	ClientReEnter;
	func_t	ClientDisconnect;
	func_t	ClassChangeWeapon;
	func_t	SetNewParms;
	func_t	SetChangeParms;
	/* SmitePlayer only in v0.15 */
} globalvars_v009_t;

/* hexenworld v0.11 progdefs: */
typedef struct
{	int	pad[28];
	int	self;
	int	other;
	int	world;
	float	time;
	float	frametime;
	int	newmis;
	float	force_retouch;
	string_t	mapname;
	string_t	startspot;
	float	deathmatch;
	float	randomclass;
	float	damageScale;
	float	meleeDamScale;
	float	shyRespawn;
	/* spartanPrint not in v0.11 */
	float	manaScale;
	float	tomeMode;
	float	tomeRespawn;
	float	w2Respawn;
	float	altRespawn;
	float	fixedLevel;
	float	autoItems;
	float	dmMode;
	float	easyFourth;
	float	patternRunner;
	float	coop;
	float	teamplay;
	float	serverflags;
	float	total_secrets;
	float	total_monsters;
	float	found_secrets;
	float	killed_monsters;
	float	chunk_cnt;
	float	done_precache;
	float	parm1;
	float	parm2;
	float	parm4;
	float	parm5;
	float	parm6;
	float	parm7;
	float	parm8;
	float	parm9;
	float	parm10;
	float	parm11;
	float	parm12;
	float	parm13;
	float	parm14;
	float	parm15;
	float	parm16;
	string_t	parm3;
	vec3_t	v_forward;
	vec3_t	v_up;
	vec3_t	v_right;
	float	trace_allsolid;
	float	trace_startsolid;
	float	trace_fraction;
	vec3_t	trace_endpos;
	vec3_t	trace_plane_normal;
	float	trace_plane_dist;
	int	trace_ent;
	float	trace_inopen;
	float	trace_inwater;
	int	msg_entity;
	float	cycle_wrapped;
	float	crouch_cnt;
	float	modelindex_assassin;
	float	modelindex_crusader;
	float	modelindex_paladin;
	float	modelindex_necromancer;
	float	modelindex_sheep;
	float	num_players;
	float	exp_mult;
	/* max_players, defLosses and attLosses
	 * are for Siege:  not in v0.11. */
	func_t	main;
	func_t	StartFrame;
	func_t	PlayerPreThink;
	func_t	PlayerPostThink;
	func_t	ClientKill;
	func_t	ClientConnect;
	func_t	PutClientInServer;
	func_t	ClientReEnter;
	func_t	ClientDisconnect;
	func_t	ClassChangeWeapon;
	func_t	SetNewParms;
	func_t	SetChangeParms;
	/* SmitePlayer only in v0.15 */
} globalvars_v011_t;

/* hexenworld v0.14 progdefs: */
typedef struct
{	int	pad[28];
	int	self;
	int	other;
	int	world;
	float	time;
	float	frametime;
	int	newmis;
	float	force_retouch;
	string_t	mapname;
	string_t	startspot;
	float	deathmatch;
	float	randomclass;
	float	damageScale;
	float	meleeDamScale;
	float	shyRespawn;
	float	spartanPrint;	/* in v0.14 and newer */
	float	manaScale;
	float	tomeMode;
	float	tomeRespawn;
	float	w2Respawn;
	float	altRespawn;
	float	fixedLevel;
	float	autoItems;
	float	dmMode;
	float	easyFourth;
	float	patternRunner;
	float	coop;
	float	teamplay;
	float	serverflags;
	float	total_secrets;
	float	total_monsters;
	float	found_secrets;
	float	killed_monsters;
	float	chunk_cnt;
	float	done_precache;
	float	parm1;
	float	parm2;
	float	parm4;
	float	parm5;
	float	parm6;
	float	parm7;
	float	parm8;
	float	parm9;
	float	parm10;
	float	parm11;
	float	parm12;
	float	parm13;
	float	parm14;
	float	parm15;
	float	parm16;
	string_t	parm3;
	vec3_t	v_forward;
	vec3_t	v_up;
	vec3_t	v_right;
	float	trace_allsolid;
	float	trace_startsolid;
	float	trace_fraction;
	vec3_t	trace_endpos;
	vec3_t	trace_plane_normal;
	float	trace_plane_dist;
	int	trace_ent;
	float	trace_inopen;
	float	trace_inwater;
	int	msg_entity;
	float	cycle_wrapped;
	float	crouch_cnt;
	float	modelindex_assassin;
	float	modelindex_crusader;
	float	modelindex_paladin;
	float	modelindex_necromancer;
	float	modelindex_sheep;
	float	num_players;
	float	exp_mult;
	/* max_players, defLosses and attLosses
	 * are for Siege:  in v0.14 and newer. */
	float	max_players;
	float	defLosses;
	float	attLosses;
	func_t	main;
	func_t	StartFrame;
	func_t	PlayerPreThink;
	func_t	PlayerPostThink;
	func_t	ClientKill;
	func_t	ClientConnect;
	func_t	PutClientInServer;
	func_t	ClientReEnter;
	func_t	ClientDisconnect;
	func_t	ClassChangeWeapon;
	func_t	SetNewParms;
	func_t	SetChangeParms;
	/* SmitePlayer only in v0.15 */
} globalvars_v014_t;

/* hexenworld v0.15 progdefs: */
typedef struct
{	int	pad[28];
	int	self;
	int	other;
	int	world;
	float	time;
	float	frametime;
	int	newmis;
	float	force_retouch;
	string_t	mapname;
	string_t	startspot;
	float	deathmatch;
	float	randomclass;
	float	damageScale;
	float	meleeDamScale;
	float	shyRespawn;
	float	spartanPrint;	/* in v0.14 and newer */
	float	manaScale;
	float	tomeMode;
	float	tomeRespawn;
	float	w2Respawn;
	float	altRespawn;
	float	fixedLevel;
	float	autoItems;
	float	dmMode;
	float	easyFourth;
	float	patternRunner;
	float	coop;
	float	teamplay;
	float	serverflags;
	float	total_secrets;
	float	total_monsters;
	float	found_secrets;
	float	killed_monsters;
	float	chunk_cnt;
	float	done_precache;
	float	parm1;
	float	parm2;
	float	parm4;
	float	parm5;
	float	parm6;
	float	parm7;
	float	parm8;
	float	parm9;
	float	parm10;
	float	parm11;
	float	parm12;
	float	parm13;
	float	parm14;
	float	parm15;
	float	parm16;
	string_t	parm3;
	vec3_t	v_forward;
	vec3_t	v_up;
	vec3_t	v_right;
	float	trace_allsolid;
	float	trace_startsolid;
	float	trace_fraction;
	vec3_t	trace_endpos;
	vec3_t	trace_plane_normal;
	float	trace_plane_dist;
	int	trace_ent;
	float	trace_inopen;
	float	trace_inwater;
	int	msg_entity;
	float	cycle_wrapped;
	float	crouch_cnt;
	float	modelindex_assassin;
	float	modelindex_crusader;
	float	modelindex_paladin;
	float	modelindex_necromancer;
	float	modelindex_sheep;
	float	num_players;
	float	exp_mult;
	/* max_players, defLosses and attLosses
	 * are for Siege:  in v0.14 and newer. */
	float	max_players;
	float	defLosses;
	float	attLosses;
	func_t	main;
	func_t	StartFrame;
	func_t	PlayerPreThink;
	func_t	PlayerPostThink;
	func_t	ClientKill;
	func_t	ClientConnect;
	func_t	PutClientInServer;
	func_t	ClientReEnter;
	func_t	ClientDisconnect;
	func_t	ClassChangeWeapon;
	func_t	SetNewParms;
	func_t	SetChangeParms;
	func_t	SmitePlayer;	/* in v0.15 */
} globalvars_v015_t;

typedef struct
{
	int	*self;		/* @ offset 28. */
	int	*other;
	int	*world;
	float	*time;
	float	*frametime;
	int	*newmis;
	float	*force_retouch;
	string_t	*mapname;
	string_t	*startspot;
	float	*deathmatch;
	float	*randomclass;
	float	*damageScale;
	float	*meleeDamScale;
	float	*shyRespawn;
	float	*spartanPrint;
	float	*manaScale;
	float	*tomeMode;
	float	*tomeRespawn;
	float	*w2Respawn;
	float	*altRespawn;
	float	*fixedLevel;
	float	*autoItems;
	float	*dmMode;
	float	*easyFourth;
	float	*patternRunner;
	float	*coop;
	float	*teamplay;
	float	*serverflags;
	float	*total_secrets;
	float	*total_monsters;
	float	*found_secrets;
	float	*killed_monsters;
	float	*chunk_cnt;
	float	*done_precache;
	/* parm1-16 form an array.  Unlike Quake, Hexen II progs has them
	 * in order parms1..2 parms4..16 as float and parm3 as string_t */
	float	*parm;
	vec3_t	*v_forward;
	vec3_t	*v_up;
	vec3_t	*v_right;
	float	*trace_allsolid;
	float	*trace_startsolid;
	float	*trace_fraction;
	vec3_t	*trace_endpos;
	vec3_t	*trace_plane_normal;
	float	*trace_plane_dist;
	int	*trace_ent;
	float	*trace_inopen;
	float	*trace_inwater;
	int	*msg_entity;
	float	*cycle_wrapped;
	float	*crouch_cnt;
	float	*modelindex_assassin;
	float	*modelindex_crusader;
	float	*modelindex_paladin;
	float	*modelindex_necromancer;
	float	*modelindex_sheep;
	float	*num_players;
	float	*exp_mult;
	/* max_players, defLosses and attLosses
	 * are for Siege:  in v0.14 and newer. */
	float	*max_players;
	float	*defLosses;
	float	*attLosses;
	/* functions */
	func_t	*main;
	func_t	*StartFrame;
	func_t	*PlayerPreThink;
	func_t	*PlayerPostThink;
	func_t	*ClientKill;
	func_t	*ClientConnect;
	func_t	*PutClientInServer;
	func_t	*ClientReEnter;
	func_t	*ClientDisconnect;
	func_t	*ClassChangeWeapon;
	func_t	*SetNewParms;
	func_t	*SetChangeParms;
	func_t	*SmitePlayer;
} sv_globals_t;

typedef struct
{
	float	modelindex;
	vec3_t	absmin;
	vec3_t	absmax;
	float	ltime;
	float	lastruntime;
	float	movetype;
	float	solid;
	vec3_t	origin;
	vec3_t	oldorigin;
	vec3_t	velocity;
	vec3_t	angles;
	vec3_t	avelocity;
	vec3_t	punchangle;
	string_t	classname;
	string_t	model;
	float	frame;
	float	skin;
	float	effects;
	float	scale;
	float	drawflags;
	float	abslight;
	vec3_t	mins;
	vec3_t	maxs;
	vec3_t	size;
	float	hull;
	func_t	touch;
	func_t	use;
	func_t	think;
	func_t	blocked;
	float	nextthink;
	int	groundentity;
	float	stats_restored;
	float	frags;
	float	weapon;
	string_t	weaponmodel;
	float	weaponframe;
	float	health;
	float	max_health;
	float	playerclass;
	float	next_playerclass;
	float	has_portals;	/* has_portals is NOT in v0.09 */
	float	bluemana;
	float	greenmana;
	float	max_mana;
	float	armor_amulet;
	float	armor_bracer;
	float	armor_breastplate;
	float	armor_helmet;
	float	level;
	float	intelligence;
	float	wisdom;
	float	dexterity;
	float	strength;
	float	experience;
	float	ring_flight;
	float	ring_water;
	float	ring_turning;
	float	ring_regeneration;
	float	haste_time;
	float	tome_time;
	string_t	puzzle_inv1;
	string_t	puzzle_inv2;
	string_t	puzzle_inv3;
	string_t	puzzle_inv4;
	string_t	puzzle_inv5;
	string_t	puzzle_inv6;
	string_t	puzzle_inv7;
	string_t	puzzle_inv8;
	float	experience_value;
	float	items;
	float	takedamage;
	int	chain;
	float	deadflag;
	vec3_t	view_ofs;
	float	button0;
	float	button1;
	float	button2;
	float	impulse;
	float	fixangle;
	vec3_t	v_angle;
	float	idealpitch;
	float	idealroll;
	float	hoverz;
	string_t	netname;
	int	enemy;
	float	flags;
	float	flags2;
	float	artifact_flags;
	float	colormap;
	float	team;
	float	light_level;
	float	wpn_sound;
	float	targAng;
	float	targPitch;
	float	targDist;
	float	teleport_time;
	float	armortype;
	float	armorvalue;
	float	waterlevel;
	float	watertype;
	float	friction;
	float	ideal_yaw;
	float	yaw_speed;
	int	goalentity;
	float	spawnflags;
	string_t	target;
	string_t	targetname;
	float	dmg_take;
	float	dmg_save;
	int	dmg_inflictor;
	int	owner;
	vec3_t	movedir;
	float	message;
	float	soundtype;
	string_t	noise;
	string_t	noise1;
	string_t	noise2;
	string_t	noise3;
	float	rings;
	float	rings_active;
	float	rings_low;
	float	artifacts;
	float	artifact_active;
	float	artifact_low;
	float	hasted;
	float	inventory;
	float	cnt_torch;
	float	cnt_h_boost;
	float	cnt_sh_boost;
	float	cnt_mana_boost;
	float	cnt_teleport;
	float	cnt_tome;
	float	cnt_summon;
	float	cnt_invisibility;
	float	cnt_glyph;
	float	cnt_haste;
	float	cnt_blast;
	float	cnt_polymorph;
	float	cnt_flight;
	float	cnt_cubeofforce;
	float	cnt_invincibility;
	int	cameramode;
	int	movechain;
	func_t	chainmoved;
	float	string_index;
	float	gravity;	/* gravity is not in v0.09 */
	float	siege_team;	/* siege support: in v0.14 (0.12?) and newer */
} entvars_t;

/* crc for HexenWorld v0.09 hwprogs.dat headers	*/
#define	PROGS_V009_CRC		27922

/* crc for HexenWorld v0.11 hwprogs.dat headers	*/
#define	PROGS_V011_CRC		48691

/* crc for HexenWorld v0.14 hwprogs.dat headers	*/
#define	PROGS_V014_CRC		61593

/* crc for HexenWorld v0.15 hwprogs.dat headers	*/
#define	PROGS_V015_CRC		25203

/* the default valid crc:			*/
#define	PROGHEADER_CRC		(PROGS_V015_CRC)

#endif	/* __PROGDEFS_H */

