!{\src2tex{textfont=tt}}
!!****f* ABINIT/cppm4par
!! NAME
!! cppm4par
!!
!! FUNCTION
!! Calculate the plasmon-pole parameters using Engel and Farid model (PRB47,15931,1993)
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (RShaltaf,GMR,XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  epsm1(npwvec,npwvec,nomega,nq)=dielectric matrix at nomega frequencies, and nq wavevectors
!!  npwvec=number of plane waves
!!  nomega=number of frequencies (usually 2)
!!  nq=number of q vectors
!!  omegaplasma=input variable
!!  rho=charge deinsity on real space FFT grid
!!  b1,b2,b3=reciprocal lattice vectors
!!  rho =denisity in real space
!!  ngfft1,ngfft2,ngfft3= FFT parameters
!!  gvec=G vectors in reduced reciprocal lattice
!! OUTPUT
!!  bigomegatwsq(npwvec,npwvec,nq)=plasmon-pole strength
!!  omegatw(npwvec,npwvec,nq)=plasmon-pole energy
!!
!! PARENTS
!!      sigma
!!
!! CHILDREN
!!      fourdp
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine cppm4par(npwvec,nq,epsm1,nomega,bigomegatwsq,omegatw,&
& ngfft1,ngfft2,ngfft3,gvec,rho,nr,q,b1,b2,b3)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_12ffts
 use interfaces_15gw, except_this_one => cppm4par
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ngfft1,ngfft2,ngfft3,nomega,npwvec,nq,nr
!arrays
 integer,intent(in) :: gvec(3,npwvec)
 real(dp),intent(in) :: b1(3),b2(3),b3(3),q(3,nq)
 real(dp),intent(inout) :: rho(nr)
 complex,intent(in) :: epsm1(npwvec,npwvec,nomega,nq)
 complex,intent(out) :: bigomegatwsq(npwvec,npwvec,nq),omegatw(npwvec,1,nq)

!Local variables-------------------------------
!scalars
 integer :: ierr,ig,igp,ii,index,iq,istat,jj,lowork,tim_fourdp=2
 real(dp) :: qpg_dot_qpgp
 character(len=1) :: jobs,uplo
 character(len=500) :: message
 type(MPI_type) :: mpi_enreg
!arrays
 integer :: ngfft(18)
 integer,allocatable :: igfft(:,:)
 real(dp) :: gppq(3),gpq(3)
 real(dp),allocatable :: eigval(:),eigval1(:),qplusg(:),rhog_dp(:,:),rwork(:)
 real(dp),allocatable :: zhpev2(:)
 complex,allocatable :: chi(:,:,:),chitmp(:,:),rhog(:),rhogg(:,:),zz2(:,:)
!no_abirules
 COMPLEX*16,allocatable::mtemp(:,:),work(:),eigvec(:,:),mm(:,:,:),chitmps(:,:),tmp1(:),eigvec1(:,:)
 COMPLEX*16,allocatable::zhpev1(:),matr(:)

!*************************************************************************

! calculat the density in G space rhog(G)

#ifdef __VMS
!DEC$ ATTRIBUTES ALIAS:'ZHEGV' :: zhegv
#endif

 allocate(rhog_dp(2,nr),stat=istat)
 if(istat/=0) stop 'rhog_dp out of memory'
 allocate(rhog(nr),stat=istat)
 if(istat/=0) stop 'rhog out of memory'
 allocate(igfft(npwvec,npwvec),stat=istat)
 if(istat/=0) stop 'igfft out of memory'
 allocate(rhogg(npwvec,npwvec),stat=istat)
 if(istat/=0) stop 'rhogg out of memory'

  ngfft(1)=ngfft1
  ngfft(2)=ngfft2
  ngfft(3)=ngfft3
  ngfft(4)=2*(ngfft(1)/2)+1
  ngfft(5)=2*(ngfft(2)/2)+1
  ngfft(6)=ngfft(3)
  ngfft(7)=100
  ngfft(8)=256
  ngfft(9)=0
  ngfft(10)=1
  ngfft(11)=0
  ngfft(12)=ngfft2
  ngfft(13)=ngfft3
  ngfft(14)=0

! conduct FFT to rhog

 call fourdp(1,rhog_dp,rho,-1,mpi_enreg,nr,ngfft,0)
 rhog(1:nr)=cmplx(rhog_dp(1,1:nr),rhog_dp(2,1:nr))

! calculate the FFT index of each (G-G') vector and assign the value
! of correspondent density simultanously

 deallocate(rhog_dp)

 call cggfft(npwvec,ngfft1,ngfft2,ngfft3,gvec,igfft)

 do ig=1,npwvec
  do igp=1,npwvec
   if(igfft(ig,igp)>nr)then
   write (message,'(a,a,a)') &
   &'BUG:can not find rho(G-Gpr) for some G, Gpr, contact ABINIT group',ch10,&
   &'program will stop'
   call wrtout(ab_out,message,'COLL')
   call wrtout(std_out,message,'COLL')
   call leave_new('COLL')
   end if
   rhogg(ig,igp)=rhog(igfft(ig,igp))
  end do
 end do


 deallocate(igfft)
 deallocate(rhog)

!Now we have rhogg
!calculate the m matrix

 allocate(mm(npwvec,npwvec,nq),stat=istat)
 if(istat/=0) stop 'mm out of memory'

 do iq=1,nq
  do ig=1,npwvec
   gpq(1)=gvec(1,ig)+q(1,iq)
   gpq(2)=gvec(2,ig)+q(2,iq)
   gpq(3)=gvec(3,ig)+q(3,iq)
   do igp=1,npwvec
    gppq(1)=gvec(1,igp)+q(1,iq)
    gppq(2)=gvec(2,igp)+q(2,iq)
    gppq(3)=gvec(3,igp)+q(3,iq)
    qpg_dot_qpgp=0
    do ii=1,3
     qpg_dot_qpgp=qpg_dot_qpgp+&
&     (gpq(1)*b1(ii) +gpq(2)*b2(ii) +gpq(3)*b3(ii))*&
&     (gppq(1)*b1(ii)+gppq(2)*b2(ii)+gppq(3)*b3(ii))
    end do
    mm(ig,igp,iq)=rhogg(ig,igp)*qpg_dot_qpgp
   end do     !igp
  end do    !ig
 end do  !iq

 allocate(chitmp(npwvec,npwvec),stat=istat)
 if(istat/=0) stop 'chitmp out of memory'
 allocate(chi(npwvec,npwvec,iq),stat=istat)
 if(istat/=0) stop 'chi0 out of memory'
 allocate(qplusg(npwvec),stat=istat)
 if(istat/=0) stop 'qplusg out of memory'

! extract the full polarizability from eps1
! eps1=1+chitmp*Vc

 do iq=1,nq
  chitmp(:,:)=epsm1(:,:,1,iq)
  call cvc(nq,iq,q,b1,b2,b3,npwvec,gvec,qplusg)
  do ig=1,npwvec
   chitmp(ig,ig)=chitmp(ig,ig)-1
  end do
  do ig=1,npwvec
   do igp=1,npwvec
    chi(ig,igp,iq)=chitmp(ig,igp)*qplusg(ig)*qplusg(igp)/(4.0*pi)
   end do
  end do
 end do

 deallocate(chitmp)

! solve chi*Y=Lambda*M*Y
! Lambda=-1/em(q)**2

!DEBUG
! do iq=1,nq
!  allocate(eigval1(npwvec),stat=istat)
!  if(istat/=0) stop 'eigval1 out of memory'
!  allocate(eigvec1(npwvec,npwvec),stat=istat)
!  if(istat/=0) stop 'eigvec1 out of memory'
!  allocate(matr(npwvec*(npwvec+1)/2))
!  if(istat/=0) stop 'matr out of memory'
!  allocate(zhpev2(3*npwvec-2),stat=istat)
!  if(istat/=0) stop 'zhpev2 of memory'
!  allocate(zhpev1(2*npwvec-1),stat=istat)
!  if(istat/=0) stop 'zhpev1 of memory' ! woking arrays for lapack
!
!  index=1
!  do ii=1,npwvec
!   do jj=1,ii
!    matr(index)=chi(jj,ii,iq)
!    index=index+1
!   end do
!  end do
!
!  call zhpev('v','u',npwvec,matr,eigval1,eigvec1,npwvec,&
!&   zhpev1,zhpev2,ierr)
!
!  deallocate(zhpev1,zhpev2,matr,eigval1,eigvec1)
! end do
!ENDDEBUG


 do iq=1,nq

 allocate(eigval(npwvec),stat=istat)
 if(istat/=0) stop 'eigval out of memory'
 allocate(eigvec(npwvec,npwvec),stat=istat)
 if(istat/=0) stop 'eigvec out of memory'
 allocate(mtemp(npwvec,npwvec),stat=istat)
 if(istat/=0) stop 'mtemp out of memory'
 allocate(chitmps(npwvec,npwvec),stat=istat)       ! temp working arrays
 if(istat/=0) stop 'chitmps out of memory'
 allocate(work(2*npwvec-1),stat=istat)
 if(istat/=0) stop 'work out of memory'
 allocate(rwork(3*npwvec-2),stat=istat) ! needed by lapack
 if(istat/=0) stop 'rwork out of memory'
! copy chi, m into working arrays
  chitmps(:,:)=chi(:,:,iq)
  mtemp(:,:)=mm(:,:,iq)
  lowork=2*npwvec-1

  call zhegv(1,'v','u',npwvec,chitmps,npwvec,mtemp,npwvec,eigval,work,lowork,rwork,ierr)

 eigvec(:,:)=chitmps(:,:)

 deallocate(mtemp)
 deallocate(chitmps)       ! temp working arrays
 deallocate(work)
 deallocate(rwork) ! needed by lapack

! start the plasmon pole parameters
 allocate(tmp1(npwvec),stat=istat)   ! eign vectors
 if(istat/=0) stop 'tmp1 out of memory'
 allocate(zz2(npwvec,npwvec),stat=istat)                ! checking
 if(istat/=0) stop 'zz out of memory'

! good check:
! the lowest plasmon energy on gamma should be
! close to experimental plasma energy withen an error of 10 %
! this error can be reduced further if one includes the non local
! commutators in the calculation of polarizability at q==0

  zz2(:,:)=0.0_dp
  call cvc(nq,iq,q,b1,b2,b3,npwvec,gvec,qplusg)

  do ii=1,npwvec

! keeping in mind that the above matrix is negative definite
! we might have a small problem with the eigval that correspond to large G vectors
! i.e. DM band index, where the eigvals become very small with
! possibility of being small positive numbers
! thus as a causion one can use the following condition
! this will not affect the result since such a huge plasmon energy give almost zero
! contribution to the self correlation energy
   if(eigval(ii)>=0.0_dp)then
    if(eigval(ii)<1.0d-3)then
     eigval(ii)=-1.0d-4
    else
     write (message,'(a,a,a)') &
&     'BUG:one or more imaginary plasmon pole energies, contact ABINIT group',ch10,&
&     'program will stop'
     call wrtout(ab_out,message,'COLL')
     call wrtout(std_out,message,'COLL')
     call leave_new('COLL')
    end if
   end if
   omegatw(ii,1,iq)=sqrt(-1/eigval(ii))
   tmp1(:)=eigvec(:,ii)
   do ig=1,npwvec
    do igp=1,npwvec
     zz2(ig,ii)=zz2(ig,ii)+mm(ig,igp,iq)*tmp1(igp)
    end do
    bigomegatwsq(ig,ii,iq)=sqrt(4.0*pi)*zz2(ig,ii)/sqrt(omegatw(ii,1,iq))
    bigomegatwsq(ig,ii,iq)=bigomegatwsq(ig,ii,iq)/(qplusg(ig))
   end do
  end do
  deallocate(tmp1)   ! eign vectors

  deallocate(eigvec)
  deallocate(eigval)
  deallocate(zz2)

 end do ! iq
 deallocate(qplusg)
 deallocate(chi)
 deallocate(rhogg)
 deallocate(mm)
 write(ab_out,*)"======================================================================"
 write(ab_out,*)"plasmon energies vs q vector shown for lowest 10 bands"
 do iq=1,nq
  write(ab_out,'(2x,i3,3x,10f9.5)')iq,(real(Ha_eV*omegatw(ig,1,iq)),ig=1,10)
 end do
 write(ab_out,*)"======================================================================"

end subroutine cppm4par
!!***
