// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddTags = "AddTags"

// AddTagsRequest generates a "aws/request.Request" representing the
// client's request for the AddTags operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTags for more information on using the AddTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsRequest method.
//    req, resp := client.AddTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/tags",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	output = &AddTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTags API operation for Amazon Elasticsearch Service.
//
// Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive
// key value pairs. An Elasticsearch domain may have up to 10 tags. See  Tagging
// Amazon Elasticsearch Service Domains for more information. (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation AddTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
func (c *ElasticsearchService) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	return out, req.Send()
}

// AddTagsWithContext is the same as AddTags with the addition of
// the ability to pass a context and additional request options.
//
// See AddTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) AddTagsWithContext(ctx aws.Context, input *AddTagsInput, opts ...request.Option) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateElasticsearchDomain = "CreateElasticsearchDomain"

// CreateElasticsearchDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateElasticsearchDomain operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateElasticsearchDomain for more information on using the CreateElasticsearchDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateElasticsearchDomainRequest method.
//    req, resp := client.CreateElasticsearchDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) CreateElasticsearchDomainRequest(input *CreateElasticsearchDomainInput) (req *request.Request, output *CreateElasticsearchDomainOutput) {
	op := &request.Operation{
		Name:       opCreateElasticsearchDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/domain",
	}

	if input == nil {
		input = &CreateElasticsearchDomainInput{}
	}

	output = &CreateElasticsearchDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateElasticsearchDomain API operation for Amazon Elasticsearch Service.
//
// Creates a new Elasticsearch domain. For more information, see Creating Elasticsearch
// Domains (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains)
// in the Amazon Elasticsearch Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation CreateElasticsearchDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeDisabledOperationException "DisabledOperationException"
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeInvalidTypeException "InvalidTypeException"
//   An exception for trying to create or access sub-resource that is either invalid
//   or not supported. Gives http status code of 409.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   An exception for creating a resource that already exists. Gives http status
//   code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) CreateElasticsearchDomain(input *CreateElasticsearchDomainInput) (*CreateElasticsearchDomainOutput, error) {
	req, out := c.CreateElasticsearchDomainRequest(input)
	return out, req.Send()
}

// CreateElasticsearchDomainWithContext is the same as CreateElasticsearchDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateElasticsearchDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) CreateElasticsearchDomainWithContext(ctx aws.Context, input *CreateElasticsearchDomainInput, opts ...request.Option) (*CreateElasticsearchDomainOutput, error) {
	req, out := c.CreateElasticsearchDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteElasticsearchDomain = "DeleteElasticsearchDomain"

// DeleteElasticsearchDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteElasticsearchDomain operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteElasticsearchDomain for more information on using the DeleteElasticsearchDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteElasticsearchDomainRequest method.
//    req, resp := client.DeleteElasticsearchDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) DeleteElasticsearchDomainRequest(input *DeleteElasticsearchDomainInput) (req *request.Request, output *DeleteElasticsearchDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteElasticsearchDomain,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}",
	}

	if input == nil {
		input = &DeleteElasticsearchDomainInput{}
	}

	output = &DeleteElasticsearchDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteElasticsearchDomain API operation for Amazon Elasticsearch Service.
//
// Permanently deletes the specified Elasticsearch domain and all of its data.
// Once a domain is deleted, it cannot be recovered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DeleteElasticsearchDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) DeleteElasticsearchDomain(input *DeleteElasticsearchDomainInput) (*DeleteElasticsearchDomainOutput, error) {
	req, out := c.DeleteElasticsearchDomainRequest(input)
	return out, req.Send()
}

// DeleteElasticsearchDomainWithContext is the same as DeleteElasticsearchDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteElasticsearchDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DeleteElasticsearchDomainWithContext(ctx aws.Context, input *DeleteElasticsearchDomainInput, opts ...request.Option) (*DeleteElasticsearchDomainOutput, error) {
	req, out := c.DeleteElasticsearchDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeElasticsearchDomain = "DescribeElasticsearchDomain"

// DescribeElasticsearchDomainRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticsearchDomain operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeElasticsearchDomain for more information on using the DescribeElasticsearchDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeElasticsearchDomainRequest method.
//    req, resp := client.DescribeElasticsearchDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) DescribeElasticsearchDomainRequest(input *DescribeElasticsearchDomainInput) (req *request.Request, output *DescribeElasticsearchDomainOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticsearchDomain,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}",
	}

	if input == nil {
		input = &DescribeElasticsearchDomainInput{}
	}

	output = &DescribeElasticsearchDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticsearchDomain API operation for Amazon Elasticsearch Service.
//
// Returns domain configuration information about the specified Elasticsearch
// domain, including the domain ID, domain endpoint, and domain ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeElasticsearchDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) DescribeElasticsearchDomain(input *DescribeElasticsearchDomainInput) (*DescribeElasticsearchDomainOutput, error) {
	req, out := c.DescribeElasticsearchDomainRequest(input)
	return out, req.Send()
}

// DescribeElasticsearchDomainWithContext is the same as DescribeElasticsearchDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeElasticsearchDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeElasticsearchDomainWithContext(ctx aws.Context, input *DescribeElasticsearchDomainInput, opts ...request.Option) (*DescribeElasticsearchDomainOutput, error) {
	req, out := c.DescribeElasticsearchDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeElasticsearchDomainConfig = "DescribeElasticsearchDomainConfig"

// DescribeElasticsearchDomainConfigRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticsearchDomainConfig operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeElasticsearchDomainConfig for more information on using the DescribeElasticsearchDomainConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeElasticsearchDomainConfigRequest method.
//    req, resp := client.DescribeElasticsearchDomainConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) DescribeElasticsearchDomainConfigRequest(input *DescribeElasticsearchDomainConfigInput) (req *request.Request, output *DescribeElasticsearchDomainConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticsearchDomainConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}/config",
	}

	if input == nil {
		input = &DescribeElasticsearchDomainConfigInput{}
	}

	output = &DescribeElasticsearchDomainConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticsearchDomainConfig API operation for Amazon Elasticsearch Service.
//
// Provides cluster configuration information about the specified Elasticsearch
// domain, such as the state, creation date, update version, and update date
// for cluster options.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeElasticsearchDomainConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) DescribeElasticsearchDomainConfig(input *DescribeElasticsearchDomainConfigInput) (*DescribeElasticsearchDomainConfigOutput, error) {
	req, out := c.DescribeElasticsearchDomainConfigRequest(input)
	return out, req.Send()
}

// DescribeElasticsearchDomainConfigWithContext is the same as DescribeElasticsearchDomainConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeElasticsearchDomainConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeElasticsearchDomainConfigWithContext(ctx aws.Context, input *DescribeElasticsearchDomainConfigInput, opts ...request.Option) (*DescribeElasticsearchDomainConfigOutput, error) {
	req, out := c.DescribeElasticsearchDomainConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeElasticsearchDomains = "DescribeElasticsearchDomains"

// DescribeElasticsearchDomainsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticsearchDomains operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeElasticsearchDomains for more information on using the DescribeElasticsearchDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeElasticsearchDomainsRequest method.
//    req, resp := client.DescribeElasticsearchDomainsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) DescribeElasticsearchDomainsRequest(input *DescribeElasticsearchDomainsInput) (req *request.Request, output *DescribeElasticsearchDomainsOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticsearchDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/domain-info",
	}

	if input == nil {
		input = &DescribeElasticsearchDomainsInput{}
	}

	output = &DescribeElasticsearchDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticsearchDomains API operation for Amazon Elasticsearch Service.
//
// Returns domain configuration information about the specified Elasticsearch
// domains, including the domain ID, domain endpoint, and domain ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeElasticsearchDomains for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) DescribeElasticsearchDomains(input *DescribeElasticsearchDomainsInput) (*DescribeElasticsearchDomainsOutput, error) {
	req, out := c.DescribeElasticsearchDomainsRequest(input)
	return out, req.Send()
}

// DescribeElasticsearchDomainsWithContext is the same as DescribeElasticsearchDomains with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeElasticsearchDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeElasticsearchDomainsWithContext(ctx aws.Context, input *DescribeElasticsearchDomainsInput, opts ...request.Option) (*DescribeElasticsearchDomainsOutput, error) {
	req, out := c.DescribeElasticsearchDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeElasticsearchInstanceTypeLimits = "DescribeElasticsearchInstanceTypeLimits"

// DescribeElasticsearchInstanceTypeLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticsearchInstanceTypeLimits operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeElasticsearchInstanceTypeLimits for more information on using the DescribeElasticsearchInstanceTypeLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeElasticsearchInstanceTypeLimitsRequest method.
//    req, resp := client.DescribeElasticsearchInstanceTypeLimitsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) DescribeElasticsearchInstanceTypeLimitsRequest(input *DescribeElasticsearchInstanceTypeLimitsInput) (req *request.Request, output *DescribeElasticsearchInstanceTypeLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticsearchInstanceTypeLimits,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/instanceTypeLimits/{ElasticsearchVersion}/{InstanceType}",
	}

	if input == nil {
		input = &DescribeElasticsearchInstanceTypeLimitsInput{}
	}

	output = &DescribeElasticsearchInstanceTypeLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticsearchInstanceTypeLimits API operation for Amazon Elasticsearch Service.
//
// Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion.
// When modifying existing Domain, specify the DomainName to know what Limits
// are supported for modifying.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeElasticsearchInstanceTypeLimits for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeInvalidTypeException "InvalidTypeException"
//   An exception for trying to create or access sub-resource that is either invalid
//   or not supported. Gives http status code of 409.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) DescribeElasticsearchInstanceTypeLimits(input *DescribeElasticsearchInstanceTypeLimitsInput) (*DescribeElasticsearchInstanceTypeLimitsOutput, error) {
	req, out := c.DescribeElasticsearchInstanceTypeLimitsRequest(input)
	return out, req.Send()
}

// DescribeElasticsearchInstanceTypeLimitsWithContext is the same as DescribeElasticsearchInstanceTypeLimits with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeElasticsearchInstanceTypeLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) DescribeElasticsearchInstanceTypeLimitsWithContext(ctx aws.Context, input *DescribeElasticsearchInstanceTypeLimitsInput, opts ...request.Option) (*DescribeElasticsearchInstanceTypeLimitsOutput, error) {
	req, out := c.DescribeElasticsearchInstanceTypeLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDomainNames = "ListDomainNames"

// ListDomainNamesRequest generates a "aws/request.Request" representing the
// client's request for the ListDomainNames operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomainNames for more information on using the ListDomainNames
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDomainNamesRequest method.
//    req, resp := client.ListDomainNamesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) ListDomainNamesRequest(input *ListDomainNamesInput) (req *request.Request, output *ListDomainNamesOutput) {
	op := &request.Operation{
		Name:       opListDomainNames,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/domain",
	}

	if input == nil {
		input = &ListDomainNamesInput{}
	}

	output = &ListDomainNamesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomainNames API operation for Amazon Elasticsearch Service.
//
// Returns the name of all Elasticsearch domains owned by the current user's
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation ListDomainNames for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) ListDomainNames(input *ListDomainNamesInput) (*ListDomainNamesOutput, error) {
	req, out := c.ListDomainNamesRequest(input)
	return out, req.Send()
}

// ListDomainNamesWithContext is the same as ListDomainNames with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomainNames for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListDomainNamesWithContext(ctx aws.Context, input *ListDomainNamesInput, opts ...request.Option) (*ListDomainNamesOutput, error) {
	req, out := c.ListDomainNamesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListElasticsearchInstanceTypes = "ListElasticsearchInstanceTypes"

// ListElasticsearchInstanceTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListElasticsearchInstanceTypes operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListElasticsearchInstanceTypes for more information on using the ListElasticsearchInstanceTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListElasticsearchInstanceTypesRequest method.
//    req, resp := client.ListElasticsearchInstanceTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) ListElasticsearchInstanceTypesRequest(input *ListElasticsearchInstanceTypesInput) (req *request.Request, output *ListElasticsearchInstanceTypesOutput) {
	op := &request.Operation{
		Name:       opListElasticsearchInstanceTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/instanceTypes/{ElasticsearchVersion}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListElasticsearchInstanceTypesInput{}
	}

	output = &ListElasticsearchInstanceTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListElasticsearchInstanceTypes API operation for Amazon Elasticsearch Service.
//
// List all Elasticsearch instance types that are supported for given ElasticsearchVersion
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation ListElasticsearchInstanceTypes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) ListElasticsearchInstanceTypes(input *ListElasticsearchInstanceTypesInput) (*ListElasticsearchInstanceTypesOutput, error) {
	req, out := c.ListElasticsearchInstanceTypesRequest(input)
	return out, req.Send()
}

// ListElasticsearchInstanceTypesWithContext is the same as ListElasticsearchInstanceTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListElasticsearchInstanceTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListElasticsearchInstanceTypesWithContext(ctx aws.Context, input *ListElasticsearchInstanceTypesInput, opts ...request.Option) (*ListElasticsearchInstanceTypesOutput, error) {
	req, out := c.ListElasticsearchInstanceTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListElasticsearchInstanceTypesPages iterates over the pages of a ListElasticsearchInstanceTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListElasticsearchInstanceTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListElasticsearchInstanceTypes operation.
//    pageNum := 0
//    err := client.ListElasticsearchInstanceTypesPages(params,
//        func(page *ListElasticsearchInstanceTypesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElasticsearchService) ListElasticsearchInstanceTypesPages(input *ListElasticsearchInstanceTypesInput, fn func(*ListElasticsearchInstanceTypesOutput, bool) bool) error {
	return c.ListElasticsearchInstanceTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListElasticsearchInstanceTypesPagesWithContext same as ListElasticsearchInstanceTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListElasticsearchInstanceTypesPagesWithContext(ctx aws.Context, input *ListElasticsearchInstanceTypesInput, fn func(*ListElasticsearchInstanceTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListElasticsearchInstanceTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListElasticsearchInstanceTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListElasticsearchInstanceTypesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListElasticsearchVersions = "ListElasticsearchVersions"

// ListElasticsearchVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListElasticsearchVersions operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListElasticsearchVersions for more information on using the ListElasticsearchVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListElasticsearchVersionsRequest method.
//    req, resp := client.ListElasticsearchVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) ListElasticsearchVersionsRequest(input *ListElasticsearchVersionsInput) (req *request.Request, output *ListElasticsearchVersionsOutput) {
	op := &request.Operation{
		Name:       opListElasticsearchVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListElasticsearchVersionsInput{}
	}

	output = &ListElasticsearchVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListElasticsearchVersions API operation for Amazon Elasticsearch Service.
//
// List all supported Elasticsearch versions
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation ListElasticsearchVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) ListElasticsearchVersions(input *ListElasticsearchVersionsInput) (*ListElasticsearchVersionsOutput, error) {
	req, out := c.ListElasticsearchVersionsRequest(input)
	return out, req.Send()
}

// ListElasticsearchVersionsWithContext is the same as ListElasticsearchVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListElasticsearchVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListElasticsearchVersionsWithContext(ctx aws.Context, input *ListElasticsearchVersionsInput, opts ...request.Option) (*ListElasticsearchVersionsOutput, error) {
	req, out := c.ListElasticsearchVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListElasticsearchVersionsPages iterates over the pages of a ListElasticsearchVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListElasticsearchVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListElasticsearchVersions operation.
//    pageNum := 0
//    err := client.ListElasticsearchVersionsPages(params,
//        func(page *ListElasticsearchVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ElasticsearchService) ListElasticsearchVersionsPages(input *ListElasticsearchVersionsInput, fn func(*ListElasticsearchVersionsOutput, bool) bool) error {
	return c.ListElasticsearchVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListElasticsearchVersionsPagesWithContext same as ListElasticsearchVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListElasticsearchVersionsPagesWithContext(ctx aws.Context, input *ListElasticsearchVersionsInput, fn func(*ListElasticsearchVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListElasticsearchVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListElasticsearchVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListElasticsearchVersionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/tags/",
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for Amazon Elasticsearch Service.
//
// Returns all tags for the given Elasticsearch domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation ListTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
func (c *ElasticsearchService) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTags = "RemoveTags"

// RemoveTagsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTags operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTags for more information on using the RemoveTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsRequest method.
//    req, resp := client.RemoveTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) RemoveTagsRequest(input *RemoveTagsInput) (req *request.Request, output *RemoveTagsOutput) {
	op := &request.Operation{
		Name:       opRemoveTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/tags-removal",
	}

	if input == nil {
		input = &RemoveTagsInput{}
	}

	output = &RemoveTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTags API operation for Amazon Elasticsearch Service.
//
// Removes the specified set of tags from the specified Elasticsearch domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation RemoveTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
func (c *ElasticsearchService) RemoveTags(input *RemoveTagsInput) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	return out, req.Send()
}

// RemoveTagsWithContext is the same as RemoveTags with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) RemoveTagsWithContext(ctx aws.Context, input *RemoveTagsInput, opts ...request.Option) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateElasticsearchDomainConfig = "UpdateElasticsearchDomainConfig"

// UpdateElasticsearchDomainConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateElasticsearchDomainConfig operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateElasticsearchDomainConfig for more information on using the UpdateElasticsearchDomainConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateElasticsearchDomainConfigRequest method.
//    req, resp := client.UpdateElasticsearchDomainConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ElasticsearchService) UpdateElasticsearchDomainConfigRequest(input *UpdateElasticsearchDomainConfigInput) (req *request.Request, output *UpdateElasticsearchDomainConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateElasticsearchDomainConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}/config",
	}

	if input == nil {
		input = &UpdateElasticsearchDomainConfigInput{}
	}

	output = &UpdateElasticsearchDomainConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateElasticsearchDomainConfig API operation for Amazon Elasticsearch Service.
//
// Modifies the cluster configuration of the specified Elasticsearch domain,
// setting as setting the instance type and the number of instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation UpdateElasticsearchDomainConfig for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBaseException "BaseException"
//   An error occurred while processing the request.
//
//   * ErrCodeInternalException "InternalException"
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ErrCodeInvalidTypeException "InvalidTypeException"
//   An exception for trying to create or access sub-resource that is either invalid
//   or not supported. Gives http status code of 409.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ErrCodeValidationException "ValidationException"
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
func (c *ElasticsearchService) UpdateElasticsearchDomainConfig(input *UpdateElasticsearchDomainConfigInput) (*UpdateElasticsearchDomainConfigOutput, error) {
	req, out := c.UpdateElasticsearchDomainConfigRequest(input)
	return out, req.Send()
}

// UpdateElasticsearchDomainConfigWithContext is the same as UpdateElasticsearchDomainConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateElasticsearchDomainConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ElasticsearchService) UpdateElasticsearchDomainConfigWithContext(ctx aws.Context, input *UpdateElasticsearchDomainConfigInput, opts ...request.Option) (*UpdateElasticsearchDomainConfigOutput, error) {
	req, out := c.UpdateElasticsearchDomainConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The configured access rules for the domain's document and search endpoints,
// and the current status of those rules.
type AccessPoliciesStatus struct {
	_ struct{} `type:"structure"`

	// The access policy configured for the Elasticsearch domain. Access policies
	// may be resource-based, IP-based, or IAM-based. See  Configuring Access Policies
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-access-policies)for
	// more information.
	//
	// Options is a required field
	Options *string `type:"string" required:"true"`

	// The status of the access policy for the Elasticsearch domain. See OptionStatus
	// for the status information that's included.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s AccessPoliciesStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessPoliciesStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AccessPoliciesStatus) SetOptions(v string) *AccessPoliciesStatus {
	s.Options = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AccessPoliciesStatus) SetStatus(v *OptionStatus) *AccessPoliciesStatus {
	s.Status = v
	return s
}

// Container for the parameters to the AddTags operation. Specify the tags that
// you want to attach to the Elasticsearch domain.
type AddTagsInput struct {
	_ struct{} `type:"structure"`

	// Specify the ARN for which you want to add the tags.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// List of Tag that need to be added for the Elasticsearch domain.
	//
	// TagList is a required field
	TagList []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsInput"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}
	if s.TagList == nil {
		invalidParams.Add(request.NewErrParamRequired("TagList"))
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *AddTagsInput) SetARN(v string) *AddTagsInput {
	s.ARN = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *AddTagsInput) SetTagList(v []*Tag) *AddTagsInput {
	s.TagList = v
	return s
}

type AddTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// List of limits that are specific to a given InstanceType and for each of
// it's InstanceRole .
type AdditionalLimit struct {
	_ struct{} `type:"structure"`

	// Name of Additional Limit is specific to a given InstanceType and for each
	// of it's InstanceRole etc. Attributes and their details: MaximumNumberOfDataNodesSupported
	// This attribute will be present in Master node only to specify how much data
	// nodes upto which given ESPartitionInstanceTypecan support as master node. MaximumNumberOfDataNodesWithoutMasterNode
	// This attribute will be present in Data node only to specify how much data
	// nodes of given ESPartitionInstanceType
	LimitName *string `type:"string"`

	// Value for given AdditionalLimit$LimitName .
	LimitValues []*string `type:"list"`
}

// String returns the string representation
func (s AdditionalLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdditionalLimit) GoString() string {
	return s.String()
}

// SetLimitName sets the LimitName field's value.
func (s *AdditionalLimit) SetLimitName(v string) *AdditionalLimit {
	s.LimitName = &v
	return s
}

// SetLimitValues sets the LimitValues field's value.
func (s *AdditionalLimit) SetLimitValues(v []*string) *AdditionalLimit {
	s.LimitValues = v
	return s
}

// Status of the advanced options for the specified Elasticsearch domain. Currently,
// the following advanced options are available:
//
//    * Option to allow references to indices in an HTTP request body. Must
//    be false when configuring access to individual sub-resources. By default,
//    the value is true. See Configuration Advanced Options (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options)
//    for more information.
//    * Option to specify the percentage of heap space that is allocated to
//    field data. By default, this setting is unbounded.
// For more information, see Configuring Advanced Options (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options).
type AdvancedOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the status of advanced options for the specified Elasticsearch
	// domain.
	//
	// Options is a required field
	Options map[string]*string `type:"map" required:"true"`

	// Specifies the status of OptionStatus for advanced options for the specified
	// Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s AdvancedOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdvancedOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AdvancedOptionsStatus) SetOptions(v map[string]*string) *AdvancedOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AdvancedOptionsStatus) SetStatus(v *OptionStatus) *AdvancedOptionsStatus {
	s.Status = v
	return s
}

type CreateElasticsearchDomainInput struct {
	_ struct{} `type:"structure"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string `type:"string"`

	// Option to allow references to indices in an HTTP request body. Must be false
	// when configuring access to individual sub-resources. By default, the value
	// is true. See Configuration Advanced Options (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions map[string]*string `type:"map"`

	// The name of the Elasticsearch domain that you are creating. Domain names
	// are unique across the domains owned by an account within an AWS region. Domain
	// names must start with a letter or number and can contain the following characters:
	// a-z (lowercase), 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// Options to enable, disable and specify the type and size of EBS storage volumes.
	EBSOptions *EBSOptions `type:"structure"`

	// Configuration options for an Elasticsearch domain. Specifies the instance
	// type and number of instances in the domain cluster.
	ElasticsearchClusterConfig *ElasticsearchClusterConfig `type:"structure"`

	// String of format X.Y to specify version for the Elasticsearch domain eg.
	// "1.5" or "2.3". For more information, see Creating Elasticsearch Domains
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains)
	// in the Amazon Elasticsearch Service Developer Guide.
	ElasticsearchVersion *string `type:"string"`

	// Option to set time, in UTC format, of the daily automated snapshot. Default
	// value is 0 hours.
	SnapshotOptions *SnapshotOptions `type:"structure"`
}

// String returns the string representation
func (s CreateElasticsearchDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateElasticsearchDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateElasticsearchDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateElasticsearchDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *CreateElasticsearchDomainInput) SetAccessPolicies(v string) *CreateElasticsearchDomainInput {
	s.AccessPolicies = &v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *CreateElasticsearchDomainInput) SetAdvancedOptions(v map[string]*string) *CreateElasticsearchDomainInput {
	s.AdvancedOptions = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateElasticsearchDomainInput) SetDomainName(v string) *CreateElasticsearchDomainInput {
	s.DomainName = &v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *CreateElasticsearchDomainInput) SetEBSOptions(v *EBSOptions) *CreateElasticsearchDomainInput {
	s.EBSOptions = v
	return s
}

// SetElasticsearchClusterConfig sets the ElasticsearchClusterConfig field's value.
func (s *CreateElasticsearchDomainInput) SetElasticsearchClusterConfig(v *ElasticsearchClusterConfig) *CreateElasticsearchDomainInput {
	s.ElasticsearchClusterConfig = v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *CreateElasticsearchDomainInput) SetElasticsearchVersion(v string) *CreateElasticsearchDomainInput {
	s.ElasticsearchVersion = &v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *CreateElasticsearchDomainInput) SetSnapshotOptions(v *SnapshotOptions) *CreateElasticsearchDomainInput {
	s.SnapshotOptions = v
	return s
}

// The result of a CreateElasticsearchDomain operation. Contains the status
// of the newly created Elasticsearch domain.
type CreateElasticsearchDomainOutput struct {
	_ struct{} `type:"structure"`

	// The status of the newly created Elasticsearch domain.
	DomainStatus *ElasticsearchDomainStatus `type:"structure"`
}

// String returns the string representation
func (s CreateElasticsearchDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateElasticsearchDomainOutput) GoString() string {
	return s.String()
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *CreateElasticsearchDomainOutput) SetDomainStatus(v *ElasticsearchDomainStatus) *CreateElasticsearchDomainOutput {
	s.DomainStatus = v
	return s
}

// Container for the parameters to the DeleteElasticsearchDomain operation.
// Specifies the name of the Elasticsearch domain that you want to delete.
type DeleteElasticsearchDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the Elasticsearch domain that you want to permanently delete.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteElasticsearchDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteElasticsearchDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteElasticsearchDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteElasticsearchDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteElasticsearchDomainInput) SetDomainName(v string) *DeleteElasticsearchDomainInput {
	s.DomainName = &v
	return s
}

// The result of a DeleteElasticsearchDomain request. Contains the status of
// the pending deletion, or no status if the domain and all of its resources
// have been deleted.
type DeleteElasticsearchDomainOutput struct {
	_ struct{} `type:"structure"`

	// The status of the Elasticsearch domain being deleted.
	DomainStatus *ElasticsearchDomainStatus `type:"structure"`
}

// String returns the string representation
func (s DeleteElasticsearchDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteElasticsearchDomainOutput) GoString() string {
	return s.String()
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *DeleteElasticsearchDomainOutput) SetDomainStatus(v *ElasticsearchDomainStatus) *DeleteElasticsearchDomainOutput {
	s.DomainStatus = v
	return s
}

// Container for the parameters to the DescribeElasticsearchDomainConfig operation.
// Specifies the domain name for which you want configuration information.
type DescribeElasticsearchDomainConfigInput struct {
	_ struct{} `type:"structure"`

	// The Elasticsearch domain that you want to get information about.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchDomainConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeElasticsearchDomainConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeElasticsearchDomainConfigInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeElasticsearchDomainConfigInput) SetDomainName(v string) *DescribeElasticsearchDomainConfigInput {
	s.DomainName = &v
	return s
}

// The result of a DescribeElasticsearchDomainConfig request. Contains the configuration
// information of the requested domain.
type DescribeElasticsearchDomainConfigOutput struct {
	_ struct{} `type:"structure"`

	// The configuration information of the domain requested in the DescribeElasticsearchDomainConfig
	// request.
	//
	// DomainConfig is a required field
	DomainConfig *ElasticsearchDomainConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchDomainConfigOutput) GoString() string {
	return s.String()
}

// SetDomainConfig sets the DomainConfig field's value.
func (s *DescribeElasticsearchDomainConfigOutput) SetDomainConfig(v *ElasticsearchDomainConfig) *DescribeElasticsearchDomainConfigOutput {
	s.DomainConfig = v
	return s
}

// Container for the parameters to the DescribeElasticsearchDomain operation.
type DescribeElasticsearchDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the Elasticsearch domain for which you want information.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeElasticsearchDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeElasticsearchDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeElasticsearchDomainInput) SetDomainName(v string) *DescribeElasticsearchDomainInput {
	s.DomainName = &v
	return s
}

// The result of a DescribeElasticsearchDomain request. Contains the status
// of the domain specified in the request.
type DescribeElasticsearchDomainOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the Elasticsearch domain.
	//
	// DomainStatus is a required field
	DomainStatus *ElasticsearchDomainStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchDomainOutput) GoString() string {
	return s.String()
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *DescribeElasticsearchDomainOutput) SetDomainStatus(v *ElasticsearchDomainStatus) *DescribeElasticsearchDomainOutput {
	s.DomainStatus = v
	return s
}

// Container for the parameters to the DescribeElasticsearchDomains operation.
// By default, the API returns the status of all Elasticsearch domains.
type DescribeElasticsearchDomainsInput struct {
	_ struct{} `type:"structure"`

	// The Elasticsearch domains for which you want information.
	//
	// DomainNames is a required field
	DomainNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchDomainsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeElasticsearchDomainsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeElasticsearchDomainsInput"}
	if s.DomainNames == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainNames sets the DomainNames field's value.
func (s *DescribeElasticsearchDomainsInput) SetDomainNames(v []*string) *DescribeElasticsearchDomainsInput {
	s.DomainNames = v
	return s
}

// The result of a DescribeElasticsearchDomains request. Contains the status
// of the specified domains or all domains owned by the account.
type DescribeElasticsearchDomainsOutput struct {
	_ struct{} `type:"structure"`

	// The status of the domains requested in the DescribeElasticsearchDomains request.
	//
	// DomainStatusList is a required field
	DomainStatusList []*ElasticsearchDomainStatus `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchDomainsOutput) GoString() string {
	return s.String()
}

// SetDomainStatusList sets the DomainStatusList field's value.
func (s *DescribeElasticsearchDomainsOutput) SetDomainStatusList(v []*ElasticsearchDomainStatus) *DescribeElasticsearchDomainsOutput {
	s.DomainStatusList = v
	return s
}

// Container for the parameters to DescribeElasticsearchInstanceTypeLimits operation.
type DescribeElasticsearchInstanceTypeLimitsInput struct {
	_ struct{} `type:"structure"`

	// DomainName represents the name of the Domain that we are trying to modify.
	// This should be present only if we are querying for Elasticsearch Limits for
	// existing domain.
	DomainName *string `location:"querystring" locationName:"domainName" min:"3" type:"string"`

	// Version of Elasticsearch for which Limits are needed.
	//
	// ElasticsearchVersion is a required field
	ElasticsearchVersion *string `location:"uri" locationName:"ElasticsearchVersion" type:"string" required:"true"`

	// The instance type for an Elasticsearch cluster for which Elasticsearch Limits
	// are needed.
	//
	// InstanceType is a required field
	InstanceType *string `location:"uri" locationName:"InstanceType" type:"string" required:"true" enum:"ESPartitionInstanceType"`
}

// String returns the string representation
func (s DescribeElasticsearchInstanceTypeLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchInstanceTypeLimitsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeElasticsearchInstanceTypeLimitsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeElasticsearchInstanceTypeLimitsInput"}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.ElasticsearchVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ElasticsearchVersion"))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeElasticsearchInstanceTypeLimitsInput) SetDomainName(v string) *DescribeElasticsearchInstanceTypeLimitsInput {
	s.DomainName = &v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *DescribeElasticsearchInstanceTypeLimitsInput) SetElasticsearchVersion(v string) *DescribeElasticsearchInstanceTypeLimitsInput {
	s.ElasticsearchVersion = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *DescribeElasticsearchInstanceTypeLimitsInput) SetInstanceType(v string) *DescribeElasticsearchInstanceTypeLimitsInput {
	s.InstanceType = &v
	return s
}

// Container for the parameters received from DescribeElasticsearchInstanceTypeLimits
// operation.
type DescribeElasticsearchInstanceTypeLimitsOutput struct {
	_ struct{} `type:"structure"`

	// Map of Role of the Instance and Limits that are applicable. Role performed
	// by given Instance in Elasticsearch can be one of the following: Data: If
	// the given InstanceType is used as Data node
	// Master: If the given InstanceType is used as Master node
	LimitsByRole map[string]*Limits `type:"map"`
}

// String returns the string representation
func (s DescribeElasticsearchInstanceTypeLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchInstanceTypeLimitsOutput) GoString() string {
	return s.String()
}

// SetLimitsByRole sets the LimitsByRole field's value.
func (s *DescribeElasticsearchInstanceTypeLimitsOutput) SetLimitsByRole(v map[string]*Limits) *DescribeElasticsearchInstanceTypeLimitsOutput {
	s.LimitsByRole = v
	return s
}

type DomainInfo struct {
	_ struct{} `type:"structure"`

	// Specifies the DomainName.
	DomainName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s DomainInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainInfo) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *DomainInfo) SetDomainName(v string) *DomainInfo {
	s.DomainName = &v
	return s
}

// Options to enable, disable, and specify the properties of EBS storage volumes.
// For more information, see  Configuring EBS-based Storage (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs).
type EBSOptions struct {
	_ struct{} `type:"structure"`

	// Specifies whether EBS-based storage is enabled.
	EBSEnabled *bool `type:"boolean"`

	// Specifies the IOPD for a Provisioned IOPS EBS volume (SSD).
	Iops *int64 `type:"integer"`

	// Integer to specify the size of an EBS volume.
	VolumeSize *int64 `type:"integer"`

	// Specifies the volume type for EBS-based storage.
	VolumeType *string `type:"string" enum:"VolumeType"`
}

// String returns the string representation
func (s EBSOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EBSOptions) GoString() string {
	return s.String()
}

// SetEBSEnabled sets the EBSEnabled field's value.
func (s *EBSOptions) SetEBSEnabled(v bool) *EBSOptions {
	s.EBSEnabled = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *EBSOptions) SetIops(v int64) *EBSOptions {
	s.Iops = &v
	return s
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *EBSOptions) SetVolumeSize(v int64) *EBSOptions {
	s.VolumeSize = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *EBSOptions) SetVolumeType(v string) *EBSOptions {
	s.VolumeType = &v
	return s
}

// Status of the EBS options for the specified Elasticsearch domain.
type EBSOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the EBS options for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *EBSOptions `type:"structure" required:"true"`

	// Specifies the status of the EBS options for the specified Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s EBSOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EBSOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *EBSOptionsStatus) SetOptions(v *EBSOptions) *EBSOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *EBSOptionsStatus) SetStatus(v *OptionStatus) *EBSOptionsStatus {
	s.Status = v
	return s
}

// Specifies the configuration for the domain cluster, such as the type and
// number of instances.
type ElasticsearchClusterConfig struct {
	_ struct{} `type:"structure"`

	// Total number of dedicated master nodes, active and on standby, for the cluster.
	DedicatedMasterCount *int64 `type:"integer"`

	// A boolean value to indicate whether a dedicated master node is enabled. See
	// About Dedicated Master Nodes (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-dedicatedmasternodes)
	// for more information.
	DedicatedMasterEnabled *bool `type:"boolean"`

	// The instance type for a dedicated master node.
	DedicatedMasterType *string `type:"string" enum:"ESPartitionInstanceType"`

	// The number of instances in the specified domain cluster.
	InstanceCount *int64 `type:"integer"`

	// The instance type for an Elasticsearch cluster.
	InstanceType *string `type:"string" enum:"ESPartitionInstanceType"`

	// A boolean value to indicate whether zone awareness is enabled. See About
	// Zone Awareness (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-zoneawareness)
	// for more information.
	ZoneAwarenessEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ElasticsearchClusterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchClusterConfig) GoString() string {
	return s.String()
}

// SetDedicatedMasterCount sets the DedicatedMasterCount field's value.
func (s *ElasticsearchClusterConfig) SetDedicatedMasterCount(v int64) *ElasticsearchClusterConfig {
	s.DedicatedMasterCount = &v
	return s
}

// SetDedicatedMasterEnabled sets the DedicatedMasterEnabled field's value.
func (s *ElasticsearchClusterConfig) SetDedicatedMasterEnabled(v bool) *ElasticsearchClusterConfig {
	s.DedicatedMasterEnabled = &v
	return s
}

// SetDedicatedMasterType sets the DedicatedMasterType field's value.
func (s *ElasticsearchClusterConfig) SetDedicatedMasterType(v string) *ElasticsearchClusterConfig {
	s.DedicatedMasterType = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *ElasticsearchClusterConfig) SetInstanceCount(v int64) *ElasticsearchClusterConfig {
	s.InstanceCount = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ElasticsearchClusterConfig) SetInstanceType(v string) *ElasticsearchClusterConfig {
	s.InstanceType = &v
	return s
}

// SetZoneAwarenessEnabled sets the ZoneAwarenessEnabled field's value.
func (s *ElasticsearchClusterConfig) SetZoneAwarenessEnabled(v bool) *ElasticsearchClusterConfig {
	s.ZoneAwarenessEnabled = &v
	return s
}

// Specifies the configuration status for the specified Elasticsearch domain.
type ElasticsearchClusterConfigStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the cluster configuration for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *ElasticsearchClusterConfig `type:"structure" required:"true"`

	// Specifies the status of the configuration for the specified Elasticsearch
	// domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s ElasticsearchClusterConfigStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchClusterConfigStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *ElasticsearchClusterConfigStatus) SetOptions(v *ElasticsearchClusterConfig) *ElasticsearchClusterConfigStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ElasticsearchClusterConfigStatus) SetStatus(v *OptionStatus) *ElasticsearchClusterConfigStatus {
	s.Status = v
	return s
}

// The configuration of an Elasticsearch domain.
type ElasticsearchDomainConfig struct {
	_ struct{} `type:"structure"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *AccessPoliciesStatus `type:"structure"`

	// Specifies the AdvancedOptions for the domain. See Configuring Advanced Options
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions *AdvancedOptionsStatus `type:"structure"`

	// Specifies the EBSOptions for the Elasticsearch domain.
	EBSOptions *EBSOptionsStatus `type:"structure"`

	// Specifies the ElasticsearchClusterConfig for the Elasticsearch domain.
	ElasticsearchClusterConfig *ElasticsearchClusterConfigStatus `type:"structure"`

	// String of format X.Y to specify version for the Elasticsearch domain.
	ElasticsearchVersion *ElasticsearchVersionStatus `type:"structure"`

	// Specifies the SnapshotOptions for the Elasticsearch domain.
	SnapshotOptions *SnapshotOptionsStatus `type:"structure"`
}

// String returns the string representation
func (s ElasticsearchDomainConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchDomainConfig) GoString() string {
	return s.String()
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *ElasticsearchDomainConfig) SetAccessPolicies(v *AccessPoliciesStatus) *ElasticsearchDomainConfig {
	s.AccessPolicies = v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *ElasticsearchDomainConfig) SetAdvancedOptions(v *AdvancedOptionsStatus) *ElasticsearchDomainConfig {
	s.AdvancedOptions = v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *ElasticsearchDomainConfig) SetEBSOptions(v *EBSOptionsStatus) *ElasticsearchDomainConfig {
	s.EBSOptions = v
	return s
}

// SetElasticsearchClusterConfig sets the ElasticsearchClusterConfig field's value.
func (s *ElasticsearchDomainConfig) SetElasticsearchClusterConfig(v *ElasticsearchClusterConfigStatus) *ElasticsearchDomainConfig {
	s.ElasticsearchClusterConfig = v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *ElasticsearchDomainConfig) SetElasticsearchVersion(v *ElasticsearchVersionStatus) *ElasticsearchDomainConfig {
	s.ElasticsearchVersion = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *ElasticsearchDomainConfig) SetSnapshotOptions(v *SnapshotOptionsStatus) *ElasticsearchDomainConfig {
	s.SnapshotOptions = v
	return s
}

// The current status of an Elasticsearch domain.
type ElasticsearchDomainStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) of an Elasticsearch domain. See Identifiers
	// for IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
	// in Using AWS Identity and Access Management for more information.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string `type:"string"`

	// Specifies the status of the AdvancedOptions
	AdvancedOptions map[string]*string `type:"map"`

	// The domain creation status. True if the creation of an Elasticsearch domain
	// is complete. False if domain creation is still in progress.
	Created *bool `type:"boolean"`

	// The domain deletion status. True if a delete request has been received for
	// the domain but resource cleanup is still in progress. False if the domain
	// has not been deleted. Once domain deletion is complete, the status of the
	// domain is no longer returned.
	Deleted *bool `type:"boolean"`

	// The unique identifier for the specified Elasticsearch domain.
	//
	// DomainId is a required field
	DomainId *string `min:"1" type:"string" required:"true"`

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter
	// or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// The EBSOptions for the specified domain. See Configuring EBS-based Storage
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs)
	// for more information.
	EBSOptions *EBSOptions `type:"structure"`

	// The type and number of instances in the domain cluster.
	//
	// ElasticsearchClusterConfig is a required field
	ElasticsearchClusterConfig *ElasticsearchClusterConfig `type:"structure" required:"true"`

	ElasticsearchVersion *string `type:"string"`

	// The Elasticsearch domain endpoint that you use to submit index and search
	// requests.
	Endpoint *string `type:"string"`

	// The status of the Elasticsearch domain configuration. True if Amazon Elasticsearch
	// Service is processing configuration changes. False if the configuration is
	// active.
	Processing *bool `type:"boolean"`

	// Specifies the status of the SnapshotOptions
	SnapshotOptions *SnapshotOptions `type:"structure"`
}

// String returns the string representation
func (s ElasticsearchDomainStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchDomainStatus) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *ElasticsearchDomainStatus) SetARN(v string) *ElasticsearchDomainStatus {
	s.ARN = &v
	return s
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *ElasticsearchDomainStatus) SetAccessPolicies(v string) *ElasticsearchDomainStatus {
	s.AccessPolicies = &v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *ElasticsearchDomainStatus) SetAdvancedOptions(v map[string]*string) *ElasticsearchDomainStatus {
	s.AdvancedOptions = v
	return s
}

// SetCreated sets the Created field's value.
func (s *ElasticsearchDomainStatus) SetCreated(v bool) *ElasticsearchDomainStatus {
	s.Created = &v
	return s
}

// SetDeleted sets the Deleted field's value.
func (s *ElasticsearchDomainStatus) SetDeleted(v bool) *ElasticsearchDomainStatus {
	s.Deleted = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *ElasticsearchDomainStatus) SetDomainId(v string) *ElasticsearchDomainStatus {
	s.DomainId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *ElasticsearchDomainStatus) SetDomainName(v string) *ElasticsearchDomainStatus {
	s.DomainName = &v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *ElasticsearchDomainStatus) SetEBSOptions(v *EBSOptions) *ElasticsearchDomainStatus {
	s.EBSOptions = v
	return s
}

// SetElasticsearchClusterConfig sets the ElasticsearchClusterConfig field's value.
func (s *ElasticsearchDomainStatus) SetElasticsearchClusterConfig(v *ElasticsearchClusterConfig) *ElasticsearchDomainStatus {
	s.ElasticsearchClusterConfig = v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *ElasticsearchDomainStatus) SetElasticsearchVersion(v string) *ElasticsearchDomainStatus {
	s.ElasticsearchVersion = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *ElasticsearchDomainStatus) SetEndpoint(v string) *ElasticsearchDomainStatus {
	s.Endpoint = &v
	return s
}

// SetProcessing sets the Processing field's value.
func (s *ElasticsearchDomainStatus) SetProcessing(v bool) *ElasticsearchDomainStatus {
	s.Processing = &v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *ElasticsearchDomainStatus) SetSnapshotOptions(v *SnapshotOptions) *ElasticsearchDomainStatus {
	s.SnapshotOptions = v
	return s
}

// Status of the Elasticsearch version options for the specified Elasticsearch
// domain.
type ElasticsearchVersionStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the Elasticsearch version for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *string `type:"string" required:"true"`

	// Specifies the status of the Elasticsearch version options for the specified
	// Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s ElasticsearchVersionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchVersionStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *ElasticsearchVersionStatus) SetOptions(v string) *ElasticsearchVersionStatus {
	s.Options = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ElasticsearchVersionStatus) SetStatus(v *OptionStatus) *ElasticsearchVersionStatus {
	s.Status = v
	return s
}

// InstanceCountLimits represents the limits on number of instances that be
// created in Amazon Elasticsearch for given InstanceType.
type InstanceCountLimits struct {
	_ struct{} `type:"structure"`

	// Maximum number of Instances that can be instantiated for given InstanceType.
	MaximumInstanceCount *int64 `type:"integer"`

	// Minimum number of Instances that can be instantiated for given InstanceType.
	MinimumInstanceCount *int64 `type:"integer"`
}

// String returns the string representation
func (s InstanceCountLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceCountLimits) GoString() string {
	return s.String()
}

// SetMaximumInstanceCount sets the MaximumInstanceCount field's value.
func (s *InstanceCountLimits) SetMaximumInstanceCount(v int64) *InstanceCountLimits {
	s.MaximumInstanceCount = &v
	return s
}

// SetMinimumInstanceCount sets the MinimumInstanceCount field's value.
func (s *InstanceCountLimits) SetMinimumInstanceCount(v int64) *InstanceCountLimits {
	s.MinimumInstanceCount = &v
	return s
}

// InstanceLimits represents the list of instance related attributes that are
// available for given InstanceType.
type InstanceLimits struct {
	_ struct{} `type:"structure"`

	// InstanceCountLimits represents the limits on number of instances that be
	// created in Amazon Elasticsearch for given InstanceType.
	InstanceCountLimits *InstanceCountLimits `type:"structure"`
}

// String returns the string representation
func (s InstanceLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceLimits) GoString() string {
	return s.String()
}

// SetInstanceCountLimits sets the InstanceCountLimits field's value.
func (s *InstanceLimits) SetInstanceCountLimits(v *InstanceCountLimits) *InstanceLimits {
	s.InstanceCountLimits = v
	return s
}

// Limits for given InstanceType and for each of it's role. Limits contains following StorageTypes,   InstanceLimitsand AdditionalLimits
type Limits struct {
	_ struct{} `type:"structure"`

	// List of additional limits that are specific to a given InstanceType and for
	// each of it's InstanceRole .
	AdditionalLimits []*AdditionalLimit `type:"list"`

	// InstanceLimits represents the list of instance related attributes that are
	// available for given InstanceType.
	InstanceLimits *InstanceLimits `type:"structure"`

	// StorageType represents the list of storage related types and attributes that
	// are available for given InstanceType.
	StorageTypes []*StorageType `type:"list"`
}

// String returns the string representation
func (s Limits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Limits) GoString() string {
	return s.String()
}

// SetAdditionalLimits sets the AdditionalLimits field's value.
func (s *Limits) SetAdditionalLimits(v []*AdditionalLimit) *Limits {
	s.AdditionalLimits = v
	return s
}

// SetInstanceLimits sets the InstanceLimits field's value.
func (s *Limits) SetInstanceLimits(v *InstanceLimits) *Limits {
	s.InstanceLimits = v
	return s
}

// SetStorageTypes sets the StorageTypes field's value.
func (s *Limits) SetStorageTypes(v []*StorageType) *Limits {
	s.StorageTypes = v
	return s
}

type ListDomainNamesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListDomainNamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainNamesInput) GoString() string {
	return s.String()
}

// The result of a ListDomainNames operation. Contains the names of all Elasticsearch
// domains owned by this account.
type ListDomainNamesOutput struct {
	_ struct{} `type:"structure"`

	// List of Elasticsearch domain names.
	DomainNames []*DomainInfo `type:"list"`
}

// String returns the string representation
func (s ListDomainNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainNamesOutput) GoString() string {
	return s.String()
}

// SetDomainNames sets the DomainNames field's value.
func (s *ListDomainNamesOutput) SetDomainNames(v []*DomainInfo) *ListDomainNamesOutput {
	s.DomainNames = v
	return s
}

// Container for the parameters to the ListElasticsearchInstanceTypes operation.
type ListElasticsearchInstanceTypesInput struct {
	_ struct{} `type:"structure"`

	// DomainName represents the name of the Domain that we are trying to modify.
	// This should be present only if we are querying for list of available Elasticsearch
	// instance types when modifying existing domain.
	DomainName *string `location:"querystring" locationName:"domainName" min:"3" type:"string"`

	// Version of Elasticsearch for which list of supported elasticsearch instance
	// types are needed.
	//
	// ElasticsearchVersion is a required field
	ElasticsearchVersion *string `location:"uri" locationName:"ElasticsearchVersion" type:"string" required:"true"`

	// Set this value to limit the number of results returned. Value provided must
	// be greater than 30 else it wont be honored.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// NextToken should be sent in case if earlier API call produced result containing
	// NextToken. It is used for pagination.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListElasticsearchInstanceTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListElasticsearchInstanceTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListElasticsearchInstanceTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListElasticsearchInstanceTypesInput"}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}
	if s.ElasticsearchVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ElasticsearchVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListElasticsearchInstanceTypesInput) SetDomainName(v string) *ListElasticsearchInstanceTypesInput {
	s.DomainName = &v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *ListElasticsearchInstanceTypesInput) SetElasticsearchVersion(v string) *ListElasticsearchInstanceTypesInput {
	s.ElasticsearchVersion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListElasticsearchInstanceTypesInput) SetMaxResults(v int64) *ListElasticsearchInstanceTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListElasticsearchInstanceTypesInput) SetNextToken(v string) *ListElasticsearchInstanceTypesInput {
	s.NextToken = &v
	return s
}

// Container for the parameters returned by ListElasticsearchInstanceTypes operation.
type ListElasticsearchInstanceTypesOutput struct {
	_ struct{} `type:"structure"`

	// List of instance types supported by Amazon Elasticsearch service for given
	// ElasticsearchVersion
	ElasticsearchInstanceTypes []*string `type:"list"`

	// In case if there are more results available NextToken would be present, make
	// further request to the same API with received NextToken to paginate remaining
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListElasticsearchInstanceTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListElasticsearchInstanceTypesOutput) GoString() string {
	return s.String()
}

// SetElasticsearchInstanceTypes sets the ElasticsearchInstanceTypes field's value.
func (s *ListElasticsearchInstanceTypesOutput) SetElasticsearchInstanceTypes(v []*string) *ListElasticsearchInstanceTypesOutput {
	s.ElasticsearchInstanceTypes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListElasticsearchInstanceTypesOutput) SetNextToken(v string) *ListElasticsearchInstanceTypesOutput {
	s.NextToken = &v
	return s
}

// Container for the parameters to the ListElasticsearchVersions operation.
//  Use MaxResults to control the maximum number of results to retrieve in a
// single call.
//
//  Use NextToken in response to retrieve more results. If the received response
// does not contain a NextToken, then there are no more results to retrieve.
type ListElasticsearchVersionsInput struct {
	_ struct{} `type:"structure"`

	// Set this value to limit the number of results returned. Value provided must
	// be greater than 10 else it wont be honored.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Paginated APIs accepts NextToken input to returns next page results and provides
	// a NextToken output in the response which can be used by the client to retrieve
	// more results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListElasticsearchVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListElasticsearchVersionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListElasticsearchVersionsInput) SetMaxResults(v int64) *ListElasticsearchVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListElasticsearchVersionsInput) SetNextToken(v string) *ListElasticsearchVersionsInput {
	s.NextToken = &v
	return s
}

// Container for the parameters for response received from ListElasticsearchVersions
// operation.
type ListElasticsearchVersionsOutput struct {
	_ struct{} `type:"structure"`

	// List of supported elastic search versions.
	ElasticsearchVersions []*string `type:"list"`

	// Paginated APIs accepts NextToken input to returns next page results and provides
	// a NextToken output in the response which can be used by the client to retrieve
	// more results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListElasticsearchVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListElasticsearchVersionsOutput) GoString() string {
	return s.String()
}

// SetElasticsearchVersions sets the ElasticsearchVersions field's value.
func (s *ListElasticsearchVersionsOutput) SetElasticsearchVersions(v []*string) *ListElasticsearchVersionsOutput {
	s.ElasticsearchVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListElasticsearchVersionsOutput) SetNextToken(v string) *ListElasticsearchVersionsOutput {
	s.NextToken = &v
	return s
}

// Container for the parameters to the ListTags operation. Specify the ARN for
// the Elasticsearch domain to which the tags are attached that you want to
// view are attached.
type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// Specify the ARN for the Elasticsearch domain to which the tags are attached
	// that you want to view.
	//
	// ARN is a required field
	ARN *string `location:"querystring" locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *ListTagsInput) SetARN(v string) *ListTagsInput {
	s.ARN = &v
	return s
}

// The result of a ListTags operation. Contains tags for all requested Elasticsearch
// domains.
type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// List of Tag for the requested Elasticsearch domain.
	TagList []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *ListTagsOutput) SetTagList(v []*Tag) *ListTagsOutput {
	s.TagList = v
	return s
}

// Provides the current status of the entity.
type OptionStatus struct {
	_ struct{} `type:"structure"`

	// Timestamp which tells the creation date for the entity.
	//
	// CreationDate is a required field
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// Indicates whether the Elasticsearch domain is being deleted.
	PendingDeletion *bool `type:"boolean"`

	// Provides the OptionState for the Elasticsearch domain.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"OptionState"`

	// Timestamp which tells the last updated time for the entity.
	//
	// UpdateDate is a required field
	UpdateDate *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// Specifies the latest version for the entity.
	UpdateVersion *int64 `type:"integer"`
}

// String returns the string representation
func (s OptionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionStatus) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *OptionStatus) SetCreationDate(v time.Time) *OptionStatus {
	s.CreationDate = &v
	return s
}

// SetPendingDeletion sets the PendingDeletion field's value.
func (s *OptionStatus) SetPendingDeletion(v bool) *OptionStatus {
	s.PendingDeletion = &v
	return s
}

// SetState sets the State field's value.
func (s *OptionStatus) SetState(v string) *OptionStatus {
	s.State = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *OptionStatus) SetUpdateDate(v time.Time) *OptionStatus {
	s.UpdateDate = &v
	return s
}

// SetUpdateVersion sets the UpdateVersion field's value.
func (s *OptionStatus) SetUpdateVersion(v int64) *OptionStatus {
	s.UpdateVersion = &v
	return s
}

// Container for the parameters to the RemoveTags operation. Specify the ARN
// for the Elasticsearch domain from which you want to remove the specified
// TagKey.
type RemoveTagsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN for the Elasticsearch domain from which you want to delete
	// the specified tags.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// Specifies the TagKey list which you want to remove from the Elasticsearch
	// domain.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsInput"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *RemoveTagsInput) SetARN(v string) *RemoveTagsInput {
	s.ARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsInput) SetTagKeys(v []*string) *RemoveTagsInput {
	s.TagKeys = v
	return s
}

type RemoveTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsOutput) GoString() string {
	return s.String()
}

// Specifies the time, in UTC format, when the service takes a daily automated
// snapshot of the specified Elasticsearch domain. Default value is 0 hours.
type SnapshotOptions struct {
	_ struct{} `type:"structure"`

	// Specifies the time, in UTC format, when the service takes a daily automated
	// snapshot of the specified Elasticsearch domain. Default value is 0 hours.
	AutomatedSnapshotStartHour *int64 `type:"integer"`
}

// String returns the string representation
func (s SnapshotOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotOptions) GoString() string {
	return s.String()
}

// SetAutomatedSnapshotStartHour sets the AutomatedSnapshotStartHour field's value.
func (s *SnapshotOptions) SetAutomatedSnapshotStartHour(v int64) *SnapshotOptions {
	s.AutomatedSnapshotStartHour = &v
	return s
}

// Status of a daily automated snapshot.
type SnapshotOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the daily snapshot options specified for the Elasticsearch domain.
	//
	// Options is a required field
	Options *SnapshotOptions `type:"structure" required:"true"`

	// Specifies the status of a daily automated snapshot.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s SnapshotOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *SnapshotOptionsStatus) SetOptions(v *SnapshotOptions) *SnapshotOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *SnapshotOptionsStatus) SetStatus(v *OptionStatus) *SnapshotOptionsStatus {
	s.Status = v
	return s
}

// StorageTypes represents the list of storage related types and their attributes
// that are available for given InstanceType.
type StorageType struct {
	_ struct{} `type:"structure"`

	// SubType of the given storage type. List of available sub-storage options:
	// For "instance" storageType we wont have any storageSubType, in case of "ebs"
	// storageType we will have following valid storageSubTypes standard
	// gp2
	// io1
	//  Refer VolumeType for more information regarding above EBS storage options.
	StorageSubTypeName *string `type:"string"`

	// List of limits that are applicable for given storage type.
	StorageTypeLimits []*StorageTypeLimit `type:"list"`

	// Type of the storage. List of available storage options: instance
	//  Inbuilt storage available for the given Instance ebs
	//  Elastic block storage that would be attached to the given Instance
	StorageTypeName *string `type:"string"`
}

// String returns the string representation
func (s StorageType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageType) GoString() string {
	return s.String()
}

// SetStorageSubTypeName sets the StorageSubTypeName field's value.
func (s *StorageType) SetStorageSubTypeName(v string) *StorageType {
	s.StorageSubTypeName = &v
	return s
}

// SetStorageTypeLimits sets the StorageTypeLimits field's value.
func (s *StorageType) SetStorageTypeLimits(v []*StorageTypeLimit) *StorageType {
	s.StorageTypeLimits = v
	return s
}

// SetStorageTypeName sets the StorageTypeName field's value.
func (s *StorageType) SetStorageTypeName(v string) *StorageType {
	s.StorageTypeName = &v
	return s
}

// Limits that are applicable for given storage type.
type StorageTypeLimit struct {
	_ struct{} `type:"structure"`

	// Name of storage limits that are applicable for given storage type. If StorageType
	// is ebs, following storage options are applicable MinimumVolumeSize
	//  Minimum amount of volume size that is applicable for given storage type.It
	// can be empty if it is not applicable. MaximumVolumeSize
	//  Maximum amount of volume size that is applicable for given storage type.It
	// can be empty if it is not applicable. MaximumIops
	//  Maximum amount of Iops that is applicable for given storage type.It can
	// be empty if it is not applicable. MinimumIops
	//  Minimum amount of Iops that is applicable for given storage type.It can
	// be empty if it is not applicable.
	LimitName *string `type:"string"`

	// Values for the StorageTypeLimit$LimitName .
	LimitValues []*string `type:"list"`
}

// String returns the string representation
func (s StorageTypeLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageTypeLimit) GoString() string {
	return s.String()
}

// SetLimitName sets the LimitName field's value.
func (s *StorageTypeLimit) SetLimitName(v string) *StorageTypeLimit {
	s.LimitName = &v
	return s
}

// SetLimitValues sets the LimitValues field's value.
func (s *StorageTypeLimit) SetLimitValues(v []*string) *StorageTypeLimit {
	s.LimitValues = v
	return s
}

// Specifies a key value pair for a resource tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// Specifies the TagKey, the name of the tag. Tag keys must be unique for the
	// Elasticsearch domain to which they are attached.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Specifies the TagValue, the value assigned to the corresponding tag key.
	// Tag values can be null and do not have to be unique in a tag set. For example,
	// you can have a key value pair in a tag set of project : Trinity and cost-center
	// : Trinity
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Container for the parameters to the UpdateElasticsearchDomain operation.
// Specifies the type and number of instances in the domain cluster.
type UpdateElasticsearchDomainConfigInput struct {
	_ struct{} `type:"structure"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string `type:"string"`

	// Modifies the advanced option to allow references to indices in an HTTP request
	// body. Must be false when configuring access to individual sub-resources.
	// By default, the value is true. See Configuration Advanced Options (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions map[string]*string `type:"map"`

	// The name of the Elasticsearch domain that you are updating.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// Specify the type and size of the EBS volume that you want to use.
	EBSOptions *EBSOptions `type:"structure"`

	// The type and number of instances to instantiate for the domain cluster.
	ElasticsearchClusterConfig *ElasticsearchClusterConfig `type:"structure"`

	// Option to set the time, in UTC format, for the daily automated snapshot.
	// Default value is 0 hours.
	SnapshotOptions *SnapshotOptions `type:"structure"`
}

// String returns the string representation
func (s UpdateElasticsearchDomainConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateElasticsearchDomainConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateElasticsearchDomainConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateElasticsearchDomainConfigInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetAccessPolicies(v string) *UpdateElasticsearchDomainConfigInput {
	s.AccessPolicies = &v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetAdvancedOptions(v map[string]*string) *UpdateElasticsearchDomainConfigInput {
	s.AdvancedOptions = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetDomainName(v string) *UpdateElasticsearchDomainConfigInput {
	s.DomainName = &v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetEBSOptions(v *EBSOptions) *UpdateElasticsearchDomainConfigInput {
	s.EBSOptions = v
	return s
}

// SetElasticsearchClusterConfig sets the ElasticsearchClusterConfig field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetElasticsearchClusterConfig(v *ElasticsearchClusterConfig) *UpdateElasticsearchDomainConfigInput {
	s.ElasticsearchClusterConfig = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetSnapshotOptions(v *SnapshotOptions) *UpdateElasticsearchDomainConfigInput {
	s.SnapshotOptions = v
	return s
}

// The result of an UpdateElasticsearchDomain request. Contains the status of
// the Elasticsearch domain being updated.
type UpdateElasticsearchDomainConfigOutput struct {
	_ struct{} `type:"structure"`

	// The status of the updated Elasticsearch domain.
	//
	// DomainConfig is a required field
	DomainConfig *ElasticsearchDomainConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateElasticsearchDomainConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateElasticsearchDomainConfigOutput) GoString() string {
	return s.String()
}

// SetDomainConfig sets the DomainConfig field's value.
func (s *UpdateElasticsearchDomainConfigOutput) SetDomainConfig(v *ElasticsearchDomainConfig) *UpdateElasticsearchDomainConfigOutput {
	s.DomainConfig = v
	return s
}

const (
	// ESPartitionInstanceTypeM3MediumElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM3MediumElasticsearch = "m3.medium.elasticsearch"

	// ESPartitionInstanceTypeM3LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM3LargeElasticsearch = "m3.large.elasticsearch"

	// ESPartitionInstanceTypeM3XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM3XlargeElasticsearch = "m3.xlarge.elasticsearch"

	// ESPartitionInstanceTypeM32xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM32xlargeElasticsearch = "m3.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeM4LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM4LargeElasticsearch = "m4.large.elasticsearch"

	// ESPartitionInstanceTypeM4XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM4XlargeElasticsearch = "m4.xlarge.elasticsearch"

	// ESPartitionInstanceTypeM42xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM42xlargeElasticsearch = "m4.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeM44xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM44xlargeElasticsearch = "m4.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeM410xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM410xlargeElasticsearch = "m4.10xlarge.elasticsearch"

	// ESPartitionInstanceTypeT2MicroElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeT2MicroElasticsearch = "t2.micro.elasticsearch"

	// ESPartitionInstanceTypeT2SmallElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeT2SmallElasticsearch = "t2.small.elasticsearch"

	// ESPartitionInstanceTypeT2MediumElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeT2MediumElasticsearch = "t2.medium.elasticsearch"

	// ESPartitionInstanceTypeR3LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR3LargeElasticsearch = "r3.large.elasticsearch"

	// ESPartitionInstanceTypeR3XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR3XlargeElasticsearch = "r3.xlarge.elasticsearch"

	// ESPartitionInstanceTypeR32xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR32xlargeElasticsearch = "r3.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeR34xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR34xlargeElasticsearch = "r3.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeR38xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR38xlargeElasticsearch = "r3.8xlarge.elasticsearch"

	// ESPartitionInstanceTypeI2XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI2XlargeElasticsearch = "i2.xlarge.elasticsearch"

	// ESPartitionInstanceTypeI22xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI22xlargeElasticsearch = "i2.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeD2XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeD2XlargeElasticsearch = "d2.xlarge.elasticsearch"

	// ESPartitionInstanceTypeD22xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeD22xlargeElasticsearch = "d2.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeD24xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeD24xlargeElasticsearch = "d2.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeD28xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeD28xlargeElasticsearch = "d2.8xlarge.elasticsearch"

	// ESPartitionInstanceTypeC4LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC4LargeElasticsearch = "c4.large.elasticsearch"

	// ESPartitionInstanceTypeC4XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC4XlargeElasticsearch = "c4.xlarge.elasticsearch"

	// ESPartitionInstanceTypeC42xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC42xlargeElasticsearch = "c4.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeC44xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC44xlargeElasticsearch = "c4.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeC48xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeC48xlargeElasticsearch = "c4.8xlarge.elasticsearch"

	// ESPartitionInstanceTypeR4LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR4LargeElasticsearch = "r4.large.elasticsearch"

	// ESPartitionInstanceTypeR4XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR4XlargeElasticsearch = "r4.xlarge.elasticsearch"

	// ESPartitionInstanceTypeR42xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR42xlargeElasticsearch = "r4.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeR44xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR44xlargeElasticsearch = "r4.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeR48xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR48xlargeElasticsearch = "r4.8xlarge.elasticsearch"

	// ESPartitionInstanceTypeR416xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR416xlargeElasticsearch = "r4.16xlarge.elasticsearch"
)

// The state of a requested change. One of the following:
//
//    * Processing: The request change is still in-process.
//    * Active: The request change is processed and deployed to the Elasticsearch
//    domain.
const (
	// OptionStateRequiresIndexDocuments is a OptionState enum value
	OptionStateRequiresIndexDocuments = "RequiresIndexDocuments"

	// OptionStateProcessing is a OptionState enum value
	OptionStateProcessing = "Processing"

	// OptionStateActive is a OptionState enum value
	OptionStateActive = "Active"
)

// The type of EBS volume, standard, gp2, or io1. See Configuring EBS-based
// Storage (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs)for
// more information.
const (
	// VolumeTypeStandard is a VolumeType enum value
	VolumeTypeStandard = "standard"

	// VolumeTypeGp2 is a VolumeType enum value
	VolumeTypeGp2 = "gp2"

	// VolumeTypeIo1 is a VolumeType enum value
	VolumeTypeIo1 = "io1"
)
