// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef BLIMP_NET_STREAM_SOCKET_CONNECTION_H_
#define BLIMP_NET_STREAM_SOCKET_CONNECTION_H_

#include "base/memory/scoped_ptr.h"
#include "blimp/net/blimp_connection.h"
#include "net/socket/stream_socket.h"

namespace net {
class StreamSocket;
}  // namespace net

namespace blimp {

// BlimpConnection specialization for StreamSocket-based connections.
class StreamSocketConnection : public BlimpConnection {
 public:
  explicit StreamSocketConnection(scoped_ptr<net::StreamSocket> socket);

  ~StreamSocketConnection() override;

 private:
  scoped_ptr<net::StreamSocket> socket_;
};

}  // namespace blimp

#endif  // BLIMP_NET_STREAM_SOCKET_CONNECTION_H_
