/*
 *  connctdialog.cpp
 *  ui
 *
 *  Created by Mikael Gransell on 4/13/06.
 *  Copyright 2006 __MyCompanyName__. All rights reserved.
 *
 */

#include "connectdialog.h"
#include "publichubswidget.h"
#include "favouritehubswidget.h"

ConnectDialog::ConnectDialog( const BackendConnectionPtr& backendConn,
							  QWidget* parent )
: QDialog( parent ),
  backendConnection( backendConn )
{
	// Create hub lists and add them to the tab widget that we contain
	ui.setupUi( this );
	// Remove the first tab that is automatically created by designer
	publicHubs = new PublicHubs( backendConn, ui.tabWidget );
	ui.tabWidget->addTab( publicHubs, tr("Public Hubs") );
	favouriteHubs = new FavouriteHubs( backendConn, ui.tabWidget );
	ui.tabWidget->addTab( favouriteHubs, tr("Favourite Hubs") );
	ui.tabWidget->removeTab(0);
	
	connect(publicHubs, SIGNAL(close()), this, SLOT(accept()));
	connect(favouriteHubs, SIGNAL(close()), this, SLOT(accept()));
}


void ConnectDialog::publicHubList( const QList<rpc_types::HubEntry>& hubs )
{
	publicHubs->hubList(hubs);
}

void ConnectDialog::favouriteHubList( const QList<rpc_types::FavouriteHub>& hubs )
{
	favouriteHubs->setHubs(hubs);
}

void ConnectDialog::favouriteHubAdded( const rpc_types::FavouriteHub& hub )
{
	favouriteHubs->addHub(hub);
}

void ConnectDialog::favouriteHubRemoved( const string& hub )
{
	favouriteHubs->removeHub(hub);
}

void ConnectDialog::getLists()
{
	publicHubs->on_refreshButton_pressed();
	favouriteHubs->refresh();
}

void ConnectDialog::on_quickConnectButton_pressed()
{
	QString addr = ui.addressEdit->text();	
	if( !addr.isEmpty() ) {
		backendConnection->createSession( addr );
	}
	
	done(QDialog::Accepted);
}