#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
VERSION=$2
TAR=../derby_$VERSION.orig.tar.gz
DIR=db-derby-$VERSION-src

tar -zxf $3
rm $3
GZIP=--best tar -c -z -f $TAR \
 --exclude '*.bat' \
 --exclude 'tools/java/*' \
 $DIR
rm -rf $DIR
rm -rf db-derby-$VERSION-doc-src

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir && echo "moved $TAR to $origDir"
fi
