/*
 *   This file is part of Dianara
 *   Copyright 2012-2014  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef MINORFEED_H
#define MINORFEED_H

#include <QFrame>
#include <QVBoxLayout>
#include <QLabel>
#include <QFont>
#include <QVariantList>
#include <QPushButton>

#include <QDebug>

#include "pumpcontroller.h"
#include "mischelpers.h"
#include "minorfeeditem.h"
#include "asactivity.h"


class MinorFeed : public QFrame
{
    Q_OBJECT

public:
    explicit MinorFeed(PumpController *pumpController,
                       QWidget *parent = 0);
    ~MinorFeed();
    void clearContents();
    void markAllAsRead();

signals:
    void newItemsCountChanged(int count);
    
public slots:
    void updateFeed();
    void getMoreActivities();
    void setFeedContents(QVariantList activitiesList);

    void decreaseNewItemsCount();


private:
    int feedOffset;

    QString previousNewestActivityId;
    QList<MinorFeedItem *> itemsInFeed;

    int newItemsCount;

    QVBoxLayout *mainLayout;
    QVBoxLayout *itemsLayout;
    QPushButton *getMoreButton;

    PumpController *pController;
};

#endif // MINORFEED_H
