/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __delay
#define __delay

#include "multi_curve.h"
#include "solver.h"
#include "listeners.h"

struct delay { // 1 channel delay

  int nsamples;

  float* samples;
  float* fbk;
  float* vol;
  int id;

  float msecs; // delay time

  // feedback and volume are beziers solved into fbk and vol
  std::string fbk_fname, vol_fname;
  multi_curve fbk_crv, vol_crv;
  delay_listener fbk_lis, vol_lis;
  solver fbk_sol, vol_sol;

  delay (float t, const std::string& fn, const std::string& vn);
  ~delay ();
  void zero ();
  void check_buffer ();
  void operator() (float* out, int nz, float fdr);
  void set (float t);
  void get (float& t);

};
#endif
