  std::cout << "For installation instructions and usage, see README.1st and INSTALL" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "This document is a not very well structured story about findent." << std::endl;
  std::cout << "You can skip this and use findent after reading the output of" << std::endl;
  std::cout << "  findent -h." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "findent, what?" << std::endl;
  std::cout << "==============" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   findent is an indenter for Fortran programs, fixed and free format." << std::endl;
  std::cout << "   findent can also translate fixed format to free format and vice versa." << std::endl;
  std::cout << "   Since version 3.0.0, findent can generate dependencies based on USE," << std::endl;
  std::cout << "   MODULE, SUBMODULE, INCLUDE, #include, ??include  and emit a bash script" << std::endl;
  std::cout << "   that, using findent, creates a dependency file to be used in a Makefile." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   findent will take care of:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      continuation lines" << std::endl;
  std::cout << "      multi-statement lines" << std::endl;
  std::cout << "      labelled and unlabelled do-loops" << std::endl;
  std::cout << "      IF" << std::endl;
  std::cout << "      IF ... THEN ... ENDIF" << std::endl;
  std::cout << "      where" << std::endl;
  std::cout << "      FORALL" << std::endl;
  std::cout << "      WHERE constructs" << std::endl;
  std::cout << "      FORALL constructs" << std::endl;
  std::cout << "      etc. see findentclass.cpp for details" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   findent will remove trailing spaces and tabs, and convert" << std::endl;
  std::cout << "   tabs at the start of a line into spaces. By default, statement " << std::endl;
  std::cout << "   labels are placed at the start of a line. Apart from this and" << std::endl;
  std::cout << "   indenting, findent will not alter the input, trying to" << std::endl;
  std::cout << "   preserve alignment. For example, the alignment in:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      X = 3.0*A + 4*B +  &" << std::endl;
  std::cout << "      &   2  *C +   Y" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   will remain intact." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   Optionally, findent will refactor lines that end a subroutine etc.:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      SUBROUTINE SUB" << std::endl;
  std::cout << "      ..." << std::endl;
  std::cout << "      END FUNCTION MYFUN" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   will become:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      SUBROUTINE SUB" << std::endl;
  std::cout << "      ..." << std::endl;
  std::cout << "      END SUBROUTINE SUB" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   findent is space-insensitive, for example a line like:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      REALFUN  CTIONFUN(X)" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   is recognized as the start of a function definition." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   Usage:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "       findent -h" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "findent, why?" << std::endl;
  std::cout << "=============" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   There are a number of public domain Fortran indenting tools, for example:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   - vim is shipped with an simple Fortran indenter" << std::endl;
  std::cout << "   - emacs has a Fortran indenter" << std::endl;
  std::cout << "   - floppy, only for fixed format: http://www.netlib.org/floppy/" << std::endl;
  std::cout << "   - convert.f90: converts from fixed to free format, and indents:" << std::endl;
  std::cout << "        ftp://ftp.numerical.rl.ac.uk/pub/MandR/convert.f90" << std::endl;
  std::cout << "   - f2f90: based on convert.f90: http://www.fortran.com/f2f90.tar.gz" << std::endl;
  std::cout << "   - f90ppr: an impressive piece of software that beautifies" << std::endl;
  std::cout << "        Fortran code and contains a macro processor." << std::endl;
  std::cout << "        http://fortranwiki.org/fortran/show/f90ppr" << std::endl;
  std::cout << "   - fprettify: an indenter and beautifier, written in Python." << std::endl;
  std::cout << "	IMHO not mature at the time of this writing (august 2018)." << std::endl;
  std::cout << "        https://github.com/pseewald/fprettify" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   For me, the problem with these tools is, that " << std::endl;
  std::cout << "" << std::endl;
  std::cout << "    - they are too simple (for example, do not recognize labelled " << std::endl;
  std::cout << "      do-loops) " << std::endl;
  std::cout << "    - or do too much (destroying neatly aligned pieces of code)" << std::endl;
  std::cout << "    - or are for me too complicated to adapt and extend." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   Furthermore, I want that indenting does not make irreversible changes " << std::endl;
  std::cout << "   to the source: I want always be able to get back to the version after" << std::endl;
  std::cout << "   the first indenting. (Exceptions: converting from fixed to free format;" << std::endl;
  std::cout << "   adding 'subroutine foo' after 'end')." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   Therefore I decided, having some spare time after my retirement, " << std::endl;
  std::cout << "   to try to build a Fortran indenter, based on flex and bison for" << std::endl;
  std::cout << "   readability." << std::endl;
  std::cout << "   As programming language I chose C++, because of the availability" << std::endl;
  std::cout << "   of string and deque." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   After more or less finishing the indenting part, I realized that" << std::endl;
  std::cout << "   findent should be able to play a role in determining the dependencies" << std::endl;
  std::cout << "   based on (sub)modules and various kinds of include's. So I added some" << std::endl;
  std::cout << "   lines to accomplish this. Together with an simple script " << std::endl;
  std::cout << "   dependencies are easily created. See 'man findent' under '--deps' for" << std::endl;
  std::cout << "   details. " << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   There are some tools that can generate dependencies for Fortran" << std::endl;
  std::cout << "   projects:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   - makedepf90: see https://github.com/outpaddling/makedepf90, also" << std::endl;
  std::cout << "        in debian and ubuntu. It seems that there is no support for" << std::endl;
  std::cout << "	submodules, but apart from that it seems to work well." << std::endl;
  std::cout << "   - f90_mod_deps.py: see " << std::endl;
  std::cout << "     http://lagrange.mechse.illinois.edu/f90_mod_deps/f90_mod_deps.py" << std::endl;
  std::cout << "        does not seem to work properly." << std::endl;
  std::cout << "   - fortdepend: see https://github.com/ZedThree/fort_depend.py" << std::endl;
  std::cout << "        Does not work with submodules and is picky about end statements." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   I did not investigate if these tools can cope with split MODULE and" << std::endl;
  std::cout << "   USE lines and fixed-format space-independent source code." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "findent, how?" << std::endl;
  std::cout << "=============" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   So, here it is, a Fortran indenter to my taste, based on flex," << std::endl;
  std::cout << "   bison and g++. " << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   The program performs the following major tasks:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "    - determine the input format: free or fixed" << std::endl;
  std::cout << "    - glue together continuation lines removing comments" << std::endl;
  std::cout << "    - pre-process the assembled input line, to make it better processable " << std::endl;
  std::cout << "        by flex: remove white space, substitute strings, hollerith's, " << std::endl;
  std::cout << "	statement label and operators like .EQ. by special tokens" << std::endl;
  std::cout << "    - perform a two-stage parsing:" << std::endl;
  std::cout << "      - try if the line is an assignment" << std::endl;
  std::cout << "      - if it is not an assignment, parse the line using as tokens the" << std::endl;
  std::cout << "        Fortran keywords (SUBROUTINE, DO, ...)" << std::endl;
  std::cout << "    - based on the outcome of the parse, determine the indentation" << std::endl;
  std::cout << "    - output the lines that were read in to compose the full line," << std::endl;
  std::cout << "      trying to preserve the lay-out after the original leading white" << std::endl;
  std::cout << "      space, optionally converting from fixed-form to free-form." << std::endl;
  std::cout << "      Also optionally, lines that end a subroutine, program etc.," << std::endl;
  std::cout << "      are completed (or even modified) as in:" << std::endl;
  std::cout << "        END subroutine mysub" << std::endl;
  std::cout << "      Preprocessor statements are accounted for to prevent that code like:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "        #ifdef one" << std::endl;
  std::cout << "        SUBROUTINE ONE" << std::endl;
  std::cout << "        #else" << std::endl;
  std::cout << "        SUBROUTINE TWO" << std::endl;
  std::cout << "        #endif" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "       would result in a double SUBROUTINE indentation." << std::endl;
  std::cout << "       Moreover, track is kept of do-labels, in order to correctly indent" << std::endl;
  std::cout << "       constructs like:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "           DO 10 I=1,20" << std::endl;
  std::cout << "	     DO 10 J=1,10" << std::endl;
  std::cout << "		X(I) = Y(I)+J" << std::endl;
  std::cout << "        10 CONTINUE" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "Findent, structure" << std::endl;
  std::cout << "==================" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   In version 2.8.4, a major reorganizing has been done, trying to" << std::endl;
  std::cout << "   make the source more readable and more object-oriented." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   These are the classes (all starting with a capital):" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   - Debugostream" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      This class contains code for debugging." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   - Docs" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      This class contains code (often generated) to output help-" << std::endl;
  std::cout << "      texts (includeing this text) etcetera." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   - Findentclass" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      Findentclass contains basic functions and variables that" << std::endl;
  std::cout << "      are used throughout the program, such as:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      int determine_fix_or_free()" << std::endl;
  std::cout << "         if the input format is not given (parameter -ifixed" << std::endl;
  std::cout << "	 or -ifree), this function tries to find a proof that" << std::endl;
  std::cout << "	 the program is free-format. If so, FREE is returned," << std::endl;
  std::cout << "	 else FIXED." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      Fortranline mygetline()" << std::endl;
  std::cout << "         Reads a line from STDIN." << std::endl;
  std::cout << "	 Optionally, the function builds a buffer to store the" << std::endl;
  std::cout << "	 line just read, this option is used by determine_fixed_or_free()." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      Fortranline Getline()" << std::endl;
  std::cout << "         Uses the buffer from mygetline() or mygetline() to return" << std::endl;
  std::cout << "	 a Fortranline. Optionally, maintains a buffer (wizardbuffer)" << std::endl;
  std::cout << "	 to enable a look-ahead for the wizard functions." << std::endl;
  std::cout << "	" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   - Fortranline" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      This class contains a line of fortran code, and has many" << std::endl;
  std::cout << "      frequently used functions operating on that line." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   - Fortran" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      This is an abstract class with functions and variables needed" << std::endl;
  std::cout << "      to construct a 'full_statement': a string that is composed" << std::endl;
  std::cout << "      of pure fortran code (stripped from comments, preprocessor" << std::endl;
  std::cout << "      directives, ..) and a deque of lines that constructed the" << std::endl;
  std::cout << "      full_statement, including comments and preprocessor statements. " << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      The pure virtual functions are filled in by class Fixed or" << std::endl;
  std::cout << "      class Free, depending on the format of the input." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      The indentation required is computed from full_statement" << std::endl;
  std::cout << "      and the current indentation." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      Special provisions are made for storing labelled do statements," << std::endl;
  std::cout << "      preprocessor statements and more." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   - Free" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      This class is a child of Fortran, and contains functions to" << std::endl;
  std::cout << "      indent and output the deque containing the continuation lines" << std::endl;
  std::cout << "      of a free format fortran source." << std::endl;
  std::cout << "      Also, when conversion from free to fixed format is required, " << std::endl;
  std::cout << "      there is code to store the continuation lines in a fixed" << std::endl;
  std::cout << "      (not properly indented) deque, and present this to Fixed to" << std::endl;
  std::cout << "      output this in a properly indented format." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   - Fixed" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      Basically the same as Free, but vice-versa. " << std::endl;
  std::cout << "      There is a special issue: to determine if there are continuation" << std::endl;
  std::cout << "      lines, a wizard has been created that can look ahead, see" << std::endl;
  std::cout << "      getnext() in Findentclass." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   - Flags" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      This class implements a container for the flags (-ifree, -i4 ...)" << std::endl;
  std::cout << "      and contains code to interpret the flags." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   - Globals" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      This class implements a container for a few global variables." << std::endl;
  std::cout << "      Maybe, one would be tempted to make these static, but I tried " << std::endl;
  std::cout << "      not to use static variables in order to able to run more than" << std::endl;
  std::cout << "      one Findent in one program, one reading from STDIN, the other" << std::endl;
  std::cout << "      from a file for example. " << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   - Line_prep" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      This class contains code to pre-analyze a full_statement to" << std::endl;
  std::cout << "      make the work easier for the lexer and parser." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   - Pre_analyzer" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      This class contains code to see if a line is a preprocessor" << std::endl;
  std::cout << "      statement or a findentfix: line." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   - Simpleostream" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      This class implements a simple filter to std::cout." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   The program starts in findent.cpp, and goes on in fortranrun.cpp." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   The whole thing is somewhat more hairy than I would like to see." << std::endl;
  std::cout << "   I did not succeed to make the whole thing strictly hierarchical," << std::endl;
  std::cout << "   and solved this by giving classes access to the internals of" << std::endl;
  std::cout << "   other classes using pointers. But, like in biology, in creating" << std::endl;
  std::cout << "   a program, there is no law to keep it simple." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "findent, usage?" << std::endl;
  std::cout << "===============" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   Findent reads from standard input and writes to standard output:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      findent < prog.f90 > prog1.f90" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   See also 'wfindent', later in this file." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   The command" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      findent -h" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   gives an overview of the possible flags and there effect. Most" << std::endl;
  std::cout << "   interesting are:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      -i<n>  " << std::endl;
  std::cout << "        example: -i5" << std::endl;
  std::cout << "        which determines the amount of indent to be used by every" << std::endl;
  std::cout << "        item that calls for indenting" << std::endl;
  std::cout << "      -Ia" << std::endl;
  std::cout << "        The starting indent is determined from the first line (more" << std::endl;
  std::cout << "        or less), useful when using findent within vim, for example" << std::endl;
  std::cout << "        to intent a selected region:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "           '<,'>:!findent -Ia" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      -ofree" << std::endl;
  std::cout << "        converts from fixed format to free format." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      -L<n>" << std::endl;
  std::cout << "        example: -L72" << std::endl;
  std::cout << "        limit input line length to 72 characters." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   NOTE 1: findent knows about tabbed input: for fixed-format input," << std::endl;
  std::cout << "           the following transformations are made:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "           10<tab>I=   -> 10<sp><sp><sp><sp>I=" << std::endl;
  std::cout << "           <tab>1K*J   -> <sp><sp><sp><sp><sp>1K*J" << std::endl;
  std::cout << "           <tab>X=Y    -> <sp><sp><sp><sp><sp><sp>X=Y" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "           So, a tab followed by 1-9 is transformed to a continuation line," << std::endl;
  std::cout << "           otherwise to a normal line, starting in column 7." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   NOTE 2: findent silently ignores errors in the flags" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   NOTE 3: handling of continuation lines" << std::endl;
  std::cout << "           Example:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "              a = &" << std::endl;
  std::cout << "                 (/ 3, 10, 12, 4, &" << std::endl;
  std::cout << "                    5,  9,  1, 0, &" << std::endl;
  std::cout << "                   13,  2, 25, 6 /)" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "           After running findent, with standard parameters, you get this:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "              a = &" << std::endl;
  std::cout << "                 (/ 3, 10, 12, 4, &" << std::endl;
  std::cout << "                 5,  9,  1, 0, &" << std::endl;
  std::cout << "                 13,  2, 25, 6 /)" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "          That is probably not what you really want." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "          The recommended solution is: add '&' at the start of the " << std::endl;
  std::cout << "          continuation lines:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "           a = &" << std::endl;
  std::cout << "              &   (/ 3, 10, 12, 4, &" << std::endl;
  std::cout << "              &      5,  9,  1, 0, &" << std::endl;
  std::cout << "              &     13,  2, 25, 6 /) " << std::endl;
  std::cout << "" << std::endl;
  std::cout << "          Findent will indent this as:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "           a = &" << std::endl;
  std::cout << "           &   (/ 3, 10, 12, 4, &" << std::endl;
  std::cout << "           &      5,  9,  1, 0, &" << std::endl;
  std::cout << "           &     13,  2, 25, 6 /)" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "         Not recommended solution: You can use the '-k-' flag, like:" << std::endl;
  std::cout << "           findent -k- < prog.f90 > prog1.f90" << std::endl;
  std::cout << "          " << std::endl;
  std::cout << "         Findent will in this case not touch continuation lines without " << std::endl;
  std::cout << "         a starting '&', but leave them as they are." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   NOTE 4:" << std::endl;
  std::cout << "        " << std::endl;
  std::cout << "        Findent does not check the length of an output line, so it could" << std::endl;
  std::cout << "        be that the length will be larger than 72 or 132 for fixed and " << std::endl;
  std::cout << "        free format respectively. In fact, indenting old fixed format" << std::endl;
  std::cout << "        sources will very likely result in lines longer than 72 columns." << std::endl;
  std::cout << "        If you are lucky, the compiler will generate an error message," << std::endl;
  std::cout << "        but too long lines can result in changing the semantics of a " << std::endl;
  std::cout << "	program without notice." << std::endl;
  std::cout << "        Advice: use a compiler flag that allows long lines:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "          gfortran, free format:    -ffree-line-length-none  # unlimited" << std::endl;
  std::cout << "          gfortran, fixed formtat:  -ffixed-line-length-none # unlimited" << std::endl;
  std::cout << "          ifort, free format:       # no flag needed, default is unlimited" << std::endl;
  std::cout << "          ifort, fixed format:      -132  # max line length is 132" << std::endl;
  std::cout << "          pgf90, free format:       # max line length is 264, " << std::endl;
  std::cout << "	                            # error if longer" << std::endl;
  std::cout << "          pgf90, fixed format:      -Mextend  # max line length is 132, " << std::endl;
  std::cout << "                                    #           no error if longer" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   NOTE 4.1:" << std::endl;
  std::cout << "        Here a script to check for line length:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << ">>>> snip ---------- checklength ---------------------------------------" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "#!/bin/bash" << std::endl;
  std::cout << "# checks file line lengths" << std::endl;
  std::cout << "# Usage:" << std::endl;
  std::cout << "# checklength <length> [file ...]" << std::endl;
  std::cout << "# outputs \"filename:line number:line length:line\" for lines longer than length" << std::endl;
  std::cout << "# tabs are converted to spaces using expand" << std::endl;
  std::cout << "# if no file is given, read from stdin" << std::endl;
  std::cout << "usage()" << std::endl;
  std::cout << "{" << std::endl;
  std::cout << "   echo \"Usage:\"" << std::endl;
  std::cout << "   echo \"$0 <length> [file ...]\"" << std::endl;
  std::cout << "}" << std::endl;
  std::cout << "if [ -z \"$1\" ] ; then" << std::endl;
  std::cout << "   usage" << std::endl;
  std::cout << "   exit 1" << std::endl;
  std::cout << "fi" << std::endl;
  std::cout << "l=\"$1\"" << std::endl;
  std::cout << "doit()" << std::endl;
  std::cout << "{" << std::endl;
  std::cout << "   expand | awk -v l=\"$1\" -v f=\"$2\" '{" << std::endl;
  std::cout << "   if (length($0) > l)" << std::endl;
  std::cout << "	 printf \"%s:%d:%d:%s\\n\",f,FNR,length($0),$0" << std::endl;
  std::cout << "   }'" << std::endl;
  std::cout << "}" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "if [ -z \"$2\" ] ; then" << std::endl;
  std::cout << "   doit \"$l\" \"-\"" << std::endl;
  std::cout << "   exit 0" << std::endl;
  std::cout << "fi" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "shift" << std::endl;
  std::cout << "while [ \"$1\" ] ; do" << std::endl;
  std::cout << "   cat \"$1\" | doit \"$l\" \"$1\"" << std::endl;
  std::cout << "   shift" << std::endl;
  std::cout << "done" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "<<<< snip ---------- checklength --------------------------------------" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   Example of usage:" << std::endl;
  std::cout << "       checklength 72 *.f" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   NOTE 5: handling of comment lines" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "        Findent indents comment lines, but does not touch comment lines" << std::endl;
  std::cout << "        with the '!' in column one." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   NOTE 5.1: handling of comment lines converting fixed to free format" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "        As said above, findent does not touch comments starting" << std::endl;
  std::cout << "        in column 1. Since all vintage comments start in column 1," << std::endl;
  std::cout << "        this has the effect that these comments will not be indented" << std::endl;
  std::cout << "        when converting from fixed to free format (using -ofree)." << std::endl;
  std::cout << "        If you want the comments indented, convert to free format," << std::endl;
  std::cout << "        add a space before every line and use findent again." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "        Example if the stream editor 'sed' is available:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "          findent -ofree < prog.f | sed 's/^/ /' | findent > prog.f90" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "        If 'sed' is not available (on Windows for example), you" << std::endl;
  std::cout << "        can create the program 'addspace' or, on Windows, 'addspace.exe'" << std::endl;
  std::cout << "        by compiling this program:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << ">>>> snip -------- addspace.f ------------------------------------------" << std::endl;
  std::cout << "program addspace" << std::endl;
  std::cout << "   implicit none" << std::endl;
  std::cout << "   character(1000) :: line" << std::endl;
  std::cout << "   integer         :: io" << std::endl;
  std::cout << "   do" << std::endl;
  std::cout << "      read(*,'(a)',iostat=io) line" << std::endl;
  std::cout << "      if (io .ne. 0) exit" << std::endl;
  std::cout << "      write(*,'(1x,a)') trim(line)" << std::endl;
  std::cout << "   enddo" << std::endl;
  std::cout << "end program addspace" << std::endl;
  std::cout << "<<<< snip -------- addspace.f ------------------------------------------" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "        Or, if you have a vintage Fortran-4 compiler, by compiling" << std::endl;
  std::cout << "        this program:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << ">>>> snip -------- ADDSPACE.F ------------------------------------------" << std::endl;
  std::cout << "      DIMENSION L(1000)" << std::endl;
  std::cout << "      DATA LB/1H /" << std::endl;
  std::cout << "   10 DO 15 I=1,1000" << std::endl;
  std::cout << "   15 L(I)=LB" << std::endl;
  std::cout << "      READ(5,100,END=30) L" << std::endl;
  std::cout << "      DO 20 I=1000,1,-1" << std::endl;
  std::cout << "         IF (L(I)-LB) 25,20,25" << std::endl;
  std::cout << "   20 CONTINUE" << std::endl;
  std::cout << "      WRITE(6,110)" << std::endl;
  std::cout << "      GOTO 10" << std::endl;
  std::cout << "   25 WRITE(6,110) (L(J),J=1,I)" << std::endl;
  std::cout << "      GOTO 10" << std::endl;
  std::cout << "   30 CONTINUE" << std::endl;
  std::cout << "  100 FORMAT(1000A1)" << std::endl;
  std::cout << "  110 FORMAT(1H ,1000A1)" << std::endl;
  std::cout << "      END" << std::endl;
  std::cout << "<<<< snip -------- ADDSPACE.F ------------------------------------------" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "        Use the generated program 'addspace' in stead of 'sed':" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "        findent -ofree < prog.f | addspace | findent > prog.f90" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "findent, failure, findentfix:" << std::endl;
  std::cout << "=============================" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   One thing is certain: findent contains errors. I appreciate it " << std::endl;
  std::cout << "   if you bring errors to my attention. If possible I will fix them." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   On the other hand, it is possible to fool findent, for example" << std::endl;
  std::cout << "   by using #ifdef, #else, #endif in a way that confuses findent." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   Both cases can be solved using ! findentfix: , read on:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   The next program will not be indented correctly:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << ">>>> snip -------- fixdemo.f90 -----------------------------------------" << std::endl;
  std::cout << "! compile with: gfortran -cpp fixdemo.f90" << std::endl;
  std::cout << "! or" << std::endl;
  std::cout << "!               gfortran -cpp -DLOOPJ fixdemo.f90" << std::endl;
  std::cout << "   program fixdemo" << std::endl;
  std::cout << "      implicit none" << std::endl;
  std::cout << "      integer i,j" << std::endl;
  std::cout << "      j=4" << std::endl;
  std::cout << "      do i=1,3" << std::endl;
  std::cout << "#ifdef LOOPJ" << std::endl;
  std::cout << "      do j=1,2" << std::endl;
  std::cout << "#endif" << std::endl;
  std::cout << "      print *,i*j" << std::endl;
  std::cout << "      enddo" << std::endl;
  std::cout << "#ifdef LOOPJ" << std::endl;
  std::cout << "      enddo" << std::endl;
  std::cout << "      print *,'with j-loop'" << std::endl;
  std::cout << "#else" << std::endl;
  std::cout << "      print *,'without j-loop'" << std::endl;
  std::cout << "#endif" << std::endl;
  std::cout << "      continue" << std::endl;
  std::cout << "   end program fixdemo" << std::endl;
  std::cout << "<<<< snip -------- fixdemo.f90 -----------------------------------------" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   That is because findent takes the indentation from:" << std::endl;
  std::cout << "#ifdef LOOPJ" << std::endl;
  std::cout << "      do j=1,2" << std::endl;
  std::cout << "#endif" << std::endl;
  std::cout << "   and" << std::endl;
  std::cout << "#else" << std::endl;
  std::cout << "      print *,'without j-loop'" << std::endl;
  std::cout << "#endif" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   So, findent is missing an enddo for the j-loop." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   In this case, the solution would be to insert #else just before the" << std::endl;
  std::cout << "   first #endif. " << std::endl;
  std::cout << "   If, however, in a real-world example this is not possible, or " << std::endl;
  std::cout << "   when findent really makes an error, you can use findentfix." << std::endl;
  std::cout << "   In the example above, insert directly after the last #endif:" << std::endl;
  std::cout << "     ! findentfix: enddo" << std::endl;
  std::cout << "   and findent will indent correctly. In general, the text after" << std::endl;
  std::cout << "     ! findentfix:" << std::endl;
  std::cout << "   will be used by findent as a normal source line, so the following" << std::endl;
  std::cout << "   could also be useful:" << std::endl;
  std::cout << "     ! FINDENTfix: subroutine dummy" << std::endl;
  std::cout << "     ! findentFIX: do;do;do" << std::endl;
  std::cout << "     ! FINDENTFIX: end;end" << std::endl;
  std::cout << "     ! findentfix: where ()" << std::endl;
  std::cout << "   But the following would do nothing:" << std::endl;
  std::cout << "     ! findentfix: continue" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "findent, creating a dependency file for use in an Makefile." << std::endl;
  std::cout << "===========================================================" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      findent --deps < prog.f90" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   prints the dependencies found in prog.f90, based on USE," << std::endl;
  std::cout << "   MODULE, SUBMODULE, INCLUDE, #include and ??include." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   This is used by the bash script makefdeps to create a dependency" << std::endl;
  std::cout << "   file for use in an Makefile. " << std::endl;
  std::cout << "   Creation of the makefdeps script:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      findent --makefdeps > makefdeps" << std::endl;
  std::cout << "      chmod +x makefdeps" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   The command:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      ./makefdeps *.f90" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   will output a dependency file, to be used in an Makefile." << std::endl;
  std::cout << "   The dependencies are based on .o files, for example:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      main.o: sub1.o sub2.o" << std::endl;
  std::cout << "      sub1.o: sub1.inc" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   Example Makefile and fortran sources to create 'program' from " << std::endl;
  std::cout << "   main.f90 sub1.f90 sub2.f90 sub.inc:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "" << std::endl;
  std::cout << ">>>> snip ---------- Makefile ---------------------------------------" << std::endl;
  std::cout << "SRCS = main.f90 sub1.f90 sub2.f90" << std::endl;
  std::cout << "OBJS = $(SRCS:.f90=.o)" << std::endl;
  std::cout << "%.o: %.f90" << std::endl;
  std::cout << "	gfortran -c -o $@ $<" << std::endl;
  std::cout << "program: $(OBJS)" << std::endl;
  std::cout << "	gfortran -o $@ $(OBJS)" << std::endl;
  std::cout << "include deps" << std::endl;
  std::cout << "dep deps:" << std::endl;
  std::cout << "	findent --makefdeps < /dev/null > makefdeps.sh" << std::endl;
  std::cout << "	@if [ \"`head -n 1 makefdeps.sh`\" != \"#!/bin/bash\" ] ; then \\" << std::endl;
  std::cout << "	   findent -v 1>&2; \\" << std::endl;
  std::cout << "	   echo \"Use findent version >= 3.0.0\" 1>&2 ; exit 1 ; fi" << std::endl;
  std::cout << "	chmod +x makefdeps.sh" << std::endl;
  std::cout << "	./makefdeps.sh $(SRCS) > deps" << std::endl;
  std::cout << "clean: " << std::endl;
  std::cout << "	rm -f *.o *.mod *.smod program deps" << std::endl;
  std::cout << "<<<< snip ---------- Makefile ---------------------------------------" << std::endl;
  std::cout << "" << std::endl;
  std::cout << ">>>> snip ---------- main.f90 ---------------------------------------" << std::endl;
  std::cout << "   program main" << std::endl;
  std::cout << "      use mymod1" << std::endl;
  std::cout << "      use mymod" << std::endl;
  std::cout << "      call sub1" << std::endl;
  std::cout << "      call sub" << std::endl;
  std::cout << "   end" << std::endl;
  std::cout << "<<<< snip ---------- main.f90 ---------------------------------------" << std::endl;
  std::cout << "" << std::endl;
  std::cout << ">>>> snip ---------- sub1.f90 ---------------------------------------" << std::endl;
  std::cout << "   module mymod1" << std::endl;
  std::cout << "   contains" << std::endl;
  std::cout << "      subroutine sub1" << std::endl;
  std::cout << "         print *,'this is sub1'" << std::endl;
  std::cout << "      end" << std::endl;
  std::cout << "   end" << std::endl;
  std::cout << "   module mymod" << std::endl;
  std::cout << "      interface" << std::endl;
  std::cout << "         module subroutine sub" << std::endl;
  std::cout << "         end subroutine" << std::endl;
  std::cout << "      end interface" << std::endl;
  std::cout << "   end module" << std::endl;
  std::cout << "<<<< snip ---------- sub1.f90 ---------------------------------------" << std::endl;
  std::cout << "" << std::endl;
  std::cout << ">>>> snip ---------- sub2.f90 ---------------------------------------" << std::endl;
  std::cout << "   submodule (mymod) mymod2" << std::endl;
  std::cout << "   contains" << std::endl;
  std::cout << "      module procedure sub" << std::endl;
  std::cout << "   include 'sub.inc'" << std::endl;
  std::cout << "      end procedure" << std::endl;
  std::cout << "   end submodule" << std::endl;
  std::cout << "<<<< snip ---------- sub2.f90 ---------------------------------------" << std::endl;
  std::cout << "" << std::endl;
  std::cout << ">>>> snip ---------- sub.inc ---------------------------------------" << std::endl;
  std::cout << "print *,'this is sub'" << std::endl;
  std::cout << "<<<< snip ---------- sub.inc ---------------------------------------" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   The fortran sources will be compiled in correct order, you can even" << std::endl;
  std::cout << "   use parallel make (make -j). BTW: this example uses the SUBMODULE" << std::endl;
  std::cout << "   statement: you need to have gfortran >= 6 to compile." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "findent, installation:" << std::endl;
  std::cout << "======================" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   (For a more comprehensive text, see README.1st and INSTALL)" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   Linux:" << std::endl;
  std::cout << "         $ ./configure --prefix=/usr/local" << std::endl;
  std::cout << "         $ make" << std::endl;
  std::cout << "	 On systems with sudo (Debian, Ubuntu, Mint, ...):" << std::endl;
  std::cout << "	 $ sudo make install" << std::endl;
  std::cout << "	 On systems without sudo (Redhat, Scientific Linux, ...):" << std::endl;
  std::cout << "	 $ su -c 'make install'" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   Windows:" << std::endl;
  std::cout << "      copy findent.exe C:\\WINDOWS" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "wfindent" << std::endl;
  std::cout << "========" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "  wfindent, a bash shell script, indents Fortran source in-place, " << std::endl;
  std::cout << "  performing a sanity check." << std::endl;
  std::cout << "  It accepts all flags that findent accepts." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "  Usage:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "     wfindent [ findent flags ] files" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   example" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "     wfindent -I4 *.f90" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   Installation:" << std::endl;
  std::cout << "     " << std::endl;
  std::cout << "      If you installed findent with the ./configure, make, make install " << std::endl;
  std::cout << "      method, wfindent is installed as well." << std::endl;
  std::cout << "      Otherwise:" << std::endl;
  std::cout << "      On systems with sudo (Debian, Ubuntu, Mint, ...):" << std::endl;
  std::cout << "      $ sudo install scripts/wfindent /usr/local/bin" << std::endl;
  std::cout << "      On systems without sudo (Redhat, Scientific Linux, ...):" << std::endl;
  std::cout << "      $ su -c 'make install'" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "wfindent.bat" << std::endl;
  std::cout << "============" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "  wfindent.bat is for usage in the cmd shell of Windows and has the same" << std::endl;
  std::cout << "  functionality as wfindent, described just above." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "  Installation:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "    copy wfindent.bat C:\\WINDOWS" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "jfindent or jfindent.jar" << std::endl;
  std::cout << "========================" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "  jfindent is a graphical front end for findent, and is available as" << std::endl;
  std::cout << "  a separate package on findent.sourceforge.net" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "findent and vim" << std::endl;
  std::cout << "===============" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   Findent is since version 2.7 very vim-aware. When using the vim scripts" << std::endl;
  std::cout << "   (look at findent --vim-help), findent is used as equalprg " << std::endl;
  std::cout << "   ( :help equalprg )" << std::endl;
  std::cout << "   and indentexpr ( :help indentexpr )" << std::endl;
  std::cout << "   This is possible because of the speed of findent: it indents about " << std::endl;
  std::cout << "   50000 - 100000 lines per second." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   Findent can emit configuration files, look at the output of:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      findent --vim_help" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "findent and gedit" << std::endl;
  std::cout << "=================" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   To enable findent in gedit, look at the output of:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      findent --gedit_help" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "findent and emacs" << std::endl;
  std::cout << "=================" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   To enable findent in emacs, look at the output of:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "      findent --emacs_help" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "Issues" << std::endl;
  std::cout << "======" << std::endl;
  std::cout << "   " << std::endl;
  std::cout << "   Since findent parses line-by-line, there are situations that are " << std::endl;
  std::cout << "   ambiguous:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "     F(X) = X**2        An assignment or a statement function?" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "     ELSE WHERE          Is this an ELSEWHERE as in" << std::endl;
  std::cout << "                        WHERE(X .EQ. 0)" << std::endl;
  std::cout << "                           Y=10" << std::endl;
  std::cout << "                        ELSE WHERE" << std::endl;
  std::cout << "                           Y=1" << std::endl;
  std::cout << "                        END WHERE" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "                         or is it part of an IF construct with name WHERE:" << std::endl;
  std::cout << "                        WHERE: IF (X .EQ. 0) THEN" << std::endl;
  std::cout << "                                  Y=10" << std::endl;
  std::cout << "                               ELSE WHERE" << std::endl;
  std::cout << "                                  Y=1" << std::endl;
  std::cout << "                               ENDIF WHERE" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "                         Findent chooses the first possibility." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   And there must be more ..." << std::endl;
  std::cout << "   Luckily, it seems that these ambiguities do not affect indentation." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   I tried to make findent Fortran-2008 compatible. This raised another" << std::endl;
  std::cout << "   ambiguity, because findent is space-insensitive:" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "   MODULE PROCEDURE MYPROC  Is this an module PROCEDUREMYPROC or" << std::endl;
  std::cout << "                            an moduleprocedure MYPROC?" << std::endl;
  std::cout << "                            Findent assumes the last." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "Thanks to" << std::endl;
  std::cout << "=========" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "It would not be possible for me to create findent if I could not stand" << std::endl;
  std::cout << "of the shoulders of other free software projects. In alphabetical order" << std::endl;
  std::cout << "(and probably forgetting some):" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "autoconf:      https://www.gnu.org/software/autoconf/autoconf.html" << std::endl;
  std::cout << "bash:          https://www.gnu.org/software/bash/" << std::endl;
  std::cout << "bison:         https://www.gnu.org/software/bison/" << std::endl;
  std::cout << "debian:        https://www.debian.org/" << std::endl;
  std::cout << "flex:          https://github.com/westes/flex" << std::endl;
  std::cout << "g++:           https://gcc.gnu.org/" << std::endl;
  std::cout << "gcc:           https://gcc.gnu.org/" << std::endl;
  std::cout << "gfortran:      https://gcc.gnu.org/wiki/GFortran" << std::endl;
  std::cout << "gnu software:  https://www.gnu.org/" << std::endl;
  std::cout << "kcachegrind:   https://kcachegrind.github.io/html/Home.html" << std::endl;
  std::cout << "linux:         https://en.wikipedia.org/wiki/Linux" << std::endl;
  std::cout << "make:          https://www.gnu.org/software/make/" << std::endl;
  std::cout << "ubuntu:        https://www.ubuntu.com/" << std::endl;
  std::cout << "valgrind:      http://valgrind.org/" << std::endl;
  std::cout << "vim:           https://www.vim.org/" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "The website http://www.cplusplus.com/ helped me to find a way through C++." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "I like to thank the people who gave suggestions to improve the functionality" << std::endl;
  std::cout << "of findent." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "=============================================================================" << std::endl;
  std::cout << "" << std::endl;
  std::cout << "I am happy to receive comments, error reports and suggestions for" << std::endl;
  std::cout << "improvements." << std::endl;
  std::cout << "" << std::endl;
  std::cout << "October 2018, Willem Vermin, wvermin@gmail.com" << std::endl;
  std::cout << "" << std::endl;
