/* playstation-header.c generated by valac 0.36.9, the Vala compiler
 * generated from playstation-header.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define GAMES_TYPE_PLAY_STATION_HEADER (games_play_station_header_get_type ())
#define GAMES_PLAY_STATION_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeader))
#define GAMES_PLAY_STATION_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeaderClass))
#define GAMES_IS_PLAY_STATION_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PLAY_STATION_HEADER))
#define GAMES_IS_PLAY_STATION_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PLAY_STATION_HEADER))
#define GAMES_PLAY_STATION_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeaderClass))

typedef struct _GamesPlayStationHeader GamesPlayStationHeader;
typedef struct _GamesPlayStationHeaderClass GamesPlayStationHeaderClass;
typedef struct _GamesPlayStationHeaderPrivate GamesPlayStationHeaderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GamesPlayStationHeader {
	GObject parent_instance;
	GamesPlayStationHeaderPrivate * priv;
};

struct _GamesPlayStationHeaderClass {
	GObjectClass parent_class;
};

struct _GamesPlayStationHeaderPrivate {
	gchar* _disc_id;
	GFile* file;
};

typedef enum  {
	GAMES_PLAY_STATION_ERROR_INVALID_HEADER
} GamesPlayStationError;
#define GAMES_PLAY_STATION_ERROR games_play_station_error_quark ()

static gpointer games_play_station_header_parent_class = NULL;
static GRegex* games_play_station_header_disc_id_regex;
static GRegex* games_play_station_header_disc_id_regex = NULL;
static GType games_play_station_header_type_id = 0;

GType games_play_station_header_get_type (void) G_GNUC_CONST;
#define GAMES_PLAY_STATION_HEADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeaderPrivate))
enum  {
	GAMES_PLAY_STATION_HEADER_0_PROPERTY,
	GAMES_PLAY_STATION_HEADER_DISC_ID_PROPERTY
};
#define GAMES_PLAY_STATION_HEADER_DISC_ID_SIZE ((gsize) 10)
GamesPlayStationHeader* games_play_station_header_new (GFile* file);
GamesPlayStationHeader* games_play_station_header_construct (GType object_type, GFile* file);
void games_play_station_header_check_validity (GamesPlayStationHeader* self, GError** error);
gboolean get_playstation_info (const gchar* filename, gchar* * label, gchar* * exe, GError** error);
GQuark games_play_station_error_quark (void);
static gchar* games_play_station_header_parse_id_from_exe (GamesPlayStationHeader* self, const gchar* exe, GError** error);
static gchar* games_play_station_header_parse_id_from_label (GamesPlayStationHeader* self, const gchar* label, GError** error);
static gboolean games_play_station_header_is_a_disc_id (const gchar* disc_id);
const gchar* games_play_station_header_get_disc_id (GamesPlayStationHeader* self);
static void games_play_station_header_finalize (GObject * obj);
static void _vala_games_play_station_header_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static GRegex* _tmp_regex_0 = NULL;

static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GamesPlayStationHeader* games_play_station_header_construct (GType object_type, GFile* file) {
	GamesPlayStationHeader * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GamesPlayStationHeader*) g_object_new (object_type, NULL);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	return self;
}


GamesPlayStationHeader* games_play_station_header_new (GFile* file) {
	return games_play_station_header_construct (GAMES_TYPE_PLAY_STATION_HEADER, file);
}


void games_play_station_header_check_validity (GamesPlayStationHeader* self, GError** error) {
	const gchar* _tmp0_;
	gchar* label = NULL;
	gchar* exe = NULL;
	gboolean _tmp1_ = FALSE;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_ = NULL;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	GFile* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GError* _tmp27_;
	GError* _tmp28_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_disc_id;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp2_ = self->priv->file;
	_tmp3_ = g_file_get_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp7_ = get_playstation_info (_tmp4_, &_tmp5_, &_tmp6_, &_inner_error_);
	_g_free0 (label);
	label = _tmp5_;
	_g_free0 (exe);
	exe = _tmp6_;
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp4_);
	_tmp1_ = _tmp8_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (exe);
		_g_free0 (label);
		return;
	}
	if (!_tmp1_) {
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
		_tmp9_ = self->priv->file;
		_tmp10_ = g_file_get_uri (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_error_new (GAMES_PLAY_STATION_ERROR, GAMES_PLAY_STATION_ERROR_INVALID_HEADER, _ ("Not a PlayStation disc: “%s”."), _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_inner_error_ = _tmp13_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (exe);
		_g_free0 (label);
		return;
	}
	_tmp15_ = exe;
	_tmp16_ = games_play_station_header_parse_id_from_exe (self, _tmp15_, &_inner_error_);
	_tmp14_ = _tmp16_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (exe);
		_g_free0 (label);
		return;
	}
	_tmp17_ = _tmp14_;
	_tmp14_ = NULL;
	_g_free0 (self->priv->_disc_id);
	self->priv->_disc_id = _tmp17_;
	_tmp18_ = self->priv->_disc_id;
	if (_tmp18_ != NULL) {
		_g_free0 (_tmp14_);
		_g_free0 (exe);
		_g_free0 (label);
		return;
	}
	_tmp20_ = label;
	_tmp21_ = games_play_station_header_parse_id_from_label (self, _tmp20_, &_inner_error_);
	_tmp19_ = _tmp21_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (_tmp14_);
		_g_free0 (exe);
		_g_free0 (label);
		return;
	}
	_tmp22_ = _tmp19_;
	_tmp19_ = NULL;
	_g_free0 (self->priv->_disc_id);
	self->priv->_disc_id = _tmp22_;
	_tmp23_ = self->priv->_disc_id;
	if (_tmp23_ != NULL) {
		_g_free0 (_tmp19_);
		_g_free0 (_tmp14_);
		_g_free0 (exe);
		_g_free0 (label);
		return;
	}
	_tmp24_ = self->priv->file;
	_tmp25_ = g_file_get_uri (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_error_new (GAMES_PLAY_STATION_ERROR, GAMES_PLAY_STATION_ERROR_INVALID_HEADER, _ ("Invalid PlayStation header: disc ID not found in “%s”."), _tmp26_);
	_tmp28_ = _tmp27_;
	_g_free0 (_tmp26_);
	_inner_error_ = _tmp28_;
	g_propagate_error (error, _inner_error_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp14_);
	_g_free0 (exe);
	_g_free0 (label);
	return;
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	glong _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = offset;
	result = (const gchar*) (((gchar*) self) + _tmp0_);
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* games_play_station_header_parse_id_from_exe (GamesPlayStationHeader* self, const gchar* exe, GError** error) {
	gchar* result = NULL;
	gint start = 0;
	const gchar* _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* disc_id = NULL;
	const gchar* _tmp5_;
	gint _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gboolean _tmp24_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (exe != NULL, NULL);
	_tmp0_ = exe;
	_tmp1_ = string_last_index_of (_tmp0_, "\\", 0);
	_tmp2_ = exe;
	_tmp3_ = string_last_index_of (_tmp2_, "/", 0);
	_tmp4_ = MAX (_tmp1_, _tmp3_);
	start = _tmp4_ + 1;
	_tmp5_ = exe;
	_tmp6_ = start;
	_tmp7_ = string_offset (_tmp5_, (glong) _tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	disc_id = _tmp8_;
	_tmp9_ = disc_id;
	_tmp10_ = string_strip (_tmp9_);
	_g_free0 (disc_id);
	disc_id = _tmp10_;
	_tmp11_ = disc_id;
	_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, ";", 0);
	_tmp14_ = _tmp13_;
	_tmp14__length1 = _vala_array_length (_tmp12_);
	_tmp15_ = _tmp14_[0];
	_tmp16_ = g_strdup (_tmp15_);
	_g_free0 (disc_id);
	disc_id = _tmp16_;
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp17_ = disc_id;
	_tmp18_ = string_replace (_tmp17_, "_", "-");
	_g_free0 (disc_id);
	disc_id = _tmp18_;
	_tmp19_ = disc_id;
	_tmp20_ = string_replace (_tmp19_, ".", "");
	_g_free0 (disc_id);
	disc_id = _tmp20_;
	_tmp21_ = disc_id;
	_tmp22_ = g_utf8_strup (_tmp21_, (gssize) -1);
	_g_free0 (disc_id);
	disc_id = _tmp22_;
	_tmp23_ = disc_id;
	_tmp24_ = games_play_station_header_is_a_disc_id (_tmp23_);
	if (!_tmp24_) {
		result = NULL;
		_g_free0 (disc_id);
		return result;
	}
	result = disc_id;
	return result;
}


static gchar* games_play_station_header_parse_id_from_label (GamesPlayStationHeader* self, const gchar* label, GError** error) {
	gchar* result = NULL;
	gchar* disc_id = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	_tmp0_ = label;
	_tmp1_ = string_strip (_tmp0_);
	disc_id = _tmp1_;
	_tmp2_ = disc_id;
	_tmp3_ = string_replace (_tmp2_, "_", "-");
	_g_free0 (disc_id);
	disc_id = _tmp3_;
	_tmp4_ = disc_id;
	_tmp5_ = string_strip (_tmp4_);
	_g_free0 (disc_id);
	disc_id = _tmp5_;
	_tmp6_ = disc_id;
	_tmp7_ = g_utf8_strup (_tmp6_, (gssize) -1);
	_g_free0 (disc_id);
	disc_id = _tmp7_;
	_tmp8_ = disc_id;
	_tmp9_ = games_play_station_header_is_a_disc_id (_tmp8_);
	if (!_tmp9_) {
		result = NULL;
		_g_free0 (disc_id);
		return result;
	}
	result = disc_id;
	return result;
}


static inline GRegex* _thread_safe_regex_init (GRegex** re, const gchar * pattern, GRegexMatchFlags match_options) {
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, match_options, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}


static gpointer _g_regex_ref0 (gpointer self) {
	return self ? g_regex_ref (self) : NULL;
}


static gboolean games_play_station_header_is_a_disc_id (const gchar* disc_id) {
	gboolean result = FALSE;
	GRegex* _tmp0_;
	GRegex* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (disc_id != NULL, FALSE);
	_tmp0_ = games_play_station_header_disc_id_regex;
	if (_tmp0_ == NULL) {
		GRegex* _tmp1_;
		_tmp1_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "[A-Z]{4}-\\d{5}", 0));
		_g_regex_unref0 (games_play_station_header_disc_id_regex);
		games_play_station_header_disc_id_regex = _tmp1_;
	}
	_tmp2_ = games_play_station_header_disc_id_regex;
	_tmp3_ = disc_id;
	_tmp4_ = g_regex_match (_tmp2_, _tmp3_, 0, NULL);
	result = _tmp4_;
	return result;
}


const gchar* games_play_station_header_get_disc_id (GamesPlayStationHeader* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_disc_id;
	result = _tmp0_;
	return result;
}


static void games_play_station_header_class_init (GamesPlayStationHeaderClass * klass) {
	games_play_station_header_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesPlayStationHeaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_games_play_station_header_get_property;
	G_OBJECT_CLASS (klass)->finalize = games_play_station_header_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_PLAY_STATION_HEADER_DISC_ID_PROPERTY, g_param_spec_string ("disc-id", "disc-id", "disc-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void games_play_station_header_instance_init (GamesPlayStationHeader * self) {
	self->priv = GAMES_PLAY_STATION_HEADER_GET_PRIVATE (self);
}


static void games_play_station_header_finalize (GObject * obj) {
	GamesPlayStationHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeader);
	_g_free0 (self->priv->_disc_id);
	_g_object_unref0 (self->priv->file);
	G_OBJECT_CLASS (games_play_station_header_parent_class)->finalize (obj);
}


GType games_play_station_header_get_type (void) {
	return games_play_station_header_type_id;
}


GType games_play_station_header_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesPlayStationHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_play_station_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesPlayStationHeader), 0, (GInstanceInitFunc) games_play_station_header_instance_init, NULL };
	games_play_station_header_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesPlayStationHeader", &g_define_type_info, 0);
	return games_play_station_header_type_id;
}


static void _vala_games_play_station_header_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GamesPlayStationHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeader);
	switch (property_id) {
		case GAMES_PLAY_STATION_HEADER_DISC_ID_PROPERTY:
		g_value_set_string (value, games_play_station_header_get_disc_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



