// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/customid/ent/bloblink"
	"entgo.io/ent/entc/integration/customid/ent/predicate"
)

// BlobLinkDelete is the builder for deleting a BlobLink entity.
type BlobLinkDelete struct {
	config
	hooks    []Hook
	mutation *BlobLinkMutation
}

// Where appends a list predicates to the BlobLinkDelete builder.
func (bld *BlobLinkDelete) Where(ps ...predicate.BlobLink) *BlobLinkDelete {
	bld.mutation.Where(ps...)
	return bld
}

// Exec executes the deletion query and returns how many vertices were deleted.
func (bld *BlobLinkDelete) Exec(ctx context.Context) (int, error) {
	var (
		err      error
		affected int
	)
	if len(bld.hooks) == 0 {
		affected, err = bld.sqlExec(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*BlobLinkMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			bld.mutation = mutation
			affected, err = bld.sqlExec(ctx)
			mutation.done = true
			return affected, err
		})
		for i := len(bld.hooks) - 1; i >= 0; i-- {
			if bld.hooks[i] == nil {
				return 0, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = bld.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, bld.mutation); err != nil {
			return 0, err
		}
	}
	return affected, err
}

// ExecX is like Exec, but panics if an error occurs.
func (bld *BlobLinkDelete) ExecX(ctx context.Context) int {
	n, err := bld.Exec(ctx)
	if err != nil {
		panic(err)
	}
	return n
}

func (bld *BlobLinkDelete) sqlExec(ctx context.Context) (int, error) {
	_spec := &sqlgraph.DeleteSpec{
		Node: &sqlgraph.NodeSpec{
			Table: bloblink.Table,
		},
	}
	if ps := bld.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	affected, err := sqlgraph.DeleteNodes(ctx, bld.driver, _spec)
	if err != nil && sqlgraph.IsConstraintError(err) {
		err = &ConstraintError{msg: err.Error(), wrap: err}
	}
	return affected, err
}

// BlobLinkDeleteOne is the builder for deleting a single BlobLink entity.
type BlobLinkDeleteOne struct {
	bld *BlobLinkDelete
}

// Exec executes the deletion query.
func (bldo *BlobLinkDeleteOne) Exec(ctx context.Context) error {
	n, err := bldo.bld.Exec(ctx)
	switch {
	case err != nil:
		return err
	case n == 0:
		return &NotFoundError{bloblink.Label}
	default:
		return nil
	}
}

// ExecX is like Exec, but panics if an error occurs.
func (bldo *BlobLinkDeleteOne) ExecX(ctx context.Context) {
	bldo.bld.ExecX(ctx)
}
