// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot1clickprojects

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateDeviceWithPlacement = "AssociateDeviceWithPlacement"

// AssociateDeviceWithPlacementRequest generates a "aws/request.Request" representing the
// client's request for the AssociateDeviceWithPlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateDeviceWithPlacement for more information on using the AssociateDeviceWithPlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateDeviceWithPlacementRequest method.
//	req, resp := client.AssociateDeviceWithPlacementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/AssociateDeviceWithPlacement
func (c *IoT1ClickProjects) AssociateDeviceWithPlacementRequest(input *AssociateDeviceWithPlacementInput) (req *request.Request, output *AssociateDeviceWithPlacementOutput) {
	op := &request.Operation{
		Name:       opAssociateDeviceWithPlacement,
		HTTPMethod: "PUT",
		HTTPPath:   "/projects/{projectName}/placements/{placementName}/devices/{deviceTemplateName}",
	}

	if input == nil {
		input = &AssociateDeviceWithPlacementInput{}
	}

	output = &AssociateDeviceWithPlacementOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateDeviceWithPlacement API operation for AWS IoT 1-Click Projects Service.
//
// Associates a physical device with a placement.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation AssociateDeviceWithPlacement for usage and error information.
//
// Returned Error Types:
//
//   - InternalFailureException
//
//   - InvalidRequestException
//
//   - ResourceConflictException
//
//   - ResourceNotFoundException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/AssociateDeviceWithPlacement
func (c *IoT1ClickProjects) AssociateDeviceWithPlacement(input *AssociateDeviceWithPlacementInput) (*AssociateDeviceWithPlacementOutput, error) {
	req, out := c.AssociateDeviceWithPlacementRequest(input)
	return out, req.Send()
}

// AssociateDeviceWithPlacementWithContext is the same as AssociateDeviceWithPlacement with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateDeviceWithPlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) AssociateDeviceWithPlacementWithContext(ctx aws.Context, input *AssociateDeviceWithPlacementInput, opts ...request.Option) (*AssociateDeviceWithPlacementOutput, error) {
	req, out := c.AssociateDeviceWithPlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePlacement = "CreatePlacement"

// CreatePlacementRequest generates a "aws/request.Request" representing the
// client's request for the CreatePlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePlacement for more information on using the CreatePlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePlacementRequest method.
//	req, resp := client.CreatePlacementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/CreatePlacement
func (c *IoT1ClickProjects) CreatePlacementRequest(input *CreatePlacementInput) (req *request.Request, output *CreatePlacementOutput) {
	op := &request.Operation{
		Name:       opCreatePlacement,
		HTTPMethod: "POST",
		HTTPPath:   "/projects/{projectName}/placements",
	}

	if input == nil {
		input = &CreatePlacementInput{}
	}

	output = &CreatePlacementOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreatePlacement API operation for AWS IoT 1-Click Projects Service.
//
// Creates an empty placement.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation CreatePlacement for usage and error information.
//
// Returned Error Types:
//
//   - InternalFailureException
//
//   - InvalidRequestException
//
//   - ResourceConflictException
//
//   - ResourceNotFoundException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/CreatePlacement
func (c *IoT1ClickProjects) CreatePlacement(input *CreatePlacementInput) (*CreatePlacementOutput, error) {
	req, out := c.CreatePlacementRequest(input)
	return out, req.Send()
}

// CreatePlacementWithContext is the same as CreatePlacement with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) CreatePlacementWithContext(ctx aws.Context, input *CreatePlacementInput, opts ...request.Option) (*CreatePlacementOutput, error) {
	req, out := c.CreatePlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProject = "CreateProject"

// CreateProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProject for more information on using the CreateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateProjectRequest method.
//	req, resp := client.CreateProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/CreateProject
func (c *IoT1ClickProjects) CreateProjectRequest(input *CreateProjectInput) (req *request.Request, output *CreateProjectOutput) {
	op := &request.Operation{
		Name:       opCreateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/projects",
	}

	if input == nil {
		input = &CreateProjectInput{}
	}

	output = &CreateProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateProject API operation for AWS IoT 1-Click Projects Service.
//
// Creates an empty project with a placement template. A project contains zero
// or more placements that adhere to the placement template defined in the project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation CreateProject for usage and error information.
//
// Returned Error Types:
//
//   - InternalFailureException
//
//   - InvalidRequestException
//
//   - ResourceConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/CreateProject
func (c *IoT1ClickProjects) CreateProject(input *CreateProjectInput) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	return out, req.Send()
}

// CreateProjectWithContext is the same as CreateProject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) CreateProjectWithContext(ctx aws.Context, input *CreateProjectInput, opts ...request.Option) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePlacement = "DeletePlacement"

// DeletePlacementRequest generates a "aws/request.Request" representing the
// client's request for the DeletePlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePlacement for more information on using the DeletePlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePlacementRequest method.
//	req, resp := client.DeletePlacementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DeletePlacement
func (c *IoT1ClickProjects) DeletePlacementRequest(input *DeletePlacementInput) (req *request.Request, output *DeletePlacementOutput) {
	op := &request.Operation{
		Name:       opDeletePlacement,
		HTTPMethod: "DELETE",
		HTTPPath:   "/projects/{projectName}/placements/{placementName}",
	}

	if input == nil {
		input = &DeletePlacementInput{}
	}

	output = &DeletePlacementOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePlacement API operation for AWS IoT 1-Click Projects Service.
//
// Deletes a placement. To delete a placement, it must not have any devices
// associated with it.
//
// When you delete a placement, all associated data becomes irretrievable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation DeletePlacement for usage and error information.
//
// Returned Error Types:
//
//   - InternalFailureException
//
//   - InvalidRequestException
//
//   - ResourceNotFoundException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DeletePlacement
func (c *IoT1ClickProjects) DeletePlacement(input *DeletePlacementInput) (*DeletePlacementOutput, error) {
	req, out := c.DeletePlacementRequest(input)
	return out, req.Send()
}

// DeletePlacementWithContext is the same as DeletePlacement with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) DeletePlacementWithContext(ctx aws.Context, input *DeletePlacementInput, opts ...request.Option) (*DeletePlacementOutput, error) {
	req, out := c.DeletePlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProject = "DeleteProject"

// DeleteProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProject for more information on using the DeleteProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProjectRequest method.
//	req, resp := client.DeleteProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DeleteProject
func (c *IoT1ClickProjects) DeleteProjectRequest(input *DeleteProjectInput) (req *request.Request, output *DeleteProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProject,
		HTTPMethod: "DELETE",
		HTTPPath:   "/projects/{projectName}",
	}

	if input == nil {
		input = &DeleteProjectInput{}
	}

	output = &DeleteProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProject API operation for AWS IoT 1-Click Projects Service.
//
// Deletes a project. To delete a project, it must not have any placements associated
// with it.
//
// When you delete a project, all associated data becomes irretrievable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation DeleteProject for usage and error information.
//
// Returned Error Types:
//
//   - InternalFailureException
//
//   - InvalidRequestException
//
//   - ResourceNotFoundException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DeleteProject
func (c *IoT1ClickProjects) DeleteProject(input *DeleteProjectInput) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	return out, req.Send()
}

// DeleteProjectWithContext is the same as DeleteProject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) DeleteProjectWithContext(ctx aws.Context, input *DeleteProjectInput, opts ...request.Option) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePlacement = "DescribePlacement"

// DescribePlacementRequest generates a "aws/request.Request" representing the
// client's request for the DescribePlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePlacement for more information on using the DescribePlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePlacementRequest method.
//	req, resp := client.DescribePlacementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DescribePlacement
func (c *IoT1ClickProjects) DescribePlacementRequest(input *DescribePlacementInput) (req *request.Request, output *DescribePlacementOutput) {
	op := &request.Operation{
		Name:       opDescribePlacement,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{projectName}/placements/{placementName}",
	}

	if input == nil {
		input = &DescribePlacementInput{}
	}

	output = &DescribePlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePlacement API operation for AWS IoT 1-Click Projects Service.
//
// Describes a placement in a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation DescribePlacement for usage and error information.
//
// Returned Error Types:
//
//   - InternalFailureException
//
//   - InvalidRequestException
//
//   - ResourceNotFoundException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DescribePlacement
func (c *IoT1ClickProjects) DescribePlacement(input *DescribePlacementInput) (*DescribePlacementOutput, error) {
	req, out := c.DescribePlacementRequest(input)
	return out, req.Send()
}

// DescribePlacementWithContext is the same as DescribePlacement with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) DescribePlacementWithContext(ctx aws.Context, input *DescribePlacementInput, opts ...request.Option) (*DescribePlacementOutput, error) {
	req, out := c.DescribePlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProject = "DescribeProject"

// DescribeProjectRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProject for more information on using the DescribeProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeProjectRequest method.
//	req, resp := client.DescribeProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DescribeProject
func (c *IoT1ClickProjects) DescribeProjectRequest(input *DescribeProjectInput) (req *request.Request, output *DescribeProjectOutput) {
	op := &request.Operation{
		Name:       opDescribeProject,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{projectName}",
	}

	if input == nil {
		input = &DescribeProjectInput{}
	}

	output = &DescribeProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProject API operation for AWS IoT 1-Click Projects Service.
//
// Returns an object describing a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation DescribeProject for usage and error information.
//
// Returned Error Types:
//
//   - InternalFailureException
//
//   - InvalidRequestException
//
//   - ResourceNotFoundException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DescribeProject
func (c *IoT1ClickProjects) DescribeProject(input *DescribeProjectInput) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	return out, req.Send()
}

// DescribeProjectWithContext is the same as DescribeProject with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) DescribeProjectWithContext(ctx aws.Context, input *DescribeProjectInput, opts ...request.Option) (*DescribeProjectOutput, error) {
	req, out := c.DescribeProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateDeviceFromPlacement = "DisassociateDeviceFromPlacement"

// DisassociateDeviceFromPlacementRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateDeviceFromPlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateDeviceFromPlacement for more information on using the DisassociateDeviceFromPlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateDeviceFromPlacementRequest method.
//	req, resp := client.DisassociateDeviceFromPlacementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DisassociateDeviceFromPlacement
func (c *IoT1ClickProjects) DisassociateDeviceFromPlacementRequest(input *DisassociateDeviceFromPlacementInput) (req *request.Request, output *DisassociateDeviceFromPlacementOutput) {
	op := &request.Operation{
		Name:       opDisassociateDeviceFromPlacement,
		HTTPMethod: "DELETE",
		HTTPPath:   "/projects/{projectName}/placements/{placementName}/devices/{deviceTemplateName}",
	}

	if input == nil {
		input = &DisassociateDeviceFromPlacementInput{}
	}

	output = &DisassociateDeviceFromPlacementOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateDeviceFromPlacement API operation for AWS IoT 1-Click Projects Service.
//
// Removes a physical device from a placement.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation DisassociateDeviceFromPlacement for usage and error information.
//
// Returned Error Types:
//
//   - InternalFailureException
//
//   - InvalidRequestException
//
//   - ResourceNotFoundException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DisassociateDeviceFromPlacement
func (c *IoT1ClickProjects) DisassociateDeviceFromPlacement(input *DisassociateDeviceFromPlacementInput) (*DisassociateDeviceFromPlacementOutput, error) {
	req, out := c.DisassociateDeviceFromPlacementRequest(input)
	return out, req.Send()
}

// DisassociateDeviceFromPlacementWithContext is the same as DisassociateDeviceFromPlacement with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateDeviceFromPlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) DisassociateDeviceFromPlacementWithContext(ctx aws.Context, input *DisassociateDeviceFromPlacementInput, opts ...request.Option) (*DisassociateDeviceFromPlacementOutput, error) {
	req, out := c.DisassociateDeviceFromPlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevicesInPlacement = "GetDevicesInPlacement"

// GetDevicesInPlacementRequest generates a "aws/request.Request" representing the
// client's request for the GetDevicesInPlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevicesInPlacement for more information on using the GetDevicesInPlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDevicesInPlacementRequest method.
//	req, resp := client.GetDevicesInPlacementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/GetDevicesInPlacement
func (c *IoT1ClickProjects) GetDevicesInPlacementRequest(input *GetDevicesInPlacementInput) (req *request.Request, output *GetDevicesInPlacementOutput) {
	op := &request.Operation{
		Name:       opGetDevicesInPlacement,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{projectName}/placements/{placementName}/devices",
	}

	if input == nil {
		input = &GetDevicesInPlacementInput{}
	}

	output = &GetDevicesInPlacementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDevicesInPlacement API operation for AWS IoT 1-Click Projects Service.
//
// Returns an object enumerating the devices in a placement.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation GetDevicesInPlacement for usage and error information.
//
// Returned Error Types:
//
//   - InternalFailureException
//
//   - InvalidRequestException
//
//   - ResourceNotFoundException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/GetDevicesInPlacement
func (c *IoT1ClickProjects) GetDevicesInPlacement(input *GetDevicesInPlacementInput) (*GetDevicesInPlacementOutput, error) {
	req, out := c.GetDevicesInPlacementRequest(input)
	return out, req.Send()
}

// GetDevicesInPlacementWithContext is the same as GetDevicesInPlacement with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevicesInPlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) GetDevicesInPlacementWithContext(ctx aws.Context, input *GetDevicesInPlacementInput, opts ...request.Option) (*GetDevicesInPlacementOutput, error) {
	req, out := c.GetDevicesInPlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPlacements = "ListPlacements"

// ListPlacementsRequest generates a "aws/request.Request" representing the
// client's request for the ListPlacements operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPlacements for more information on using the ListPlacements
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPlacementsRequest method.
//	req, resp := client.ListPlacementsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListPlacements
func (c *IoT1ClickProjects) ListPlacementsRequest(input *ListPlacementsInput) (req *request.Request, output *ListPlacementsOutput) {
	op := &request.Operation{
		Name:       opListPlacements,
		HTTPMethod: "GET",
		HTTPPath:   "/projects/{projectName}/placements",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPlacementsInput{}
	}

	output = &ListPlacementsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPlacements API operation for AWS IoT 1-Click Projects Service.
//
// Lists the placement(s) of a project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation ListPlacements for usage and error information.
//
// Returned Error Types:
//
//   - InternalFailureException
//
//   - InvalidRequestException
//
//   - ResourceNotFoundException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListPlacements
func (c *IoT1ClickProjects) ListPlacements(input *ListPlacementsInput) (*ListPlacementsOutput, error) {
	req, out := c.ListPlacementsRequest(input)
	return out, req.Send()
}

// ListPlacementsWithContext is the same as ListPlacements with the addition of
// the ability to pass a context and additional request options.
//
// See ListPlacements for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) ListPlacementsWithContext(ctx aws.Context, input *ListPlacementsInput, opts ...request.Option) (*ListPlacementsOutput, error) {
	req, out := c.ListPlacementsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPlacementsPages iterates over the pages of a ListPlacements operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPlacements method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPlacements operation.
//	pageNum := 0
//	err := client.ListPlacementsPages(params,
//	    func(page *iot1clickprojects.ListPlacementsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoT1ClickProjects) ListPlacementsPages(input *ListPlacementsInput, fn func(*ListPlacementsOutput, bool) bool) error {
	return c.ListPlacementsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPlacementsPagesWithContext same as ListPlacementsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) ListPlacementsPagesWithContext(ctx aws.Context, input *ListPlacementsInput, fn func(*ListPlacementsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPlacementsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPlacementsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPlacementsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProjects = "ListProjects"

// ListProjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListProjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProjects for more information on using the ListProjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProjectsRequest method.
//	req, resp := client.ListProjectsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListProjects
func (c *IoT1ClickProjects) ListProjectsRequest(input *ListProjectsInput) (req *request.Request, output *ListProjectsOutput) {
	op := &request.Operation{
		Name:       opListProjects,
		HTTPMethod: "GET",
		HTTPPath:   "/projects",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProjectsInput{}
	}

	output = &ListProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProjects API operation for AWS IoT 1-Click Projects Service.
//
// Lists the AWS IoT 1-Click project(s) associated with your AWS account and
// region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation ListProjects for usage and error information.
//
// Returned Error Types:
//
//   - InternalFailureException
//
//   - InvalidRequestException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListProjects
func (c *IoT1ClickProjects) ListProjects(input *ListProjectsInput) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	return out, req.Send()
}

// ListProjectsWithContext is the same as ListProjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) ListProjectsWithContext(ctx aws.Context, input *ListProjectsInput, opts ...request.Option) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProjectsPages iterates over the pages of a ListProjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProjects operation.
//	pageNum := 0
//	err := client.ListProjectsPages(params,
//	    func(page *iot1clickprojects.ListProjectsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoT1ClickProjects) ListProjectsPages(input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool) error {
	return c.ListProjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProjectsPagesWithContext same as ListProjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) ListProjectsPagesWithContext(ctx aws.Context, input *ListProjectsInput, fn func(*ListProjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProjectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListTagsForResource
func (c *IoT1ClickProjects) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS IoT 1-Click Projects Service.
//
// Lists the tags (metadata key/value pairs) which you have assigned to the
// resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalFailureException
//
//   - InvalidRequestException
//
//   - ResourceNotFoundException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListTagsForResource
func (c *IoT1ClickProjects) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/TagResource
func (c *IoT1ClickProjects) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS IoT 1-Click Projects Service.
//
// Creates or modifies tags for a resource. Tags are key/value pairs (metadata)
// that can be used to manage a resource. For more information, see AWS Tagging
// Strategies (https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalFailureException
//
//   - InvalidRequestException
//
//   - ResourceNotFoundException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/TagResource
func (c *IoT1ClickProjects) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UntagResource
func (c *IoT1ClickProjects) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS IoT 1-Click Projects Service.
//
// Removes one or more tags (metadata key/value pairs) from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalFailureException
//
//   - InvalidRequestException
//
//   - ResourceNotFoundException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UntagResource
func (c *IoT1ClickProjects) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePlacement = "UpdatePlacement"

// UpdatePlacementRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePlacement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePlacement for more information on using the UpdatePlacement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePlacementRequest method.
//	req, resp := client.UpdatePlacementRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UpdatePlacement
func (c *IoT1ClickProjects) UpdatePlacementRequest(input *UpdatePlacementInput) (req *request.Request, output *UpdatePlacementOutput) {
	op := &request.Operation{
		Name:       opUpdatePlacement,
		HTTPMethod: "PUT",
		HTTPPath:   "/projects/{projectName}/placements/{placementName}",
	}

	if input == nil {
		input = &UpdatePlacementInput{}
	}

	output = &UpdatePlacementOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdatePlacement API operation for AWS IoT 1-Click Projects Service.
//
// Updates a placement with the given attributes. To clear an attribute, pass
// an empty value (i.e., "").
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation UpdatePlacement for usage and error information.
//
// Returned Error Types:
//
//   - InternalFailureException
//
//   - InvalidRequestException
//
//   - ResourceNotFoundException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UpdatePlacement
func (c *IoT1ClickProjects) UpdatePlacement(input *UpdatePlacementInput) (*UpdatePlacementOutput, error) {
	req, out := c.UpdatePlacementRequest(input)
	return out, req.Send()
}

// UpdatePlacementWithContext is the same as UpdatePlacement with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePlacement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) UpdatePlacementWithContext(ctx aws.Context, input *UpdatePlacementInput, opts ...request.Option) (*UpdatePlacementOutput, error) {
	req, out := c.UpdatePlacementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProject = "UpdateProject"

// UpdateProjectRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProject for more information on using the UpdateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateProjectRequest method.
//	req, resp := client.UpdateProjectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UpdateProject
func (c *IoT1ClickProjects) UpdateProjectRequest(input *UpdateProjectInput) (req *request.Request, output *UpdateProjectOutput) {
	op := &request.Operation{
		Name:       opUpdateProject,
		HTTPMethod: "PUT",
		HTTPPath:   "/projects/{projectName}",
	}

	if input == nil {
		input = &UpdateProjectInput{}
	}

	output = &UpdateProjectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateProject API operation for AWS IoT 1-Click Projects Service.
//
// Updates a project associated with your AWS account and region. With the exception
// of device template names, you can pass just the values that need to be updated
// because the update request will change only the values that are provided.
// To clear a value, pass the empty string (i.e., "").
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT 1-Click Projects Service's
// API operation UpdateProject for usage and error information.
//
// Returned Error Types:
//
//   - InternalFailureException
//
//   - InvalidRequestException
//
//   - ResourceNotFoundException
//
//   - TooManyRequestsException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UpdateProject
func (c *IoT1ClickProjects) UpdateProject(input *UpdateProjectInput) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	return out, req.Send()
}

// UpdateProjectWithContext is the same as UpdateProject with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoT1ClickProjects) UpdateProjectWithContext(ctx aws.Context, input *UpdateProjectInput, opts ...request.Option) (*UpdateProjectOutput, error) {
	req, out := c.UpdateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AssociateDeviceWithPlacementInput struct {
	_ struct{} `type:"structure"`

	// The ID of the physical device to be associated with the given placement in
	// the project. Note that a mandatory 4 character prefix is required for all
	// deviceId values.
	//
	// DeviceId is a required field
	DeviceId *string `locationName:"deviceId" min:"1" type:"string" required:"true"`

	// The device template name to associate with the device ID.
	//
	// DeviceTemplateName is a required field
	DeviceTemplateName *string `location:"uri" locationName:"deviceTemplateName" min:"1" type:"string" required:"true"`

	// The name of the placement in which to associate the device.
	//
	// PlacementName is a required field
	PlacementName *string `location:"uri" locationName:"placementName" min:"1" type:"string" required:"true"`

	// The name of the project containing the placement in which to associate the
	// device.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDeviceWithPlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDeviceWithPlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateDeviceWithPlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateDeviceWithPlacementInput"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}
	if s.DeviceTemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceTemplateName"))
	}
	if s.DeviceTemplateName != nil && len(*s.DeviceTemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceTemplateName", 1))
	}
	if s.PlacementName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementName"))
	}
	if s.PlacementName != nil && len(*s.PlacementName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementName", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *AssociateDeviceWithPlacementInput) SetDeviceId(v string) *AssociateDeviceWithPlacementInput {
	s.DeviceId = &v
	return s
}

// SetDeviceTemplateName sets the DeviceTemplateName field's value.
func (s *AssociateDeviceWithPlacementInput) SetDeviceTemplateName(v string) *AssociateDeviceWithPlacementInput {
	s.DeviceTemplateName = &v
	return s
}

// SetPlacementName sets the PlacementName field's value.
func (s *AssociateDeviceWithPlacementInput) SetPlacementName(v string) *AssociateDeviceWithPlacementInput {
	s.PlacementName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *AssociateDeviceWithPlacementInput) SetProjectName(v string) *AssociateDeviceWithPlacementInput {
	s.ProjectName = &v
	return s
}

type AssociateDeviceWithPlacementOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDeviceWithPlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDeviceWithPlacementOutput) GoString() string {
	return s.String()
}

type CreatePlacementInput struct {
	_ struct{} `type:"structure"`

	// Optional user-defined key/value pairs providing contextual data (such as
	// location or function) for the placement.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The name of the placement to be created.
	//
	// PlacementName is a required field
	PlacementName *string `locationName:"placementName" min:"1" type:"string" required:"true"`

	// The name of the project in which to create the placement.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePlacementInput"}
	if s.PlacementName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementName"))
	}
	if s.PlacementName != nil && len(*s.PlacementName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementName", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *CreatePlacementInput) SetAttributes(v map[string]*string) *CreatePlacementInput {
	s.Attributes = v
	return s
}

// SetPlacementName sets the PlacementName field's value.
func (s *CreatePlacementInput) SetPlacementName(v string) *CreatePlacementInput {
	s.PlacementName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreatePlacementInput) SetProjectName(v string) *CreatePlacementInput {
	s.ProjectName = &v
	return s
}

type CreatePlacementOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePlacementOutput) GoString() string {
	return s.String()
}

type CreateProjectInput struct {
	_ struct{} `type:"structure"`

	// An optional description for the project.
	Description *string `locationName:"description" type:"string"`

	// The schema defining the placement to be created. A placement template defines
	// placement default attributes and device templates. You cannot add or remove
	// device templates after the project has been created. However, you can update
	// callbackOverrides for the device templates using the UpdateProject API.
	PlacementTemplate *PlacementTemplate `locationName:"placementTemplate" type:"structure"`

	// The name of the project to create.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`

	// Optional tags (metadata key/value pairs) to be associated with the project.
	// For example, { {"key1": "value1", "key2": "value2"} }. For more information,
	// see AWS Tagging Strategies (https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProjectInput"}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateProjectInput) SetDescription(v string) *CreateProjectInput {
	s.Description = &v
	return s
}

// SetPlacementTemplate sets the PlacementTemplate field's value.
func (s *CreateProjectInput) SetPlacementTemplate(v *PlacementTemplate) *CreateProjectInput {
	s.PlacementTemplate = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateProjectInput) SetProjectName(v string) *CreateProjectInput {
	s.ProjectName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProjectInput) SetTags(v map[string]*string) *CreateProjectInput {
	s.Tags = v
	return s
}

type CreateProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectOutput) GoString() string {
	return s.String()
}

type DeletePlacementInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the empty placement to delete.
	//
	// PlacementName is a required field
	PlacementName *string `location:"uri" locationName:"placementName" min:"1" type:"string" required:"true"`

	// The project containing the empty placement to delete.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePlacementInput"}
	if s.PlacementName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementName"))
	}
	if s.PlacementName != nil && len(*s.PlacementName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementName", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlacementName sets the PlacementName field's value.
func (s *DeletePlacementInput) SetPlacementName(v string) *DeletePlacementInput {
	s.PlacementName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DeletePlacementInput) SetProjectName(v string) *DeletePlacementInput {
	s.ProjectName = &v
	return s
}

type DeletePlacementOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePlacementOutput) GoString() string {
	return s.String()
}

type DeleteProjectInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the empty project to delete.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProjectInput"}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectName sets the ProjectName field's value.
func (s *DeleteProjectInput) SetProjectName(v string) *DeleteProjectInput {
	s.ProjectName = &v
	return s
}

type DeleteProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectOutput) GoString() string {
	return s.String()
}

type DescribePlacementInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the placement within a project.
	//
	// PlacementName is a required field
	PlacementName *string `location:"uri" locationName:"placementName" min:"1" type:"string" required:"true"`

	// The project containing the placement to be described.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePlacementInput"}
	if s.PlacementName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementName"))
	}
	if s.PlacementName != nil && len(*s.PlacementName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementName", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlacementName sets the PlacementName field's value.
func (s *DescribePlacementInput) SetPlacementName(v string) *DescribePlacementInput {
	s.PlacementName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribePlacementInput) SetProjectName(v string) *DescribePlacementInput {
	s.ProjectName = &v
	return s
}

type DescribePlacementOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the placement.
	//
	// Placement is a required field
	Placement *PlacementDescription `locationName:"placement" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePlacementOutput) GoString() string {
	return s.String()
}

// SetPlacement sets the Placement field's value.
func (s *DescribePlacementOutput) SetPlacement(v *PlacementDescription) *DescribePlacementOutput {
	s.Placement = v
	return s
}

type DescribeProjectInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the project to be described.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProjectInput"}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribeProjectInput) SetProjectName(v string) *DescribeProjectInput {
	s.ProjectName = &v
	return s
}

type DescribeProjectOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the project.
	//
	// Project is a required field
	Project *ProjectDescription `locationName:"project" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectOutput) GoString() string {
	return s.String()
}

// SetProject sets the Project field's value.
func (s *DescribeProjectOutput) SetProject(v *ProjectDescription) *DescribeProjectOutput {
	s.Project = v
	return s
}

// An object representing a device for a placement template (see PlacementTemplate).
type DeviceTemplate struct {
	_ struct{} `type:"structure"`

	// An optional Lambda function to invoke instead of the default Lambda function
	// provided by the placement template.
	CallbackOverrides map[string]*string `locationName:"callbackOverrides" type:"map"`

	// The device type, which currently must be "button".
	DeviceType *string `locationName:"deviceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceTemplate) GoString() string {
	return s.String()
}

// SetCallbackOverrides sets the CallbackOverrides field's value.
func (s *DeviceTemplate) SetCallbackOverrides(v map[string]*string) *DeviceTemplate {
	s.CallbackOverrides = v
	return s
}

// SetDeviceType sets the DeviceType field's value.
func (s *DeviceTemplate) SetDeviceType(v string) *DeviceTemplate {
	s.DeviceType = &v
	return s
}

type DisassociateDeviceFromPlacementInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The device ID that should be removed from the placement.
	//
	// DeviceTemplateName is a required field
	DeviceTemplateName *string `location:"uri" locationName:"deviceTemplateName" min:"1" type:"string" required:"true"`

	// The name of the placement that the device should be removed from.
	//
	// PlacementName is a required field
	PlacementName *string `location:"uri" locationName:"placementName" min:"1" type:"string" required:"true"`

	// The name of the project that contains the placement.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateDeviceFromPlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateDeviceFromPlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateDeviceFromPlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateDeviceFromPlacementInput"}
	if s.DeviceTemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceTemplateName"))
	}
	if s.DeviceTemplateName != nil && len(*s.DeviceTemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceTemplateName", 1))
	}
	if s.PlacementName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementName"))
	}
	if s.PlacementName != nil && len(*s.PlacementName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementName", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceTemplateName sets the DeviceTemplateName field's value.
func (s *DisassociateDeviceFromPlacementInput) SetDeviceTemplateName(v string) *DisassociateDeviceFromPlacementInput {
	s.DeviceTemplateName = &v
	return s
}

// SetPlacementName sets the PlacementName field's value.
func (s *DisassociateDeviceFromPlacementInput) SetPlacementName(v string) *DisassociateDeviceFromPlacementInput {
	s.PlacementName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DisassociateDeviceFromPlacementInput) SetProjectName(v string) *DisassociateDeviceFromPlacementInput {
	s.ProjectName = &v
	return s
}

type DisassociateDeviceFromPlacementOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateDeviceFromPlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateDeviceFromPlacementOutput) GoString() string {
	return s.String()
}

type GetDevicesInPlacementInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the placement to get the devices from.
	//
	// PlacementName is a required field
	PlacementName *string `location:"uri" locationName:"placementName" min:"1" type:"string" required:"true"`

	// The name of the project containing the placement.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicesInPlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicesInPlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDevicesInPlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDevicesInPlacementInput"}
	if s.PlacementName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementName"))
	}
	if s.PlacementName != nil && len(*s.PlacementName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementName", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPlacementName sets the PlacementName field's value.
func (s *GetDevicesInPlacementInput) SetPlacementName(v string) *GetDevicesInPlacementInput {
	s.PlacementName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *GetDevicesInPlacementInput) SetProjectName(v string) *GetDevicesInPlacementInput {
	s.ProjectName = &v
	return s
}

type GetDevicesInPlacementOutput struct {
	_ struct{} `type:"structure"`

	// An object containing the devices (zero or more) within the placement.
	//
	// Devices is a required field
	Devices map[string]*string `locationName:"devices" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicesInPlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDevicesInPlacementOutput) GoString() string {
	return s.String()
}

// SetDevices sets the Devices field's value.
func (s *GetDevicesInPlacementOutput) SetDevices(v map[string]*string) *GetDevicesInPlacementOutput {
	s.Devices = v
	return s
}

type InternalFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) GoString() string {
	return s.String()
}

func newErrorInternalFailureException(v protocol.ResponseMetadata) error {
	return &InternalFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalFailureException) Code() string {
	return "InternalFailureException"
}

// Message returns the exception's message.
func (s *InternalFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalFailureException) OrigErr() error {
	return nil
}

func (s *InternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListPlacementsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return per request. If not set, a default
	// value of 100 is used.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The project containing the placements to be listed.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPlacementsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPlacementsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPlacementsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPlacementsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPlacementsInput) SetMaxResults(v int64) *ListPlacementsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlacementsInput) SetNextToken(v string) *ListPlacementsInput {
	s.NextToken = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ListPlacementsInput) SetProjectName(v string) *ListPlacementsInput {
	s.ProjectName = &v
	return s
}

type ListPlacementsOutput struct {
	_ struct{} `type:"structure"`

	// The token used to retrieve the next set of results - will be effectively
	// empty if there are no further results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// An object listing the requested placements.
	//
	// Placements is a required field
	Placements []*PlacementSummary `locationName:"placements" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPlacementsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPlacementsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlacementsOutput) SetNextToken(v string) *ListPlacementsOutput {
	s.NextToken = &v
	return s
}

// SetPlacements sets the Placements field's value.
func (s *ListPlacementsOutput) SetPlacements(v []*PlacementSummary) *ListPlacementsOutput {
	s.Placements = v
	return s
}

type ListProjectsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return per request. If not set, a default
	// value of 100 is used.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProjectsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProjectsInput) SetMaxResults(v int64) *ListProjectsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsInput) SetNextToken(v string) *ListProjectsInput {
	s.NextToken = &v
	return s
}

type ListProjectsOutput struct {
	_ struct{} `type:"structure"`

	// The token used to retrieve the next set of results - will be effectively
	// empty if there are no further results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// An object containing the list of projects.
	//
	// Projects is a required field
	Projects []*ProjectSummary `locationName:"projects" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProjectsOutput) SetNextToken(v string) *ListProjectsOutput {
	s.NextToken = &v
	return s
}

// SetProjects sets the Projects field's value.
func (s *ListProjectsOutput) SetProjects(v []*ProjectSummary) *ListProjectsOutput {
	s.Projects = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource whose tags you want to list.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags (metadata key/value pairs) which you have assigned to the resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// An object describing a project's placement.
type PlacementDescription struct {
	_ struct{} `type:"structure"`

	// The user-defined attributes associated with the placement.
	//
	// Attributes is a required field
	Attributes map[string]*string `locationName:"attributes" type:"map" required:"true"`

	// The date when the placement was initially created, in UNIX epoch time format.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" required:"true"`

	// The name of the placement.
	//
	// PlacementName is a required field
	PlacementName *string `locationName:"placementName" min:"1" type:"string" required:"true"`

	// The name of the project containing the placement.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`

	// The date when the placement was last updated, in UNIX epoch time format.
	// If the placement was not updated, then createdDate and updatedDate are the
	// same.
	//
	// UpdatedDate is a required field
	UpdatedDate *time.Time `locationName:"updatedDate" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementDescription) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *PlacementDescription) SetAttributes(v map[string]*string) *PlacementDescription {
	s.Attributes = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PlacementDescription) SetCreatedDate(v time.Time) *PlacementDescription {
	s.CreatedDate = &v
	return s
}

// SetPlacementName sets the PlacementName field's value.
func (s *PlacementDescription) SetPlacementName(v string) *PlacementDescription {
	s.PlacementName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *PlacementDescription) SetProjectName(v string) *PlacementDescription {
	s.ProjectName = &v
	return s
}

// SetUpdatedDate sets the UpdatedDate field's value.
func (s *PlacementDescription) SetUpdatedDate(v time.Time) *PlacementDescription {
	s.UpdatedDate = &v
	return s
}

// An object providing summary information for a particular placement.
type PlacementSummary struct {
	_ struct{} `type:"structure"`

	// The date when the placement was originally created, in UNIX epoch time format.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" required:"true"`

	// The name of the placement being summarized.
	//
	// PlacementName is a required field
	PlacementName *string `locationName:"placementName" min:"1" type:"string" required:"true"`

	// The name of the project containing the placement.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`

	// The date when the placement was last updated, in UNIX epoch time format.
	// If the placement was not updated, then createdDate and updatedDate are the
	// same.
	//
	// UpdatedDate is a required field
	UpdatedDate *time.Time `locationName:"updatedDate" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementSummary) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PlacementSummary) SetCreatedDate(v time.Time) *PlacementSummary {
	s.CreatedDate = &v
	return s
}

// SetPlacementName sets the PlacementName field's value.
func (s *PlacementSummary) SetPlacementName(v string) *PlacementSummary {
	s.PlacementName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *PlacementSummary) SetProjectName(v string) *PlacementSummary {
	s.ProjectName = &v
	return s
}

// SetUpdatedDate sets the UpdatedDate field's value.
func (s *PlacementSummary) SetUpdatedDate(v time.Time) *PlacementSummary {
	s.UpdatedDate = &v
	return s
}

// An object defining the template for a placement.
type PlacementTemplate struct {
	_ struct{} `type:"structure"`

	// The default attributes (key/value pairs) to be applied to all placements
	// using this template.
	DefaultAttributes map[string]*string `locationName:"defaultAttributes" type:"map"`

	// An object specifying the DeviceTemplate for all placements using this (PlacementTemplate)
	// template.
	DeviceTemplates map[string]*DeviceTemplate `locationName:"deviceTemplates" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementTemplate) GoString() string {
	return s.String()
}

// SetDefaultAttributes sets the DefaultAttributes field's value.
func (s *PlacementTemplate) SetDefaultAttributes(v map[string]*string) *PlacementTemplate {
	s.DefaultAttributes = v
	return s
}

// SetDeviceTemplates sets the DeviceTemplates field's value.
func (s *PlacementTemplate) SetDeviceTemplates(v map[string]*DeviceTemplate) *PlacementTemplate {
	s.DeviceTemplates = v
	return s
}

// An object providing detailed information for a particular project associated
// with an AWS account and region.
type ProjectDescription struct {
	_ struct{} `type:"structure"`

	// The ARN of the project.
	Arn *string `locationName:"arn" type:"string"`

	// The date when the project was originally created, in UNIX epoch time format.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" required:"true"`

	// The description of the project.
	Description *string `locationName:"description" type:"string"`

	// An object describing the project's placement specifications.
	PlacementTemplate *PlacementTemplate `locationName:"placementTemplate" type:"structure"`

	// The name of the project for which to obtain information from.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`

	// The tags (metadata key/value pairs) associated with the project.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The date when the project was last updated, in UNIX epoch time format. If
	// the project was not updated, then createdDate and updatedDate are the same.
	//
	// UpdatedDate is a required field
	UpdatedDate *time.Time `locationName:"updatedDate" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectDescription) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ProjectDescription) SetArn(v string) *ProjectDescription {
	s.Arn = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *ProjectDescription) SetCreatedDate(v time.Time) *ProjectDescription {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ProjectDescription) SetDescription(v string) *ProjectDescription {
	s.Description = &v
	return s
}

// SetPlacementTemplate sets the PlacementTemplate field's value.
func (s *ProjectDescription) SetPlacementTemplate(v *PlacementTemplate) *ProjectDescription {
	s.PlacementTemplate = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ProjectDescription) SetProjectName(v string) *ProjectDescription {
	s.ProjectName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ProjectDescription) SetTags(v map[string]*string) *ProjectDescription {
	s.Tags = v
	return s
}

// SetUpdatedDate sets the UpdatedDate field's value.
func (s *ProjectDescription) SetUpdatedDate(v time.Time) *ProjectDescription {
	s.UpdatedDate = &v
	return s
}

// An object providing summary information for a particular project for an associated
// AWS account and region.
type ProjectSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the project.
	Arn *string `locationName:"arn" type:"string"`

	// The date when the project was originally created, in UNIX epoch time format.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" required:"true"`

	// The name of the project being summarized.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"1" type:"string" required:"true"`

	// The tags (metadata key/value pairs) associated with the project.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The date when the project was last updated, in UNIX epoch time format. If
	// the project was not updated, then createdDate and updatedDate are the same.
	//
	// UpdatedDate is a required field
	UpdatedDate *time.Time `locationName:"updatedDate" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ProjectSummary) SetArn(v string) *ProjectSummary {
	s.Arn = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *ProjectSummary) SetCreatedDate(v time.Time) *ProjectSummary {
	s.CreatedDate = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ProjectSummary) SetProjectName(v string) *ProjectSummary {
	s.ProjectName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ProjectSummary) SetTags(v map[string]*string) *ProjectSummary {
	s.Tags = v
	return s
}

// SetUpdatedDate sets the UpdatedDate field's value.
func (s *ProjectSummary) SetUpdatedDate(v time.Time) *ProjectSummary {
	s.UpdatedDate = &v
	return s
}

type ResourceConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceConflictException) GoString() string {
	return s.String()
}

func newErrorResourceConflictException(v protocol.ResponseMetadata) error {
	return &ResourceConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceConflictException) Code() string {
	return "ResourceConflictException"
}

// Message returns the exception's message.
func (s *ResourceConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceConflictException) OrigErr() error {
	return nil
}

func (s *ResourceConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resouce for which tag(s) should be added or modified.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The new or modifying tag(s) for the resource. See AWS IoT 1-Click Service
	// Limits (https://docs.aws.amazon.com/iot-1-click/latest/developerguide/1click-appendix.html#1click-limits)
	// for the maximum number of tags allowed per resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource whose tag you want to remove.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The keys of those tags which you want to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdatePlacementInput struct {
	_ struct{} `type:"structure"`

	// The user-defined object of attributes used to update the placement. The maximum
	// number of key/value pairs is 50.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// The name of the placement to update.
	//
	// PlacementName is a required field
	PlacementName *string `location:"uri" locationName:"placementName" min:"1" type:"string" required:"true"`

	// The name of the project containing the placement to be updated.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePlacementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePlacementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePlacementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePlacementInput"}
	if s.PlacementName == nil {
		invalidParams.Add(request.NewErrParamRequired("PlacementName"))
	}
	if s.PlacementName != nil && len(*s.PlacementName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementName", 1))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *UpdatePlacementInput) SetAttributes(v map[string]*string) *UpdatePlacementInput {
	s.Attributes = v
	return s
}

// SetPlacementName sets the PlacementName field's value.
func (s *UpdatePlacementInput) SetPlacementName(v string) *UpdatePlacementInput {
	s.PlacementName = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *UpdatePlacementInput) SetProjectName(v string) *UpdatePlacementInput {
	s.ProjectName = &v
	return s
}

type UpdatePlacementOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePlacementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePlacementOutput) GoString() string {
	return s.String()
}

type UpdateProjectInput struct {
	_ struct{} `type:"structure"`

	// An optional user-defined description for the project.
	Description *string `locationName:"description" type:"string"`

	// An object defining the project update. Once a project has been created, you
	// cannot add device template names to the project. However, for a given placementTemplate,
	// you can update the associated callbackOverrides for the device definition
	// using this API.
	PlacementTemplate *PlacementTemplate `locationName:"placementTemplate" type:"structure"`

	// The name of the project to be updated.
	//
	// ProjectName is a required field
	ProjectName *string `location:"uri" locationName:"projectName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProjectInput"}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateProjectInput) SetDescription(v string) *UpdateProjectInput {
	s.Description = &v
	return s
}

// SetPlacementTemplate sets the PlacementTemplate field's value.
func (s *UpdateProjectInput) SetPlacementTemplate(v *PlacementTemplate) *UpdateProjectInput {
	s.PlacementTemplate = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *UpdateProjectInput) SetProjectName(v string) *UpdateProjectInput {
	s.ProjectName = &v
	return s
}

type UpdateProjectOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProjectOutput) GoString() string {
	return s.String()
}
