//
//  ========================================================================
//  Copyright (c) 1995-2022 Mort Bay Consulting Pty Ltd and others.
//  ------------------------------------------------------------------------
//  All rights reserved. This program and the accompanying materials
//  are made available under the terms of the Eclipse Public License v1.0
//  and Apache License v2.0 which accompanies this distribution.
//
//      The Eclipse Public License is available at
//      http://www.eclipse.org/legal/epl-v10.html
//
//      The Apache License v2.0 is available at
//      http://www.opensource.org/licenses/apache2.0.php
//
//  You may elect to redistribute this code under either of these licenses.
//  ========================================================================
//

package org.eclipse.jetty.test.session;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SessionTest extends HttpServlet
{

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp)
        throws ServletException, IOException
    {
        String action = req.getParameter("action");
        if ("CREATE".equals(action))
        {
            HttpSession session = req.getSession(true);
            session.setAttribute("CHOCOLATE", new Chocolate());
            resp.getOutputStream().println("SESSION CREATED");
        }
        else
        {
            HttpSession session = req.getSession(false);
            Chocolate yummi = (Chocolate)session.getAttribute("CHOCOLATE");
            resp.getOutputStream().println("SESSION READ CHOCOLATE THE BEST:" + yummi.getTheBest());
        }
    }
}
