/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#include "setupsubtitle.h"
#include "ui_setupsubtitle.h"

#include <QDir>
#include <QFileDialog>
#include <QFontDatabase>
#include <QFileSystemWatcher>

#include "global/global.h"

using namespace Global;

SetupSubtitle::SetupSubtitle(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::SetupSubtitle)
{
    ui->setupUi(this);

    QFont f("Noto Sans CJK SC Regular");
    f.setPixelSize(14);
    ui->le_SubPath->setFont(f);
    ui->le_SubPath->setReadOnly(true);

    ui->pushButton->setFont(f);
    ui->cb_Family->setFont(f);
    ui->cb_OtherName->setFont(f);
    ui->cb_SameName->setFont(f);
    ui->cb_Size->setFont(f);
    ui->label_3->setFont(f);
    ui->label_4->setFont(f);
    ui->label_5->setFont(f);

    f.setPixelSize(16);
    ui->label_Titile1->setFont(f);
    ui->label_Titile2->setFont(f);


    QFontDatabase fdb;
    ui->cb_Family->addItems(fdb.families());

    // 字体选择列表 先自己设置一些
    QStringList size_list;
    size_list << "26" << "32" << "42" << "52" << "64" << "76";
    ui->cb_Size->addItems(size_list);

    initConnect();
}

SetupSubtitle::~SetupSubtitle()
{
    delete ui;
}

void SetupSubtitle::initData()
{
    ui->cb_SameName->setChecked(gsetup->loadSameNameSub.first);
    ui->cb_OtherName->setChecked(gsetup->loadAllSubInDir.first);
    // 如果默认字幕路径为空的话设置为家目录
    ui->le_SubPath->setText(gsetup->subDir.first == "" ? QDir::homePath() : gsetup->subDir.first);

    // 加载字体
    QString font_family = gsetup->subFontFamily.first;
    int font_size = gsetup->subFontSize.first;
    QFont f;
    if(font_family.length() > 0)
        ui->cb_Family->setCurrentText(font_family);
    else
        ui->cb_Family->setCurrentText(f.defaultFamily());

    if(font_size == 0)
        ui->cb_Size->setCurrentText(QString("%1").arg(f.pointSize()));
    else
        ui->cb_Size->setCurrentText(QString("%1").arg(font_size));
}

void SetupSubtitle::setBlackTheme()
{
    ui->label_Titile1->setStyleSheet(QString("color:rgb(255,255,255);"));
    ui->label_Titile2->setStyleSheet(QString("color:rgb(255,255,255);"));

    ui->cb_Family->setStyleSheet(QString("color:rgb(249,249,249);background-color:rgb(64,64,64);"));
    ui->cb_Size->setStyleSheet(QString("color:rgb(249,249,249);background-color:rgb(64,64,64);"));
    ui->le_SubPath->setStyleSheet(QString("color:rgb(249,249,249);background-color:rgb(64,64,64);"));
    ui->pushButton->setStyleSheet(QString("color:rgb(249,249,249);background-color:rgb(64,64,64);"));
    ui->cb_OtherName->setStyleSheet(QString("color:rgb(249,249,249);"));
    ui->cb_SameName->setStyleSheet(QString("color:rgb(249,249,249);"));
    ui->label_3->setStyleSheet(QString("color:rgb(249,249,249);"));
    ui->label_4->setStyleSheet(QString("color:rgb(249,249,249);"));
    ui->label_5->setStyleSheet(QString("color:rgb(249,249,249);"));
}

void SetupSubtitle::setLightTheme()
{
    ui->label_Titile1->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->label_Titile2->setStyleSheet(QString("color:rgb(38,38,38);"));

    ui->cb_Family->setStyleSheet(QString("color:rgb(38,38,38);background-color:rgb(240,240,240);"));
    ui->cb_Size->setStyleSheet(QString("color:rgb(38,38,38);background-color:rgb(240,240,240);"));
    ui->le_SubPath->setStyleSheet(QString("color:rgb(38,38,38);background-color:rgb(240,240,240);"));
    ui->pushButton->setStyleSheet(QString("color:rgb(38,38,38);background-color:rgb(240,240,240);"));
    ui->cb_OtherName->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->cb_SameName->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->label_3->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->label_4->setStyleSheet(QString("color:rgb(38,38,38);"));
    ui->label_5->setStyleSheet(QString("color:rgb(38,38,38);"));
}

void SetupSubtitle::setWidgetFont(QString family, int size)
{
    QFont f(family);
    f.setPointSize(size + 2);
    ui->label_Titile1->setFont(f);
    ui->label_Titile2->setFont(f);

    f.setPointSize(size);
    ui->label_3->setFont(f);
    ui->label_4->setFont(f);
    ui->label_5->setFont(f);
    ui->cb_Family->setFont(f);
    ui->cb_OtherName->setFont(f);
    ui->cb_SameName->setFont(f);
    ui->cb_Size->setFont(f);
    ui->pushButton->setFont(f);
    ui->le_SubPath->setFont(f);
}

void SetupSubtitle::initConnect()
{
    connect(ui->cb_SameName, &QCheckBox::clicked, [&](bool checked){
        gsetup->loadSameNameSub.second = checked;
    });
    connect(ui->cb_OtherName, &QCheckBox::clicked, [&](bool checked){
        gsetup->loadAllSubInDir.second = checked;
    });
    connect(ui->le_SubPath, &QLineEdit::textChanged, [&](QString path){
        gsetup->subDir.second = path;
    });
    connect(ui->pushButton, &QPushButton::clicked, [&](){
        // 打开文件夹
        QString url;

        {
            QFileDialog fd(parentWidget());
            fd.setModal(true);
            QList<QUrl> list = fd.sidebarUrls();
            int sidebarNum = 8;
            QString home = QDir::homePath().section("/", -1, -1);
            QString mnt = "/media/" + home + "/";
            QDir mntDir(mnt);
            mntDir.setFilter(QDir::Dirs | QDir::NoDotAndDotDot);
            QFileInfoList filist = mntDir.entryInfoList();
            QList<QUrl> mntUrlList;
            for(int i=0; i < sidebarNum && i < filist.size(); i++) {
                QFileInfo fi = filist.at(i);
                //华为990、9a0需要屏蔽最小系统挂载的目录
                if (fi.fileName() == "2691-6AB8")
                     continue;
                mntUrlList << QUrl("file://" + fi.filePath());
            }
            QFileSystemWatcher fsw(&fd);
            fsw.addPath("/media/" + home + "/");
            connect(&fsw, &QFileSystemWatcher::directoryChanged, &fd, [=, &sidebarNum, &mntUrlList, &list, &fd](const QString path){
                QDir wmnDir(path);
                wmnDir.setFilter(QDir::Dirs | QDir::NoDotAndDotDot);
                QFileInfoList wfilist = wmnDir.entryInfoList();
                mntUrlList.clear();
                for(int i=0; i < sidebarNum && i < wfilist.size(); ++i) {
                    QFileInfo fi = wfilist.at(i);
                    //华为990、9a0需要屏蔽最小系统挂载的目录
                    if (fi.fileName() == "2691-6AB8")
                         continue;
                    mntUrlList << QUrl("file://" + fi.filePath());
                }
                fd.setSidebarUrls(list + mntUrlList);
                fd.update();
            });
            connect(&fd, &QFileDialog::finished, &fd, [=, &list, &fd](){
                fd.setSidebarUrls(list);
            });
            fd.setSidebarUrls(list + mntUrlList);
            fd.setDirectory(QDir(ui->le_SubPath->text()));
            fd.setWindowTitle(tr("Video Player Choose a directory"));
            fd.setFileMode(QFileDialog::DirectoryOnly);

            gshortCut->makeAllInvalid();
            if(fd.exec() == QFileDialog::Accepted)
            {
                url = fd.selectedUrls().at(0).toString();
                if(url.startsWith("file"))
                    url.remove(0, 7);
            }
            gshortCut->makeAllValid();
        }

        if(url.length() > 0)
            ui->le_SubPath->setText(url);
    });
    connect(ui->cb_Family, &QComboBox::currentTextChanged, [&](QString family){
        gsetup->subFontFamily.second = family;
    });
    connect(ui->cb_Size, &QComboBox::currentTextChanged, [&](QString size){
        gsetup->subFontSize.second = size.toInt();
    });
}
