/* linux/drivers/media/video/exynos/jpeg/jpeg_conf.h
 *
 * Copyright (c) 2012 Samsung Electronics Co., Ltd.
 * http://www.samsung.com/
 *
 * Definition Quantization Table for Jpeg encoder/docoder
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef __JPEG_CONF_H__
#define __JPEG_CONF_H__

/* Q-table for JPEG */
/*  ITU standard Q-table */
const unsigned int ITU_Q_tbl[8][16] = {
	{
	0x06030303, 0x07070706, 0x03030303, 0x08080804, /* Y QF:97 */
	0x01010101, 0x03040303, 0x03010101, 0x04050503,
	0x03030101, 0x05060704, 0x04030301, 0x06070605,
	0x05050403, 0x06070706, 0x06060604, 0x06070707
	}, {
	0x06030303, 0x07070706, 0x04030303, 0x08080806, /* CbCr QF:97 */
	0x06030301, 0x06060606, 0x06060403, 0x06060606,
	0x06060606, 0x06060606, 0x06060606, 0x06060606,
	0x06060606, 0x06060606, 0x06060606, 0x06060606
	}, {
	0x06030303, 0x0a080706, 0x03030303, 0x090a0904, /* Y QF:92 */
	0x04030303, 0x090b0906, 0x05040303, 0x0a0d0e08,
	0x09060403, 0x0c10110d, 0x0a090604, 0x0f12110d,
	0x0e0c0a08, 0x10131310, 0x100f0f0c, 0x10101012
	}, {
	0x08040303, 0x10101010, 0x0b040303, 0x10101010, /* CbCr QF:92 */
	0x10090404, 0x10101010, 0x10100b08, 0x10101010,
	0x10101010, 0x10101010, 0x10101010, 0x10101010,
	0x10101010, 0x10101010, 0x10101010, 0x10101010
	}, {
	0x06030304, 0x0e0c0a06, 0x05030303, 0x0d0e0e06, /* Y QF:88 */
	0x06040303, 0x0d110e0a, 0x07050403, 0x0f13150c,
	0x0d090504, 0x12191a10, 0x0f0d0806, 0x161b1913,
	0x15130f0c, 0x181d1d19, 0x18171611, 0x1819181b
	}, {
	0x0b060404, 0x18181818, 0x10060504, 0x18181818, /* CbCr QF:88 */
	0x180d0606, 0x18181818, 0x1818100b, 0x18181818,
	0x18181818, 0x18181818, 0x18181818, 0x18181818,
	0x18181818, 0x18181818, 0x18181818, 0x18181818
	}, {
	0x06040406, 0x16120e09, 0x07050404, 0x14161509, /* Y QF:82 */
	0x09060505, 0x1419150e, 0x0a080605, 0x161d1f12,
	0x140d0806, 0x1c252718, 0x17140d09, 0x2129251d,
	0x1f1c1712, 0x242b2c25, 0x2322211a, 0x24252428
	}, {
	0x11090606, 0x24242424, 0x18090806, 0x24242424, /* CbCr QF:82 */
	0x24140909, 0x24242424, 0x24241811, 0x24242424,
	0x24242424, 0x24242424, 0x24242424, 0x24242424,
	0x24242424, 0x24242424, 0x24242424, 0x24242424
	},

};

/* ITU Luminace Huffman Table */
static unsigned int ITU_H_tbl_len_DC_luminance[4] = {
	0x01050100, 0x01010101, 0x00000001, 0x00000000
};
static unsigned int ITU_H_tbl_val_DC_luminance[3] = {
	0x03020100, 0x07060504, 0x0b0a0908
};

/* ITU Chrominace Huffman Table */
static unsigned int ITU_H_tbl_len_DC_chrominance[4] = {
	0x01010300, 0x01010101, 0x00010101, 0x00000000
};
static unsigned int ITU_H_tbl_val_DC_chrominance[3] = {
	0x03020100, 0x07060504, 0x0b0a0908
};

static unsigned int ITU_H_tbl_len_AC_luminance[4] = {
	0x03010200, 0x03040203, 0x04040505, 0x7d010000
};

static unsigned int ITU_H_tbl_val_AC_luminance[41] = {
	0x00030201, 0x12051104, 0x06413121, 0x07615113,
	0x32147122, 0x08a19181, 0xc1b14223, 0xf0d15215,
	0x72623324, 0x160a0982, 0x1a191817, 0x28272625,
	0x35342a29, 0x39383736, 0x4544433a, 0x49484746,
	0x5554534a, 0x59585756, 0x6564635a, 0x69686766,
	0x7574736a, 0x79787776, 0x8584837a, 0x89888786,
	0x9493928a, 0x98979695, 0xa3a29a99, 0xa7a6a5a4,
	0xb2aaa9a8, 0xb6b5b4b3, 0xbab9b8b7, 0xc5c4c3c2,
	0xc9c8c7c6, 0xd4d3d2ca, 0xd8d7d6d5, 0xe2e1dad9,
	0xe6e5e4e3, 0xeae9e8e7, 0xf4f3f2f1, 0xf8f7f6f5,
	0x0000faf9
};

static u32 ITU_H_tbl_len_AC_chrominance[4] = {
	0x02010200, 0x04030404, 0x04040507, 0x77020100
};
static u32 ITU_H_tbl_val_AC_chrominance[41] = {
	0x03020100, 0x21050411, 0x41120631, 0x71610751,
	0x81322213, 0x91421408, 0x09c1b1a1, 0xf0523323,
	0xd1726215, 0x3424160a, 0x17f125e1, 0x261a1918,
	0x2a292827, 0x38373635, 0x44433a39, 0x48474645,
	0x54534a49, 0x58575655, 0x64635a59, 0x68676665,
	0x74736a69, 0x78777675, 0x83827a79, 0x87868584,
	0x928a8988, 0x96959493, 0x9a999897, 0xa5a4a3a2,
	0xa9a8a7a6, 0xb4b3b2aa, 0xb8b7b6b5, 0xc3c2bab9,
	0xc7c6c5c4, 0xd2cac9c8, 0xd6d5d4d3, 0xdad9d8d7,
	0xe5e4e3e2, 0xe9e8e7e6, 0xf4f3f2ea, 0xf8f7f6f5,
	0x0000faf9
};
#endif /* __JPEG_CONF_H__ */
