<?php
/*
# Copyright 2006, CRIM,Martin Rioux
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/

/**
 * This class manage current node hardware group
 *
 * 16 mars 2006 - Martin Rioux
 */

require_once 'Attribute.php';
require_once 'AttributeDef.php';
require_once 'dbFunctions.php';

class HWGroupManager {
	var $hwGroupRules;
	var $isError;
	var $errors;
	var $operators;

	function HWGroupManager($node) {
		/////////////////////////////
		// General construction
		////////////////////////////
		if (strtolower(get_class($node)) != "node"){
			$this->isError = true;
			return;
		}
		if ($node->isError) {
			$this->isError = true;
			return;
		}
		$this->node = $node;
		$this->isError = false;
		$hg = new HWGroupRule($node->getID());
		$this->operators = $hg->getOperators();
		/////////////////////////
		// Actions
		/////////////////////////

		// Cancel
		if (isset($_POST['cancel'])||(!isset($_POST['delete_hwg'])&&!isset($_POST['add_hwg'])&&!isset($_POST['modify_hwg']))) {
		    unset($GLOBALS['_POST']);
		    $this->hwGroupRules = $node->getHwGroupsRules();
		}
		// Add an hw Group Rule
		if (isset($_POST['add_hwg'])) {
			$this->hwGroupRules = $node->getHwGroupsRules();
			$hwGroupRule = new HWGroupRule($node->getID(),$_POST['hwGroupKey'],$_POST['hwGroupValue'],$_POST['hwGroupOperator']);
			if(!$hwGroupRule->insertDB()){
				$this->errors[]=$hwGroupRule->lastError;
			}else{
				$this->hwGroupRules[] = $hwGroupRule;
				logAdminAccess(array("ADD HARDWARE GROUP RULE","NODE ID : ".$node->getID(),"NAME : ".$node->getName(),"RULE : ".$hwGroupRule->getHwKey().$hwGroupRule->getOperator().$hwGroupRule->getHwValue()));
			}
			unset($_POST['add_hwg']);
		}

		// Deleting hw Group Rule
		if (isset($_POST['delete_hwg'])) {
			if (is_array($_POST['selection'])) {
				foreach ($_POST['selection'] as $id) {
					$hgToDelete = new HWGroupRule($node->getID(),$_POST['key'.$id],$_POST['value'.$id],$_POST['operator'.$id]);
					if ($error = $hgToDelete->delete()) {
						$this->errors[] = $error;
						unset($error);
					}else{
						$this->hwGroupRules = $node->getHwGroupsRules();
						logAdminAccess(array("DELETE HARDWARE GROUP RULE","NODE ID : ".$node->getID(),"NAME : ".$node->getName(),"RULE : ".$hgToDelete->getHwKey().$hgToDelete->getOperator().$hgToDelete->getHwValue()));
					}
				}
			}
			unset($_POST['delete_hwg']);
		}

		// Modify attributes
		if (isset($_POST['modify_hwg'])) {
			foreach($_POST as $postKey => $postValue) {
				//get the input name (key*, value*, operator*)
				if(substr($postKey, 0, 3) == "key"){
					$hwGroupToUpdate = new HWGroupRule($node->getID(),$_POST['key'.$postKey{3}],$_POST['value'.$postKey{3}],$_POST['operator'.$postKey{3}]);
					$list[] = $hwGroupToUpdate;
				}
			}
			$hg->updateList($list);
			if($hg->isError()){
				$this->errors[] = $hg->lastError;
			}else{
				logAdminAccess(array("MODIFY HARDWARE GROUP RULE","NODE ID : ".$node->getID(),"NAME : ".$node->getName()));
			}
			$this->hwGroupRules = $node->getHwGroupsRules();
			unset($_POST['modify_hwg']);
		}
	}

	function isError() {
		return $this->isError;
	}

	function printErrors() {
		if (isset($this->errors[0])) print "<p>\n";
		else return;
		foreach ($this->errors as $error) {
			print "<font color=\"red\" size=\"-1\">".$error."</font><br>\n";
		}
		print "</p>\n";
	}

	function printView() {
		if ($this->isError) {
			$this->printErrors();
			return;
		}
		include 'HWGroupManagerView.php';
	}

}
?>



