<?php
/*
 * LTSP-Cluster Control Center
 * Copyright (2008-2009) Stéphane Graber <stgraber@ubuntu.com>, Revolution Linux Inc.

 * Author: Stéphane Graber <stgraber@ubuntu.com>

 * 2008, Stéphane Graber <stgraber@ubuntu.com>
 * 2009, Stéphane Graber <stgraber@ubuntu.com>

 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of 
 * the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, you can find it on the World Wide
 * Web at http://www.gnu.org/copyleft/gpl.html, or write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

    # Set the document's charset
    header('Content-type: text/html; charset=utf-8');

    # Try to guess the user's langauge FIXME: This shouldn't contain hardcoded locales
    $languages=split(",",$_SERVER['HTTP_ACCEPT_LANGUAGE']);
    $locale="en_US.UTF-8";
    foreach ($languages as $language) {
        if (ereg("^fr",$language)) {
            $locale="fr_CA.UTF-8";
            break;
        }
        if (ereg("^en",$language)) {
            $locale="en_US.UTF-8";
            break;
        }
    }

    # Setup gettext
    setlocale(LC_ALL, $locale);
    bindtextdomain("ltsp-cluster-control","./po/");
    bind_textdomain_codeset("ltsp-cluster-control","utf-8");
    textdomain("ltsp-cluster-control");

    require_once("config.php");

    # Set the URL prefix based on current URL and rewriting settings
    if ($config['url_rewriting'] == "1") {
        ereg("(.*)/index.*",$_SERVER["SCRIPT_NAME"],$url);
        $url_prefix=$url[1]."/";
    }
    else {
        $url_prefix=$_SERVER["SCRIPT_NAME"]."?page=";
    }

    # Load the base functions
    include "includes/menu.php";
    include "themes/engine.php";

    # Check and parse the query (GET)
    if ($_GET['q']) {
        $current_page=$_GET['q'];
    }
    else {
        $current_page=Null;
    }

    # Add stock categories
    menuAddCategory(_("Administration"),1);
    menuAddCategory(_("Monitoring"),0);

    # Load the modules FIXME: This needs to be automatic
    include "modules/appservers.page.php";
    include "modules/frontpage.page.php";
    include "modules/users.page.php";

    # Build the page
    $page = array();
    $page['title'] = _("LTSP-Cluster Control Center");
    if ($current_page) {
        $page['parameters'] = split("/",$current_page);
        $page['function'] = $page['parameters'][0]."_main";
        if (count($page['parameters'] > 1)) {
            $page['arguments']=array_slice($page['parameters'],1);
        }
        else {
            $page['arguments']=array();
        }
        $page['content'] = call_user_func($page['function'],$page['arguments']);
    }
    else {
        #FIXME: That should be configurable
        header("Location: /frontpage");
    }
    $page['footer'] = "Copyright &copy; 2008-2009 Revolution Linux Inc.";

    # Show the result to the user
    print renderPage($page,$menu);
?>
