<?xml version="1.0" encoding="ISO-8859-1"?>

<!--
Site-wide style for each sub-project
version $Date: 2003/11/23 21:28:46 $


Creates an HTML-viewable document for a code-coverage report.

 @author Matt Albrecht (mailto:groboclown@users.sourceforge.net)
-->

<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'>

    <xsl:output method="html" indent="no" />

    <xsl:param name="perfectP" select="'100'" />
    <xsl:param name="goodP" select="'80'" />
    <xsl:param name="warnP" select="'60'" />
    
    <xsl:param name="do-weight" select="false" />
    
    
    <!-- base document -->
    <xsl:template match="coveragereport">
<HTML>
<xsl:comment>
This file was auto-generated.
</xsl:comment>
<HEAD>
    <TITLE>
    Code Coverage Report - <xsl:value-of select="@measure" />
    </TITLE>
    <STYLE TYPE="text/css">
      body {
        font:normal 68% verdana,arial,helvetica;
        color:#000000;
      }
      table {
        width:100%;
        border:0;
      }
      table tr td {
        font-size: 68%;
        background:#eeeee0;
      }
      table tr th {
        font-size: 68%;
        text-align:center;
        background:#a6caf0;
      }
      table.details tr th{
        font-weight: bold;
        text-align:left;
        background:#a6caf0;
      }
      table.details tr td{
        background:#eeeee0;
      }
      
      p {
        line-height:1.5em;
        margin-top:0.5em; margin-bottom:1.0em;
      }
      h1 {
        margin: 0px 0px 5px; font: 165% verdana,arial,helvetica;
      }
      h2 {
        margin-top: 1em; margin-bottom: 0.5em; font: bold 125% verdana,arial,helvetica;
      }
      h3 {
        margin-bottom: 0.5em; font: bold 115% verdana,arial,helvetica;
      }
      h4 {
        margin-top: 0px;
        margin-bottom: 0.5em; font: bold 100% verdana,arial,helvetica;
        color: blue;
      }
      h5 {
        margin-bottom: 0.5em; font: bold 100% verdana,arial,helvetica;
        font-size: 95%;
      }
      h6 {
        margin-bottom: 0px; font: bold 100% verdana,arial,helvetica;
      }
      .Perfect {
        background:green;
        color:white;
        text-align:center;
      }
      .Good {
        background:yellow;
        font-weight:bold;
        color:black;
        text-align:center;
      }
      .Warn {
        background:orange;
        font-weight:bold;
        color:black;
        text-align:center;
      }
      .Fail {
        background:red;
        font-weight:bold;
        color:white;
        text-align:center;
      }
      .CoverageTitle {
        text-align:left;
      }
      </STYLE>
</HEAD>
<BODY>
    <h1>Coverage Report for <xsl:value-of select="@measure" /></h1>
    <p><i>All units are in <xsl:value-of select="@unit" />.</i></p>
    
    <h2>Totals</h2>
    <TABLE>
        <xsl:call-template name="Header" >
            <xsl:with-param name="Title" select="''" />
        </xsl:call-template>
        <xsl:apply-templates select="/coveragereport/cover">
            <xsl:with-param name="Title" select="'All Packages'" />
            <xsl:with-param name="ref" select="'packages'" />
        </xsl:apply-templates>
    </TABLE>
    
    <h2><a name="packages">All Packages</a></h2>
    <TABLE>
        <xsl:call-template name="Header" >
            <xsl:with-param name="Title" select="'Package'" />
        </xsl:call-template>
        <xsl:for-each select="package" >
            <xsl:sort select="./cover/@percentcovered" data-type="number" />
            <xsl:apply-templates select="./cover">
                <xsl:with-param name="Title" select="@name" />
                <xsl:with-param name="ref" select="@name" />
            </xsl:apply-templates>
        </xsl:for-each>
    </TABLE>
    
    <hr />
    
    <h2><a name="classes">Classes By Package</a></h2>
    <xsl:apply-templates select="package">
        <xsl:sort select="@name" />
    </xsl:apply-templates>
    
    <hr />
    
    <h2><a name="methods">Methods By Class</a></h2>
    <xsl:apply-templates select="/coveragereport/classcoverage" >
        <xsl:sort select="@name" />
    </xsl:apply-templates>
    
    <hr />
    
    <h2><a name="details">Method Details</a></h2>
    <xsl:apply-templates select="/coveragereport/classcoverage/methodcoverage" >
        <xsl:sort select="@name" />
    </xsl:apply-templates>
</BODY>
</HTML>
    </xsl:template>
    
    
    <xsl:template match="package">
        <xsl:variable name="pname" select="@name" />
        <h3><a><xsl:attribute name="name"><xsl:value-of select="@name" /></xsl:attribute>
        Package <xsl:value-of select="@name" /></a></h3>
        
        <TABLE>
            <xsl:call-template name="Header" >
                <xsl:with-param name="Title" select="'Class'" />
            </xsl:call-template>
            <xsl:for-each select="/coveragereport/classcoverage[@package = $pname]">
                <!--
                <xsl:sort select="@name" />
                -->
                <xsl:sort select="./cover/@percentcovered" data-type="number" />
                <xsl:apply-templates select="./cover">
                    <xsl:with-param name="Title" select="@classname" />
                    <xsl:with-param name="ref" select="@classsignature" />
                </xsl:apply-templates>
            </xsl:for-each>
        </TABLE>
    </xsl:template>
    
    
    <xsl:template match="classcoverage">
        <h3><a><xsl:attribute name="name"><xsl:value-of select="@classsignature" /></xsl:attribute>
        Class <xsl:value-of select="@classname" /></a></h3>
        
        <TABLE>
            <xsl:call-template name="Header" >
                <xsl:with-param name="Title" select="'Method'" />
            </xsl:call-template>
            <xsl:for-each select="methodcoverage">
                <xsl:sort select="./cover/@percentcovered" data-type="number" />
                <xsl:variable name="sig"><xsl:value-of select="../@classsignature" /><xsl:value-of select="@methodsignature" /></xsl:variable>
                <xsl:apply-templates select="./cover">
                    <xsl:with-param name="Title" select="@methodsignature" />
                    <xsl:with-param name="ref" select="$sig" />
                </xsl:apply-templates>
            </xsl:for-each>
        </TABLE>
    </xsl:template>
    
    
    <xsl:template match="methodcoverage">
        <xsl:variable name="sig"><xsl:value-of select="../@classsignature" /><xsl:value-of select="@methodsignature" /></xsl:variable>
        <h6><a><xsl:attribute name="name">
        <xsl:value-of select="$sig" /></xsl:attribute>
        Class <xsl:value-of select="../@classname" /></a></h6>
        <h4>Method
        <xsl:value-of select="@methodsignature" /></h4>
        <h5>Units Not Covered</h5>
        
        <TABLE STYLE="details">
            <xsl:choose>
                <xsl:when test="mark[@covered='false']">
                    <TR>
                        <TH>Index</TH>
                        <TH>Details</TH>
                    </TR>
                    <xsl:for-each select="mark[@covered='false']">
                        <xsl:sort select="@index" data-type="number" />
                        <TR>
                            <TD><xsl:value-of select="@index" /></TD>
                            <TD><xsl:value-of select="@text" /></TD>
                        </TR>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <TR>
                        <TD><i>All units were covered</i></TD>
                    </TR>
                </xsl:otherwise>
            </xsl:choose>
        </TABLE>
    </xsl:template>
    
    
    
    <!--
    Here starts the callable templates
    -->
    
    <xsl:template name="Header">
        <xsl:param name="Title" select="'[not set]'" />
        <TR>
            <TH><xsl:value-of select="$Title" /></TH>
            <TH>Covered</TH>
            <TH>Total</TH>
            <TH>% Covered</TH>
            <xsl:if test="$do-weight">
            <TH>Weighted %</TH>
            </xsl:if>
        </TR>
    </xsl:template>
    
    <xsl:template name="Coverage" match="cover">
        <xsl:param name="Title" select="'[not set]'" />
        <xsl:param name="ref" select="'[not set]'" />
        <TR>
            <TD STYLE="CoverageTitle"><a>
            <xsl:attribute name="href">#<xsl:value-of select="$ref" /></xsl:attribute>
            <xsl:value-of select="$Title" />
            </a></TD>
            <TD>
            <xsl:call-template name="PassFailStyle" />
            <xsl:value-of select="@display-covered" /></TD>
            <TD>
            <xsl:call-template name="PassFailStyle" />
            <xsl:value-of select="@display-total" /></TD>
            <TD>
            <xsl:call-template name="PassFailStyle" />
            <xsl:value-of select="@display-percentcovered" /></TD>
            <xsl:if test="$do-weight">
                <TD>
                <xsl:call-template name="PassFailStyle" />
                <xsl:value-of select="@display-weightedpercent" /></TD>
            </xsl:if>
        </TR>
    </xsl:template>
    
    
    <!--
    Set the style attribute based on the "percentcovered" attribute.
    -->
    <xsl:template name="PassFailStyle">
        <xsl:param name="prepend" select="''" />
        <xsl:attribute name="CLASS"><xsl:value-of select="$prepend"/><xsl:choose><xsl:when test="@percentcovered &gt;= $perfectP">Perfect</xsl:when><xsl:when test="@percentcovered &gt;= $goodP">Good</xsl:when><xsl:when test="@percentcovered &gt;= $warnP">Warn</xsl:when><xsl:otherwise>Fail</xsl:otherwise></xsl:choose></xsl:attribute>
    </xsl:template>
</xsl:stylesheet>
