/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.passivation;

import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.xml.XmlHelper;
import org.w3c.dom.Element;

import java.util.Properties;

/**
 * Tests passivation using JDBC Cache Loader.
 * This test has MySQL hard-coded. To run it, run MySQL first: mysqld -u=root
 *
 * @author <a href="mailto:{hmesha@novell.com}">{Hany Mesha}</a>
 * @version $Id: PassivationToJDBCCacheLoaderTest.java 4836 2007-12-11 17:34:04Z manik.surtani@jboss.com $
 */
public class PassivationToJDBCCacheLoaderTest extends PassivationTestsBase
{


   protected CacheLoaderConfig getCacheLoaderConfig() throws Exception
   {
      String xml = "            <config>\n" +
            "                \n" +
            "                <passivation>true</passivation>\n" +
            "                <preload></preload>\n" +
            "\n" +
            "                <cacheloader>\n" +
            "                    <class>org.jboss.cache.loader.JDBCCacheLoader</class>\n" +
            "                    <properties>\n" +
            getJDBCProps() +
            "                    </properties>\n" +
            "                    <async>false</async>\n" +
            "                    <fetchPersistentState>false</fetchPersistentState>\n" +
            "                    <ignoreModifications>false</ignoreModifications>\n" +
            "                </cacheloader>\n" +
            "                \n" +
            "            </config>";
      Element element = XmlHelper.stringToElement(xml);
      return XmlConfigurationParser.parseCacheLoaderConfig(element);
   }


   protected String getJDBCProps()
   {
      Properties prop = new Properties();
      try
      {
         prop.load(this.getClass().getClassLoader().getResourceAsStream("cache-jdbc.properties"));
      }
      catch (Exception e)
      {
         System.out.println("Error loading jdbc properties ");
      }
      return "cache.jdbc.driver =" + prop.getProperty("cache.jdbc.driver") + "\n" +
            "cache.jdbc.url=" + prop.getProperty("cache.jdbc.url") + "\n" +
            "cache.jdbc.user=" + prop.getProperty("cache.jdbc.user") + "\n" +
            "cache.jdbc.password=" + prop.getProperty("cache.jdbc.password") + "\n" +
            "cache.jdbc.node.type=" + prop.getProperty("cache.jdbc.node.type") + "\n" +
            "cache.jdbc.sql-concat=" + prop.getProperty("cache.jdbc.sql-concat");
   }

   protected void configureCache() throws Exception
   {
      cache.getConfiguration().setCacheLoaderConfig(getCacheLoaderConfig());
   }
}
