/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */

package org.apache.jdo.tck.pc.fieldtypes;

import java.io.Serializable;
import java.util.HashMap;

public class HashMapStringKeyCollections { 
  public int identifier;
  public HashMap HashMapOfString_Object0;
  public HashMap HashMapOfString_Object1;
  public HashMap HashMapOfString_Object2;
  public HashMap HashMapOfString_SimpleClass3;
  public HashMap HashMapOfString_SimpleClass4;
  public HashMap HashMapOfString_SimpleClass5;
  public HashMap HashMapOfString_SimpleInterface6;
  public HashMap HashMapOfString_SimpleInterface7;
  public HashMap HashMapOfString_SimpleInterface8;
  public HashMap HashMapOfString_String9;
  public HashMap HashMapOfString_String10;
  public HashMap HashMapOfString_String11;
  public HashMap HashMapOfString_Date12;
  public HashMap HashMapOfString_Date13;
  public HashMap HashMapOfString_Date14;
  public HashMap HashMapOfString_Locale15;
  public HashMap HashMapOfString_Locale16;
  public HashMap HashMapOfString_Locale17;
  public HashMap HashMapOfString_BigDecimal18;
  public HashMap HashMapOfString_BigDecimal19;
  public HashMap HashMapOfString_BigDecimal20;
  public HashMap HashMapOfString_BigInteger21;
  public HashMap HashMapOfString_BigInteger22;
  public HashMap HashMapOfString_BigInteger23;
  public HashMap HashMapOfString_Byte24;
  public HashMap HashMapOfString_Byte25;
  public HashMap HashMapOfString_Byte26;
  public HashMap HashMapOfString_Double27;
  public HashMap HashMapOfString_Double28;
  public HashMap HashMapOfString_Double29;
  public HashMap HashMapOfString_Float30;
  public HashMap HashMapOfString_Float31;
  public HashMap HashMapOfString_Float32;
  public HashMap HashMapOfString_Integer33;
  public HashMap HashMapOfString_Integer34;
  public HashMap HashMapOfString_Integer35;
  public HashMap HashMapOfString_Long36;
  public HashMap HashMapOfString_Long37;
  public HashMap HashMapOfString_Long38;
  public HashMap HashMapOfString_Short39;
  public HashMap HashMapOfString_Short40;
  public HashMap HashMapOfString_Short41;
  public HashMap HashMapOfString_Object42;
  public HashMap HashMapOfString_Object43;
  public HashMap HashMapOfString_SimpleClass45;
  public HashMap HashMapOfString_SimpleClass46;
  public HashMap HashMapOfString_SimpleInterface48;
  public HashMap HashMapOfString_SimpleInterface49;
  public HashMap HashMapOfString_String51;
  public HashMap HashMapOfString_String52;
  public HashMap HashMapOfString_Date54;
  public HashMap HashMapOfString_Date55;
  public HashMap HashMapOfString_Locale57;
  public HashMap HashMapOfString_Locale58;
  public HashMap HashMapOfString_BigDecimal60;
  public HashMap HashMapOfString_BigDecimal61;
  public HashMap HashMapOfString_BigInteger63;
  public HashMap HashMapOfString_BigInteger64;
  public HashMap HashMapOfString_Byte66;
  public HashMap HashMapOfString_Byte67;
  public HashMap HashMapOfString_Double69;
  public HashMap HashMapOfString_Double70;
  public HashMap HashMapOfString_Float72;
  public HashMap HashMapOfString_Float73;
  public HashMap HashMapOfString_Integer75;
  public HashMap HashMapOfString_Integer76;
  public HashMap HashMapOfString_Long78;
  public HashMap HashMapOfString_Long79;
  public HashMap HashMapOfString_Short81;
  public HashMap HashMapOfString_Short82;
  public HashMap HashMapOfString_Object84;
  public HashMap HashMapOfString_Object86;
  public HashMap HashMapOfString_SimpleClass87;
  public HashMap HashMapOfString_SimpleClass89;
  public HashMap HashMapOfString_SimpleInterface90;
  public HashMap HashMapOfString_SimpleInterface92;
  public HashMap HashMapOfString_String93;
  public HashMap HashMapOfString_String95;
  public HashMap HashMapOfString_Date96;
  public HashMap HashMapOfString_Date98;
  public HashMap HashMapOfString_Locale99;
  public HashMap HashMapOfString_Locale101;
  public HashMap HashMapOfString_BigDecimal102;
  public HashMap HashMapOfString_BigDecimal104;
  public HashMap HashMapOfString_BigInteger105;
  public HashMap HashMapOfString_BigInteger107;
  public HashMap HashMapOfString_Byte108;
  public HashMap HashMapOfString_Byte110;
  public HashMap HashMapOfString_Double111;
  public HashMap HashMapOfString_Double113;
  public HashMap HashMapOfString_Float114;
  public HashMap HashMapOfString_Float116;
  public HashMap HashMapOfString_Integer117;
  public HashMap HashMapOfString_Integer119;
  public HashMap HashMapOfString_Long120;
  public HashMap HashMapOfString_Long122;
  public HashMap HashMapOfString_Short123;
  public HashMap HashMapOfString_Short125;

  public static final String [] fieldSpecs = { 
  "public HashMap HashMapOfString_Object0",
  "embedded-value=true public HashMap HashMapOfString_Object1",
  "embedded-value=false public HashMap HashMapOfString_Object2",
  "public HashMap HashMapOfString_SimpleClass3",
  "embedded-value=true public HashMap HashMapOfString_SimpleClass4",
  "embedded-value=false public HashMap HashMapOfString_SimpleClass5",
  "public HashMap HashMapOfString_SimpleInterface6",
  "embedded-value=true public HashMap HashMapOfString_SimpleInterface7",
  "embedded-value=false public HashMap HashMapOfString_SimpleInterface8",
  "public HashMap HashMapOfString_String9",
  "embedded-value=true public HashMap HashMapOfString_String10",
  "embedded-value=false public HashMap HashMapOfString_String11",
  "public HashMap HashMapOfString_Date12",
  "embedded-value=true public HashMap HashMapOfString_Date13",
  "embedded-value=false public HashMap HashMapOfString_Date14",
  "public HashMap HashMapOfString_Locale15",
  "embedded-value=true public HashMap HashMapOfString_Locale16",
  "embedded-value=false public HashMap HashMapOfString_Locale17",
  "public HashMap HashMapOfString_BigDecimal18",
  "embedded-value=true public HashMap HashMapOfString_BigDecimal19",
  "embedded-value=false public HashMap HashMapOfString_BigDecimal20",
  "public HashMap HashMapOfString_BigInteger21",
  "embedded-value=true public HashMap HashMapOfString_BigInteger22",
  "embedded-value=false public HashMap HashMapOfString_BigInteger23",
  "public HashMap HashMapOfString_Byte24",
  "embedded-value=true public HashMap HashMapOfString_Byte25",
  "embedded-value=false public HashMap HashMapOfString_Byte26",
  "public HashMap HashMapOfString_Double27",
  "embedded-value=true public HashMap HashMapOfString_Double28",
  "embedded-value=false public HashMap HashMapOfString_Double29",
  "public HashMap HashMapOfString_Float30",
  "embedded-value=true public HashMap HashMapOfString_Float31",
  "embedded-value=false public HashMap HashMapOfString_Float32",
  "public HashMap HashMapOfString_Integer33",
  "embedded-value=true public HashMap HashMapOfString_Integer34",
  "embedded-value=false public HashMap HashMapOfString_Integer35",
  "public HashMap HashMapOfString_Long36",
  "embedded-value=true public HashMap HashMapOfString_Long37",
  "embedded-value=false public HashMap HashMapOfString_Long38",
  "public HashMap HashMapOfString_Short39",
  "embedded-value=true public HashMap HashMapOfString_Short40",
  "embedded-value=false public HashMap HashMapOfString_Short41",
  "embedded-key=true  public HashMap HashMapOfString_Object42",
  "embedded-key=true embedded-value=true public HashMap HashMapOfString_Object43",
  "embedded-key=true  public HashMap HashMapOfString_SimpleClass45",
  "embedded-key=true embedded-value=true public HashMap HashMapOfString_SimpleClass46",
  "embedded-key=true  public HashMap HashMapOfString_SimpleInterface48",
  "embedded-key=true embedded-value=true public HashMap HashMapOfString_SimpleInterface49",
  "embedded-key=true  public HashMap HashMapOfString_String51",
  "embedded-key=true embedded-value=true public HashMap HashMapOfString_String52",
  "embedded-key=true  public HashMap HashMapOfString_Date54",
  "embedded-key=true embedded-value=true public HashMap HashMapOfString_Date55",
  "embedded-key=true  public HashMap HashMapOfString_Locale57",
  "embedded-key=true embedded-value=true public HashMap HashMapOfString_Locale58",
  "embedded-key=true  public HashMap HashMapOfString_BigDecimal60",
  "embedded-key=true embedded-value=true public HashMap HashMapOfString_BigDecimal61",
  "embedded-key=true  public HashMap HashMapOfString_BigInteger63",
  "embedded-key=true embedded-value=true public HashMap HashMapOfString_BigInteger64",
  "embedded-key=true  public HashMap HashMapOfString_Byte66",
  "embedded-key=true embedded-value=true public HashMap HashMapOfString_Byte67",
  "embedded-key=true  public HashMap HashMapOfString_Double69",
  "embedded-key=true embedded-value=true public HashMap HashMapOfString_Double70",
  "embedded-key=true  public HashMap HashMapOfString_Float72",
  "embedded-key=true embedded-value=true public HashMap HashMapOfString_Float73",
  "embedded-key=true  public HashMap HashMapOfString_Integer75",
  "embedded-key=true embedded-value=true public HashMap HashMapOfString_Integer76",
  "embedded-key=true  public HashMap HashMapOfString_Long78",
  "embedded-key=true embedded-value=true public HashMap HashMapOfString_Long79",
  "embedded-key=true  public HashMap HashMapOfString_Short81",
  "embedded-key=true embedded-value=true public HashMap HashMapOfString_Short82",
  "embedded-key=false  public HashMap HashMapOfString_Object84",
  "embedded-key=false embedded-value=false public HashMap HashMapOfString_Object86",
  "embedded-key=false  public HashMap HashMapOfString_SimpleClass87",
  "embedded-key=false embedded-value=false public HashMap HashMapOfString_SimpleClass89",
  "embedded-key=false  public HashMap HashMapOfString_SimpleInterface90",
  "embedded-key=false embedded-value=false public HashMap HashMapOfString_SimpleInterface92",
  "embedded-key=false  public HashMap HashMapOfString_String93",
  "embedded-key=false embedded-value=false public HashMap HashMapOfString_String95",
  "embedded-key=false  public HashMap HashMapOfString_Date96",
  "embedded-key=false embedded-value=false public HashMap HashMapOfString_Date98",
  "embedded-key=false  public HashMap HashMapOfString_Locale99",
  "embedded-key=false embedded-value=false public HashMap HashMapOfString_Locale101",
  "embedded-key=false  public HashMap HashMapOfString_BigDecimal102",
  "embedded-key=false embedded-value=false public HashMap HashMapOfString_BigDecimal104",
  "embedded-key=false  public HashMap HashMapOfString_BigInteger105",
  "embedded-key=false embedded-value=false public HashMap HashMapOfString_BigInteger107",
  "embedded-key=false  public HashMap HashMapOfString_Byte108",
  "embedded-key=false embedded-value=false public HashMap HashMapOfString_Byte110",
  "embedded-key=false  public HashMap HashMapOfString_Double111",
  "embedded-key=false embedded-value=false public HashMap HashMapOfString_Double113",
  "embedded-key=false  public HashMap HashMapOfString_Float114",
  "embedded-key=false embedded-value=false public HashMap HashMapOfString_Float116",
  "embedded-key=false  public HashMap HashMapOfString_Integer117",
  "embedded-key=false embedded-value=false public HashMap HashMapOfString_Integer119",
  "embedded-key=false  public HashMap HashMapOfString_Long120",
  "embedded-key=false embedded-value=false public HashMap HashMapOfString_Long122",
  "embedded-key=false  public HashMap HashMapOfString_Short123",
  "embedded-key=false embedded-value=false public HashMap HashMapOfString_Short125"
  };
  public int getLength()
  {
    return fieldSpecs.length;
  }
  public HashMap get(int index)
  {
    switch (index)
    {
      case(0):
        return HashMapOfString_Object0;
      case(1):
        return HashMapOfString_Object1;
      case(2):
        return HashMapOfString_Object2;
      case(3):
        return HashMapOfString_SimpleClass3;
      case(4):
        return HashMapOfString_SimpleClass4;
      case(5):
        return HashMapOfString_SimpleClass5;
      case(6):
        return HashMapOfString_SimpleInterface6;
      case(7):
        return HashMapOfString_SimpleInterface7;
      case(8):
        return HashMapOfString_SimpleInterface8;
      case(9):
        return HashMapOfString_String9;
      case(10):
        return HashMapOfString_String10;
      case(11):
        return HashMapOfString_String11;
      case(12):
        return HashMapOfString_Date12;
      case(13):
        return HashMapOfString_Date13;
      case(14):
        return HashMapOfString_Date14;
      case(15):
        return HashMapOfString_Locale15;
      case(16):
        return HashMapOfString_Locale16;
      case(17):
        return HashMapOfString_Locale17;
      case(18):
        return HashMapOfString_BigDecimal18;
      case(19):
        return HashMapOfString_BigDecimal19;
      case(20):
        return HashMapOfString_BigDecimal20;
      case(21):
        return HashMapOfString_BigInteger21;
      case(22):
        return HashMapOfString_BigInteger22;
      case(23):
        return HashMapOfString_BigInteger23;
      case(24):
        return HashMapOfString_Byte24;
      case(25):
        return HashMapOfString_Byte25;
      case(26):
        return HashMapOfString_Byte26;
      case(27):
        return HashMapOfString_Double27;
      case(28):
        return HashMapOfString_Double28;
      case(29):
        return HashMapOfString_Double29;
      case(30):
        return HashMapOfString_Float30;
      case(31):
        return HashMapOfString_Float31;
      case(32):
        return HashMapOfString_Float32;
      case(33):
        return HashMapOfString_Integer33;
      case(34):
        return HashMapOfString_Integer34;
      case(35):
        return HashMapOfString_Integer35;
      case(36):
        return HashMapOfString_Long36;
      case(37):
        return HashMapOfString_Long37;
      case(38):
        return HashMapOfString_Long38;
      case(39):
        return HashMapOfString_Short39;
      case(40):
        return HashMapOfString_Short40;
      case(41):
        return HashMapOfString_Short41;
      case(42):
        return HashMapOfString_Object42;
      case(43):
        return HashMapOfString_Object43;
      case(44):
        return HashMapOfString_SimpleClass45;
      case(45):
        return HashMapOfString_SimpleClass46;
      case(46):
        return HashMapOfString_SimpleInterface48;
      case(47):
        return HashMapOfString_SimpleInterface49;
      case(48):
        return HashMapOfString_String51;
      case(49):
        return HashMapOfString_String52;
      case(50):
        return HashMapOfString_Date54;
      case(51):
        return HashMapOfString_Date55;
      case(52):
        return HashMapOfString_Locale57;
      case(53):
        return HashMapOfString_Locale58;
      case(54):
        return HashMapOfString_BigDecimal60;
      case(55):
        return HashMapOfString_BigDecimal61;
      case(56):
        return HashMapOfString_BigInteger63;
      case(57):
        return HashMapOfString_BigInteger64;
      case(58):
        return HashMapOfString_Byte66;
      case(59):
        return HashMapOfString_Byte67;
      case(60):
        return HashMapOfString_Double69;
      case(61):
        return HashMapOfString_Double70;
      case(62):
        return HashMapOfString_Float72;
      case(63):
        return HashMapOfString_Float73;
      case(64):
        return HashMapOfString_Integer75;
      case(65):
        return HashMapOfString_Integer76;
      case(66):
        return HashMapOfString_Long78;
      case(67):
        return HashMapOfString_Long79;
      case(68):
        return HashMapOfString_Short81;
      case(69):
        return HashMapOfString_Short82;
      case(70):
        return HashMapOfString_Object84;
      case(71):
        return HashMapOfString_Object86;
      case(72):
        return HashMapOfString_SimpleClass87;
      case(73):
        return HashMapOfString_SimpleClass89;
      case(74):
        return HashMapOfString_SimpleInterface90;
      case(75):
        return HashMapOfString_SimpleInterface92;
      case(76):
        return HashMapOfString_String93;
      case(77):
        return HashMapOfString_String95;
      case(78):
        return HashMapOfString_Date96;
      case(79):
        return HashMapOfString_Date98;
      case(80):
        return HashMapOfString_Locale99;
      case(81):
        return HashMapOfString_Locale101;
      case(82):
        return HashMapOfString_BigDecimal102;
      case(83):
        return HashMapOfString_BigDecimal104;
      case(84):
        return HashMapOfString_BigInteger105;
      case(85):
        return HashMapOfString_BigInteger107;
      case(86):
        return HashMapOfString_Byte108;
      case(87):
        return HashMapOfString_Byte110;
      case(88):
        return HashMapOfString_Double111;
      case(89):
        return HashMapOfString_Double113;
      case(90):
        return HashMapOfString_Float114;
      case(91):
        return HashMapOfString_Float116;
      case(92):
        return HashMapOfString_Integer117;
      case(93):
        return HashMapOfString_Integer119;
      case(94):
        return HashMapOfString_Long120;
      case(95):
        return HashMapOfString_Long122;
      case(96):
        return HashMapOfString_Short123;
      case(97):
        return HashMapOfString_Short125;
      default:
        throw new IndexOutOfBoundsException();
    }
  }
  public boolean set(int index,HashMap value)
  {
    if(fieldSpecs[index].indexOf("final") != -1)
      return false;
    switch (index)
    {
      case(0):
        HashMapOfString_Object0= value;
         break;
      case(1):
        HashMapOfString_Object1= value;
         break;
      case(2):
        HashMapOfString_Object2= value;
         break;
      case(3):
        HashMapOfString_SimpleClass3= value;
         break;
      case(4):
        HashMapOfString_SimpleClass4= value;
         break;
      case(5):
        HashMapOfString_SimpleClass5= value;
         break;
      case(6):
        HashMapOfString_SimpleInterface6= value;
         break;
      case(7):
        HashMapOfString_SimpleInterface7= value;
         break;
      case(8):
        HashMapOfString_SimpleInterface8= value;
         break;
      case(9):
        HashMapOfString_String9= value;
         break;
      case(10):
        HashMapOfString_String10= value;
         break;
      case(11):
        HashMapOfString_String11= value;
         break;
      case(12):
        HashMapOfString_Date12= value;
         break;
      case(13):
        HashMapOfString_Date13= value;
         break;
      case(14):
        HashMapOfString_Date14= value;
         break;
      case(15):
        HashMapOfString_Locale15= value;
         break;
      case(16):
        HashMapOfString_Locale16= value;
         break;
      case(17):
        HashMapOfString_Locale17= value;
         break;
      case(18):
        HashMapOfString_BigDecimal18= value;
         break;
      case(19):
        HashMapOfString_BigDecimal19= value;
         break;
      case(20):
        HashMapOfString_BigDecimal20= value;
         break;
      case(21):
        HashMapOfString_BigInteger21= value;
         break;
      case(22):
        HashMapOfString_BigInteger22= value;
         break;
      case(23):
        HashMapOfString_BigInteger23= value;
         break;
      case(24):
        HashMapOfString_Byte24= value;
         break;
      case(25):
        HashMapOfString_Byte25= value;
         break;
      case(26):
        HashMapOfString_Byte26= value;
         break;
      case(27):
        HashMapOfString_Double27= value;
         break;
      case(28):
        HashMapOfString_Double28= value;
         break;
      case(29):
        HashMapOfString_Double29= value;
         break;
      case(30):
        HashMapOfString_Float30= value;
         break;
      case(31):
        HashMapOfString_Float31= value;
         break;
      case(32):
        HashMapOfString_Float32= value;
         break;
      case(33):
        HashMapOfString_Integer33= value;
         break;
      case(34):
        HashMapOfString_Integer34= value;
         break;
      case(35):
        HashMapOfString_Integer35= value;
         break;
      case(36):
        HashMapOfString_Long36= value;
         break;
      case(37):
        HashMapOfString_Long37= value;
         break;
      case(38):
        HashMapOfString_Long38= value;
         break;
      case(39):
        HashMapOfString_Short39= value;
         break;
      case(40):
        HashMapOfString_Short40= value;
         break;
      case(41):
        HashMapOfString_Short41= value;
         break;
      case(42):
        HashMapOfString_Object42= value;
         break;
      case(43):
        HashMapOfString_Object43= value;
         break;
      case(44):
        HashMapOfString_SimpleClass45= value;
         break;
      case(45):
        HashMapOfString_SimpleClass46= value;
         break;
      case(46):
        HashMapOfString_SimpleInterface48= value;
         break;
      case(47):
        HashMapOfString_SimpleInterface49= value;
         break;
      case(48):
        HashMapOfString_String51= value;
         break;
      case(49):
        HashMapOfString_String52= value;
         break;
      case(50):
        HashMapOfString_Date54= value;
         break;
      case(51):
        HashMapOfString_Date55= value;
         break;
      case(52):
        HashMapOfString_Locale57= value;
         break;
      case(53):
        HashMapOfString_Locale58= value;
         break;
      case(54):
        HashMapOfString_BigDecimal60= value;
         break;
      case(55):
        HashMapOfString_BigDecimal61= value;
         break;
      case(56):
        HashMapOfString_BigInteger63= value;
         break;
      case(57):
        HashMapOfString_BigInteger64= value;
         break;
      case(58):
        HashMapOfString_Byte66= value;
         break;
      case(59):
        HashMapOfString_Byte67= value;
         break;
      case(60):
        HashMapOfString_Double69= value;
         break;
      case(61):
        HashMapOfString_Double70= value;
         break;
      case(62):
        HashMapOfString_Float72= value;
         break;
      case(63):
        HashMapOfString_Float73= value;
         break;
      case(64):
        HashMapOfString_Integer75= value;
         break;
      case(65):
        HashMapOfString_Integer76= value;
         break;
      case(66):
        HashMapOfString_Long78= value;
         break;
      case(67):
        HashMapOfString_Long79= value;
         break;
      case(68):
        HashMapOfString_Short81= value;
         break;
      case(69):
        HashMapOfString_Short82= value;
         break;
      case(70):
        HashMapOfString_Object84= value;
         break;
      case(71):
        HashMapOfString_Object86= value;
         break;
      case(72):
        HashMapOfString_SimpleClass87= value;
         break;
      case(73):
        HashMapOfString_SimpleClass89= value;
         break;
      case(74):
        HashMapOfString_SimpleInterface90= value;
         break;
      case(75):
        HashMapOfString_SimpleInterface92= value;
         break;
      case(76):
        HashMapOfString_String93= value;
         break;
      case(77):
        HashMapOfString_String95= value;
         break;
      case(78):
        HashMapOfString_Date96= value;
         break;
      case(79):
        HashMapOfString_Date98= value;
         break;
      case(80):
        HashMapOfString_Locale99= value;
         break;
      case(81):
        HashMapOfString_Locale101= value;
         break;
      case(82):
        HashMapOfString_BigDecimal102= value;
         break;
      case(83):
        HashMapOfString_BigDecimal104= value;
         break;
      case(84):
        HashMapOfString_BigInteger105= value;
         break;
      case(85):
        HashMapOfString_BigInteger107= value;
         break;
      case(86):
        HashMapOfString_Byte108= value;
         break;
      case(87):
        HashMapOfString_Byte110= value;
         break;
      case(88):
        HashMapOfString_Double111= value;
         break;
      case(89):
        HashMapOfString_Double113= value;
         break;
      case(90):
        HashMapOfString_Float114= value;
         break;
      case(91):
        HashMapOfString_Float116= value;
         break;
      case(92):
        HashMapOfString_Integer117= value;
         break;
      case(93):
        HashMapOfString_Integer119= value;
         break;
      case(94):
        HashMapOfString_Long120= value;
         break;
      case(95):
        HashMapOfString_Long122= value;
         break;
      case(96):
        HashMapOfString_Short123= value;
         break;
      case(97):
        HashMapOfString_Short125= value;
         break;
      default:
        throw new IndexOutOfBoundsException();
    }
    return true;
  }

    public static class Oid implements Serializable {
        public int identifier;

        public Oid() {
        }

        public Oid(String s) { identifier = Integer.parseInt(justTheId(s)); }

        public String toString() { return this.getClass().getName() + ": "  + identifier;}

        public int hashCode() { return (int)identifier ; }

        public boolean equals(Object other) {
            if (other != null && (other instanceof Oid)) {
                Oid k = (Oid)other;
                return k.identifier == this.identifier;
            }
            return false;
        }
        
        protected static String justTheId(String str) {
            return str.substring(str.indexOf(':') + 1);
        }

    }   
}
