/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.xml.catalog.impl;

import java.beans.*;
import static org.netbeans.modules.xml.catalog.impl.res.Bundle.*;

/**
 * Customizer for Netbeans IDE catalog is read only because the catalog
 * can be modified just by modules using OpenIDE API.
 *
 * @author  Petr Kuzel
 * @version 1.0
 */
public class SystemCatalogCustomizer extends javax.swing.JPanel implements Customizer {

    /** Serial Version UID */
    private static final long serialVersionUID = -7117054881250295623L;

    /** Creates new form CatalogCustomizer */
    public SystemCatalogCustomizer() {
        initComponents ();
        this.getAccessibleContext().setAccessibleDescription(ACSD_SystemCatalogCustomizer());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jTextArea1 = new javax.swing.JTextArea(){
            public boolean isFocusTraversable(){
                return false;
            }
        };

        setLayout(new java.awt.GridBagLayout());

        jTextArea1.setEditable(false);
        jTextArea1.setColumns(40);
        jTextArea1.setFont(javax.swing.UIManager.getFont ("Label.font"));
        jTextArea1.setForeground(new java.awt.Color(102, 102, 153));
        jTextArea1.setLineWrap(true);
        jTextArea1.setRows(4);
        jTextArea1.setText(SystemCatalogCustomizer_readOnly_text());
        jTextArea1.setWrapStyleWord(true);
        jTextArea1.setBorder(null);
        jTextArea1.setDisabledTextColor(javax.swing.UIManager.getColor ("Label.foreground"));
        jTextArea1.setEnabled(false);
        jTextArea1.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jTextArea1, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea jTextArea1;
    // End of variables declaration//GEN-END:variables


    public void setObject(final java.lang.Object peer) {
    }
    
    public void addPropertyChangeListener(final java.beans.PropertyChangeListener p1) {
    }
    
    public void removePropertyChangeListener(final java.beans.PropertyChangeListener p1) {
    }
}
