# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20231210185944;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            15(?:
              [0568]|
              31
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15(?:
            [0-25-9]\\d\\d|
            310
          )\\d{6}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"495344", "Lengede",
"492462", "Linnich",
"492587", "Ennigerloh\-Westkirchen",
"4935021", "Königstein\ Sächsische\ Schweiz",
"4935975", "Hohnstein",
"49531", "Braunschweig",
"496184", "Langenselbold",
"496722", "Rüdesheim\ am\ Rhein",
"493304", "Velten",
"494305", "Westensee",
"499495", "Breitenbrunn\ Oberpfalz",
"494877", "Hennstedt\ bei\ Itzehoe",
"4935601", "Peitz",
"494354", "Fleckeby",
"497725", "Königsfeld\ im\ Schwarzwald",
"495584", "Hattorf\ am\ Harz",
"499347", "Wittighausen",
"4933087", "Bredereiche",
"494961", "Papenburg",
"4989", "Munich",
"498785", "Rottenburg\-Oberroning",
"493774", "Schwarzenberg",
"494775", "Grossenwörden",
"499462", "Falkenstein\ Oberpfalz",
"4936924", "Mihla",
"499482", "Wörth\ an\ der\ Donau",
"499567", "Sesslach\-Gemünda",
"498765", "Bruckberg\ Niederbayern",
"4935387", "Seyda",
"492738", "Netphen",
"497194", "Spiegelberg",
"499326", "Markt\ Einersheim",
"4938294", "Neubukow",
"495564", "Dassel",
"4939741", "Jatznick",
"499738", "Rottershausen",
"4936209", "Klettbach",
"498867", "Rottenbuch\ Oberbayern",
"497150", "Korntal\-Münchingen",
"497553", "Salem\ Baden",
"494535", "Nahe",
"496164", "Reichelsheim\ Odenwald",
"4934925", "Bad\ Schmiedeberg",
"49355", "Cottbus",
"4934743", "Ermsleben",
"492567", "Ahaus\-Alstätte",
"492482", "Hellenthal",
"4940", "Hamburg",
"497442", "Baiersbronn",
"492353", "Halver",
"496445", "Schöffengrund",
"499179", "Freystadt",
"495295", "Lichtenau\ Westfalen",
"493421", "Torgau",
"495873", "Eimke",
"498061", "Bad\ Aibling",
"497367", "Aalen\-Ebnat",
"498586", "Hauzenberg",
"4937293", "Eppendorf\ Sachsen",
"495672", "Bad\ Karlshafen",
"496203", "Ladenburg",
"4936873", "Themar",
"4936783", "Gehren\ Thüringen",
"499353", "Karlstadt",
"496397", "Leimen\ Pfalz",
"498346", "Pforzen",
"496083", "Weilrod",
"495262", "Extertal",
"4939054", "Flechtingen",
"493493", "Bitterfeld",
"494328", "Rickling",
"497708", "Geisingen\-Leipferdingen",
"492866", "Dorsten\-Rhade",
"492171", "Leverkusen\-Opladen",
"498327", "Rettenberg",
"495282", "Schieder\-Schwalenberg",
"496063", "Bad\ König",
"497021", "Kirchheim\ unter\ Teck",
"495060", "Bodenburg",
"497387", "Hohenstein\ Württemberg",
"4939245", "Loburg",
"498081", "Dorfen\ Stadt",
"4938456", "Langhagen\ bei\ Güstrow",
"494736", "Butjadingen\-Tossens",
"499171", "Roth\ Mittelfranken",
"4938428", "Hohenkirchen\ bei\ Wismar",
"494609", "Eggebek",
"4938308", "Göhren\ Rügen",
"497146", "Remseck\ am\ Neckar",
"495655", "Wanfried",
"495604", "Grossalmerode",
"498035", "Raubling",
"492607", "Kobern\-Gondorf",
"49361", "Erfurt",
"496401", "Grünberg\ Hessen",
"493644", "Apolda",
"495425", "Borgholzhausen",
"494168", "Neu\ Wulmstorf\-Elstorf",
"4935245", "Burkhardswalde\-Munzig",
"499607", "Luhe\-Wildenau",
"498167", "Zolling",
"496864", "Mettlach",
"4939086", "Jävenitz",
"497947", "Forchtenberg",
"498403", "Pförring",
"4936208", "Ermstedt",
"499208", "Bindlach",
"499077", "Bachhagel",
"4938850", "Gammelin",
"496358", "Kriegsfeld",
"499088", "Mönchsdeggingen",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"498178", "Icking",
"494177", "Drage\ Elbe",
"494188", "Welle\ Nordheide",
"496409", "Biebertal",
"4936621", "Elsterberg\ bei\ Plauen",
"494976", "Spiekeroog",
"495074", "Rodewald",
"4938484", "Ventschow",
"492208", "Niederkassel",
"4935054", "Lauenstein\ Sachsen",
"497127", "Neckartenzlingen",
"498245", "Türkheim\ Wertach",
"495742", "Preussisch\ Oldendorf",
"492871", "Bocholt",
"492166", "Mönchengladbach\-Rheydt",
"496733", "Gau\-Odernheim",
"499225", "Stadtsteinach",
"496324", "Hassloch",
"498571", "Simbach\ am\ Inn",
"495351", "Helmstedt",
"494752", "Neuhaus\ Oste",
"4939387", "Havelberg",
"497953", "Blaufelden",
"494935", "Juist",
"495964", "Lähden",
"492225", "Meckenheim\ Rheinland",
"493372", "Jüterbog",
"499166", "Münchsteinach",
"499871", "Windsbach",
"49395", "Neubrandenburg",
"4939975", "Thürkow",
"498731", "Dingolfing",
"496573", "Gillenfeld",
"499186", "Lauterhofen\ Oberpfalz",
"4933764", "Mittenwalde\ Mark",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"4938309", "Trent",
"494206", "Stuhr\-Heiligenrode",
"495173", "Uetze",
"4938429", "Glasin",
"493448", "Meuselwitz\ Thüringen",
"4939601", "Friedland",
"498076", "Pfaffing",
"494561", "Neustadt\ in\ Holstein",
"498394", "Lautrach",
"499978", "Schönthal\ Oberpfalz",
"494349", "Dänischenhagen",
"4938752", "Zierzow\ bei\ Ludwigslust",
"4934322", "Rosswein",
"4937341", "Ehrenfriedersdorf",
"4933231", "Pausin",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"494488", "Westerstede",
"494477", "Lastrup\-Hemmelte",
"495945", "Wilsum",
"498562", "Triftern",
"495286", "Ottenstein\ Niedersachsen",
"497933", "Creglingen",
"494955", "Westoverledingen",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"492862", "Südlohn",
"497427", "Schömberg\ bei\ Balingen",
"496753", "Meisenheim",
"492663", "Westerburg\ Westerwald",
"494732", "Stadland\-Rodenkirchen",
"495509", "Rosdorf\ Kreis\ Göttingen",
"495331", "Wolfenbüttel",
"493361", "Fürstenwalde\ Spree",
"494740", "Loxstedt\-Dedesdorf",
"4938855", "Lübtheen",
"497657", "Eisenbach\ Hochschwarzwald",
"4933085", "Seilershof",
"496109", "Frankfurt\-Bergen\-Enkheim",
"492273", "Kerpen\-Horrem",
"4934294", "Rackwitz",
"4935385", "Annaburg",
"496101", "Bad\ Vilbel",
"493541", "Calau",
"497258", "Oberderdingen\-Flehingen",
"4935240", "Tauscha\ bei\ Grossenhain",
"493381", "Brandenburg\ an\ der\ Havel",
"496525", "Irrel",
"495339", "Gielde",
"497522", "Wangen\ im\ Allgäu",
"492683", "Asbach\ Westerwald",
"497446", "Lossburg",
"4938232", "Zingst\ Ostseebad",
"499683", "Friedenfels",
"4934927", "Globig\-Bleddin",
"498330", "Legau",
"495266", "Lemgo\-Kirchheide",
"498342", "Marktoberdorf",
"498582", "Röhrnbach",
"498467", "Kinding",
"495676", "Liebenau\ Hessen",
"498751", "Mainburg",
"494468", "Friedeburg\-Reepsholt",
"4933878", "Nennhausen",
"492903", "Meschede\-Freienohl",
"495473", "Ostercappeln",
"496508", "Hetzerath\ Mosel",
"497224", "Gernsbach",
"493821", "Ribnitz\-Damgarten",
"497842", "Kappelrodeck",
"4935478", "Goyatz",
"495108", "Gehrden\ Han",
"497643", "Herbolzheim\ Breisgau",
"498284", "Ziemetshausen",
"498055", "Halfing",
"4933361", "Joachimsthal",
"492486", "Nettersheim",
"494274", "Varrel\ bei\ Sulingen",
"494664", "Neukirchen\ bei\ Niebüll",
"496747", "Emmelshausen",
"499903", "Schöllnach",
"4933832", "Rogäsen",
"495635", "Vöhl",
"493685", "Hildburghausen",
"493928", "Schönebeck\ Elbe",
"4933976", "Wutike",
"4933632", "Hangelsberg",
"496726", "Lorch\ Rheingau",
"4936379", "Holzengel",
"494684", "Langeness\ Hallig",
"4935268", "Stauchitz",
"4936964", "Dermbach\ Rhön",
"499466", "Stamsried",
"4939202", "Gross\ Ammensleben",
"4933433", "Buckow\ Märkische\ Schweiz",
"4939247", "Güterglück",
"496338", "Hornbach\ Pfalz",
"4933678", "Storkow\ Mark",
"499724", "Stadtlauringen",
"498072", "Haag\ in\ Oberbayern",
"499333", "Sommerhausen",
"495825", "Wieren",
"494202", "Achim\ bei\ Bremen",
"493528", "Radeberg",
"4939344", "Güsen",
"4934920", "Kropstädt",
"494260", "Visselhövede\-Wittorf",
"499182", "Velburg",
"4939061", "Weferlingen",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"4937604", "Mosel",
"4935202", "Klingenberg\ Sachsen",
"492182", "Grevenbroich\-Kapellen",
"4934362", "Mügeln\ bei\ Oschatz",
"497620", "Schopfheim\-Gersbach",
"495271", "Höxter",
"496464", "Angelburg",
"4939268", "Egeln",
"495661", "Melsungen",
"493631", "Nordhausen\ Thüringen",
"4935247", "Zehren\ Sachsen",
"492333", "Ennepetal",
"492724", "Finnentrop\-Serkenrode",
"499195", "Adelsdorf\ Mittelfranken",
"494756", "Odisheim",
"495681", "Homberg\ Efze",
"496484", "Beselich",
"498803", "Peissenberg",
"495746", "Rödinghausen",
"492162", "Viersen",
"499162", "Scheinfeld",
"499503", "Oberhaid\ Oberfranken",
"4933203", "Kleinmachnow",
"492195", "Radevormwald",
"496809", "Grossrosseln",
"496267", "Fahrenbach\ Baden",
"493941", "Halberstadt",
"494791", "Osterholz\-Scharmbeck",
"497773", "Bodman\-Ludwigshafen",
"495901", "Fürstenau\ bei\ Bramsche",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"492471", "Roetgen\ Eifel",
"496677", "Neuenstein\ Hessen",
"493335", "Finowfurt",
"499471", "Burglengenfeld",
"495365", "Wolfsburg\-Neindorf",
"494334", "Bredenbek\ bei\ Rendsburg",
"494723", "Cuxhaven\-Altenwalde",
"497303", "Illertissen",
"494972", "Langeoog",
"495545", "Hedemünden",
"4933679", "Wendisch\ Rietz",
"4939977", "Jördenstorf",
"496145", "Flörsheim\ am\ Main",
"497142", "Bietigheim\-Bissingen",
"497533", "Allensbach",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"495808", "Gerdau",
"497130", "Löwenstein\ Württemberg",
"4936332", "Ellrich",
"494504", "Ratekau",
"495909", "Wettrup",
"496668", "Birstein\-Lichenroth",
"49871", "Landshut",
"492758", "Bad\ Berleburg\-Girkhausen",
"4936378", "Ostramondra",
"4938322", "Richtenberg",
"498744", "Gerzen",
"4934445", "Stössen",
"493949", "Oschersleben\ Bode",
"496007", "Rosbach\-Rodheim",
"496287", "Limbach\ Baden",
"494124", "Glückstadt",
"495541", "Hann\.\ Münden",
"4938727", "Mestlin",
"4938355", "Züssow",
"493501", "Pirna",
"498772", "Mallersdorf\-Pfaffenberg",
"494551", "Bad\ Segeberg",
"495381", "Seesen",
"4936203", "Vieselbach",
"497174", "Mögglingen",
"495236", "Blomberg\-Grossenmarpe",
"498302", "Görisried",
"495027", "Linsburg",
"4936737", "Drognitz",
"49491", "Leer\ Ostfriesland",
"494795", "Garlstedt",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"498143", "Inning\ am\ Ammersee",
"498532", "Griesbach\ im\ Rottal",
"492957", "Wünnenberg\-Haaren",
"494944", "Wiesmoor",
"499633", "Mitterteich",
"495954", "Lorup",
"495905", "Beesten",
"492832", "Kevelaer",
"498380", "Achberg",
"497963", "Adelmannsfelden",
"494762", "Kutenholz",
"495361", "Wolfsburg",
"493331", "Angermünde",
"499832", "Wassertrüdingen",
"494559", "Wensin",
"492633", "Brohl\-Lützing",
"4935775", "Pechern",
"492156", "Willich\-Anrath",
"4937430", "Eichigt",
"492598", "Senden\-Ottmarsbocholt",
"499191", "Forchheim\ Oberfranken",
"4934221", "Schildau\ Gneisenaustadt",
"495685", "Knüllwald",
"4933332", "Gartz\ Oder",
"498234", "Bobingen",
"4934906", "Raguhn",
"492520", "Wadersloh\-Diestedde",
"492436", "Wegberg\-Rödgen",
"4939223", "Theessen",
"4937207", "Hainichen\ Sachsen",
"497073", "Ammerbuch",
"499123", "Lauf\ an\ der\ Pegnitz",
"499436", "Nittenau",
"495829", "Wriedel",
"492191", "Remscheid",
"495148", "Steinhorst\ Niedersachsen",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"497802", "Oberkirch\ Baden",
"495821", "Bad\ Bevensen",
"496805", "Kleinblittersdorf",
"496854", "Oberthal\ Saar",
"495692", "Wolfhagen",
"498157", "Feldafing",
"492943", "Erwitte",
"494158", "Roseburg",
"499943", "Lam\ Oberpfalz",
"496707", "Windesheim",
"49465", "Sylt",
"495275", "Höxter\-Ottbergen",
"492058", "Wülfrath",
"499199", "Kunreuth",
"4935844", "Oybin\ Kurort",
"493635", "Kölleda",
"495665", "Guxhagen",
"494634", "Husby",
"4935032", "Langenhennersdorf",
"493681", "Suhl",
"499856", "Dürrwangen",
"495706", "Porta\ Westfalica",
"492383", "Bönen",
"4937437", "Bad\ Elster",
"492132", "Meerbusch\-Büderich",
"492543", "Billerbeck\ Westfalen",
"496849", "Kirkel",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"498556", "Haidmühle",
"499543", "Hirschaid",
"499132", "Herzogenaurach",
"499383", "Wiesentheid",
"499097", "Marxheim",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"496053", "Wächtersbach",
"492856", "Hamminkeln\-Brünen",
"498630", "Oberneukirchen",
"498642", "Übersee",
"494824", "Krempe",
"495528", "Gieboldehausen",
"495252", "Bad\ Lippspringe",
"499363", "Arnstein\ Unterfranken",
"4934496", "Nöbdenitz",
"496128", "Taunusstein",
"494230", "Verden\-Walle",
"496841", "Homburg\ Saar",
"494242", "Syke",
"4936730", "Sitzendorf",
"4934463", "Bad\ Kösen",
"497357", "Attenweiler",
"499920", "Bischofsmais",
"4936085", "Reinholterode",
"498051", "Prien\ am\ Chiemsee",
"496434", "Bad\ Camberg",
"4938720", "Grebbin",
"493727", "Mittweida",
"492363", "Datteln",
"495631", "Korbach",
"493661", "Greiz",
"495848", "Trebel",
"494544", "Berkenthin",
"492557", "Wettringen\ Kreis\ Steinfurt",
"495121", "Hildesheim",
"4934609", "Salzmünde",
"496105", "Mörfelden\-Walldorf",
"49451", "Lübeck",
"496154", "Ober\-Ramstadt",
"498374", "Dietmannsried",
"493385", "Rathenow",
"497563", "Kisslegg",
"498857", "Benediktbeuern",
"4938423", "Bad\ Kleinen",
"495505", "Hardegsen",
"494858", "Sankt\ Margarethen\ Holstein",
"494384", "Selent",
"4938303", "Sellin\ Ostseebad",
"495554", "Moringen",
"494959", "Dollart",
"496047", "Altenstadt\ Hessen",
"496638", "Schwalmtal\-Renzendorf",
"493909", "Klötze\ Altmark",
"495193", "Schneverdingen",
"498704", "Altdorf\-Pfettrach",
"4933964", "Fretzdorf",
"4939885", "Jakobshagen",
"496593", "Hillesheim\ Eifel",
"496190", "Hattersheim\ am\ Main",
"4936255", "Goldbach\ bei\ Gotha",
"4939775", "Ahlbeck\ bei\ Torgelow",
"499452", "Langquaid",
"4937298", "Oelsnitz\ Erzgebirge",
"495941", "Neuenhaus\ Dinkel",
"496237", "Maxdorf",
"4936878", "Oberland",
"499622", "Hirschau\ Oberpfalz",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"494951", "Weener",
"492823", "Goch",
"496026", "Grossostheim",
"493901", "Salzwedel",
"494364", "Dahme\ Kreis\ Ostholstein",
"498591", "Obernzell",
"499823", "Leutershausen",
"497583", "Bad\ Schussenried",
"495335", "Schladen",
"492622", "Bendorf\ am\ Rhein",
"495129", "Söhlde",
"497343", "Buch\ bei\ Illertissen",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"492452", "Heinsberg\ Rheinland",
"498735", "Gangkofen\-Kollbach",
"495696", "Bad\ Arolsen\-Landau",
"496428", "Stadtallendorf",
"4938725", "Gross\ Godems",
"494939", "Baltrum",
"4933208", "Fahrland",
"496658", "Poppenhausen\ Wasserkuppe",
"497806", "Bad\ Peterstal\-Griesbach",
"499229", "Mainleus",
"494838", "Tellingstedt",
"493564", "Schwarze\ Pumpe",
"495534", "Eschershausen\ an\ der\ Lenne",
"4936735", "Probstzella",
"496134", "Mainz\-Kastel",
"492293", "Nümbrecht",
"4938792", "Lenzen\ \(Elbe\)",
"49331", "Potsdam",
"492307", "Kamen",
"492432", "Wassenberg",
"493344", "Bad\ Freienwalde",
"4939263", "Unseburg",
"492440", "Nettersheim\-Tondorf",
"4934261", "Kühren\ bei\ Wurzen",
"499221", "Kulmbach",
"495355", "Frellstedt",
"499777", "Ostheim\ von\ der\ Rhön",
"495304", "Meine",
"4939296", "Welsleben",
"494931", "Norden",
"492777", "Breitscheid\ Hessen",
"499307", "Altertheim",
"494497", "Barssel\-Harkebrügge",
"499875", "Wolframs\-Eschenbach",
"495774", "Wagenfeld\-Ströhen",
"499293", "Berg\ Oberfranken",
"496257", "Seeheim\-Jugenheim",
"496033", "Butzbach",
"4936373", "Buttstädt",
"492836", "Wachtendonk",
"498650", "Marktschellenberg",
"495042", "Bad\ Münder\ am\ Deister",
"4938221", "Marlow",
"497748", "Grafenhausen\ Hochschwarzwald",
"4936764", "Neuhaus\-Schierschnitz",
"499152", "Hartenstein\ Mittelfranken",
"498536", "Kösslarn",
"492152", "Kempen",
"498039", "Rott\ am\ Inn",
"4936072", "Weissenborn\-Lüderode",
"495429", "Melle\-Wellingholzhausen",
"499836", "Gunzenhausen\-Cronheim",
"4933394", "Blumberg\ Kreis\ Barnim",
"494766", "Basdahl",
"495659", "Ringgau",
"498241", "Buchloe",
"4933439", "Fredersdorf\-Vogelsdorf",
"496624", "Heringen\ Werra",
"495651", "Eschwege",
"498249", "Ettringen\ Wertach",
"496454", "Lichtenfels\-Sachsenberg",
"498031", "Rosenheim\ Oberbayern",
"497337", "Nellingen\ Alb",
"496405", "Laubach\ Hessen",
"494294", "Riede\ Kreis\ Verden",
"494641", "Süderbrarup",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"497402", "Fluorn\-Winzeln",
"4939454", "Elbingerode\ Harz",
"493672", "Rudolstadt",
"498306", "Ronsberg",
"496243", "Monsheim",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"495232", "Lage\ Lippe",
"496022", "Obernburg\ am\ Main",
"4937435", "Reuth\ bei\ Plauen",
"492175", "Leichlingen\ Rheinland",
"499626", "Hohenburg",
"497025", "Neuffen",
"4934346", "Narsdorf",
"4938331", "Rakow\ Vorpom",
"498443", "Hohenwart\ Paar",
"498205", "Dasing",
"498254", "Altomünster",
"492456", "Selfkant",
"498085", "Sankt\ Wolfgang",
"4935454", "Uckro",
"492248", "Hennef\-Uckerath",
"492626", "Selters\ Westferwald",
"499175", "Spalt",
"4933209", "Caputh",
"496449", "Ehringshausen\-Katzenfurt",
"492647", "Kesseling",
"4933654", "Fünfeichen",
"496441", "Wetzlar",
"494605", "Medelby",
"493425", "Wurzen",
"495644", "Willebadessen\-Peckelsheim",
"498065", "Tuntenhausen\-Schönau",
"49561", "Kassel",
"498137", "Petershausen",
"496220", "Wilhelmsfeld",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"4933924", "Rägelin",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"499647", "Kirchenthumbach",
"4936087", "Wüstheuterode",
"497474", "Haigerloch",
"496834", "Bous",
"498092", "Grafing\ bei\ München",
"495223", "Bünde",
"4935263", "Gröditz\ bei\ Riesa",
"494458", "Wiefelstede\-Spohle",
"496298", "Möckmühl",
"4934423", "Heuckewalde",
"498761", "Moosburg\ an\ der\ Isar",
"498457", "Vohburg\ an\ der\ Donau",
"494779", "Freiburg\ Elbe",
"49202", "Wuppertal",
"494246", "Twistringen\-Heiligenloh",
"4933438", "Altlandsberg",
"493984", "Prenzlau",
"4939421", "Osterwieck",
"495448", "Barver",
"4933673", "Weichensdorf",
"496783", "Baumholder",
"4939887", "Gerswalde",
"497729", "Tennenbronn",
"4933472", "Golzow\ bei\ Seelow",
"499499", "Painten",
"494531", "Bad\ Oldesloe",
"4939777", "Borkenfriede",
"4936694", "Schkölen\ Thüringen",
"497268", "Bad\ Rappenau\-Obergimpern",
"4936257", "Luisenthal\ Thüringen",
"4935872", "Neusalza\-Spremberg",
"4937464", "Schöneck\ Vogtland",
"499937", "Oberpöring",
"4935936", "Sohland\ Spree",
"492423", "Langerwehe",
"497667", "Breisach\ am\ Rhein",
"4933989", "Sadenbeck",
"497277", "Wörth\-Büchelberg",
"499491", "Hemau",
"494539", "Westerau",
"496763", "Kirchberg\ Hunsrück",
"492653", "Kaisersesch",
"495702", "Petershagen\-Lahde",
"499852", "Feuchtwangen",
"497721", "Villingen\ im\ Schwarzwald",
"4933873", "Grosswudicke",
"492852", "Hamminkeln",
"499653", "Eslarn",
"496697", "Willingshausen",
"495934", "Haren\-Rütenbrock",
"493964", "Bredenfelde\ bei\ Strasburg",
"4937382", "Geringswalde",
"494965", "Surwold",
"498552", "Grafenau\ Niederbayern",
"499423", "Geiselhöring",
"498781", "Rottenburg\ an\ der\ Laaber",
"494771", "Hemmoor",
"492937", "Arnsberg\-Oeventrop",
"495372", "Meinersen",
"4935473", "Neu\ Lübbenau",
"499642", "Kemnath\ Stadt",
"492843", "Rheinberg",
"496046", "Ortenberg\ Hessen",
"498383", "Grünenbach\ Allgäu",
"497391", "Ehingen\ Donau",
"499198", "Heiligenstadt\ in\ Oberfranken",
"499556", "Geiselwind",
"498543", "Aidenbach",
"495921", "Nordhorn",
"4933974", "Dessow",
"497323", "Gerstetten",
"495149", "Wienhausen",
"497734", "Gailingen",
"496361", "Rockenhausen",
"494703", "Loxstedt\-Donnern",
"492556", "Metelen",
"4937320", "Mulda\ Sachsen",
"4933369", "Oderberg",
"499843", "Burgbernheim",
"498856", "Penzberg",
"4936966", "Kaltennordheim",
"492630", "Mülheim\-Kärlich",
"494159", "Basthorst",
"492642", "Remagen",
"496541", "Traben\-Trarbach",
"494151", "Schwarzenbek",
"4938223", "Saal\ Vorpom",
"494524", "Scharbeutz\-Pönitz",
"495828", "Himbergen",
"495141", "Celle",
"4936371", "Schlossvippach",
"496381", "Kusel",
"493525", "Riesa",
"492051", "Velbert",
"496236", "Neuhofen\ Pfalz",
"4936742", "Uhlstädt",
"496027", "Stockstadt\ am\ Main",
"498363", "Pfronten",
"497574", "Gammertingen",
"498557", "Mauth",
"494222", "Ganderkesee",
"496821", "Neunkirchen\ Saar",
"495377", "Ehra\-Lessien",
"492932", "Neheim\-Hüsten",
"495805", "Oetzen",
"494558", "Todesfelde",
"499704", "Euerdorf",
"495854", "Bleckede\-Barskamp",
"4934263", "Hohburg",
"494844", "Pellworm",
"496692", "Neustadt\ Hessen",
"492374", "Iserlohn\-Letmathe",
"492857", "Rees\-Mehr",
"4935895", "Klitten",
"4935952", "Grossröhrsdorf\ OL",
"49481", "Heide\ Holstein",
"4934296", "Groitzsch\ bei\ Pegau",
"492599", "Ascheberg\-Herbern",
"497272", "Rülzheim",
"494431", "Wildeshausen",
"495707", "Petershagen\ Weser",
"499857", "Schopfloch\ Mittelfranken",
"496893", "Saarbrücken\-Ensheim",
"499374", "Eschau",
"496275", "Rothenberg\ Odenwald",
"4936640", "Remptendorf",
"499932", "Osterhofen",
"496665", "Sinntal\-Altengronau",
"492755", "Bad\ Berleburg\-Schwarzenau",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"4934782", "Mansfeld\ Südharz",
"4935822", "Hagenwerder",
"493726", "Flöha",
"497682", "Elzach",
"492523", "Wadersloh",
"4934672", "Rossleben",
"497356", "Schemmerhofen",
"4936840", "Trusetal",
"498823", "Mittenwald",
"4939727", "Spantekow",
"492591", "Lüdinghausen",
"4935695", "Simmersdorf",
"498622", "Tacherting\-Peterskirchen",
"493338", "Bernau\ Brandenburg",
"495368", "Parsau",
"499523", "Hofheim\ in\ Unterfranken",
"499120", "Leinburg",
"498452", "Geisenfeld",
"4934638", "Zöschen",
"497204", "Malsch\-Völkersbach",
"494233", "Blender",
"497084", "Schömberg\ bei\ Neuenbürg",
"497255", "Graben\-Neudorf",
"494851", "Marne",
"496252", "Heppenheim\ Bergstrasse",
"492923", "Lippetal\-Herzfeld",
"494492", "Saterland",
"499302", "Rottendorf\ Unterfranken",
"4939822", "Kratzeburg",
"495128", "Hohenhameln",
"492772", "Herborn\ Hessen",
"495841", "Lüchow\ Wendland",
"4935727", "Burghammer",
"4933368", "Hohensaaten",
"499360", "Thüngen",
"4935471", "Birkenhainchen",
"492360", "Haltern\-Lippramsdorf",
"495434", "Essen\ Oldenburg",
"493464", "Sangerhausen",
"492991", "Marsberg\-Bredelar",
"494465", "Friedeburg\ Ostfriesland",
"499772", "Bischofsheim\ an\ der\ Rhön",
"498024", "Holzkirchen",
"492302", "Witten",
"499923", "Teisnach",
"496631", "Alsfeld",
"494958", "Jemgum",
"4933671", "Lieberose",
"4937755", "Schönheide\ Erzgebirge",
"4937327", "Rechenberg\-Bienenmühle",
"4939423", "Wegeleben",
"492532", "Ostbevern",
"496706", "Wallhausen\ Nahe",
"496639", "Ottrau",
"496094", "Weibersbrunn",
"494485", "Elsfleth\-Huntorf",
"4939952", "Grammentin",
"495948", "Itterbeck",
"4933055", "Kremmen",
"496050", "Biebergemünd",
"495849", "Waddeweitz",
"4939002", "Oebisfelde",
"498633", "Tüssling",
"495053", "Fassberg\-Müden",
"499143", "Pappenheim\ Mittelfranken",
"499532", "Maroldsweisach",
"494859", "Windbergen",
"4937365", "Sayda",
"495237", "Augustdorf",
"493677", "Ilmenau\ Thüringen",
"492234", "Frechen",
"493925", "Stassfurt",
"498123", "Moosinning",
"495026", "Steimbke",
"494924", "Moormerland\-Oldersum",
"4938461", "Bützow",
"495529", "Rhumspringe",
"497332", "Lauterstein",
"497340", "Neenstetten",
"4936847", "Steinbach\-Hallenberg",
"496335", "Trulben",
"499234", "Neusorg",
"496129", "Schlangenbad",
"498191", "Landsberg\ am\ Lech",
"497974", "Bühlerzell",
"497183", "Rudersberg\ Württemberg",
"499820", "Lehrberg",
"496848", "Homburg\-Einöd",
"4936602", "Ronneburg\ Thüringen",
"497163", "Ebersbach\ an\ der\ Fils",
"4938333", "Horst\ bei\ Grimmen",
"495105", "Barsinghausen",
"495154", "Aerzen",
"4934639", "Wallendorf\ Luppe",
"494144", "Himmelpforten",
"4936022", "Grossengottern",
"497502", "Wolpertswende",
"492157", "Nettetal\-Kaldenkirchen",
"4939346", "Tucheim",
"495521", "Herzberg\ am\ Harz",
"499956", "Eichendorf\-Aufhausen",
"496505", "Kordel",
"4936647", "Saalburg\ Thüringen",
"496554", "Waxweiler",
"4938844", "Gülze",
"499157", "Alfeld\ Mittelfranken",
"49201", "Essen",
"495593", "Bovenden\-Lenglern",
"495190", "Soltau\-Emmingen",
"4937606", "Lengenfeld\ Vogtland",
"493973", "Pasewalk",
"494185", "Marxen\ Auetal",
"497741", "Tiengen\ Hochrhein",
"497352", "Ochsenhausen",
"499085", "Alerheim",
"496355", "Albisheim\ Pfrimm",
"492443", "Mechernich",
"493722", "Limbach\-Oberfrohna",
"499254", "Gefrees",
"496304", "Wolfstein\ Pfalz",
"499205", "Vorbach",
"492205", "Rösrath",
"494247", "Affinghausen",
"492254", "Weilerswist",
"498456", "Lenting",
"499443", "Abensberg",
"498248", "Lamerdingen",
"4938454", "Kritzkow",
"496774", "Kaub",
"495257", "Hövelhof",
"4937348", "Oberwiesenthal\ Kurort",
"499092", "Wemding",
"4933238", "Senzke",
"498038", "Vogtareuth",
"4939221", "Möckern\ bei\ Magdeburg",
"496696", "Gilserberg",
"495428", "Melle\-Neuenkirchen",
"494192", "Bad\ Bramstedt",
"4934223", "Dommitzsch",
"492065", "Duisburg\-Rheinhausen",
"495658", "Wehretal",
"492137", "Neuss\-Norf",
"497666", "Denzlingen",
"4939056", "Klüden",
"4939608", "Staven",
"496534", "Mülheim\ Mosel",
"499936", "Wallerfing",
"494165", "Hollenstedt\ Nordheide",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"495624", "Bad\ Emstal",
"49441", "Oldenburg",
"4938296", "Rerik\ Ostseebad",
"493445", "Naumburg\ Saale",
"492761", "Olpe\ Biggesee",
"496651", "Rasdorf",
"4935609", "Drachhausen",
"494444", "Goldenstedt",
"495454", "Hörstel\-Riesenbeck",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"496421", "Marburg",
"492975", "Schmallenberg\-Oberkirchen",
"492627", "Braubach",
"497463", "Mühlheim\ an\ der\ Donau",
"4938782", "Reetz\ bei\ Perleberg",
"4938872", "Rehna",
"499627", "Freudenberg\ Oberpfalz",
"499975", "Waldmünchen\-Geigant",
"494253", "Asendorf\ Kreis\ Diepholz",
"497235", "Unterreichenbach\ Kreis\ Calw",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"496232", "Speyer",
"495033", "Wunstorf\-Grossenheidorn",
"497906", "Braunsbach",
"499228", "Thurnau",
"494839", "Wöhrden\ Dithmarschen",
"498423", "Titting",
"499552", "Burghaslach",
"498136", "Markt\ Indersdorf",
"496042", "Büdingen\ Hessen",
"4936628", "Zeulenroda",
"499646", "Freihung",
"497045", "Oberderdingen",
"497483", "Horb\-Mühringen",
"4936926", "Creuzburg",
"492646", "Königsfeld\ Eifel",
"496429", "Schweinsberg\ Hessen",
"492552", "Steinfurt\-Borghorst",
"4937360", "Olbernhau",
"494938", "Hagermarsch",
"4939749", "Grambow\ bei\ Pasewalk",
"4935697", "Bagenz",
"492228", "Remagen\-Rolandseck",
"4936201", "Walschleben",
"496659", "Eichenzell",
"492735", "Neunkirchen\ Siegerl",
"499952", "Eichendorf",
"4935725", "Wittichenau",
"494621", "Schleswig",
"495441", "Diepholz",
"497506", "Wangen\-Leupolz",
"496644", "Grebenhain",
"496291", "Adelsheim",
"494892", "Schenefeld\ Mittelholstein",
"4933766", "Teupitz",
"494767", "Bremervörde\-Bevern",
"494451", "Varel\ Jadebusen",
"4936450", "Kranichfeld",
"49661", "Fulda",
"499837", "Haundorf",
"497671", "Todtnau",
"492837", "Weeze",
"498537", "Bad\ Füssing\-Aigen",
"494865", "Osterhever",
"495834", "Wittingen\-Knesebeck",
"497261", "Sinsheim",
"496223", "Neckargemünd",
"499735", "Massbach",
"492952", "Rüthen",
"498293", "Welden\ bei\ Augsburg",
"495022", "Wietzen",
"4938301", "Putbus",
"498432", "Burgheim",
"494885", "Bergenhusen",
"497728", "Niedereschach",
"499498", "Laaber",
"497269", "Sulzfeld\ Baden",
"494308", "Schwedeneck",
"4937757", "Rittersgrün",
"4937325", "Niederbobritzsch",
"4935792", "Ossling",
"492575", "Greven\-Reckenfeld",
"499575", "Weismain",
"4933239", "Gross\ Behnitz",
"498221", "Günzburg",
"494778", "Wingst",
"4937349", "Scheibenberg",
"497336", "Lonsee",
"4934775", "Wippra",
"499241", "Pegnitz",
"4934461", "Nebra\ Unstrut",
"494139", "Hohnstorf\ Elbe",
"497705", "Wolterdingen\ Schwarzw",
"497754", "Görwihl",
"4937367", "Lengefeld\ Erzgebirge",
"493733", "Annaberg\-Buchholz",
"495763", "Uchte",
"492536", "Münster\-Albachten",
"499420", "Feldkirchen\ Niederbayern",
"499536", "Kirchlauter",
"498152", "Herrsching\ am\ Ammersee",
"4935608", "Gross\ Ossnig",
"4935056", "Altenberg\ Sachsen",
"4938486", "Gustävel",
"497375", "Obermarchtal",
"497807", "Neuried\ Ortenaukreis",
"4936845", "Gehlberg",
"4935028", "Krippen",
"492694", "Wershofen",
"496372", "Bruchmühlbach\-Miesau",
"492241", "Siegburg",
"492776", "Bad\ Endbach\-Hartenrod",
"4936645", "Mühltroff",
"493573", "Senftenberg",
"496256", "Lampertheim\-Hüttenfeld",
"499306", "Kist",
"4939862", "Schmölln\ bei\ Prenzlau",
"494496", "Friesoythe\-Markhausen",
"4939748", "Viereck",
"492306", "Lünen",
"4939084", "Lindstedt",
"499776", "Mellrichstadt",
"494131", "Lüneburg",
"4938229", "Bad\ Sülze",
"49228", "Bonn",
"499167", "Oberscheinfeld",
"4939390", "Iden",
"494608", "Handewitt",
"494329", "Langwedel\ Holstein",
"496564", "Neuerburg\ Eifel",
"497709", "Wutach",
"499966", "Wiesenfelden",
"4939428", "Pabstorf",
"497636", "Münstertal\ Schwarzwald",
"4935362", "Schönewalde\ bei\ Herzberg",
"4934202", "Delitzsch",
"495164", "Hodenhagen",
"4939456", "Altenbrak",
"497153", "Plochingen",
"494135", "Kirchgellersen",
"496344", "Schwegenheim",
"499245", "Obertrubach",
"492403", "Eschweiler\ Rheinland",
"4936766", "Schalkau",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"495184", "Freden\ Leine",
"49631", "Kaiserslautern",
"495722", "Bückeburg",
"494321", "Neumünster",
"496584", "Wellen\ Mosel",
"4933396", "Klosterfelde",
"499187", "Altdorf\ bei\ Nürnberg",
"499178", "Abenberg\ Mittelfranken",
"497371", "Riedlingen\ Württemberg",
"498208", "Eurasburg\ bei\ Augsburg",
"494393", "Boostedt",
"4933363", "Altenhof\ Kreis\ Barnim",
"499403", "Donaustauf",
"492245", "Much",
"494207", "Oyten",
"4939294", "Gross\ Rosenburg",
"497054", "Wildberg\ Württemberg",
"498166", "Allershausen\ Oberbayern",
"499606", "Pfreimd",
"496282", "Walldürn",
"494881", "Friedrichstadt",
"495063", "Bad\ Salzdetfurth",
"496002", "Ober\-Mörlen",
"4938372", "Usedom",
"492571", "Greven\ Westfalen",
"497946", "Bretzfeld",
"4939927", "Nossentiner\ Hütte",
"499571", "Lichtenfels\ Bayern",
"497147", "Sachsenheim\ Württemberg",
"498225", "Jettingen\-Scheppach",
"492739", "Wilnsdorf",
"492606", "Winningen\ Mosel",
"494968", "Neulehe",
"494625", "Jübek",
"494977", "Blomberg\ Ostfriesland",
"495445", "Drebber",
"493624", "Ohrdruf",
"497126", "Burladingen\-Melchingen",
"494404", "Elsfleth",
"496295", "Rosenberg\ Baden",
"499394", "Esselbach",
"496873", "Nonnweiler",
"494455", "Jade\-Schweiburg",
"497433", "Balingen",
"4939934", "Gross\ Plasten",
"499350", "Eussenheim\-Hundsbach",
"497675", "Bernau\ Baden",
"4933845", "Borkheide",
"499076", "Wittislingen",
"4935752", "Ruhland",
"492394", "Neuenrade\-Affeln",
"496672", "Eiterfeld",
"495203", "Werther\ Westfalen",
"495083", "Hohne\ bei\ Celle",
"496262", "Aglasterhausen",
"494176", "Marschacht",
"494861", "Tönning",
"497265", "Angelbachtal",
"4939857", "Drense",
"498462", "Berching",
"495358", "Bahrdorf\-Mackendorf",
"4934977", "Quellendorf",
"494348", "Schönkirchen",
"4935934", "Grossdubrau",
"496396", "Hinterweidenthal",
"498347", "Friesenried",
"497041", "Mühlacker",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"4939752", "Blumenhagen\ bei\ Strasburg",
"4938228", "Dettmannsdorf\-Kölzow",
"497527", "Wolfegg",
"496074", "Rödermark",
"4933457", "Altreetz",
"497366", "Abtsgmünd",
"493441", "Zeitz",
"497652", "Hinterzarten",
"4933981", "Putlitz",
"496655", "Neuhof\ Kreis\ Fulda",
"497386", "Hayingen",
"4934385", "Mutzschen",
"497546", "Oberteuringen",
"4936462", "Ossmannstedt",
"499867", "Geslau",
"497422", "Schramberg",
"495401", "Georgsmarienhütte",
"496425", "Rauschenberg\ Hessen",
"492971", "Schmallenberg\-Dorlar",
"494737", "Stadland\-Schwei",
"499971", "Cham",
"498326", "Fischen\ im\ Allgäu",
"49385", "Schwerin",
"492867", "Heiden\ Kreis\ Borken",
"493834", "Greifswald",
"497231", "Pforzheim",
"495864", "Jameln",
"494472", "Lastrup",
"499765", "Trappstadt",
"497853", "Kehl\-Bodersweier",
"494835", "Albersdorf\ Holstein",
"4939397", "Geestgottberg",
"496408", "Buseck",
"495573", "Uslar\-Volpriehausen",
"499346", "Grünsfeld",
"497826", "Schuttertal",
"496173", "Kronberg\ im\ Taunus",
"4933656", "Bahro",
"4934633", "Braunsbedra",
"4933201", "Gross\ Glienicke",
"499209", "Emtmannsberg",
"492586", "Beelen",
"496359", "Grünstadt",
"499089", "Bissingen\-Unterringingen",
"4933926", "Herzberg\ Mark",
"4939484", "Harzgerode",
"498179", "Eurasburg\ an\ der\ Loisach",
"494876", "Reher\ Holstein",
"494161", "Buxtehude",
"494189", "Undeloh",
"496742", "Boppard",
"494169", "Sauensiek",
"498171", "Wolfratshausen",
"494181", "Buchholz\ in\ der\ Nordheide",
"492327", "Bochum\-Wattenscheid",
"4934344", "Kohren\-Sahlis",
"497745", "Jestetten",
"493763", "Glauchau",
"495733", "Vlotho",
"495324", "Vienenburg",
"492566", "Legden",
"496351", "Eisenberg\ Pfalz",
"499081", "Nördlingen",
"499201", "Gesees",
"4939362", "Grieben\ bei\ Tangerhütte",
"499566", "Meeder",
"497950", "Schnelldorf",
"4935456", "Terpt",
"4939831", "Feldberg",
"495101", "Pattensen",
"497122", "St\ Johann\ Württemberg",
"492680", "Mündersbach",
"495525", "Walkenried",
"496501", "Konz",
"496339", "Grosssteinhausen",
"496266", "Hassmersheim",
"494172", "Salzhausen",
"4938202", "Volkenshagen",
"496676", "Hohenroda\ Hessen",
"498333", "Babenhausen\ Schwaben",
"498724", "Massing",
"499072", "Lauingen\ Donau",
"497930", "Boxberg\ Baden",
"497942", "Neuenstein\ Württemberg",
"498503", "Neuhaus\ am\ Inn",
"4934904", "Oranienbaum",
"493921", "Burg\ bei\ Magdeburg",
"496286", "Walldürn\-Rippberg",
"499270", "Creussen",
"492803", "Wesel\-Büderich",
"499602", "Neustadt\ an\ der\ Waldnaab",
"492602", "Montabaur",
"499803", "Colmberg",
"495753", "Auetal\-Bernsen",
"497764", "Herrischried",
"4936781", "Grossbreitenbach",
"496509", "Büdlich",
"4936871", "Bad\ Colberg\-Heldburg",
"496331", "Pirmasens",
"4937291", "Augustusburg",
"494743", "Langen\ bei\ Bremerhaven",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"495109", "Ronnenberg",
"495726", "Wiedensahl",
"4933602", "Alt\ Zeschdorf",
"494481", "Hatten\-Sandkrug",
"494469", "Wangerooge",
"4938736", "Goldberg",
"4934741", "Frose",
"497259", "Östringen\-Odenheim",
"4939925", "Wredenhagen",
"4939743", "Zerrenthin",
"492982", "Medebach",
"492962", "Olsberg",
"493377", "Zossen\ Brandenburg",
"497251", "Bruchsal",
"4935603", "Burg\ Spreewald",
"497833", "Hornberg\ Schwarzwaldbahn",
"494855", "Eddelak",
"496473", "Leun",
"495508", "Gleichen\-Rittmarshausen",
"494804", "Nordhastedt",
"499744", "Zeitlofs\-Detter",
"4935023", "Bad\ Gottleuba",
"495845", "Bergen\ Dumme",
"49971", "Bad\ Kissingen",
"496108", "Mühlheim\ am\ Main",
"4939992", "Görmin",
"49271", "Siegen",
"494489", "Apen",
"494461", "Jever",
"494757", "Wanna",
"492744", "Herdorf",
"4939855", "Parmen\-Weggun",
"497632", "Badenweiler",
"4933847", "Görzke",
"4935322", "Doberlug\-Kirchhain",
"496635", "Kirtorf",
"499962", "Schwarzach\ Niederbayern",
"495908", "Wietmarschen\-Lohne",
"496669", "Neuhof\-Hauswurz",
"492759", "Bad\ Berleburg\-Aue",
"4934975", "Görzig\ Kreis\ Köthen",
"496681", "Hilders",
"4939603", "Burg\ Stargard",
"492562", "Gronau\ Westfalen",
"495484", "Lienen\-Kattenvenne",
"4934601", "Teutschenthal",
"496746", "Pfalzfeld",
"492103", "Hilden",
"498862", "Steingaden\ Oberbayern",
"4933233", "Ketzin",
"4937343", "Jöhstadt",
"4933742", "Oehna\ Brandenburg",
"499103", "Cadolzburg",
"498663", "Ruhpolding",
"492595", "Olfen",
"497034", "Ehningen",
"494283", "Tarmstedt",
"499562", "Sonnefeld",
"4939322", "Tangermünde",
"4939402", "Völpke",
"498273", "Nordendorf",
"496825", "Illingen\ Saar",
"499467", "Michelsneukirchen",
"497822", "Ettenheim",
"494263", "Scheessel",
"49721", "Karlsruhe",
"499342", "Wertheim",
"494673", "Joldelund",
"498683", "Tittmoning",
"493841", "Wismar",
"497244", "Weingarten\ Baden",
"494435", "Grossenkneten",
"497453", "Altensteig\ Württemberg",
"496727", "Gensingen",
"4933966", "Dranse",
"492330", "Herdecke",
"494872", "Hanerau\-Hademarschen",
"496271", "Eberbach\ Baden",
"4939395", "Wanzer",
"495464", "Alfhausen",
"497623", "Rheinfelden\ Baden",
"492582", "Everswinkel",
"492751", "Bad\ Berleburg",
"496661", "Schlüchtern",
"49345", "Halle\ Saale",
"496545", "Blankenrath",
"497542", "Tettnang",
"497133", "Lauffen\ am\ Neckar",
"494155", "Büchen",
"497426", "Gosheim",
"4936422", "Reinstädt\ Thüringen",
"494104", "Aumühle\ bei\ Hamburg",
"4934494", "Ehrenhain",
"495145", "Beedenbostel",
"497382", "Römerstein",
"496385", "Reichenbach\-Steegen",
"499284", "Schwarzenbach\ an\ der\ Saale",
"493521", "Meissen",
"497656", "Schluchsee",
"495278", "Höxter\-Ovenhausen",
"4936623", "Berga\ Elster",
"498322", "Oberstdorf",
"496392", "Hauenstein\ Pfalz",
"492674", "Bad\ Bertrich",
"497395", "Ehingen\-Dächingen",
"495925", "Wietmarschen",
"498466", "Denkendorf\ Oberbayern",
"492264", "Marienheide",
"495677", "Calden\-Westuffeln",
"499264", "Küps",
"493529", "Heidenau\ Sachsen",
"497362", "Bopfingen",
"497447", "Baiersbronn\-Schwarzenberg",
"497300", "Roggenburg",
"499674", "Schönsee",
"497651", "Titisee\-Neustadt",
"492334", "Hagen\-Hohenlimburg",
"492723", "Kirchhundem",
"492972", "Schmallenberg",
"495337", "Kissenbrück",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"4934382", "Nerchau",
"499972", "Waldmünchen",
"499723", "Röthlein",
"496235", "Schifferstadt",
"499334", "Giebelstadt",
"4936465", "Oberndorf\ bei\ Apolda",
"498469", "Freystadt\-Burggriesbach",
"497240", "Pfinztal",
"494471", "Cloppenburg",
"497232", "Königsbach\-Stein",
"499555", "Schlüsselfeld\-Aschbach",
"4937423", "Adorf\ Vogtland",
"4939407", "Seehausen\ Börde",
"499504", "Stadelhofen",
"4933702", "Wünsdorf",
"4939327", "Klietz",
"494758", "Nordleda",
"494479", "Molbergen\-Peheim",
"4936626", "Auma",
"498461", "Beilngries",
"497042", "Vaihingen\ an\ der\ Enz",
"4933747", "Marzahna",
"496045", "Gedern",
"495507", "Ebergötzen",
"496483", "Selters\ Taunus",
"497429", "Egesheim",
"493378", "Ludwigsfelde",
"496107", "Kelsterbach",
"4934464", "Freyburg\ Unstrut",
"4936928", "Neuenhof\ Thüringen",
"492504", "Telgte",
"492555", "Schöppingen",
"499260", "Wilhelmsthal\ Oberfranken",
"494182", "Tostedt",
"4939365", "Bellingen\ bei\ Stendal",
"496741", "St\ Goar",
"499202", "Waischenfeld",
"499082", "Oettingen\ in\ Bayern",
"496352", "Kirchheimbolanden",
"493725", "Zschopau",
"494333", "Erfde",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"497355", "Hochdorf\ Riss",
"494724", "Cuxhaven\-Lüdingworth",
"497304", "Blaustein\ Württemberg",
"4933769", "Töpchin",
"492202", "Bergisch\ Gladbach",
"4938304", "Garz\ Rügen",
"4938424", "Bobitz",
"497774", "Eigeltingen",
"4936043", "Kirchheilingen",
"4937346", "Geyer",
"495806", "Barum\ bei\ Bad\ Bevensen",
"498743", "Geisenhausen",
"494195", "Hartenholm",
"496666", "Freiensteinau",
"497534", "Reichenau\ Baden",
"494503", "Timmendorfer\ Strand",
"4936427", "Dornburg\ Saale",
"4939058", "Uthmöden",
"496276", "Hesseneck",
"494162", "Jork",
"4939606", "Glienke",
"499280", "Selbitz\ Oberfranken",
"494486", "Edewecht\-Friedrichsfehn",
"4936204", "Stotternheim",
"492274", "Elsdorf\ Rheinland",
"496754", "Martinstein",
"495277", "Höxter\-Fürstenau",
"492664", "Rennerod",
"494322", "Bordesholm",
"495721", "Stadthagen",
"497702", "Blumberg\ Baden",
"4938488", "Demen",
"494903", "Wymeer",
"497934", "Weikersheim",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"4939400", "Wefensleben",
"499664", "Hahnbach",
"498104", "Sauerlach",
"4939320", "Schinne",
"499274", "Hollfeld",
"496375", "Wallhalben",
"4935606", "Briesen\ bei\ Cottbus",
"4935058", "Pretzschendorf",
"4934205", "Markranstädt",
"4935365", "Falkenberg\ Elster",
"4939746", "Krackow",
"4938207", "Stäbelow",
"497256", "Philippsburg",
"4938733", "Karbow\-Vietlübbe",
"497448", "Seewald",
"4936929", "Ruhla",
"4936945", "Henneberg",
"492684", "Puderbach\ Westerwald",
"494466", "Wittmund\-Ardorf",
"494663", "Süderlügum",
"4933768", "Prieros",
"499904", "Lalling",
"4935755", "Ortrand",
"4935327", "Priessen",
"492732", "Kreuztal",
"499955", "Mamming",
"496506", "Welschbillig",
"497644", "Kenzingen",
"498283", "Neuburg\ an\ der\ Kammel",
"494273", "Kirchdorf\ bei\ Sulingen",
"4939997", "Jarmen",
"49761", "Freiburg\ im\ Breisgau",
"495907", "Geeste",
"492955", "Büren\-Wewelsburg",
"499732", "Hammelburg",
"492904", "Bestwig",
"496261", "Mosbach\ Baden",
"494862", "Garding",
"4939224", "Büden",
"493947", "Thale",
"495474", "Stemwede\-Dielingen",
"497223", "Bühl\ Baden",
"498435", "Ehekirchen",
"496281", "Buchen\ Odenwald",
"494882", "Lunden",
"496728", "Ober\-Hilbersheim",
"4938451", "Hoppenrade\ bei\ Güstrow",
"495025", "Estorf\ Weser",
"496269", "Gundelsheim\ Württemberg",
"492572", "Emsdetten",
"4939059", "Wegenstedt",
"4935843", "Hirschfelde\ bei\ Zittau",
"499572", "Burgkunstadt",
"499468", "Zell\ Oberpfalz",
"498263", "Breitenbrunn\ Schwaben",
"4933607", "Briesen\ Mark",
"496336", "Dellfeld",
"4938375", "Koserow",
"494683", "Oldsum",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"497148", "Grossbottwar",
"497821", "Lahr\ Schwarzwald",
"4935453", "Drahnsdorf",
"495802", "Wrestedt",
"492935", "Sundern\-Hachen",
"499569", "Sesslach",
"4934298", "Taucha\ bei\ Leipzig",
"492066", "Duisburg\-Homberg",
"494967", "Rhauderfehn\-Burlage",
"4938841", "Neuhaus\ Elbe",
"4936940", "Oepfershausen",
"499341", "Tauberbischofsheim",
"496695", "Jesberg",
"496272", "Hirschhorn\ Neckar",
"494166", "Ahlerstedt",
"494871", "Hohenwestedt",
"498869", "Kinsau",
"493643", "Weimar\ Thüringen",
"497275", "Kandel",
"497665", "March\ Breisgau",
"492752", "Bad\ Laasphe",
"499935", "Stephansposching",
"492581", "Warendorf",
"495603", "Gudensberg",
"4933923", "Flecken\ Zechlin",
"4937609", "Wolkenburg\ Mulde",
"492561", "Ahaus",
"496682", "Tann\ Rhön",
"499206", "Mistelgau\-Obernsees",
"497685", "Gutach\-Bleibach",
"499086", "Fremdingen",
"496356", "Carlsberg\ Pfalz",
"4933745", "Petkus",
"4939405", "Hötensleben",
"4933452", "Neulewin",
"498861", "Schongau",
"498176", "Egling\ bei\ Wolfratshausen",
"4939325", "Vinzelberg",
"495073", "Neustadt\-Esperke",
"494186", "Buchholz\-Trelde",
"4933653", "Ziltendorf",
"499349", "Werbach\-Wenkheim",
"4939349", "Parey\ Elbe",
"4938464", "Bernitt",
"4934636", "Schafstädt",
"498404", "Oberdolling",
"492206", "Overath",
"499561", "Coburg",
"4936693", "Crossen\ an\ der\ Elster",
"4938370", "Kröslin",
"497046", "Zaberfeld",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"496391", "Dahn",
"497954", "Kirchberg\ an\ der\ Jagst",
"497905", "Langenburg",
"4937463", "Bergen\ Vogtland",
"498135", "Sulzemoos",
"495963", "Bawinkel",
"493933", "Genthin",
"496734", "Flonheim",
"498067", "Tuntenhausen",
"496323", "Edenkoben",
"497361", "Aalen",
"4936968", "Rossdorf\ Rhön",
"4934424", "Reuden\ bei\ Zeitz",
"497389", "Heroldstatt",
"4935264", "Strehla",
"494607", "Janneby",
"4933674", "Trebatsch",
"492645", "Vettelschoss",
"495320", "Torfhaus",
"499177", "Heideck",
"495406", "Belm",
"499188", "Postbauer\-Heng",
"497541", "Friedrichshafen",
"4933874", "Stechow\ Brandenburg",
"4935474", "Schönwalde\ bei\ Lübben",
"493522", "Grossenhain\ Sachsen",
"494208", "Grasberg",
"497381", "Münsingen",
"498207", "Affing",
"498393", "Holzgünz",
"4936425", "Isserstedt",
"497236", "Keltern",
"495174", "Lahstedt",
"498321", "Sonthofen",
"499976", "Rötz",
"496574", "Hasborn",
"493773", "Johanngeorgenstadt",
"497941", "Öhringen",
"498161", "Freising",
"494179", "Winsen\-Tönnhausen",
"496332", "Zweibrücken",
"4934299", "Gaschwitz",
"493303", "Birkenwerder",
"496340", "Wörth\-Schaidt",
"494353", "Ascheffel",
"492601", "Nauort",
"497335", "Wiesensteig",
"496407", "Rabenau\ Hessen",
"495583", "Braunlage\-Hohegeiss",
"497129", "Lichtenstein\ Württemberg",
"496580", "Zemmer",
"499576", "Lichtenfels\-Isling",
"496183", "Erlensee",
"496163", "Höchst\ im\ Odenwald",
"497121", "Reutlingen",
"4939348", "Klitsche",
"495102", "Laatzen",
"4934242", "Hohenpriessnitz",
"495563", "Kreiensen",
"493533", "Elsterwerda",
"4934207", "Zwochau",
"496502", "Schweich",
"492736", "Burbach\ Siegerl",
"497505", "Fronreute",
"497554", "Heiligenberg\ Baden",
"4938205", "Tessin\ bei\ Rostock",
"4939264", "Kroppenstedt",
"494171", "Winsen\ Luhe",
"499736", "Oberthulba",
"497193", "Sulzbach\ an\ der\ Murr",
"4937608", "Waldenburg\ Sachsen",
"4936947", "Jüchsen",
"499071", "Dillingen\ an\ der\ Donau",
"497949", "Pfedelbach\-Untersteinbach",
"497528", "Neukirch\ bei\ Tettnang",
"494495", "Friesoythe\-Thüle",
"496204", "Viernheim",
"499305", "Estenfeld",
"4939852", "Schönermark\ bei\ Prenzlau",
"496255", "Lindenfels",
"496084", "Schmitten\ Taunus",
"499354", "Rieneck",
"4936969", "Merkers",
"497252", "Bretten",
"4933366", "Chorin",
"4939995", "Nossendorf",
"493494", "Wolfen",
"492961", "Brilon",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"492775", "Driedorf",
"499775", "Schönau\ an\ der\ Brend",
"495357", "Grasleben",
"495874", "Soltendieck",
"494462", "Wittmund",
"4936374", "Weissensee",
"499961", "Mitterfels",
"498348", "Bidingen",
"492354", "Meinerzhagen",
"492305", "Castrop\-Rauxel",
"494347", "Flintbek",
"497631", "Müllheim\ Baden",
"494326", "Wankendorf",
"497706", "Oberbaldingen",
"4939453", "Derenburg",
"492535", "Sendenhorst\-Albersloh",
"494482", "Hatten",
"4939922", "Dambeck\ bei\ Röbel",
"497376", "Langenenslingen",
"4933971", "Kyritz\ Brandenburg",
"4938377", "Zinnowitz",
"492981", "Winterberg\ Westfalen",
"499535", "Pfarrweisach",
"499868", "Schillingsfürst",
"4933605", "Boossen",
"49212", "Solingen",
"499628", "Ursensollen",
"492309", "Waltrop",
"4933052", "Leegebruch",
"4939005", "Kusey",
"499246", "Pegnitz\-Trockau",
"498253", "Pöttmes",
"499779", "Nordheim\ von\ der\ Rhön",
"49841", "Ingolstadt\ Donau",
"498444", "Schweitenkirchen",
"492779", "Greifenstein\-Beilstein",
"492246", "Lohmar\ Rheinland",
"4935797", "Schwepnitz",
"4937752", "Eibenstock",
"492985", "Winterberg\-Niedersfeld",
"4938738", "Karow\ bei\ Lübz",
"499531", "Ebern",
"492628", "Rhens",
"494499", "Barssel",
"4939955", "Jürgenstorf",
"494491", "Friesoythe",
"4938483", "Brüel",
"494852", "Brunsbüttel",
"496251", "Bensheim",
"497473", "Mössingen",
"496833", "Rehlingen\-Siersburg",
"495224", "Enger\ Westfalen",
"492227", "Bornheim\-Merten",
"4935053", "Glashütte\ Sachsen",
"495842", "Schnega",
"492771", "Dillenburg",
"493860", "Raben\ Steinfeld",
"4939825", "Wokuhl",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"495643", "Borgentreich",
"4934491", "Schmölln\ Thüringen",
"494136", "Scharnebeck",
"499227", "Neuenmarkt",
"492992", "Marsberg",
"49760", "Oberried\ Breisgau",
"494423", "Fedderwarden",
"499965", "Sankt\ Englmar",
"493603", "Bad\ Langensalza",
"497635", "Schliengen",
"492301", "Holzwickede",
"494456", "Varel\-Altjührden",
"498247", "Bad\ Wörishofen",
"496296", "Ahorn\ Baden",
"497125", "Bad\ Urach",
"496122", "Hofheim\-Wallau",
"494248", "Bassum\-Neubruchhausen",
"495258", "Salzkotten",
"494626", "Treia",
"496784", "Weierbach",
"495522", "Osterode\ am\ Harz",
"495446", "Rehden",
"494175", "Egestorf\ Nordheide",
"497266", "Kirchardt",
"4936605", "Bad\ Köstritz",
"499075", "Glött",
"497676", "Feldberg\ Schwarzwald",
"4938780", "Lanz\ Brandenburg",
"4936025", "Körner",
"499424", "Strasskirchen",
"497945", "Wüstenrot",
"498165", "Neufahrn\ bei\ Freising",
"499605", "Weiherhammer",
"4933969", "Stepenitz",
"499654", "Pleystein",
"495933", "Lathen",
"493963", "Woldegk",
"495427", "Melle\-Buer",
"4934604", "Niemberg",
"4937362", "Seiffen\ Erzgebirge",
"4933763", "Bestensee",
"492654", "Polch",
"496764", "Rheinböllen",
"497331", "Geislingen\ an\ der\ Steige",
"492605", "Löf",
"495657", "Meissner",
"498192", "Schondorf\ am\ Ammersee",
"498226", "Bibertal",
"492424", "Vettweiss",
"4936452", "Berlstedt",
"497545", "Immenstaad\ am\ Bodensee",
"494152", "Geesthacht",
"496133", "Oppenheim",
"496542", "Bullay",
"496426", "Fronhausen",
"4936923", "Treffurt",
"496382", "Lauterecken",
"495142", "Eschede",
"497385", "Gomadingen",
"495533", "Bodenwerder",
"493563", "Spremberg",
"495130", "Wedemark",
"496656", "Ebersburg",
"497808", "Hohberg\ bei\ Offenburg",
"499766", "Grosswenkheim",
"494836", "Hennstedt\ Dithmarschen",
"492052", "Velbert\-Langenberg",
"498139", "Röhrmoos",
"498325", "Oberstaufen\-Thalkirchdorf",
"4936653", "Lehesten\ Thüringer\ Wald",
"497392", "Laupheim",
"496395", "Münchweiler\ an\ der\ Rodalb",
"495773", "Stemwede\-Wehdem",
"499641", "Grafenwöhr",
"499294", "Regnitzlosau",
"495922", "Bad\ Bentheim",
"498131", "Dachau",
"493583", "Zittau",
"497365", "Essingen\ Württemberg",
"496362", "Alsenz",
"495303", "Wendeburg",
"492294", "Morsbach\ Sieg",
"4938293", "Kühlungsborn\ Ostseebad",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"496447", "Langgöns\-Niederkleen",
"492565", "Gronau\-Epe",
"497669", "St\ Märgen",
"4937294", "Grünhainichen",
"4935692", "Kerkwitz",
"497681", "Waldkirch\ Breisgau",
"492838", "Sonsbeck",
"4939053", "Süplingen",
"494537", "Sülfeld\ Holstein",
"497746", "Wutöschingen",
"4936784", "Stützerbach",
"498538", "Pocking\-Hartkirchen",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"498621", "Trostberg",
"492592", "Selm",
"4935825", "Kodersdorf",
"496034", "Wöllstadt",
"494768", "Hipstedt",
"499565", "Untersiemau",
"4934901", "Rosslau\ Elbe",
"494777", "Cadenberge",
"495494", "Holdorf\ Niedersachsen",
"492931", "Arnsberg",
"497825", "Kippenheim",
"498459", "Manching",
"494221", "Delmenhorst",
"4934785", "Sandersleben",
"49621", "Mannheim",
"498629", "Palling",
"496691", "Schwalmstadt",
"496244", "Westhofen\ Rheinhessenen",
"4938787", "Glöwen",
"499345", "Külsheim\ Baden",
"494875", "Stafstedt",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"496453", "Gemünden\ Wohra",
"494307", "Raisdorf",
"494293", "Ottersberg\-Fischerhude",
"497727", "Vöhrenbach",
"494432", "Dötlingen\-Brettorf",
"493874", "Ludwigslust",
"497271", "Wörth\ am\ Rhein",
"496623", "Rotenburg\ an\ der\ Fulda",
"497661", "Kirchzarten",
"4935955", "Pulsnitz",
"4935892", "Horka\ OL",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"499931", "Plattling",
"492585", "Warendorf\-Hoetmar",
"496285", "Walldürn\-Altheim",
"496054", "Birstein",
"499384", "Schwanfeld",
"498431", "Neuburg\ an\ der\ Donau",
"495021", "Nienburg\ Weser",
"4937603", "Wildenfels",
"4933929", "Gühlen\-Glienicke",
"4934772", "Helbra",
"49951", "Bamberg",
"499544", "Baunach",
"4939007", "Tangeln",
"494557", "Blunk",
"498222", "Burgau\ Schwaben",
"495378", "Sassenburg\-Platendorf",
"4939343", "Jerichow",
"49251", "Münster",
"498558", "Hohenau\ Niederbayern",
"4939957", "Gielow",
"496147", "Trebur",
"498196", "Pürgen",
"4934341", "Geithain",
"49881", "Weilheim\ in\ Oberbayern",
"492858", "Hünxe",
"492384", "Welver",
"4937322", "Brand\-Erbisdorf",
"4935795", "Königsbrück",
"4939481", "Hedersleben\ bei\ Aschersleben",
"495442", "Barnstorf\ Kreis\ Diepholz",
"492364", "Haltern\ Westfalen",
"494622", "Taarstedt",
"498020", "Weyarn",
"499951", "Landau\ an\ der\ Isar",
"496126", "Idstein",
"496433", "Hadamar",
"494452", "Zetel\-Neuenburg",
"4933204", "Beelitz\ Mark",
"493337", "Biesenthal\ Brandenburg",
"496292", "Seckach",
"495367", "Rühen",
"496675", "Breitenbach\ am\ Herzberg",
"4935722", "Lauta\ bei\ Hoyerswerda",
"497672", "St\ Blasien",
"494823", "Wilster",
"4939827", "Schwarz\ bei\ Neustrelitz",
"492951", "Büren",
"497262", "Eppingen",
"499364", "Zellingen",
"496265", "Billigheim\ Baden",
"498703", "Essenbach",
"495846", "Gartow\ Niedersachsen",
"496594", "Birresborn",
"495194", "Bispingen",
"494856", "Kronprinzenkoog",
"497564", "Bad\ Wurzach",
"498373", "Altusried",
"4936642", "Harra",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"496636", "Romrod",
"4939458", "Heudeber",
"494383", "Grebin",
"4936027", "Lengenfeld\ Unterm\ Stein",
"495553", "Kalefeld",
"494132", "Amelinghausen",
"494543", "Nusse",
"494140", "Estorf\ Kreis\ Stade",
"4939426", "Hessen",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"496550", "Irrhausen",
"4936607", "Niederpöllnitz",
"499197", "Egloffstein",
"497344", "Blaubeuren",
"49731", "Ulm\ Donau",
"499242", "Gössweinstein",
"496701", "Sprendlingen\ Rheinhessen",
"494363", "Lensahn",
"4935820", "Zodel",
"4936842", "Oberhof\ Thüringen",
"499824", "Dietenhofen",
"496028", "Sulzbach\ am\ Main",
"497584", "Altshausen",
"495725", "Lindhorst\ bei\ Stadthagen",
"492824", "Kalkar",
"4935931", "Königswartha",
"498151", "Starnberg",
"496371", "Landstuhl",
"492242", "Hennef\ Sieg",
"4933398", "Werneuchen",
"494920", "Wirdum",
"495827", "Unterlüss",
"499091", "Monheim\ Schwaben",
"497570", "Sigmaringen\-Gutenstein",
"496826", "Bexbach",
"4936702", "Lauscha",
"497173", "Heubach",
"4939820", "Triepkendorf",
"494191", "Kaltenkirchen\ Holstein",
"4933928", "Wildberg\ Brandenburg",
"495238", "Nieheim\-Himmighausen",
"4939931", "Röbel\ Müritz",
"494123", "Barmstedt",
"497742", "Klettgau",
"499158", "Offenhausen\ Mittelfranken",
"496745", "Gondershausen",
"493721", "Meinersdorf",
"497351", "Biberach\ an\ der\ Riss",
"498057", "Aschau\-Sachrang",
"492634", "Rengsdorf",
"499634", "Wiesau",
"495953", "Börger",
"4934293", "Naunhof\ bei\ Grimma",
"497964", "Stödtlen",
"4939291", "Calbe\ Saale",
"4939000", "Beetzendorf",
"498144", "Grafrath",
"492158", "Grefrath\ bei\ Krefeld",
"49811", "Hallbergmoos",
"499099", "Kaisheim",
"492596", "Nordkirchen",
"494943", "Grossefehn",
"499551", "Burgwindheim",
"4939459", "Hasselfelde",
"496239", "Bobenheim\-Roxheim",
"495926", "Engden",
"498465", "Kipfenberg",
"496041", "Glauburg",
"498233", "Kissing",
"4939722", "Sarnow\ bei\ Anklam",
"499438", "Fensterbach",
"498851", "Kochel\ am\ See",
"496527", "Oberweis",
"4938226", "Dierhagen\ Ostseebad",
"492551", "Steinfurt\-Burgsteinfurt",
"4935827", "Nieder\-Seifersdorf",
"495127", "Harsum",
"495146", "Wietze",
"492762", "Wenden\ Südsauerland",
"496652", "Hünfeld",
"4936020", "Ebeleben",
"497655", "Feldberg\-Altglashütten",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"494633", "Satrup",
"4936963", "Dorndorf\ Rhön",
"498043", "Jachenau",
"4938785", "Berge\ bei\ Perleberg",
"496386", "Altenkirchen\ Pfalz",
"499944", "Miltach",
"496422", "Kirchhain",
"497425", "Trossingen",
"49991", "Deggendorf",
"4933434", "Herzfelde\ bei\ Strausberg",
"494156", "Talkau",
"49291", "Meschede",
"493907", "Gardelegen",
"495850", "Neetze",
"496049", "Kefenrod",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"492944", "Rietberg\-Mastholte",
"494957", "Detern",
"495947", "Laar\ Vechte",
"492056", "Heiligenhaus",
"494832", "Meldorf",
"496231", "Hochdorf\-Assenheim",
"499762", "Saal\ an\ der\ Saale",
"4937468", "Treuen\ Vogtland",
"496853", "Marpingen",
"494475", "Molbergen",
"498649", "Schleching",
"495251", "Paderborn",
"4936082", "Ershausen",
"495833", "Brome",
"493863", "Crivitz",
"4935476", "Wittmannsdorf\-Bückchen",
"499325", "Kleinlangheim",
"496224", "Sandhausen\ Baden",
"4933876", "Buschow",
"493695", "Bad\ Salzungen",
"496842", "Blieskastel",
"494241", "Bassum",
"498766", "Gammelsdorf",
"496643", "Herbstein",
"498052", "Aschau\ im\ Chiemgau",
"495632", "Willingen\ Upland",
"492325", "Wanne\-Eickel",
"497747", "Berau",
"494536", "Steinhorst\ Lauenburg",
"4935933", "Neschwitz",
"498250", "Hilgertshausen\-Tandern",
"497726", "Bad\ Dürrheim",
"493682", "Zella\-Mehlis",
"4933978", "Segeletz",
"492131", "Neuss",
"4939035", "Kuhfelde",
"499131", "Erlangen",
"4933932", "Fehrbellin",
"494776", "Osten\-Altendorf",
"4933676", "Friedland\ bei\ Beeskow",
"494249", "Bassum\-Nordwohlde",
"498641", "Grassau\ Kreis\ Traunstein",
"498294", "Horgau",
"4935266", "Heyda\ bei\ Riesa",
"495259", "Bad\ Driburg\-Neuenheerse",
"4934426", "Kayna",
"493883", "Hagenow",
"498565", "Dietersburg\-Baumgarten",
"494837", "Neuenkirchen\ Dithmarschen",
"493391", "Neuruppin",
"495942", "Uelsen",
"499451", "Schierling",
"492693", "Antweiler",
"492865", "Raesfeld",
"493902", "Diesdorf\ Altm",
"494952", "Rhauderfehn",
"492538", "Drensteinfurt\-Rinkerode",
"499621", "Amberg\ Oberpfalz",
"4939483", "Ballenstedt",
"496427", "Cölbe\-Schönstadt",
"492621", "Lahnstein",
"494735", "Butjadingen\-Stollhamm",
"497753", "Albbruck",
"498592", "Wegscheid\ Niederbayern",
"495764", "Steyerberg",
"499865", "Adelshofen\ Mittelfranken",
"496657", "Hofbieber",
"4938466", "Jürgenshagen",
"492451", "Geilenkirchen",
"49375", "Zwickau",
"4938825", "Klütz",
"492778", "Siegbach",
"4935877", "Cunewalde",
"4936252", "Tambach\-Dietharz",
"4937601", "Mülsen\ Skt\ Jacob",
"496258", "Gernsheim",
"4939772", "Rothemühl",
"4933477", "Trebnitz\ bei\ Müncheberg",
"4939882", "Gollin",
"497525", "Aulendorf",
"494498", "Saterland\-Ramsloh",
"496522", "Mettendorf",
"496446", "Hohenahr",
"498345", "Stöttwang",
"4934343", "Regis\-Breitingen",
"492308", "Unna\-Hemmerde",
"499778", "Fladungen",
"4939341", "Redekin",
"498585", "Grainet",
"493574", "Lauchhammer",
"497267", "Gemmingen",
"498531", "Pocking",
"496773", "Kamp\-Bornhofen",
"4936961", "Bad\ Liebenstein",
"492253", "Bad\ Münstereifel",
"499444", "Siegenburg",
"49941", "Regensburg",
"492831", "Geldern",
"4935772", "Rietschen",
"499831", "Gunzenhausen",
"49241", "Aachen",
"498458", "Gaimersheim",
"492444", "Schleiden\-Gemünd",
"496297", "Ravenstein\ Baden",
"499253", "Weissenstadt",
"498246", "Waal",
"495362", "Wolfsburg\-Fallersleben",
"493332", "Schwedt\/Oder",
"496303", "Enkenbach\-Alsenborn",
"494761", "Bremervörde",
"495447", "Lembruch",
"4935341", "Bad\ Liebenwerda",
"498628", "Kienberg\ Oberbayern",
"495300", "Salzgitter\-Üfingen",
"494975", "Westerholt\ Ostfriesland",
"4938797", "Karstädt\ Kreis\ Prignitz",
"494627", "Dörpstedt",
"494646", "Mohrkirch",
"498036", "Stephanskirchen\ Simssee",
"496698", "Schrecksbach",
"495542", "Witzenhausen",
"495426", "Glandorf",
"492938", "Ense",
"497145", "Markgröningen",
"495382", "Bad\ Gandersheim",
"494552", "Leezen",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"494769", "Bremervörde\-Iselersheim",
"496533", "Morbach\ Hunsrück",
"496142", "Rüsselsheim",
"495656", "Waldkappel",
"498771", "Ergoldsbach",
"496130", "Schwabenheim\ an\ der\ Selz",
"497668", "Ihringen",
"4934722", "Preusslitz",
"4938352", "Kemnitz\ bei\ Greifswald",
"492839", "Straelen\-Herongen",
"499938", "Moos\ Niederbayern",
"4936376", "Straussfurt",
"4933979", "Wusterhausen\ Dosse",
"494254", "Eystrup",
"494205", "Ottersberg",
"492247", "Neunkirchen\-Seelscheid",
"495822", "Ebstorf",
"498075", "Amerang",
"499185", "Mühlhausen\ Oberpfalz",
"49521", "Bielefeld",
"495691", "Bad\ Arolsen",
"495244", "Rietberg",
"495453", "Recke",
"496620", "Philippsthal\ Werra",
"497464", "Talheim\ Kreis\ Tuttlingen",
"4939293", "Dreileben",
"4938848", "Vellahn",
"495623", "Edertal",
"4934291", "Borsdorf",
"494443", "Dinklage",
"4939266", "Förderstedt",
"4933470", "Lietzen",
"494137", "Barendorf",
"499192", "Gräfenberg",
"498138", "Schwabhausen\ bei\ Dachau",
"492165", "Jüchen",
"497484", "Simmersfeld",
"49214", "Leverkusen",
"4936077", "Grossbodungen",
"499648", "Neustadt\ am\ Kulm",
"4933335", "Pinnow\ Kreis\ Uckermark",
"498654", "Freilassing",
"499165", "Sugenheim",
"495034", "Neustadt\-Hagen",
"494936", "Grossheide",
"4939933", "Vollrathsruhe",
"492192", "Hückeswagen",
"492226", "Rheinbach",
"498424", "Nassenfels",
"496430", "Hahnstätten",
"496526", "Bollendorf",
"496442", "Braunfels",
"499924", "Bodenmais",
"497445", "Pfalzgrafenweiler",
"4937344", "Crottendorf\ Sachsen",
"4933234", "Wustermark",
"495126", "Algermissen",
"495433", "Badbergen",
"495292", "Lichtenau\-Atteln",
"498023", "Bayrischzell",
"495675", "Trendelburg",
"4939604", "Wildberg\ bei\ Altentreptow",
"498091", "Kirchseeon",
"497203", "Walzbachtal",
"494234", "Dörverden",
"497083", "Bad\ Herrenalb",
"492924", "Möhnesee",
"495265", "Dörentrup",
"496029", "Mömbris",
"494956", "Uplengen",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"49911", "Nuremberg",
"495054", "Bergen\-Sülze",
"499144", "Pleinfeld",
"4939037", "Pretzier",
"497063", "Bad\ Wimpfen",
"496021", "Aschaffenburg",
"495946", "Georgsdorf",
"498634", "Garching\ an\ der\ Alz",
"496387", "Sankt\ Julian",
"496093", "Laufach",
"4938426", "Neuburg\-Steinhausen",
"495147", "Uetze\-Hänigsen",
"4938306", "Samtens",
"4937432", "Pausa\ Vogtland",
"4938458", "Zehna",
"498158", "Tutzing",
"49211", "Düsseldorf",
"493741", "Plauen",
"4934692", "Alsleben\ Saale",
"497973", "Obersontheim",
"497184", "Kaisersbach",
"492465", "Inden",
"4939089", "Bismark\ Altmark",
"497722", "Triberg\ im\ Schwarzwald",
"499851", "Dinkelsbühl",
"4936624", "Teichwolframsdorf",
"494302", "Kirchbarkau",
"493686", "Eisfeld",
"499492", "Parsberg",
"495028", "Pennigsehl",
"4938481", "Witzin",
"499233", "Arzberg\ Oberfranken",
"496725", "Gau\-Algesheim",
"492233", "Hürth\ Rheinland",
"498124", "Forstern\ Oberbayern",
"4938827", "Kalkhorst",
"494923", "Krummhörn\-Pewsum",
"492851", "Rees",
"4934466", "Janisroda",
"499465", "Neukirchen\-Balbini",
"495371", "Gifhorn",
"494772", "Oberndorf\ Oste",
"498782", "Pfeffenhausen",
"498551", "Freyung",
"4934493", "Gössnitz\ Thüringen",
"496827", "Eppelborn",
"495379", "Sassenburg\-Grussendorf",
"498762", "Wartenberg\ Oberbayern",
"4933475", "Letschin",
"495594", "Bovenden\-Reyershausen",
"492043", "Gladbeck",
"492597", "Senden\ Westfalen",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"492859", "Wesel\-Bislich",
"494532", "Bargteheide",
"494143", "Drochtersen",
"492958", "Büren\-Harth",
"496150", "Weiterstadt",
"495636", "Lichtenfels\-Goddelsheim",
"496553", "Schönecken",
"492485", "Schleiden\-Dreiborn",
"498056", "Eggstätt",
"497164", "Boll\ Kreis\ Göppingen",
"498370", "Wiggensbach",
"4934955", "Gossa",
"495153", "Salzhemmendorf",
"496637", "Feldatal",
"49981", "Ansbach",
"492431", "Erkelenz",
"496048", "Büdingen\-Eckartshausen",
"499844", "Obernzenn",
"495745", "Stemwede\-Levern",
"497324", "Herbrechtingen",
"494755", "Ihlienworth",
"497733", "Engen\ Hegau",
"499196", "Wiesenttal",
"494704", "Drangstedt",
"499222", "Presseck",
"492222", "Bornheim\ Rheinland",
"4939030", "Brunau",
"498544", "Eging\ am\ See",
"492558", "Horstmar",
"49851", "Passau",
"492196", "Wermelskirchen",
"494932", "Norderney",
"494857", "Barlt",
"492844", "Rheinberg\-Orsoy",
"493375", "Königs\ Wusterhausen",
"499431", "Schwandorf",
"498858", "Kochel\-Walchensee",
"498384", "Röthenbach\ Allgäu",
"49281", "Wesel",
"4936732", "Könitz",
"497573", "Stetten\ am\ kalten\ Markt",
"498364", "Seeg",
"4939051", "Calvörde",
"499439", "Neunburg\-Kemnath",
"495826", "Suderburg",
"4938459", "Laage",
"4934903", "Coswig\ Anhalt",
"494523", "Malente",
"4939226", "Hohenziatz",
"494120", "Ellerhoop",
"496238", "Dirmstein",
"4938722", "Raduhn",
"496146", "Hochheim\ am\ Main",
"495652", "Bad\ Sooden\-Allendorf",
"494556", "Ahrensbök\-Gnissau",
"495546", "Scheden",
"4939744", "Rothenklempenow",
"495422", "Melle",
"492159", "Meerbusch\-Osterath",
"496894", "St\ Ingbert",
"494642", "Kappeln\ Schlei",
"499373", "Amorbach",
"494630", "Barderup",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"4939088", "Letzlingen",
"494843", "Viöl",
"492373", "Menden\ Sauerland",
"493671", "Saalfeld\ Saale",
"495231", "Detmold",
"495853", "Neu\ Darchau",
"4936075", "Dingelstädt\ Eichsfeld",
"499524", "Zeil\ am\ Main",
"497358", "Eberhardzell\-Füramoos",
"4936921", "Wutha\-Farnroda",
"499151", "Hersbruck",
"4936206", "Grossfahner",
"495041", "Springe\ Deister",
"493679", "Neuhaus\ am\ Rennweg",
"498824", "Oberau\ Loisach",
"4936651", "Lobenstein",
"4937202", "Claussnitz\ bei\ Chemnitz",
"4935604", "Krieschow",
"492151", "Krefeld",
"495527", "Duderstadt",
"495366", "Jembke",
"4933337", "Altkünkendorf",
"492524", "Ennigerloh",
"498230", "Gablingen",
"4935024", "Stadt\ Wehlen",
"496127", "Niedernhausen\ Taunus",
"497033", "Weil\ Der\ Stadt",
"494284", "Selsingen",
"495906", "Lünne",
"498274", "Buttenwiesen",
"499155", "Simmelsdorf",
"494796", "Teufelsmoor",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"499104", "Emskirchen",
"498664", "Chieming",
"493946", "Quedlinburg",
"495045", "Springe\-Bennigsen",
"495483", "Lienen",
"496507", "Neumagen\-Dhron",
"492104", "Mettmann",
"497624", "Grenzach\-Wyhlen",
"4935242", "Nossen",
"497454", "Sulz\ am\ Neckar",
"496337", "Grossbundenbach",
"496402", "Hungen",
"4935207", "Moritzburg",
"493433", "Borna\ Stadt",
"4936691", "Eisenberg\ Thüringen",
"494674", "Ockholm",
"499720", "Üchtelhausen",
"493675", "Sonneberg\ Thüringen",
"498684", "Fridolfing",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"497243", "Ettlingen",
"495235", "Blomberg\ Lippe",
"4935939", "Hochkirch",
"494264", "Sottrum\ Kreis\ Rotenburg",
"493594", "Bischofswerda",
"4933206", "Fichtenwalde",
"498732", "Frontenhausen",
"493379", "Mahlow",
"497428", "Rosenfeld",
"4934325", "Mochau\-Lüttewitz",
"4938755", "Eldena",
"4938327", "Elmenhorst\ Vorpom",
"4933921", "Zechlinerhütte",
"496806", "Heusweiler",
"4936337", "Schiedungen",
"493636", "Greussen",
"494562", "Grömitz",
"494478", "Cappeln\ Oldenburg",
"499283", "Rehau",
"4939972", "Walkendorf",
"4933830", "Ziesar",
"494487", "Grossenkneten\-Huntlosen",
"495276", "Marienmünster",
"497134", "Weinsberg",
"494103", "Wedel",
"492435", "Erkelenz\-Lövenich",
"492872", "Rhede\ Westfalen",
"494342", "Preetz\ Kreis\ Plön",
"4938843", "Bennin",
"499673", "Tiefenbach\ Oberpfalz",
"4939298", "Barby\ Elbe",
"495741", "Lübbecke",
"494330", "Emkendorf",
"494467", "Wittmund\-Funnix",
"4939489", "Strassberg\ Harz",
"494751", "Otterndorf",
"499263", "Ludwigsstadt",
"495352", "Schöningen",
"498468", "Altmannstein\-Pondorf",
"498572", "Tann\ Niederbayern",
"4935451", "Dahme\ Brandenburg",
"495686", "Schwarzenborn\ Knüll",
"4938334", "Grammendorf",
"492263", "Engelskirchen",
"492673", "Ellenz\-Poltersdorf",
"499872", "Heilsbronn",
"493371", "Luckenwalde",
"499435", "Schwarzenfeld",
"4939200", "Gommern",
"497257", "Bruchsal\-Untergrombach",
"4933436", "Prötzel",
"499469", "Roding\-Neubäu",
"498334", "Bad\ Grönenbach",
"499481", "Pfatter",
"498723", "Arnstorf",
"4939451", "Wasserleben",
"4934922", "Mühlanger",
"496268", "Hüffenhardt",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"496678", "Wildeck\-Hönebach",
"4935200", "Arnsdorf\ bei\ Dresden",
"4934652", "Allstedt",
"493745", "Falkenstein\ Vogtland",
"49471", "Bremerhaven",
"494744", "Loxstedt",
"493994", "Malchin",
"492461", "Jülich",
"496667", "Steinau\-Ulmbach",
"499855", "Dentlein\ am\ Forst",
"495705", "Petershagen\-Windheim",
"496008", "Echzell",
"499804", "Aurach",
"495754", "Extertal\-Bremke",
"497763", "Murg",
"4935938", "Grosspostwitz\ OL",
"496721", "Bingen\ am\ Rhein",
"494962", "Papenburg\-Aschendorf",
"4938224", "Gresenhorst",
"493847", "Sternberg",
"492804", "Xanten\-Marienbaum",
"4936761", "Heubisch",
"492855", "Voerde\ Niederrhein",
"495807", "Altenmedingen",
"495375", "Müden\ Aller",
"499461", "Roding",
"498504", "Tittling",
"498555", "Perlesreut",
"497022", "Nürtingen",
"4934348", "Frohburg",
"495281", "Bad\ Pyrmont",
"4939242", "Prödel",
"4939207", "Colbitz",
"498670", "Reischach\ Kreis\ Altötting",
"498082", "Schwindegg",
"498202", "Althegnenberg",
"499172", "Georgensgmünd",
"4933637", "Beerfelde",
"495336", "Semmenstedt",
"493366", "Beeskow",
"497449", "Baiersbronn\-Obertal",
"493386", "Premnitz",
"494602", "Freienwill",
"4933837", "Brielow",
"497441", "Freudenstadt",
"4936330", "Grossberndten",
"495506", "Adelebsen",
"498062", "Bruckmühl\ Mangfall",
"493546", "Lübben\ Spreewald",
"492743", "Daaden",
"496106", "Rodgau",
"498756", "Nandlstadt",
"495671", "Hofgeismar",
"497220", "Forbach\-Hundsbach",
"4938320", "Tribsees",
"498095", "Aying",
"497834", "Wolfach",
"495261", "Lemgo",
"496474", "Villmar\-Aumenau",
"4939488", "Güntersberge",
"494803", "Pahlen",
"495682", "Borken\ Hessen",
"495356", "Helmstedt\-Barmke",
"4936041", "Bad\ Tennstedt",
"494346", "Gettorf",
"492161", "Mönchengladbach",
"496398", "Vorderweidenthal",
"496073", "Babenhausen\ Hessen",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"499876", "Rohr\ Mittelfranken",
"499161", "Neustadt\ an\ der\ Aisch",
"494209", "Schwanewede",
"4934606", "Teicha\ Sachsen\-Anhalt",
"495883", "Lemgow",
"495863", "Zernien",
"496802", "Völklingen\-Lauterbach",
"497805", "Appenweier",
"497388", "Pfronstetten",
"497854", "Kehl\-Goldscheuer",
"4935205", "Ottendorf\-Okrilla",
"498071", "Wasserburg\ am\ Inn",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"4936482", "Triptis",
"495695", "Twistetal",
"495272", "Brakel\ Westfalen",
"498328", "Balderschwang",
"497707", "Bräunlingen",
"494327", "Grossenaspe",
"492181", "Grevenbroich",
"495662", "Felsberg\ Hessen",
"493632", "Sondershausen",
"496406", "Lollar",
"4934327", "Waldheim\ Sachsen",
"499348", "Werbach\-Gamburg",
"4938757", "Neustadt\-Glewe",
"4938325", "Rolofshagen",
"497141", "Ludwigsburg\ Württemberg",
"4937421", "Oelsnitz\ Vogtland",
"496174", "Königstein\ im\ Taunus",
"492588", "Harsewinkel\-Greffen",
"4936335", "Grosswechsungen",
"495574", "Oberweser",
"4939083", "Messdorf",
"499737", "Wartmannsroth",
"498868", "Schwabsoien",
"494792", "Worpswede",
"498535", "Haarbach",
"492568", "Heek",
"492472", "Monschau",
"492835", "Issum",
"495902", "Freren",
"4938392", "Sassnitz",
"493764", "Meerane",
"495734", "Bergkirchen\ Westfalen",
"4939382", "Kamern",
"495323", "Clausthal\-Zellerfeld",
"499835", "Ehingen\ Mittelfranken",
"499472", "Hohenfels\ Oberpfalz",
"499568", "Neustadt\ bei\ Coburg",
"494765", "Ebersdorf\ bei\ Bremervörde",
"492737", "Netphen\-Deuz",
"494971", "Esens",
"493542", "Lübbenau\ Spreewald",
"495163", "Fallingbostel\-Dorfmark",
"4935841", "Grossschönau\ Sachsen",
"496102", "Neu\-Isenburg",
"497154", "Kornwestheim",
"498066", "Bad\ Feilnbach",
"496563", "Kyllburg",
"4938453", "Mistorf",
"495502", "Dransfeld",
"499869", "Wettringen\ Mittelfranken",
"494606", "Wanderup",
"493382", "Lehnin",
"498341", "Kaufbeuren",
"4934909", "Aken\ Elbe",
"498752", "Au\ in\ der\ Hallertau",
"498581", "Waldkirchen\ Niederbayern",
"498561", "Pfarrkirchen\ Niederbayern",
"493395", "Pritzwalk",
"494394", "Bokhorst",
"497237", "Neulingen\ Enzkreis",
"499404", "Nittendorf",
"492861", "Borken\ Westfalen",
"498349", "Stötten\ am\ Auerberg",
"4937296", "Stollberg\ Erzgebirge",
"497026", "Lenningen",
"4933082", "Menz\ Kreis\ Oberhavel",
"499977", "Arnschwang",
"499625", "Kastl\ bei\ Amberg",
"4938852", "Wittenburg",
"497529", "Waldburg\ Württemberg",
"493362", "Erkner",
"495332", "Schöppenstedt",
"492625", "Ochtendung",
"492977", "Schmallenberg\-Bödefeld",
"494731", "Nordenham",
"499861", "Rothenburg\ ob\ der\ Tauber",
"499176", "Allersberg",
"496583", "Palzem",
"495407", "Wallenhorst",
"498086", "Buchbach\ Oberbayern",
"496343", "Bad\ Bergzabern",
"492455", "Waldfeucht",
"492404", "Alsdorf\ Rheinland",
"498206", "Egling\ an\ der\ Paar",
"493447", "Altenburg\ Thüringen",
"4934224", "Belgern\ Sachsen",
"495183", "Lamspringe",
"4939205", "Langenweddingen",
"499608", "Kohlberg\ Oberpfalz",
"498168", "Attenkirchen",
"4938731", "Lübz",
"4934746", "Giersleben",
"494167", "Apensen",
"497948", "Öhringen\-Ohrnberg",
"499135", "Hessdorf\ Mittelfranken",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"497053", "Bad\ Teinach\-Zavelstein",
"495064", "Gross\ Düngen",
"492608", "Welschneudorf",
"494966", "Neubörger",
"495204", "Steinhagen\ Westfalen",
"495255", "Altenbeken",
"495084", "Hambühren",
"4935435", "Gollmitz\ bei\ Calau",
"499321", "Kitzingen",
"497128", "Sonnenbühl",
"4933835", "Golzow\ bei\ Brandenburg",
"497841", "Achern",
"493691", "Eisenach\ Thüringen",
"494245", "Neuenkirchen\ bei\ Bassum",
"492207", "Kürten\-Dürscheid",
"492393", "Sundern\-Allendorf",
"4934498", "Rositz",
"4938750", "Malliss",
"494403", "Bad\ Zwischenahn",
"499393", "Rothenfels\ Unterfranken",
"499087", "Marktoffingen",
"496357", "Standenbühl",
"499078", "Mertingen",
"499207", "Königsfeld\ Oberfranken",
"496874", "Wadern\-Nunkirchen",
"497434", "Winterlingen",
"494187", "Holm\-Seppensen",
"494178", "Radbruch",
"493623", "Friedrichroda",
"498177", "Münsing\ Starnberger\ See",
"498506", "Bad\ Höhenstadt",
"4936338", "Bleicherode",
"497229", "Iffezheim",
"4936741", "Bad\ Blankenburg",
"4939854", "Kleptow",
"4939209", "Wanzleben",
"496003", "Rosbach\ von\ der\ Höhe",
"496283", "Hardheim\ Odenwald",
"495062", "Holle\ bei\ Hildesheim",
"4938356", "Behrenhoff",
"494681", "Wyk\ auf\ Föhr",
"498671", "Altötting",
"4933094", "Löwenberg",
"498261", "Mindelheim",
"493996", "Teterow",
"494746", "Hagen\ bei\ Bremerhaven",
"4936372", "Kleinneuhausen",
"4938328", "Miltzow",
"498728", "Geratskirchen",
"496872", "Losheim\ am\ See",
"494271", "Sulingen",
"497432", "Albstadt\-Tailfingen",
"498269", "Unteregg\ bei\ Mindelheim",
"497440", "Bad\ Rippoldsau",
"497307", "Senden\ Iller",
"496435", "Wallmerod",
"4939924", "Stuer",
"498281", "Thannhausen\ Schwaben",
"4933839", "Wusterwitz",
"4935439", "Zinnitz",
"494661", "Niebüll",
"498679", "Burgkirchen\ an\ der\ Alz",
"496263", "Neckargerach",
"495082", "Langlingen",
"495202", "Oerlinghausen",
"497221", "Baden\-Baden",
"494825", "Burg\ Dithmarschen",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"497777", "Sauldorf",
"498336", "Erkheim",
"496673", "Haunetal",
"499480", "Sünching",
"496476", "Mengerskirchen",
"497836", "Schiltach",
"4935930", "Seitschen",
"498705", "Altfraunhofen",
"498754", "Volkenschwand",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"496104", "Heusenstamm",
"493544", "Luckau\ Brandenburg",
"496155", "Griesheim\ Hessen",
"497152", "Leonberg\ Württemberg",
"492507", "Havixbeck",
"49351", "Dresden",
"494545", "Seedorf\ Lauenburg",
"499748", "Motten",
"495504", "Friedland\ Kreis\ Göttingen",
"494385", "Hohenfelde\ bei\ Kiel",
"4934905", "Wörlitz",
"495555", "Moringen\-Fredelsloh",
"498807", "Diessen\ am\ Ammersee",
"498375", "Weitnau",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"493364", "Eisenhüttenstadt",
"495723", "Bad\ Nenndorf",
"494365", "Heringsdorf\ Holstein",
"492402", "Stolberg\ Rheinland",
"4934781", "Greifenhagen",
"4934244", "Mockrehna",
"492337", "Hagen\-Dahl",
"499337", "Gaukönigshofen",
"494392", "Nortorf\ bei\ Neumünster",
"499402", "Regenstauf",
"4939262", "Güsten\ Anh",
"4938793", "Dergenthin",
"4935208", "Radeburg",
"4935951", "Neukirch\ Lausitz",
"494266", "Brockel",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"4939001", "Apenburg",
"498741", "Vilsbiburg",
"497175", "Leinzell",
"4935873", "Herrnhut",
"495572", "Bodenfelde",
"495468", "Bramsche\-Engter",
"4933473", "Zechin",
"498686", "Petting",
"4933638", "Rüdersdorf\ bei\ Berlin",
"497248", "Marxzell",
"4934347", "Oelzschau\ bei\ Borna",
"4933672", "Pfaffendorfb\ Beeskow",
"494125", "Seestermühe",
"497456", "Haiterbach",
"4934953", "Gräfenhainichen",
"4939951", "Faulenrost",
"494501", "Kastorf\ Holstein",
"4939208", "Loitsche",
"494339", "Christiansholm",
"4934422", "Osterfeld",
"497626", "Kandern",
"494509", "Gross\ Grönau",
"494331", "Rendsburg",
"495732", "Löhne",
"4935472", "Schlepzig",
"493762", "Crimmitschau",
"499474", "Schmidmühlen",
"496743", "Bacharach",
"499907", "Zenting",
"4939487", "Friedrichsbrunn",
"4933872", "Hohennauen",
"4937383", "Lunzenau",
"4933838", "Päwesin",
"494945", "Grossefehn\-Timmel",
"49391", "Magdeburg",
"493944", "Blankenburg\ Harz",
"4939821", "Carpin",
"499106", "Markt\ Erlbach",
"498666", "Teisendorf",
"4934495", "Dobitschen",
"494794", "Worpswede\-Ostersode",
"498276", "Baar\ Schwaben",
"492474", "Nideggen\-Schmidt",
"495955", "Esterwegen",
"495904", "Lengerich\ Emsl",
"494286", "Gyhum",
"4939394", "Hohenberg\-Krusemark",
"498463", "Greding",
"4936256", "Wechmar",
"4939776", "Hintersee",
"499268", "Teuschnitz",
"4939886", "Milmersdorf",
"499729", "Grettstadt",
"495684", "Frielendorf",
"492268", "Kürten",
"4936601", "Hermsdorf\ Thüringen",
"4936021", "Schlotheim",
"492687", "Horhausen\ Westerwald",
"492678", "Büchel\ bei\ Cochem",
"497423", "Oberndorf\ am\ Neckar",
"496461", "Biedenkopf",
"4933454", "Wölsickendorf\/Wollenberg",
"496757", "Becherbach\ bei\ Kirn",
"497136", "Bad\ Friedrichshall",
"495274", "Nieheim",
"492667", "Stein\-Neukirch",
"49365", "Gera",
"497653", "Lenzkirch",
"494635", "Sörup",
"492721", "Lennestadt",
"4935209", "Mohorn",
"498045", "Lenggries\-Fall",
"493634", "Sömmerda",
"495664", "Morschen",
"496804", "Mandelbachtal",
"499277", "Warmensteinach",
"499288", "Bad\ Steben",
"496855", "Freisen",
"494473", "Emstek",
"497852", "Willstätt",
"499721", "Schweinfurt",
"494108", "Rosengarten\ Kreis\ Harburg",
"497937", "Dörzbach",
"4938462", "Baumgarten",
"4935937", "Prischwitz",
"493596", "Neustadt\ in\ Sachsen",
"495976", "Salzbergen",
"4936736", "Arnsgereuth",
"498204", "Mickhausen",
"492406", "Herzogenrath",
"498084", "Taufkirchen\ Vils",
"499174", "Hilpoltstein",
"4933844", "Brück\ Brandenburg",
"4934328", "Hartha\ bei\ Döbeln",
"496588", "Pluwig",
"497024", "Wendlingen\ am\ Neckar",
"492983", "Winterberg\-Siedlinghausen",
"4938758", "Dömitz",
"4939222", "Möser",
"492174", "Burscheid\ Rheinland",
"4938726", "Spornitz",
"499406", "Mintraching",
"495177", "Edemissen\-Abbensen",
"4933333", "Tantow",
"496348", "Offenbach\ an\ der\ Queich",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"497957", "Kressberg",
"495168", "Walsrode\-Stellichte",
"497475", "Burladingen",
"496835", "Beckingen",
"492963", "Brilon\-Messinghausen",
"497832", "Haslach\ im\ Kinzigtal",
"496568", "Wolsfeld",
"496472", "Weilmünster",
"494604", "Grossenwiehe",
"497633", "Staufen\ im\ Breisgau",
"499963", "Konzell",
"493605", "Leinefelde",
"498064", "Au\ bei\ Bad\ Aibling",
"496737", "Köngernheim",
"497156", "Ditzingen",
"494425", "Wangerland\-Hooksiel",
"495645", "Borgentreich\-Borgholz",
"4939295", "Zuchau",
"493531", "Finsterwalde",
"495561", "Einbeck",
"497436", "Messstetten\-Oberdigisheim",
"497520", "Bodnegg",
"496876", "Weiskirchen\ Saar",
"496161", "Brensbach",
"497123", "Metzingen\ Württemberg",
"4936202", "Neudietendorf",
"4937206", "Frankenberg\ Sachsen",
"4934907", "Jeber\-Bergfrieden",
"498407", "Grossmehring",
"498332", "Ottobeuren",
"499073", "Gundelfingen\ an\ der\ Donau",
"499398", "Birkenfeld\ bei\ Würzburg",
"498340", "Baisweil",
"494408", "Hude\ Oldenburg",
"497191", "Backnang",
"493628", "Arnstadt",
"494173", "Wulfsen",
"495086", "Celle\-Scheuen",
"495206", "Bielefeld\-Jöllenbeck",
"494964", "Rhede\ Ems",
"4938871", "Mühlen\ Eichsen",
"495066", "Sarstedt",
"4938781", "Mellen",
"499603", "Floss",
"492802", "Alpen",
"495935", "Twist\-Schöninghsdorf",
"493965", "Burow\ bei\ Altentreptow",
"497943", "Schöntal\ Jagst",
"493771", "Aue\ Sachsen",
"498502", "Fürstenzell",
"496181", "Hanau",
"495341", "Salzgitter",
"494742", "Dorum",
"495752", "Auetal\-Hattendorf",
"499802", "Ansbach\-Katterbach",
"494351", "Eckernförde",
"492603", "Bad\ Ems",
"493301", "Oranienburg",
"497383", "Münsingen\-Buttenhausen",
"495535", "Polle",
"4938759", "Tewswoos",
"496329", "Weidenthal\ Pfalz",
"494564", "Schashagen",
"493838", "Bergen\ auf\ Rügen",
"496135", "Bodenheim\ Rhein",
"497132", "Neckarsulm",
"497543", "Kressbronn\ am\ Bodensee",
"4938422", "Neukloster",
"4938302", "Sagard",
"493592", "Kirschau",
"4937436", "Weischlitz",
"498734", "Reisbach\ Niederbayern",
"498323", "Immenstadt\ im\ Allgäu",
"4934345", "Bad\ Lausick",
"495961", "Haselünne",
"493931", "Stendal",
"4939485", "Gernrode\ Harz",
"496078", "Gross\-Umstadt",
"499874", "Neuendettelsau",
"496207", "Wald\-Michelbach",
"496393", "Fischbach\ bei\ Dahn",
"499357", "Gräfendorf\ Bayern",
"496087", "Waldems",
"495775", "Diepenau",
"49431", "Kiel",
"4938823", "Selmsdorf",
"492357", "Herscheid\ Westfalen",
"494344", "Schönberg\ Holstein",
"492874", "Isselburg",
"495354", "Jerxheim",
"495305", "Sickte",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"4934497", "Langenleuba\-Niederhain",
"493585", "Löbau",
"498574", "Wittibreut",
"497363", "Lauchheim",
"495071", "Schwarmstedt",
"4939033", "Wallstawe",
"492102", "Ratingen",
"497557", "Herdwangen\-Schönach",
"495609", "Ahnatal",
"492563", "Stadtlohn",
"496881", "Lebach",
"494282", "Sittensen",
"499563", "Rödental",
"498272", "Wertingen",
"495328", "Altenau\ Harz",
"496869", "Merzig\-Silwingen",
"499102", "Wilhermsdorf",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"4939861", "Gramzow\ bei\ Prenzlau",
"4934384", "Grossbothen",
"494672", "Langenhorn",
"499343", "Lauda\-Königshofen",
"498682", "Laufen\ Salzach",
"4933704", "Baruth\ Mark",
"494262", "Visselhövede",
"496861", "Merzig",
"497823", "Seelbach\ Schutter",
"499180", "Pyrbaum",
"495601", "Schauenburg",
"497622", "Schopfheim",
"4934462", "Laucha\ Unstrut",
"492583", "Sassenberg",
"496625", "Niederaula",
"4935935", "Kleinwelka",
"493641", "Jena",
"497452", "Nagold",
"496455", "Frankenau\ Hessen",
"494873", "Aukrug",
"494295", "Emtinghausen",
"496404", "Lich\ Hessen",
"4933833", "Wollin\ bei\ Brandenburg",
"495138", "Sehnde",
"499657", "Waldthurn",
"496693", "Neuental",
"494223", "Ganderkesee\-Bookholzberg",
"499427", "Leiblfing",
"496865", "Mettlach\-Orscholz",
"4935433", "Vetschau",
"492933", "Sundern\ Sauerland",
"499933", "Wallersdorf",
"495654", "Herleshausen",
"495605", "Kaufungen\ Hessen",
"492427", "Nideggen",
"496621", "Bad\ Hersfeld",
"497663", "Eichstetten",
"49461", "Flensburg",
"4939724", "Klein\ Bünzow",
"495424", "Bad\ Rothenfelde",
"497273", "Hagenbach\ Pfalz",
"492657", "Uersfeld",
"498034", "Brannenburg",
"496451", "Frankenberg\ Eder",
"494644", "Karby",
"498822", "Oberammergau",
"496787", "Niederbrombach",
"4933432", "Müncheberg",
"4935361", "Schlieben",
"493976", "Torgelow\ bei\ Ueckermünde",
"492522", "Oelde",
"497683", "Simonswald",
"4934926", "Pretzsch\ Elbe",
"4939203", "Barleben",
"492446", "Heimbach\ Eifel",
"49821", "Augsburg",
"496629", "Schenklengsfeld",
"496308", "Olsbrücken",
"498453", "Reichertshofen\ Oberbayern",
"499446", "Altmannstein",
"4936941", "Wasungen",
"499522", "Eltmann",
"4933478", "Gross\ Neuendorf",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"498623", "Kirchweidach",
"4933633", "Spreenhagen",
"4935751", "Welzow",
"4936704", "Steinheid",
"498542", "Ortenburg",
"498133", "Haimhausen\ Oberbayern",
"498426", "Walting\ Kreis\ Eichstätt",
"495965", "Klein\ Berssen",
"493935", "Tangerhütte",
"492224", "Bad\ Honnef",
"494934", "Marienhafe",
"495036", "Neustadt\-Schneeren",
"497903", "Mainhardt",
"494372", "Westfehmarn",
"492842", "Kamp\-Lintfort",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"498656", "Anger",
"495771", "Rahden\ Westfalen",
"498382", "Lindau\ Bodensee",
"493341", "Strausberg",
"496139", "Budenheim",
"492643", "Altenahr",
"499842", "Uffenheim",
"497486", "Horb\-Altheim",
"494702", "Sandstedt",
"497322", "Giengen\ an\ der\ Brenz",
"495301", "Lehre\-Essenrode",
"496325", "Lambrecht\ Pfalz",
"493581", "Görlitz",
"495531", "Holzminden",
"4939246", "Lindau\ Anh",
"493561", "Guben",
"4938455", "Plaaz",
"495309", "Lehre\-Wendhausen",
"498395", "Tannheim\ Württemberg",
"496131", "Mainz",
"497466", "Beuron",
"4938233", "Prerow\ Ostseebad",
"495246", "Verl",
"498362", "Füssen",
"495458", "Hopsten",
"4933977", "Gumtow",
"4938371", "Karlshagen",
"494256", "Hilgermissen",
"498122", "Erding",
"4938847", "Boizenburg\ Elbe",
"493961", "Altentreptow",
"495931", "Meppen",
"4935246", "Ziegenhain\ Sachsen",
"498296", "Villenbach",
"496247", "Worms\-Pfeddersheim",
"494774", "Hechthausen",
"4939085", "Zichtau",
"498784", "Hohenthann",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"496185", "Hammersbach\ Hessen",
"497182", "Welzheim",
"495345", "Baddeckenstedt",
"492620", "Neuhäusel\ Westerwald",
"4936644", "Hirschberg\ Saale",
"4936461", "Bad\ Sulza",
"497724", "St\ Georgen\ im\ Schwarzwald",
"494355", "Rieseby",
"495585", "Herzberg\-Sieber",
"497333", "Laichingen",
"493877", "Wittenberge",
"497503", "Wilhelmsdorf\ Württemberg",
"493868", "Rastow",
"495838", "Gross\ Oesingen",
"494534", "Steinburg\ Kreis\ Storman",
"493535", "Herzberg\ Elster",
"495565", "Einbeck\-Wenzen",
"4939751", "Penkun",
"4936844", "Rohr\ Thüringen",
"497162", "Süssen",
"496165", "Breuberg",
"4938323", "Prohn",
"4933479", "Küstrin\-Kietz",
"498764", "Mauern\ Kreis\ Freising",
"4936333", "Heringen\ Helme",
"496648", "Bad\ Salzschlirf",
"495592", "Gleichen\-Bremke",
"496226", "Meckesheim",
"497195", "Winnenden",
"493981", "Neustrelitz",
"495939", "Sustrum",
"493969", "Siedenbollentin",
"496192", "Hofheim\ am\ Taunus",
"493576", "Weisswasser",
"4934774", "Röblingen\ am\ See",
"4939361", "Lüderitz",
"492773", "Haiger",
"495250", "Delbrück\ Westfalen",
"494232", "Langwedel\ Kreis\ Verden",
"496831", "Saarlouis",
"497471", "Hechingen",
"494240", "Syke\-Heiligenfelde",
"4934363", "Cavertitz",
"4935203", "Tharandt",
"494493", "Friesoythe\-Gehlenberg",
"499303", "Eibelstadt",
"4933970", "Neustadt\ Dosse",
"4939832", "Wesenberg",
"492922", "Werl",
"496253", "Fürth\ Odenwald",
"496444", "Bischoffen",
"492297", "Wildbergerhütte",
"499922", "Zwiesel",
"492303", "Unna",
"4930", "Berlin",
"4937324", "Reinsberg\ Sachsen",
"49641", "Giessen",
"493601", "Mühlhausen\ Thüringen",
"494421", "Wilhelmshaven",
"495641", "Warburg",
"499773", "Unsleben",
"495294", "Hövelhof\-Espeln",
"498259", "Schiltberg",
"4933202", "Töplitz",
"498251", "Aichach",
"492533", "Münster\-Nienberge",
"495766", "Rehburg\-Loccum",
"495052", "Hermannsburg",
"4939976", "Gross\ Bützin",
"493328", "Teltow",
"499533", "Untermerzbach",
"499142", "Treuchtlingen",
"498640", "Reit\ Im\ Winkl",
"4935724", "Lohsa",
"496465", "Breidenbach\ bei\ Biedenkopf",
"497462", "Immendingen",
"499827", "Lichtenau\ Mittelfranken",
"497578", "Wald\ Hohenz",
"4938828", "Schönberg",
"497587", "Hosskirch",
"498239", "Langenneufnach",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"497347", "Dietenheim",
"494631", "Glücksburg\ Ostsee",
"4937292", "Oederan",
"4933086", "Grieben\ Kreis\ Oberhavel",
"4935694", "Gosda\ bei\ Klinge",
"498041", "Bad\ Tölz",
"492725", "Lennestadt\-Oedingen",
"4938856", "Pritzier\ bei\ Hagenow",
"496851", "St\ Wendel",
"494252", "Bruchhausen\-Vilsen",
"499725", "Poppenhausen\ Unterfranken",
"496233", "Frankenthal\ Pfalz",
"495824", "Bad\ Bodenteich",
"494528", "Schönwalde\ am\ Bungsberg",
"492827", "Goch\-Hassum",
"498366", "Oy\-Mittelberg",
"495242", "Rheda\-Wiedenbrück",
"498386", "Oberstaufen",
"496043", "Nidda",
"495197", "Soltau\-Frielingen",
"498652", "Berchtesgaden",
"495032", "Neustadt\ am\ Rübenberge",
"4938201", "Gelbensande",
"499553", "Ebrach\ Oberfranken",
"496597", "Jünkerath",
"498546", "Windorf\-Otterskirchen",
"497738", "Steisslingen",
"498422", "Dollnstein",
"492150", "Meerbusch\-Lank",
"4935386", "Prettin",
"494639", "Schafflund",
"492553", "Ochtrup",
"494706", "Schiffdorf",
"499194", "Ebermannstadt",
"4939080", "Kalbe\ Milde",
"4935894", "Hähnichen",
"497326", "Neresheim",
"497567", "Leutkirch\-Friesenhofen",
"497482", "Horb\-Dettingen",
"499846", "Ipsheim",
"496485", "Nentershausen\ Westerwald",
"498231", "Königsbrunn\ bei\ Augsburg",
"494335", "Hohn\ bei\ Rendsburg",
"497353", "Schwendi",
"4939991", "Daberkow",
"492526", "Sendenhorst",
"493723", "Hohenstein\-Ernstthal",
"493334", "Eberswalde",
"495364", "Velpke",
"492367", "Henrichenburg",
"4936454", "Magdala",
"49335", "Frankfurt\ \(Oder\)",
"494129", "Haseldorf",
"494941", "Aurich",
"499367", "Unterpleichfeld",
"499442", "Riedenburg",
"499526", "Riedbach",
"495951", "Werlte",
"4934742", "Sylda",
"498745", "Bodenkirchen",
"494193", "Henstedt\-Ulzburg",
"499547", "Zapfendorf",
"497171", "Schwäbisch\ Gmünd",
"4938457", "Krakow\ am\ See",
"499378", "Eichenbühl\-Riedern",
"499093", "Polsingen",
"496057", "Flörsbachtal",
"49551", "Göttingen",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"498847", "Obersöchering",
"494121", "Elmshorn",
"492387", "Drensteinfurt\-Walstedde",
"494848", "Rantrum",
"492378", "Fröndenberg\-Langschede",
"495544", "Reinhardshagen",
"4939038", "Henningen",
"499708", "Bad\ Bocklet",
"49611", "Wiesbaden",
"495858", "Hitzacker\-Wietzetze",
"495384", "Seesen\-Gross\ Rhüden",
"494554", "Wahlstedt",
"492547", "Rosendahl\-Osterwick",
"4933601", "Podelzig",
"494505", "Stockelsdorf\-Curau",
"493504", "Dippoldiswalde",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"4939087", "Jerchel\ Altmark",
"496703", "Wöllstein\ Rheinhessen",
"494361", "Oldenburg\ in\ Holstein",
"498379", "Waltenhofen\-Oberdorf",
"496159", "Messel",
"4938845", "Kaarssen",
"498636", "Ampfing",
"492850", "Rees\-Haldern",
"495944", "Hoogstede",
"496373", "Schönenberg\-Kübelberg",
"49591", "Lingen\ \(Ems\)",
"498709", "Eching\ Niederbayern",
"498550", "Philippsreut",
"493904", "Haldensleben",
"498153", "Wessling",
"499146", "Markt\ Berolzheim",
"495056", "Winsen\-Meissendorf",
"492947", "Anröchte",
"494954", "Moormerland",
"4933741", "Niedergörsdorf",
"499127", "Rosstal\ Mittelfranken",
"494236", "Kirchlinteln",
"4938753", "Wöbbelin",
"498028", "Fischbachau",
"4933338", "Stolpe\/Oder",
"4939401", "Neuwegersleben",
"495438", "Bakum\-Lüsche",
"4939321", "Arneburg",
"496151", "Darmstadt",
"494541", "Ratzeburg",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"4937364", "Reitzenhain\ Erzgebirge",
"495551", "Northeim",
"494381", "Lütjenburg",
"499926", "Frauenau",
"496524", "Rodershausen",
"494275", "Ehrenburg",
"494893", "Hohenaspe",
"498285", "Burtenbach",
"497166", "Adelberg",
"492637", "Weissenthurm",
"496431", "Limburg\ an\ der\ Lahn",
"498054", "Breitbrunn\ am\ Chiemsee",
"499953", "Pilsting",
"495634", "Waldeck\-Sachsenhausen",
"4933054", "Liebenwalde",
"494665", "Emmelsbüll\-Horsbüll",
"496558", "Büdesheim\ Eifel",
"496196", "Bad\ Soden\ am\ Taunus",
"497225", "Gaggenau",
"4939386", "Seehausen\ Altmark",
"492953", "Wünnenberg",
"496222", "Wiesloch",
"494821", "Itzehoe",
"494148", "Drochtersen\-Assel",
"495158", "Hemeringen",
"49681", "Saarbrücken",
"499637", "Falkenberg\ Oberpfalz",
"4937754", "Zwönitz",
"4938450", "Tarnow\ bei\ Bützow",
"497967", "Jagstzell",
"496844", "Blieskastel\-Altheim",
"4939039", "Bonese",
"496020", "Heigenbrücken",
"4934446", "Grosskorbetha",
"499238", "Röslau",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"498292", "Dinkelscherben",
"498433", "Königsmoos",
"494829", "Wewelsfleth",
"494928", "Ihlow\-Riepe",
"4936421", "Camburg",
"492238", "Pulheim",
"498265", "Pfaffenhausen\ Schwaben",
"496439", "Holzappel",
"4939742", "Brüssow\ bei\ Pasewalk",
"497072", "Gomaringen",
"495459", "Hörstel",
"492296", "Reichshof\-Brüchermühle",
"4939455", "Schierke",
"495308", "Lehre",
"4933603", "Falkenhagen\ bei\ Seelow",
"493588", "Niesky",
"499122", "Schwabach",
"498450", "Ingolstadt\-Zuchering",
"496138", "Mommenheim",
"495693", "Volkmarsen",
"4935323", "Sonnewalde",
"4933395", "Zerpenschleuse",
"492942", "Geseke",
"497803", "Gengenbach",
"4938789", "Wolfshagen\ bei\ Perleberg",
"494834", "Büsum",
"495865", "Gusborn",
"4939993", "Hohenmocker",
"499764", "Höchheim",
"496654", "Gersfeld\ Rhön",
"492764", "Welschen\ Ennest",
"494441", "Vechta",
"495621", "Bad\ Wildungen",
"4935022", "Bad\ Schandau",
"499942", "Viechtach",
"496424", "Ebsdorfergrund",
"495767", "Warmsen",
"497660", "St\ Peter\ Schwarzwald",
"493737", "Rochlitz",
"495451", "Ibbenbüren",
"4937204", "Lichtenstein\ Sachsen",
"4935602", "Drebkau",
"496531", "Bernkastel\-Kues",
"498773", "Neufahrn\ in\ Niederbayern",
"4938203", "Bad\ Doberan",
"493876", "Perleberg",
"495131", "Garbsen",
"4938737", "Ganzlin",
"496246", "Eich\ Rheinhessen",
"498303", "Waltenhofen",
"494298", "Lilienthal",
"496458", "Rosenthal\ Hessen",
"496628", "Oberaula",
"4933846", "Dippmannsdorf",
"492833", "Kerken",
"499632", "Waldsassen",
"497962", "Fichtenau",
"496036", "Wölfersheim",
"492251", "Euskirchen",
"498533", "Rotthalmünster",
"498142", "Olching",
"4936734", "Leutenberg",
"496771", "St\ Goarshausen",
"496227", "Walldorf\ Baden",
"495139", "Burgwedel",
"497744", "Stühlingen",
"49771", "Donaueschingen",
"4938724", "Siggelkow",
"499251", "Münchberg",
"494763", "Gnarrenburg",
"496301", "Otterbach\ Pfalz",
"492632", "Andernach",
"495325", "Goslar\-Hahnenklee",
"499833", "Heidenheim\ Mittelfranken",
"4936622", "Triebes",
"496838", "Saarwellingen",
"497562", "Isny\ im\ Allgäu",
"493329", "Stahnsdorf",
"497478", "Hirrlingen",
"496565", "Dudeldorf",
"494134", "Embsen\ Kreis\ Lüneburg",
"495165", "Rethem\ Aller",
"495037", "Bad\ Rehburg",
"498427", "Wellheim",
"495648", "Brakel\-Gehrden",
"496592", "Daun",
"495226", "Bruchmühlen\ Westfalen",
"4936423", "Orlamünde",
"498657", "Ramsau\ bei\ Berchtesgaden",
"495192", "Munster",
"492822", "Emmerich",
"495247", "Harsewinkel",
"4937465", "Tannenbergsthal\ Vogtland",
"494257", "Schweringen",
"492691", "Adenau",
"492244", "Königswinter\-Oberpleis",
"499453", "Thalmassing",
"498446", "Pörnbach",
"4936695", "Söllmnitz",
"498258", "Sielenbach",
"49221", "Cologne",
"4933967", "Freyenstein",
"49921", "Bayreuth",
"495185", "Duingen",
"496345", "Albersweiler",
"492453", "Heinsberg\-Randerath",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"499244", "Betzenstein",
"493321", "Nauen\ Brandenburg",
"496585", "Ralingen",
"497582", "Bad\ Buchau",
"492623", "Ransbach\-Baumbach",
"4938788", "Gross\ Warnow",
"497751", "Waldshut",
"497467", "Neuhausen\ ob\ Eck",
"499822", "Bechhofen\ an\ der\ Heide",
"4939323", "Schönhausen\ Elbe",
"492542", "Gescher",
"492133", "Dormagen",
"492426", "Nörvenich",
"498224", "Offingen\ Donau",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"4938751", "Picher",
"492656", "Virneburg",
"496766", "Kisselbach",
"4933925", "Wustrau\-Altfriesack",
"4937342", "Cranzahl",
"4933743", "Blönsdorf",
"493968", "Schönbeck",
"4933232", "Brieselang",
"4934321", "Leisnig",
"492382", "Ahlen\ Westfalen",
"496052", "Bad\ Orb",
"499382", "Gerolzhofen",
"495839", "Wittingen\-Ohrdorf",
"493869", "Dümmer",
"499656", "Moosbach\ bei\ Vohenstrauss",
"497055", "Neuweiler\ Kreis\ Calw",
"493881", "Grevesmühlen",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"4939602", "Kleeth",
"499426", "Oberschneiding",
"499133", "Baiersdorf\ Mittelfranken",
"499542", "Schesslitz",
"494243", "Twistringen",
"492395", "Finnentrop\-Rönkhausen",
"499447", "Essing",
"497674", "Todtmoos",
"497264", "Bad\ Rappenau",
"495831", "Wittingen",
"493861", "Plate",
"492770", "Eschenburg",
"4935455", "Walddrehna",
"495253", "Bad\ Driburg",
"495444", "Wagenfeld",
"492362", "Dorsten",
"496786", "Kempfeld",
"494624", "Kropp",
"49541", "Osnabrück",
"496294", "Krautheim\ Jagst",
"496641", "Lauterbach\ Hessen",
"494405", "Edewecht",
"4937434", "Bobenneukirchen",
"492447", "Dahlem\ bei\ Kall",
"499395", "Triefenstein",
"494454", "Jade",
"4938231", "Barth",
"492594", "Dülmen",
"495043", "Lauenau",
"498146", "Moorenweis",
"499153", "Schnaittach",
"4936028", "Kammerforst\ Thüringen",
"4939457", "Benneckenstein\ Harz",
"492379", "Menden\-Asbeck",
"494849", "Hooge",
"495859", "Thomasburg",
"497966", "Unterschneidheim",
"496032", "Bad\ Nauheim",
"4936608", "Seelingstädt\ bei\ Gera",
"499636", "Plössberg",
"492636", "Burgbrohl",
"4938373", "Katzow",
"494948", "Wiesmoor\-Marcardsmoor",
"4935829", "Gersdorf\ bei\ Görlitz",
"492153", "Nettetal\-Lobberich",
"495485", "Ladbergen",
"495465", "Neuenkirchen\ bei\ Bramsche",
"499371", "Miltenberg",
"493435", "Oschatz",
"494434", "Colnrade",
"497403", "Dunningen",
"49340", "Dessau\ Anh",
"4933397", "Wandlitz",
"4935753", "Grossräschen",
"495492", "Steinfeld\ Oldenburg",
"495851", "Dahlenburg",
"499701", "Sandberg\ Unterfranken",
"495233", "Steinheim\ Westfalen",
"496824", "Ottweiler",
"497245", "Durmersheim",
"496242", "Osthofen",
"492371", "Iserlohn",
"494841", "Husum\ Nordsee",
"494128", "Kollmar",
"4938735", "Plau\ am\ See",
"499090", "Rain\ Lech",
"494638", "Tarp",
"4939201", "Wolmirstedt",
"4935774", "Boxberg\ Sachsen",
"498637", "Lohkirchen",
"492054", "Essen\-Kettwig",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"4939926", "Grabowhöfe",
"4935363", "Fermerswalde",
"4934203", "Zwenkau",
"49203", "Duisburg",
"499147", "Nennslingen",
"497571", "Sigmaringen",
"49651", "Trier",
"4933631", "Bad\ Saarow\-Pieskow",
"494154", "Trittau",
"494105", "Seevetal",
"499946", "Hohenwarth\ bei\ Kötzing",
"496544", "Rhaunen",
"496858", "Ottweiler\-Fürth",
"496384", "Konken",
"49511", "Hannover",
"499285", "Kirchenlamitz",
"4936943", "Bettenhausen\ Thüringen",
"4939008", "Kunrau",
"494521", "Eutin",
"497739", "Hilzingen",
"495144", "Wathlingen",
"4933362", "Liepe\ Kreis\ Barnim",
"497731", "Singen\ Hohentwiel",
"4939856", "Beenz\ bei\ Prenzlau",
"499265", "Pressig",
"496364", "Nussbach\ Pfalz",
"494529", "Süsel\-Bujendorf",
"499927", "Kirchberg\ Wald",
"492292", "Windeck\ Sieg",
"499675", "Altendorf\ am\ Nabburg",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"492433", "Hückelhoven",
"4933831", "Weseram",
"499433", "Nabburg",
"499126", "Eckental",
"497394", "Schelklingen",
"494237", "Bendingbostel",
"497579", "Schwenningen\ Baden",
"492675", "Ediger\-Eller",
"499292", "Konradsreuth",
"492927", "Neuengeseke",
"4933920", "Walsleben\ bei\ Neuruppin",
"498238", "Gessertshausen",
"495924", "Bad\ Bentheim\-Gildehaus",
"492265", "Reichshof\-Eckenhagen",
"4938354", "Wusterhusen",
"494929", "Ihlow\ Kreis\ Aurich",
"499366", "Geroldshausen\ Unterfranken",
"492041", "Bottrop",
"498725", "Wurmannsquick",
"499527", "Knetzgau",
"4933456", "Wriezen",
"496438", "Hünfelden",
"4935828", "Reichenbach\ OL",
"495151", "Hameln",
"4936029", "Menteroda",
"492527", "Lippetal\-Lippborg",
"4934632", "Mücheln\ Geiseltal",
"4934976", "Gröbzig",
"496124", "Bad\ Schwalbach",
"496782", "Birkenfeld\ Nahe",
"496551", "Prüm",
"492366", "Herten\ Westfalen",
"494141", "Stade",
"495524", "Bad\ Lauterberg\ im\ Harz",
"494828", "Lägerdorf",
"496559", "Leidenborn",
"497765", "Rickenbach\ Hotzenwald",
"4939884", "Hassleben\ bei\ Prenzlau",
"4936254", "Friedrichswerth",
"499231", "Marktredwitz",
"4935201", "Langebrück",
"4939774", "Mönkebude",
"4934361", "Dahlen\ Sachsen",
"499853", "Wilburgstetten",
"498846", "Uffing\ am\ Staffelsee",
"4939396", "Neukirchen\ Altmark",
"496897", "Sulzbach\ Saar",
"495703", "Hille",
"494149", "Fredenbeck",
"496762", "Kastellaun",
"492652", "Mendig",
"4933965", "Herzsprung\ bei\ Wittstock",
"497971", "Gaildorf",
"495159", "Coppenbrügge\-Bisperode",
"498194", "Vilgertshofen",
"492546", "Coesfeld\-Lette",
"4939363", "Angern",
"4937467", "Klingenthal\ Sachsen",
"492422", "Kreuzau",
"499422", "Bogen\ Niederbayern",
"499546", "Burgebrach",
"498553", "Spiegelau",
"495373", "Hillerse\ Kreis\ Gifhorn",
"499652", "Waidhaus",
"494921", "Emden\ Stadt",
"492853", "Schermbeck",
"496056", "Bad\ Soden\-Salmünster",
"499386", "Prosselsheim",
"4939062", "Bebertal",
"4938321", "Martensdorf\ bei\ Stralsund",
"4933927", "Linum",
"498442", "Wolnzach",
"4939753", "Strasburg",
"498367", "Rosshaupten\ Forggensee",
"496023", "Alzenau\ in\ Unterfranken",
"4939009", "Badel",
"492826", "Kranenburg\ Niederrhein",
"4936084", "Heuthen",
"4939959", "Dargun",
"4933657", "Steinsdorf\ Brandenburg",
"497586", "Herbertingen",
"499826", "Weidenbach\ Mittelfranken",
"498029", "Kreuth\ bei\ Tegernsee",
"495439", "Bersenbrück",
"4936331", "Ilfeld",
"497346", "Illerkirchberg",
"497327", "Dischingen",
"492745", "Brachbach\ Sieg",
"498021", "Waakirchen",
"494707", "Langen\-Neuenwalde",
"498708", "Weihmichl\-Unterneuhausen",
"495431", "Quakenbrück",
"493461", "Merseburg\ Saale",
"492994", "Marsberg\-Westheim",
"496634", "Gemünden\ Felda",
"499847", "Ergersheim",
"497566", "Argenbühl",
"494854", "Friedrichskoog",
"495196", "Wietzendorf",
"494805", "Schafstedt",
"498093", "Glonn\ Kreis\ Ebersberg",
"498387", "Weiler\-Simmerberg",
"495222", "Bad\ Salzuflen",
"498378", "Buchenberg\ bei\ Kempten",
"4936463", "Gebstedt",
"497081", "Bad\ Wildbad",
"496158", "Riedstadt",
"49581", "Uelzen",
"498547", "Osterhofen\-Gergweis",
"496596", "Üdersdorf",
"4939829", "Blankenförde",
"499745", "Wildflecken",
"495844", "Clenze",
"495872", "Stoetze",
"4935329", "Dollenchen",
"494464", "Wittmund\-Carolinensiel",
"498025", "Miesbach",
"492741", "Betzdorf",
"495435", "Berge\ bei\ Quakenbrück",
"497443", "Dornstetten",
"492686", "Weyerbusch",
"4939999", "Tutow",
"4938783", "Dallmin",
"492352", "Altena\ Westfalen",
"4936965", "Stadtlengsfeld",
"4938873", "Carlow",
"495263", "Barntrup",
"499352", "Lohr\ am\ Main",
"496082", "Niederreifenberg",
"496202", "Schwetzingen",
"497085", "Enzklösterle",
"497254", "Waghäusel",
"496670", "Ludwigsau\ Hessen",
"499741", "Bad\ Brückenau",
"495673", "Immenhausen\ Hessen",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"499749", "Oberbach\ Unterfranken",
"499276", "Bischofsgrün",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"499666", "Illschwang",
"498106", "Vaterstetten",
"4936428", "Stadtroda",
"497936", "Schrozberg\-Bartenstein",
"496062", "Erbach\ Odenwald",
"495283", "Lügde\-Rischenau",
"4933609", "Brieskow\-Finkenheerd",
"492666", "Freilingen\ Westerwald",
"496756", "Winterbach\ Soonwald",
"496095", "Bessenbach",
"494484", "Hude\-Wüsting",
"497457", "Rottenburg\-Ergenzingen",
"497761", "Bad\ Säckingen",
"496334", "Thaleischweiler\-Fröschen",
"499235", "Thierstein",
"496723", "Oestrich\-Winkel",
"497627", "Steinen\ Kreis\ Lörrach",
"497975", "Untergröningen",
"492463", "Titz",
"498268", "Tussenhausen",
"499463", "Wald\ Oberpfalz",
"494267", "Lauenbrück",
"49208", "Oberhausen\ Rheinland",
"4938297", "Moitin",
"494925", "Hinte",
"4935384", "Steinsdorf\ bei\ Jessen",
"498687", "Taching\-Tengling",
"492235", "Erftstadt",
"4934295", "Krensitz",
"498678", "Marktl",
"495476", "Ostercappeln\-Venne",
"4938209", "Sanitz\ bei\ Rostock",
"499107", "Trautskirchen",
"498667", "Seeon\-Seebruck",
"4938854", "Redefin",
"4935696", "Briesnig",
"4933084", "Gutengermendorf",
"494668", "Klanxbüll",
"494287", "Heeslingen\-Boitzen",
"498721", "Eggenfelden",
"4936927", "Unterellen",
"492045", "Bottrop\-Kirchhellen",
"4939328", "Rochau",
"4939408", "Hadmersleben",
"495155", "Emmerthal",
"4933331", "Casekow",
"49906", "Donauwörth",
"4934222", "Arzberg\ bei\ Torgau",
"497646", "Weisweil\ Breisgau",
"497228", "Forbach",
"496504", "Thalfang",
"496555", "Bleialf",
"499906", "Mariaposching",
"497552", "Pfullendorf",
"4933748", "Treuenbrietzen",
"499289", "Schwarzenbach\ am\ Wald",
"492506", "Münster\-Wolbeck",
"496732", "Wörrstadt",
"494753", "Balje",
"497735", "Öhningen",
"4934444", "Lützen",
"499261", "Kronach",
"494109", "Tangstedt\ Bz\ Hamburg",
"499671", "Oberviechtach",
"498806", "Utting\ am\ Ammersee",
"495743", "Espelkamp\-Gestringen",
"4933767", "Friedersdorf\ bei\ Berlin",
"496477", "Greifenstein\-Nenderoth",
"492671", "Cochem",
"497837", "Oberharmersbach",
"492261", "Gummersbach",
"497952", "Gerabronn",
"4939998", "Loitz\ bei\ Demmin",
"4939050", "Bartensleben",
"495172", "Ilsede",
"492269", "Kierspe\-Rönsahl",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"4933608", "Jacobsdorf\ Mark",
"499336", "Bütthard",
"496468", "Dautphetal\-Mornshausen",
"496572", "Manderscheid\ Eifel",
"4939031", "Dähre",
"497575", "Messkirch",
"494101", "Pinneberg",
"4937756", "Breitenbrunn\ Erzgebirge",
"4939863", "Seehausen\ bei\ Prenzlau",
"499281", "Hof\ Saale",
"492336", "Schwelm",
"4939384", "Arendsee\ Altmark",
"494525", "Ahrensbök",
"499269", "Tettau\ Kreis\ Kronach",
"499728", "Wülfershausen\ Unterfranken",
"499375", "Freudenberg\ Baden",
"495461", "Bramsche\ Hase",
"493431", "Döbeln",
"496274", "Waldbrunn\ Odenwald",
"497420", "Deisslingen",
"494747", "Beverstedt",
"496664", "Sinntal\-Sterbfritz",
"4935057", "Hermsdorf\ Erzgebirge",
"492754", "Bad\ Laasphe\-Feudingen",
"494508", "Krummesse",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"495855", "Nahrendorf",
"498507", "Neuburg\ am\ Inn",
"4937366", "Rübenau",
"493844", "Schwaan",
"4938821", "Lüdersdorf",
"492375", "Balve",
"494845", "Ostenfeld\ Husum",
"49381", "Rostock",
"4936920", "Grossenlupnitz",
"4936484", "Knau\ bei\ Pössneck",
"498460", "Berching\-Holnstein",
"497249", "Stutensee",
"4939409", "Eilsleben",
"4939329", "Möringen",
"498402", "Münchsmünster",
"494338", "Alt\ Duvenstedt",
"4937605", "Hartenstein\ Sachsen",
"497031", "Böblingen",
"498337", "Altenstadt\ Iller",
"497306", "Vöhringen\ Iller",
"496684", "Hofbieber\-Schwarzbach",
"4935793", "Elstra",
"4938208", "Kavelstorf",
"4939345", "Parchen",
"495481", "Lengerich\ Westfalen",
"4934783", "Gerbstedt",
"492391", "Plettenberg",
"497843", "Renchen",
"493693", "Meiningen",
"4936967", "Geisa",
"495835", "Wahrenholz",
"492902", "Warstein",
"493865", "Holthusen",
"499323", "Iphofen",
"499734", "Burkardroth",
"494864", "Oldenswort",
"4939244", "Steutz",
"495472", "Bad\ Essen",
"493621", "Gotha\ Thüringen",
"4935953", "Burkau",
"497556", "Uhldingen\-Mühlhofen",
"4938791", "Bad\ Wilsnack",
"492734", "Freudenberg\ Westfalen",
"492323", "Herne",
"4934262", "Falkenhain\ bei\ Wurzen",
"497642", "Endingen\ Kaiserstuhl",
"499391", "Marktheidenfeld",
"494401", "Brake\ Unterweser",
"496645", "Ulrichstein",
"499574", "Marktzeuln",
"4939055", "Hörsingen",
"494409", "Westerstede\-Ocholt",
"493629", "Stadtilm",
"494358", "Loose\ bei\ Eckernförde",
"494884", "Schwabstedt",
"4938379", "Benz\ Usedom",
"497051", "Calw",
"496188", "Kahl\ am\ Main",
"4935823", "Ostritz",
"492574", "Saerbeck",
"4934673", "Heldrungen",
"497932", "Niederstetten\ Württemberg",
"496066", "Michelstadt\-Vielbrunn",
"497940", "Künzelsau",
"492863", "Velen",
"4934924", "Zahna",
"498102", "Höhenkirchen\-Siegertsbrunn",
"499662", "Vilseck",
"499272", "Fichtelberg",
"492695", "Insul",
"497374", "Uttenweiler",
"498563", "Bad\ Birnbach\ Rottal",
"4937600", "Neumark\ Sachsen",
"495181", "Alfeld\ Leine",
"4938295", "Satow\ bei\ Bad\ Doberan",
"496341", "Landau\ in\ der\ Pfalz",
"4934297", "Liebertwolkwitz",
"4934654", "Stolberg\ Harz",
"492272", "Bedburg\ Erft",
"492662", "Hachenburg",
"496752", "Kirn\ Nahe",
"496581", "Saarburg",
"497704", "Geisingen\ Baden",
"494733", "Butjadingen\-Burhave",
"497755", "Weilheim\ Kreis\ Waldshut",
"494324", "Brokstedt",
"496569", "Bickendorf",
"496589", "Kell\ am\ See",
"4936071", "Teistungen",
"4936925", "Marksuhl",
"4936743", "Teichel",
"496561", "Bitburg",
"492682", "Hamm\ Sieg",
"495161", "Walsrode",
"496349", "Billigheim\-Ingenheim",
"498583", "Neureichenau",
"4939726", "Ducherow",
"499682", "Erbendorf",
"493496", "Köthen\ Anhalt",
"4938222", "Semlow",
"4935974", "Hinterhermsdorf",
"499356", "Burgsinn",
"498343", "Aitrang",
"496086", "Grävenwiesbach",
"4936949", "Obermassfeld\-Grimmenthal",
"499070", "Tapfheim",
"496206", "Lampertheim",
"492204", "Bensberg",
"498406", "Böhmfeld",
"492255", "Euskirchen\-Flamersheim",
"495207", "Schloss\ Holte\-Stukenbrock",
"496775", "Strüth\ Taunus",
"4935726", "Gross\ Särchen",
"494184", "Hanstedt\ Nordheide",
"494973", "Wittmund\-Burhafe",
"4933765", "Märkisch\ Buchholz",
"499084", "Bissingen\ Schwaben",
"496888", "Lebach\-Steinbach",
"499255", "Marktleugast",
"496305", "Hochspeyer",
"499204", "Plankenfels",
"495321", "Goslar",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"494722", "Cuxhaven\-Altenbruch",
"496535", "Osann\-Monzel",
"4938378", "Heringsdorf\ Seebad",
"497532", "Meersburg",
"495329", "Schulenberg\ im\ Oberharz",
"497143", "Besigheim",
"496868", "Mettlach\-Tünsdorf",
"495135", "Burgwedel\-Fuhrberg",
"4934776", "Rothenschirmbach",
"494164", "Harsefeld",
"4936023", "Horsmar",
"495067", "Bockenem",
"492064", "Dinslaken",
"495608", "Söhrewald",
"4938332", "Gross\ Bisdorf",
"4937326", "Frauenstein\ Sachsen",
"4936603", "Weida",
"498320", "Missen\-Wilhams",
"4937381", "Penig",
"4933734", "Felgentreu",
"499183", "Burgthann",
"499974", "Traitsching",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"499340", "Königheim\-Brehmen",
"4936846", "Suhl\-Dietzhausen",
"4938485", "Dabel",
"498073", "Gars\ am\ Inn",
"499332", "Marktbreit",
"499407", "Wenzenbach",
"497234", "Tiefenbronn",
"495176", "Edemissen",
"495861", "Dannenberg\ Elbe",
"493831", "Stralsund",
"494203", "Weyhe\ bei\ Bremen",
"49341", "Leipzig",
"494445", "Visbek\ Kreis\ Vechta",
"492407", "Herzogenrath\-Kohlscheid",
"495625", "Naumburg\ Hessen",
"492332", "Gevelsberg",
"495977", "Spelle",
"492974", "Schmallenberg\-Fredeburg",
"4939823", "Rechlin",
"492183", "Rommerskirchen",
"495455", "Tecklenburg\-Brochterbeck",
"495404", "Westerkappeln",
"496071", "Dieburg",
"492163", "Schwalmtal\ Niederrhein",
"4937607", "Ebersbrunn\ Sachsen",
"498802", "Huglfing",
"4935244", "Krögis",
"4936948", "Römhild",
"4939003", "Jübar",
"496736", "Bechenheim",
"498860", "Bernbeuren",
"497157", "Waldenbuch",
"492502", "Nottuln",
"4939347", "Kade",
"499502", "Frensdorf",
"496328", "Elmstein",
"4936646", "Tanna\ bei\ Schleiz",
"4939953", "Schwinkendorf",
"499560", "Grub\ am\ Forst",
"4934208", "Löbnitz\ bei\ Delitzsch",
"497044", "Mönsheim",
"499163", "Dachsbach",
"4939422", "Badersleben",
"4939928", "Möllenhagen",
"4933931", "Rheinsberg\ Mark",
"497959", "Frankenhardt",
"495171", "Peine",
"493836", "Wolgast",
"498733", "Mengkofen",
"498324", "Hindelang",
"4939956", "Neukalen",
"496571", "Wittlich",
"4936643", "Thimmendorf",
"49751", "Ravensburg",
"4939006", "Miesterhorst",
"494102", "Ahrensburg",
"497544", "Markdorf",
"497384", "Schelklingen\-Hütten",
"494563", "Scharbeutz\-Haffkrug",
"499282", "Naila",
"495353", "Königslutter\ am\ Elm",
"499262", "Wallenfels",
"494180", "Königsmoor",
"4939826", "Blankensee\ bei\ Neustrelitz",
"498170", "Strasslach\-Dingharting",
"4936334", "Wolkramshausen",
"496731", "Alzey",
"498573", "Ering",
"497364", "Oberkochen",
"499080", "Harburg\ Schwaben",
"492295", "Ruppichteroth",
"499672", "Neunburg\ vorm\ Wald",
"4939858", "Bietikow",
"492873", "Isselburg\-Werth",
"494343", "Laboe",
"4936843", "Benshausen",
"499873", "Abenberg\-Wassermungenau",
"492672", "Treis\-Karden",
"496394", "Bundenthal",
"499295", "Töpen",
"4936081", "Arenshausen",
"4938324", "Velgast",
"497951", "Crailsheim",
"492262", "Wiehl",
"4939427", "Ströbeck",
"4937323", "Lichtenberg\ Erzgebirge",
"4936606", "Kraftsdorf",
"497032", "Herrenberg",
"499564", "Bad\ Rodach",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"4936026", "Struth\ bei\ Mühlhausen",
"496035", "Reichelsheim\ Wetterau",
"4939342", "Gladau",
"496167", "Modautal",
"492564", "Vreden",
"4934773", "Schwittersdorf",
"495326", "Langelsheim",
"4939881", "Ringenwalde\ bei\ Templin",
"493537", "Jessen\ Elster",
"4937602", "Kirchberg\ Sachsen",
"495482", "Tecklenburg",
"4934364", "Wermsdorf",
"4935204", "Wilsdruff",
"4939771", "Ueckermünde",
"493307", "Zehdenick",
"49231", "Dortmund",
"494874", "Todenbüttel",
"495462", "Ankum",
"496403", "Linden\ Hessen",
"494357", "Sehestedt\ Eider",
"4935723", "Bernsdorf\ OL",
"495347", "Burgdorf\ bei\ Salzgitter",
"492584", "Warendorf\-Milte",
"496187", "Schöneck",
"4938220", "Wustrow\ Ostseebad",
"495495", "Vörden\ Kreis\ Vechta",
"497824", "Schwanau",
"496245", "Biblis",
"499344", "Gerchsheim",
"4939399", "Kleinau",
"49931", "Würzburg",
"497242", "Rheinstetten",
"498445", "Gerolsbach",
"4934721", "Nienburg\ Saale",
"495978", "Hörstel\-Dreierwalde",
"492408", "Aachen\-Kornelimünster",
"4938351", "Mesekenhagen",
"496061", "Michelstadt",
"497023", "Weilheim\ an\ der\ Teck",
"499359", "Karlstadt\-Wiesenfeld",
"492984", "Hallenberg",
"492173", "Langenfeld\ Rheinland",
"4939723", "Krien",
"496209", "Mörlenbach",
"496586", "Beuren\ Hochwald",
"499173", "Thalmässing",
"492359", "Kierspe",
"4933834", "Pritzerbe",
"4939929", "Jabel\ bei\ Waren",
"495186", "Salzhemmendorf\-Wallensen",
"4935434", "Altdöbern",
"499408", "Altenthann",
"498203", "Grossaitingen",
"498083", "Isen",
"496346", "Annweiler\ am\ Trifels",
"498063", "Feldkirchen\-Westerham",
"496327", "Neustadt\-Lachen",
"493423", "Eilenburg",
"492742", "Wissen",
"495166", "Walsrode\-Kirchboitzen",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"492351", "Lüdenscheid",
"4935342", "Mühlberg\ Elbe",
"494603", "Havetoft",
"497634", "Sulzburg",
"499964", "Stallwang",
"496566", "Körperich",
"492964", "Brilon\-Alme",
"493491", "Lutherstadt\ Wittenberg",
"495225", "Spenge",
"494802", "Wrohm",
"496201", "Weinheim\ Bergstr",
"496081", "Usingen",
"499351", "Gemünden\ am\ Main",
"4936962", "Vacha",
"497158", "Neuhausen\ auf\ den\ Fildern",
"4939859", "Fürstenwerder",
"499742", "Kalbach\ Rhön",
"4939204", "Niederndodeleben",
"4935771", "Bad\ Muskau",
"493937", "Osterburg\ Altmark",
"4933458", "Falkenberg\ Mark",
"494174", "Stelle\ Kreis\ Harburg",
"4935826", "Königshain\ bei\ Görlitz",
"4938227", "Lüdershagen\ bei\ Barth",
"498722", "Gangkofen",
"499074", "Höchstädt\ an\ der\ Donau",
"496887", "Schmelz\ Saar",
"499396", "Urspringen\ bei\ Lohr",
"4936703", "Gräfenthal",
"497124", "Trochtelfingen\ Hohenz",
"494406", "Berne",
"4934978", "Radegast\ Kreis\ Köthen",
"497551", "Überlingen\ Bodensee",
"4969", "Frankfurt\ am\ Main",
"496785", "Herrstein",
"495208", "Leopoldshöhe",
"496765", "Gemünden\ Hunsrück",
"492655", "Weibern",
"492604", "Nassau\ Lahn",
"495068", "Elze\ Leine",
"493647", "Pössneck",
"497762", "Wehr\ Baden",
"492425", "Nideggen\-Embken",
"4934292", "Brandis\ bei\ Wurzen",
"4939398", "Gross\ Garz",
"494320", "Heidmühlen",
"495607", "Fuldatal",
"497944", "Kupferzell",
"496867", "Perl",
"49791", "Schwäbisch\ Hall",
"4938234", "Born\ Darss",
"494963", "Dörpen",
"499604", "Wernberg\-Köblitz",
"497056", "Gechingen",
"499655", "Tännesberg",
"494268", "Bötersen",
"497309", "Weissenhorn",
"497531", "Konstanz",
"4937431", "Mehltheuer\ Vogtland",
"498267", "Dirlewang",
"495466", "Merzen",
"498677", "Burghausen\ Salzach",
"4935796", "Panschwitz\-Kuckau",
"497246", "Malsch\ Kreis\ Karlsruhe",
"497458", "Ebhausen",
"497628", "Efringen\-Kirchen",
"492473", "Simmerath",
"497965", "Ellwangen\-Röhlingen",
"499635", "Bärnau",
"495903", "Emsbüren",
"4933848", "Raben",
"497771", "Stockach",
"493943", "Wernigerode",
"4937363", "Zöblitz",
"494793", "Hambergen",
"4933762", "Zeuthen",
"498145", "Mammendorf",
"497227", "Lichtenau\ Baden",
"4938754", "Leussow\ bei\ Ludwigslust",
"494667", "Dagebüll",
"496744", "Oberwesel",
"49671", "Bad\ Kreuznach",
"4934324", "Ostrau\ Sachsen",
"494721", "Cuxhaven",
"495322", "Bad\ Harzburg",
"492635", "Rheinbrohl",
"494277", "Schwaförden",
"499473", "Kallmünz",
"494288", "Horstedt\ Kreis\ Rotenburg",
"499676", "Winklarn",
"498801", "Seeshaupt",
"492501", "Münster\-Hiltrup",
"492339", "Sprockhövel\-Hasslinghausen",
"495683", "Wabern\ Hessen",
"4939425", "Dingelstedt\ am\ Huy",
"499266", "Mitwitz",
"492266", "Lindlar",
"498464", "Dietfurt\ an\ der\ Altmühl",
"495882", "Gorleben",
"499339", "Ippesheim",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"492676", "Ulmen",
"492945", "Lippstadt\-Benninghausen",
"497138", "Schwaigern",
"496803", "Mandelbachtal\-Ommersheim",
"495862", "Hitzacker\ Elbe",
"494474", "Garrel",
"493475", "Lutherstadt\ Eisleben",
"499331", "Ochsenfurt",
"497654", "Löffingen",
"4935052", "Kipsdorf\ Kurort",
"499286", "Oberkotzau",
"492509", "Nottuln\-Appelhülsen",
"492331", "Hagen\ Westfalen",
"495663", "Spangenberg",
"4934691", "Könnern",
"497424", "Spaichingen",
"494106", "Quickborn\ Kreis\ Pinneberg",
"498809", "Wessobrunn",
"495273", "Beverungen",
"4938482", "Warin",
"492750", "Diedenshausen",
"496660", "Steinau\-Marjoss",
"499945", "Arnbruck",
"492545", "Rosendahl\-Darfeld",
"492385", "Hamm\-Rhynern",
"494480", "Ovelgönne\-Strückhausen",
"4938721", "Ziegendorf",
"498845", "Bad\ Kohlgrub",
"497052", "Bad\ Liebenzell",
"4936731", "Unterloquitz",
"496004", "Lich\-Eberstadt",
"496284", "Mudau",
"499385", "Kolitzheim",
"496055", "Freigericht",
"4939052", "Erxleben\ bei\ Haldensleben",
"499545", "Buttenheim",
"493998", "Demmin",
"494748", "Stubben\ bei\ Bremerhaven",
"4935693", "Lauschütz",
"498726", "Schönau\ Niederbayern",
"4935893", "Mücka",
"497250", "Kraichtal",
"492392", "Werdohl",
"496674", "Friedewald\ Hessen",
"495471", "Bohmte",
"499365", "Rimpar",
"496264", "Neudenau",
"499901", "Hengersberg\ Bayern",
"49234", "Bochum",
"492365", "Marl",
"493622", "Waltershausen\ Thüringen",
"498338", "Böhen",
"494402", "Rastede",
"499392", "Faulbach\ Unterfranken",
"497641", "Emmendingen",
"494337", "Jevenstedt",
"4933849", "Wiesenburg\ Mark",
"492681", "Altenkirchen\ Westerwald",
"495503", "Nörten\-Hardenberg",
"496562", "Speicher",
"496478", "Greifenstein\-Ulm",
"497838", "Nordrach",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"4936652", "Wurzbach",
"496103", "Langen\ Hessen",
"495162", "Fallingbostel",
"496500", "Waldrach",
"4938225", "Trinwillershagen",
"4933708", "Rangsdorf",
"496595", "Dockweiler",
"4936922", "Gerstungen",
"499746", "Zeitlofs",
"498753", "Elsendorf\ Niederbayern",
"499279", "Mistelgau",
"494806", "Sarzbüttel",
"495195", "Neuenkirchen\ bei\ Soltau",
"4936453", "Mellingen",
"497939", "Schrozberg\-Spielbach",
"499681", "Windischeschenbach",
"499661", "Sulzbach\-Rosenberg",
"4938292", "Kröpelin",
"492825", "Uedem",
"497931", "Bad\ Mergentheim",
"499727", "Schonungen\-Marktsteinach",
"499271", "Thurnau\-Alladorf",
"496342", "Schweigen\-Rechtenbach",
"492271", "Bergheim\ Erft",
"495182", "Gronau\ Leine",
"497345", "Langenau\ Württemberg",
"4938876", "Roggendorf",
"499825", "Herrieden",
"492689", "Dierdorf",
"497585", "Ostrach",
"495333", "Dettum",
"495724", "Obernkirchen",
"496582", "Freudenburg",
"496467", "Hatzfeld\ Eder",
"496751", "Bad\ Sobernheim",
"492661", "Bad\ Marienberg\ Westerwald",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"499665", "Königstein\ Oberpfalz",
"498105", "Gilching",
"497066", "Bad\ Rappenau\-Bonfeld",
"495199", "Schneverdingen\-Heber",
"497935", "Schrozberg",
"492821", "Kleve\ Niederrhein",
"494953", "Bunde",
"495943", "Emlichheim",
"496599", "Weidenbach\ bei\ Gerolstein",
"499275", "Speichersdorf",
"492692", "Kelberg",
"496374", "Weilerbach",
"496857", "Namborn",
"4935241", "Lommatzsch",
"498638", "Waldkraiburg",
"4935874", "Bernstadt\ an\ der\ Eigen",
"4937462", "Rothenkirchen\ Vogtland",
"492275", "Kerpen\-Buir",
"494637", "Sterup",
"4936849", "Kleinschmalkalden",
"496096", "Wiesen\ Unterfranken",
"498593", "Untergriesbach",
"497581", "Saulgau",
"499148", "Ettenstatt",
"496704", "Langenlonsheim",
"4936692", "Bürgel",
"496755", "Odernheim\ am\ Glan",
"497569", "Isny\-Eisenbach",
"493322", "Falkensee",
"4933474", "Neutrebbin",
"492685", "Flammersfeld",
"498237", "Aindling",
"499829", "Flachslanden",
"492928", "Soest\-Ostönnen",
"497561", "Leutkirch\ im\ Allgäu",
"494238", "Neddenaverbergen",
"496120", "Aarbergen",
"496523", "Holsthum",
"498026", "Hausham",
"4936649", "Gefell\ bei\ Schleiz",
"4934637", "Frankleben",
"495520", "Braunlage",
"495436", "Nortrup",
"493466", "Artern\ Unstrut",
"495123", "Schellerten",
"496591", "Gerolstein",
"4936625", "Langenwetzendorf",
"495191", "Soltau",
"4937384", "Wechselburg",
"4933731", "Trebbin",
"499928", "Kirchdorf\ im\ Wald",
"4939728", "Medow\ bei\ Anklam",
"495957", "Lindern\ Oldenburg",
"499549", "Lisberg",
"496843", "Gersheim",
"495475", "Bohmte\-Hunteburg",
"495840", "Schnackenburg",
"496059", "Jossgrund",
"492954", "Rüthen\-Oestereiden",
"494947", "Aurich\-Ogenbargen",
"495832", "Hankensbüttel",
"492905", "Bestwig\-Ramsbeck",
"499905", "Bernried\ Niederbayern",
"496556", "Pronsfeld",
"499954", "Simbach\ Niederbayern",
"496198", "Eppstein",
"493663", "Schleiz",
"495633", "Diemelsee",
"492389", "Werne",
"4939366", "Kehnert",
"494146", "Stade\-Bützfleth",
"492361", "Recklinghausen",
"496630", "Schwalmtal\-Storndorf",
"495156", "Coppenbrügge",
"496642", "Schlitz",
"497645", "Freiamt",
"4939393", "Werben\ Elbe",
"498053", "Bad\ Endorf",
"4935452", "Golssen",
"497976", "Sulzbach\-Laufen",
"4939971", "Gnoien",
"4937329", "Grosshartmannsdorf",
"492541", "Coesfeld",
"499236", "Nagel",
"494127", "Westerhorn",
"492381", "Hamm\ Westfalen",
"4934973", "Osternienburg",
"493683", "Schmalkalden",
"492369", "Dorsten\-Wulfen",
"498841", "Murnau\ am\ Staffelsee",
"4939605", "Gross\ Nemerow",
"4933652", "Neuzelle",
"494926", "Krummhörn\-Greetsiel",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"4934779", "Abberode",
"499369", "Uettingen",
"496051", "Gelnhausen",
"499381", "Volkach",
"498434", "Rennertshofen",
"492236", "Wesseling\ Rheinland",
"4933235", "Friesack",
"4933922", "Karwesee",
"492941", "Lippstadt",
"4933093", "Fürstenberg\ Havel",
"4936848", "Wernshausen",
"4935025", "Liebstadt",
"499129", "Wendelstein",
"4935971", "Sebnitz",
"497576", "Krauchenwies",
"4936762", "Steinach\ Thüringen",
"4935605", "Komptendorf",
"496234", "Mutterstadt",
"493471", "Bernburg\ Saale",
"499335", "Aub\ Kreis\ Würzburg",
"495823", "Bienenbüttel",
"495622", "Fritzlar",
"492335", "Wetter\ Ruhr",
"494442", "Lohne\ Oldenburg",
"494526", "Ascheberg\ Holstein",
"494367", "Grossenbrode",
"4936074", "Worbis",
"495452", "Mettingen\ Westfalen",
"4939853", "Holzendorf\ bei\ Prenzlau",
"498368", "Halblech",
"492129", "Haan\ Rheinland",
"499941", "Kötzting",
"498377", "Unterthingau",
"498805", "Hohenpeissenberg",
"497071", "Tübingen",
"498388", "Hergensweiler",
"4936946", "Erbenhausen\ Thüringen",
"494547", "Gudow\ Lauenburg",
"492505", "Altenberge\ Westfalen",
"492554", "Laer\ Kreis\ Steinfurt",
"498548", "Vilshofen\-Sandbach",
"4934651", "Rossla",
"499193", "Höchstadt\ an\ der\ Aisch",
"496157", "Pfungstadt",
"497736", "Tengen",
"4939923", "Priborn",
"492193", "Dabringhausen",
"498707", "Adlkofen",
"4934206", "Rötha",
"492590", "Dülmen\-Buldern",
"499554", "Untersteinbach\ Unterfranken",
"494708", "Ringstedt",
"4939745", "Hetzdorf\ bei\ Strasburg",
"499505", "Litzendorf",
"497328", "Königsbronn",
"4939452", "Ilsenburg",
"496044", "Schotten\ Hessen",
"499848", "Simmershofen",
"4934921", "Kemberg",
"4936648", "Dittersdorf\ bei\ Schleiz",
"492252", "Zülpich",
"497961", "Ellwangen\ Jagst",
"499631", "Tirschenreuth",
"492528", "Ennigerloh\-Enniger",
"494827", "Wacken",
"497775", "Mühlingen",
"496772", "Nastätten",
"498141", "Fürstenfeldbruck",
"4935756", "Hosena",
"4935728", "Uhyst\ Spree",
"494725", "Helgoland",
"497354", "Erolzheim",
"499528", "Donnersdorf",
"492631", "Neuwied",
"497305", "Erbach\ Donau",
"496302", "Winnweiler",
"493724", "Burgstädt",
"4933367", "Friedrichswalde\ Brandenburg",
"495363", "Wolfsburg\-Vorsfelde",
"499252", "Helmbrechts",
"495383", "Lutter\ am\ Barenberge",
"492639", "Anhausen\ Kreis\ Neuwied",
"494553", "Geschendorf",
"496532", "Zeltingen\-Rachtig",
"499376", "Collenberg",
"4938794", "Cumlosen",
"4938376", "Zirchow",
"495543", "Staufenberg\ Niedersachsen",
"495132", "Lehrte",
"499094", "Tagmersheim",
"496898", "Völklingen",
"4937328", "Grossschirma",
"4939241", "Leitzkau",
"494846", "Hattstedt",
"4934243", "Bad\ Düben",
"494194", "Sievershütten",
"499639", "Mähring",
"496761", "Simmern\ Hunsrück",
"494303", "Schlesen",
"492651", "Mayen",
"499493", "Beratzhausen",
"496457", "Burgwald\ Eder",
"497723", "Furtwangen\ im\ Schwarzwald",
"494297", "Ottersberg\-Posthausen",
"497334", "Deggingen",
"496789", "Heimbach\ Nahe",
"499232", "Wunsiedel",
"4937369", "Wolkenstein",
"492421", "Düren",
"496627", "Nentershausen\ Hessen",
"4939740", "Nechlin",
"497972", "Gschwend\ bei\ Gaildorf",
"494773", "Lamstedt",
"4933962", "Heiligengrabe",
"498783", "Rohr\ in\ Niederbayern",
"499421", "Straubing",
"4936481", "Neustadt\ an\ der\ Orla",
"492232", "Brühl\ Rheinland",
"494922", "Borkum",
"493886", "Gadebusch",
"499651", "Vohenstrauss",
"495836", "Wittingen\-Radenbeck",
"493866", "Cambs",
"4938824", "Mallentin",
"4934635", "Bad\ Lauchstädt",
"499659", "Leuchtenberg",
"499429", "Rain\ Niederbayern",
"4935698", "Hornow",
"492429", "Hürtgenwald",
"4933746", "Werbig\ bei\ Jüterbog",
"4935600", "Döbern\ NL",
"495152", "Hessisch\ Oldendorf",
"496646", "Grebenau",
"497504", "Horgenzell",
"496228", "Schönau\ Odenwald",
"4939406", "Harbke",
"497555", "Deggenhausertal",
"494142", "Steinkirchen\ Kreis\ Stade",
"494533", "Reinfeld\ Holstein",
"4936042", "Tonna",
"49209", "Gelsenkirchen",
"4935020", "Struppen",
"496552", "Olzheim",
"496781", "Idar\-Oberstein",
"493462", "Bad\ Dürrenberg",
"495432", "Löningen",
"493578", "Kamenz",
"499774", "Oberelsbach",
"495293", "Paderborn\-Dahl",
"498022", "Tegernsee",
"495875", "Emmendorf",
"495307", "Braunschweig\-Wenden",
"492355", "Schalksmühle",
"496443", "Ehringshausen\ Dill",
"492304", "Schwerte",
"4934383", "Trebsen\ Mulde",
"497082", "Neuenbürg\ Württemberg",
"4939034", "Fleetmark",
"495221", "Herford",
"497202", "Karlsbad",
"494494", "Bösel\ Oldenburg",
"496205", "Hockenheim",
"496254", "Lautertal\ Odenwald",
"495777", "Diepenau\-Essern",
"499355", "Frammersbach",
"496085", "Waldsolms",
"492774", "Dietzhölztal",
"497260", "Sinsheim\-Hilsbach",
"4938391", "Altenkirchen\ Rügen",
"492696", "Nohn\ Eifel",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"4936426", "Ottendorf\ bei\ Stadtroda",
"4939607", "Kotelow",
"495768", "Petershagen\-Heimsen",
"4936458", "Bad\ Berka",
"499534", "Burgpreppach",
"497062", "Beilstein\ Württemberg",
"492534", "Münster\-Roxel",
"4933237", "Paulinenaue",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"496092", "Heimbuchenthal",
"4937422", "Markneukirchen",
"4934441", "Hohenmölsen",
"4933703", "Sperenberg",
"4935607", "Jänschwalde",
"495423", "Versmold",
"495136", "Burgdorf\ Kreis\ Hannover",
"497274", "Germersheim",
"496650", "Hosenfeld",
"493871", "Parchim",
"499372", "Klingenberg\ am\ Main",
"498033", "Oberaudorf",
"494643", "Gelting\ Angeln",
"4935027", "Weesenstein",
"495653", "Sontra",
"496536", "Kleinich",
"496420", "Lahntal",
"4933334", "Greiffenberg",
"497664", "Freiburg\-Tiengen",
"494224", "Gross\ Ippener",
"495852", "Bleckede",
"496039", "Karben",
"492934", "Sundern\-Altenhellefeld",
"495491", "Damme\ Dümmer",
"494830", "Süderhastedt",
"4933843", "Niemegk",
"495937", "Geeste\-Gross\ Hesepe",
"493967", "Oertzenhof\ bei\ Strasburg",
"496694", "Neukirchen\ Knüll",
"496241", "Worms",
"494842", "Nordstrand",
"492372", "Hemer",
"4938851", "Zarrentin",
"4937368", "Deutschneudorf",
"496776", "Dachsenhausen",
"496249", "Guntersblum",
"498624", "Obing",
"493987", "Templin",
"492448", "Hellenthal\-Rescheid",
"496031", "Friedberg\ Hessen",
"498454", "Karlshuld",
"492256", "Mechernich\-Satzvey",
"498405", "Stammham\ bei\ Ingolstadt",
"497684", "Glottertal",
"496306", "Trippstadt",
"498243", "Fuchstal",
"499256", "Stammbach",
"4935842", "Oderwitz",
"499448", "Hausen\ Niederbayern",
"4938206", "Graal\-Müritz\ Seeheilbad",
"4939747", "Züsedom",
"495647", "Lichtenau\-Kleinenberg",
"497732", "Radolfzell\ am\ Bodensee",
"499223", "Rugendorf",
"496735", "Eppelsheim",
"4933230", "Börnicke\ Kreis\ Havelland",
"49261", "Koblenz\ am\ Rhein",
"492644", "Linz\ am\ Rhein",
"492291", "Waldbröl",
"499644", "Pressath",
"4939600", "Zwiedorf",
"4939996", "Törpin",
"496837", "Wallerfangen",
"49961", "Weiden\ in\ der\ Oberpfalz",
"497477", "Jungingen\ bei\ Hechingen",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"498134", "Odelzhausen",
"492223", "Königswinter",
"497955", "Wallhausen\ Württemberg",
"494933", "Dornum\ Ostfriesland",
"497904", "Ilshofen",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"495175", "Lehrte\-Arpke",
"497572", "Mengen\ Württemberg",
"4933606", "Müllrose",
"496575", "Landscheid",
"495248", "Langenberg\ Kreis\ Gütersloh",
"4938732", "Gallin\ bei\ Lübz",
"495456", "Westerkappeln\-Velpe",
"494446", "Bakum\ Kreis\ Vechta",
"494522", "Plön",
"4936459", "Blankenhain\ Thüringen",
"498257", "Inchenhofen",
"494258", "Schwarme",
"495626", "Bad\ Zwesten",
"495523", "Bad\ Sachsa",
"4934607", "Wettin",
"497161", "Göppingen",
"496436", "Dornburg\ Hessen",
"4936870", "Masserberg",
"496123", "Eltville\ am\ Rhein",
"4933701", "Grossbeeren",
"4934443", "Teuchern",
"498335", "Fellheim",
"4937208", "Auerswalde",
"492368", "Oer\-Erkenschwick",
"494826", "Hohenlockstedt",
"494847", "Oster\-Ohrstedt",
"492377", "Wickede\ Ruhr",
"495932", "Haren\ Ems",
"493962", "Penzlin\ bei\ Waren",
"492388", "Hamm\-Uentrop",
"4934381", "Colditz",
"498121", "Markt\ Schwaben",
"498505", "Hutthurm",
"498554", "Schönberg\ Niederbayern",
"492548", "Dülmen\-Rorup",
"494950", "Holtland",
"4939383", "Sandau\ Elbe",
"495374", "Isenbüttel",
"495857", "Bleckede\-Brackede",
"49371", "Chemnitz\ Sachsen",
"494745", "Bad\ Bederkesa",
"498193", "Geltendorf",
"499548", "Mühlhausen\ Mittelfranken",
"497181", "Schorndorf\ Württemberg",
"4938393", "Binz\ Ostseebad",
"493744", "Auerbach\ Vogtland",
"496058", "Gründau",
"499854", "Wittelshofen",
"4939082", "Mieste",
"495704", "Petershagen\-Friedewalde",
"495755", "Kalletal\-Varenholz",
"499805", "Burgoberbach",
"499377", "Freudenberg\-Boxtal",
"498252", "Schrobenhausen",
"494527", "Bosau",
"499929", "Ruhmannsfelden",
"4936738", "Königsee",
"4937439", "Jocketa",
"492828", "Emmerich\-Elten",
"494366", "Grömitz\-Cismar",
"4938728", "Domsühl",
"4933205", "Michendorf",
"499141", "Weissenburg\ in\ Bayern",
"496024", "Schöllkrippen",
"499828", "Rügland",
"497577", "Veringenstadt",
"494239", "Dörverden\-Westen",
"495051", "Bergen\ Kreis\ Celle",
"498631", "Mühldorf\ am\ Inn",
"497348", "Beimerstetten",
"4938756", "Grabow",
"498639", "Neumarkt\-Sankt\ Veit",
"495843", "Wustrow\ Wendland",
"498706", "Vilsheim",
"497835", "Zell\ am\ Harmersbach",
"492921", "Soest",
"496475", "Weilmünster\-Wolfenhausen",
"494853", "Sankt\ Michaelisdonn",
"499149", "Weissenburg\-Suffersheim",
"498094", "Steinhöring",
"497568", "Bad\ Wurzach\-Hauerz",
"497472", "Rottenburg\ am\ Neckar",
"496832", "Beckingen\-Reimsbach",
"494231", "Verden\ Aller",
"495556", "Lindau\ Harz",
"495198", "Schneverdingen\-Wintermoor",
"496633", "Homberg\ Ohm",
"499921", "Regen",
"498376", "Sulzberg\ Allgäu",
"4936483", "Ziegenrück",
"495642", "Warburg\-Scherfede",
"494422", "Sande\ Kreis\ Friesl",
"494546", "Mustin\ Lauenburg",
"492993", "Marsberg\-Canstein",
"492154", "Willich",
"499190", "Heroldsbach",
"496557", "Hallschlag",
"498821", "Garmisch\-Partenkirchen",
"495157", "Emmerthal\-Börry",
"499638", "Neualbenreuth",
"492521", "Beckum",
"4937209", "Einsiedel\ bei\ Chemnitz",
"499521", "Hassfurt",
"492638", "Waldbreitbach",
"4933435", "Rehfelde",
"494285", "Rhade\ bei\ Zeven",
"495956", "Rastdorf",
"494946", "Grossefehn\-Bagband",
"4938874", "Lützow",
"492593", "Ascheberg\ Westfalen",
"495044", "Springe\-Eldagsen",
"4938784", "Kleinow\ Kreis\ Prignitz",
"499154", "Pommelsbrunn",
"499105", "Grosshabersdorf",
"498665", "Inzell",
"498685", "Kirchanschöring",
"492237", "Kerpen\ Rheinland\-Türnich",
"495820", "Suhlendorf",
"494927", "Krummhörn\-Loquard",
"499529", "Oberaurach",
"494265", "Fintel",
"495234", "Horn\-Bad\ Meinberg",
"497176", "Spraitbach",
"4934600", "Ostrau\ Saalkreis",
"496622", "Bebra",
"497977", "Oberrot\ bei\ Gaildorf",
"492529", "Oelde\-Stromberg",
"497625", "Zell\ im\ Wiesental",
"4937297", "Thum\ Sachsen",
"494292", "Ritterhude",
"496452", "Battenberg\ Eder",
"494433", "Dötlingen",
"497455", "Dornhan",
"494126", "Horst\ Holstein",
"497404", "Epfendorf",
"496383", "Glan\-Münchweiler",
"498046", "Bad\ Heilbrunn",
"494636", "Langballig",
"497329", "Steinheim\ am\ Albuch",
"495532", "Stadtoldendorf",
"4938729", "Marnitz",
"493562", "Forst\ Lausitz",
"495143", "Winsen\ Aller",
"497135", "Brackenheim",
"494153", "Lauenburg\ Elbe",
"494550", "Bühnsdorf",
"492948", "Lippstadt\-Rebbeke",
"4935383", "Elster\ Elbe",
"496543", "Büchenbeuren",
"496132", "Ingelheim\ am\ Rhein",
"498389", "Weissensberg",
"499948", "Eschlkam",
"498361", "Nesselwang",
"4938452", "Lalendorf",
"496856", "St\ Wendel\-Niederkirchen",
"4937438", "Bad\ Brambach",
"4936739", "Rottenbach",
"498549", "Vilshofen\-Pleinting",
"492053", "Velbert\-Neviges",
"495923", "Schüttorf",
"498541", "Vilshofen\ Niederbayern",
"499434", "Bodenwöhr",
"498381", "Lindenberg\ im\ Allgäu",
"497393", "Munderkingen",
"498369", "Rückholz",
"495772", "Espelkamp",
"494371", "Burg\ auf\ Fehmarn",
"492841", "Moers",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"499841", "Bad\ Windsheim",
"499128", "Feucht",
"4938853", "Drönnewitz\ bei\ Hagenow",
"492434", "Wegberg",
"4933841", "Belzig",
"498236", "Fischach",
"493342", "Neuenhagen\ bei\ Berlin",
"495437", "Menslage",
"495302", "Vechelde",
"497321", "Heidenheim\ an\ der\ Brenz",
"498027", "Dietramszell",
"496363", "Niederkirchen",
"496836", "Überherrn",
"497476", "Bisingen",
"498702", "Wörth\ an\ der\ Isar",
"493571", "Hoyerswerda",
"4939973", "Altkalen",
"4934605", "Gröbers",
"494426", "Wangerland\-Horumersiel",
"4939889", "Boitzenburg",
"4939779", "Eggesin",
"4936259", "Tabarz\ Thüringer\ Wald",
"494542", "Mölln\ Lauenburg",
"494133", "Wittorf\ Kreis\ Lüneburg",
"496152", "Gross\-Gerau",
"495646", "Willebadessen",
"495228", "Vlotho\-Exter",
"495769", "Steyerberg\-Voigtei",
"4933451", "Heckelberg",
"498372", "Obergünzburg",
"494382", "Wangels",
"493606", "Heiligenstadt\ Heilbad",
"495552", "Katlenburg",
"493731", "Freiberg\ Sachsen",
"495761", "Stolzenau",
"495457", "Hopsten\-Schale",
"4936024", "Diedorf\ bei\ Mühlhausen",
"494362", "Heiligenhafen",
"492624", "Höhr\-Grenzhausen",
"495975", "Rheine\-Mesum",
"497720", "Schwenningen\ am\ Neckar",
"4936604", "Münchenbernsdorf",
"492454", "Gangelt",
"499243", "Pottenstein",
"492405", "Würselen",
"494447", "Vechta\-Langförden",
"499405", "Bad\ Abbach",
"492243", "Eitorf",
"4939391", "Lückstedt",
"499454", "Aufhausen\ Oberpfalz",
"4935206", "Kreischa\ bei\ Dresden",
"493394", "Wittstock\ Dosse",
"494770", "Wischhafen",
"4938842", "Lüttenmark",
"499624", "Ensdorf\ Oberpfalz",
"492428", "Niederzier",
"499134", "Neunkirchen\ am\ Brand",
"495065", "Sibbesse",
"496229", "Neckarsteinach",
"49861", "Traunstein",
"4936336", "Klettenberg",
"493966", "Cölpin",
"495936", "Twist",
"498291", "Zusmarshausen",
"4939824", "Hohenzieritz",
"495137", "Seelze",
"4933733", "Stülpe",
"499658", "Georgenberg",
"4938326", "Grimmen",
"4933207", "Gross\ Kreutz",
"498223", "Ichenhausen",
"499428", "Kirchroth",
"496432", "Diez",
"4939954", "Stavenhagen\ Reuterstadt",
"496440", "Kölschhausen",
"496293", "Schefflenz",
"499257", "Zell\ Oberfranken",
"494453", "Zetel",
"496875", "Nonnweiler\-Primstal",
"496307", "Schopp",
"497435", "Albstadt\-Laufen",
"495443", "Lemförde",
"494623", "Böklund",
"497263", "Waibstadt",
"494822", "Kellinghusen",
"496221", "Heidelberg",
"495205", "Bielefeld\-Sennestadt",
"496788", "Sien",
"495254", "Paderborn\-Schloss\ Neuhaus",
"495085", "Burgdorf\-Ehlershausen",
"494244", "Harpstedt",
"4939004", "Köckte\ bei\ Gardelegen",
"492257", "Reckerscheid",
"497673", "Schönau\ im\ Schwarzwald",
"4935243", "Weinböhla",
"49421", "Bremen",
"495776", "Preussisch\ Ströhen",
"498651", "Bad\ Reichenhall",
"4936258", "Friemar",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"4939888", "Lychen",
"4935954", "Grossharthau",
"498421", "Eichstätt\ Bayern",
"495031", "Wunstorf",
"495306", "Cremlingen",
"493586", "Neugersdorf\ Sachsen",
"4934241", "Jesewitz",
"4939243", "Nedlitz\ bei\ Zerbst",
"498232", "Schwabmünchen",
"493346", "Seelow",
"4933437", "Reichenberg\ bei\ Strausberg",
"496423", "Wetter\ Hessen",
"496136", "Nieder\-Olm",
"495650", "Cornberg",
"497461", "Tuttlingen",
"493327", "Werder\ Havel",
"492763", "Drolshagen\-Bleche",
"496653", "Burghaun",
"495536", "Holzminden\-Neuhaus",
"498042", "Lenggries",
"494632", "Steinbergkirche",
"497804", "Oppenau",
"4936785", "Gräfinau\-Angstedt",
"4936875", "Straufhain\-Streufdorf",
"494833", "Wesselburen",
"496852", "Nohfelden",
"494251", "Hoya",
"492697", "Blankenheim\-Ahrhütte",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"495241", "Gütersloh",
"495694", "Diemelstadt",
"4937295", "Lugau\ Erzgebirge",
"497172", "Lorch\ Württemberg",
"4934653", "Rottleberode",
"496175", "Friedrichsdorf\ Taunus",
"4933972", "Breddin",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"498304", "Wildpoldsried",
"4934923", "Cobbelsdorf",
"494122", "Uetersen",
"4939206", "Eichenbarleben",
"494296", "Schwanewede\-Aschwarden",
"4934745", "Winningen\ Sachsen\-Anhalt",
"496456", "Haina\ Kloster",
"492449", "Blankenheim\ Ahr",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"4939921", "Ankershagen",
"496626", "Wildeck\-Obersuhl",
"496647", "Herbstein\-Stockhausen",
"492441", "Kall",
"494764", "Gnarrenburg\-Klenkendorf",
"493765", "Reichenbach\ Vogtland",
"499834", "Theilenhofen",
"497743", "Ühlingen\-Birkendorf",
"4933200", "Bergholz\-Rehbrücke",
"493971", "Anklam",
"4935973", "Stolpen",
"499220", "Kasendorf\-Azendorf",
"498534", "Tettenweis",
"4936744", "Remda",
"4939851", "Göritz\ bei\ Prenzlau",
"493867", "Lübstorf",
"495837", "Sprakensehl",
"494942", "Südbrookmerland",
"4935436", "Laasow\ bei\ Calau",
"4933836", "Butzow\ bei\ Brandenburg",
"492834", "Straelen",
"495952", "Sögel",
"499441", "Kelheim",
"499397", "Wertheim\-Dertingen",
"496353", "Freinsheim",
"499083", "Möttingen",
"492445", "Schleiden\ Eifel",
"494407", "Wardenburg",
"499203", "Neudrossenfeld",
"4934492", "Lucka",
"495731", "Bad\ Oeynhausen",
"493761", "Werdau\ Sachsen",
"494340", "Achterwehr",
"494332", "Hamdorf\ bei\ Rendsburg",
"494183", "Jesteburg",
"494974", "Neuharlingersiel",
"4939389", "Schollene",
"4936424", "Kahla\ Thüringen",
"4935475", "Straupitz",
"4933875", "Rhinow",
"492203", "Cologne\-Porz",
"499445", "Neustadt\ an\ der\ Donau",
"4933675", "Tauche",
"498742", "Velden\ Vils",
"496866", "Perl\-Nennig",
"496171", "Oberursel\ Taunus",
"4934425", "Droyssig",
"4935265", "Glaubitz",
"4938307", "Poseritz",
"4938427", "Blowatz",
"495571", "Uslar",
"4933051", "Nassenheide",
"494163", "Horneburg\ Niederelbe",
"495606", "Zierenberg",
"49711", "Stuttgart",
"494502", "Lübeck\-Travemünde",
"497144", "Marbach\ am\ Neckar",
"4939036", "Binde",
"492973", "Eslohe\ Sauerland",
"4933088", "Falkenthal",
"4937361", "Neuhausen\ Erzgebirge",
"497465", "Emmingen\-Liptingen",
"4938858", "Lassahn",
"496578", "Salmtal",
"4936200", "Elxleben\ bei\ Arnstadt",
"496462", "Gladenbach",
"495403", "Bad\ Iburg",
"496587", "Zerf",
"496347", "Hochstadt\ Pfalz",
"4934467", "Eckartsberga",
"4938826", "Dassow",
"496400", "Mücke",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"492722", "Attendorn",
"495187", "Delligsen",
"498074", "Schnaitsee",
"499722", "Werneck",
"497851", "Kehl",
"4939404", "Ausleben",
"494255", "Martfeld",
"497233", "Niefern\-Öschelbronn",
"494204", "Thedinghausen",
"4939324", "Kläden\ bei\ Stendal",
"495245", "Herzebrock\-Clarholz",
"4933744", "Hohenseefeld",
"499184", "Deining\ Oberpfalz",
"499973", "Furth\ im\ Wald",
"497043", "Maulbronn",
"499164", "Langenfeld\ Mittelfranken",
"495966", "Meppen\-Apeldorn",
"4937433", "Gutenfürst",
"495035", "Gross\ Munzel",
"495167", "Walsrode\-Westenholz",
"496326", "Deidesheim",
"497958", "Rot\ Am\ See\-Brettheim",
"496567", "Oberkail",
"4935388", "Klöden",
"496482", "Runkel",
"492164", "Jüchen\-Otzenrath",
"497485", "Empfingen",
"495327", "Bad\ Grund\ Harz",
"498282", "Krumbach\ Schwaben",
"4933604", "Lebus",
"497431", "Albstadt\-Ebingen",
"494272", "Siedenburg",
"496871", "Wadern",
"496166", "Fischbachtal",
"494662", "Leck",
"492733", "Hilchenbach",
"492324", "Hattingen\ Ruhr",
"497558", "Illmensee",
"499324", "Dettelbach",
"495069", "Nordstemmen",
"499733", "Münnerstadt",
"497222", "Rastatt",
"495201", "Halle\ Westfalen",
"494863", "Sankt\ Peter\-Ording",
"4938300", "Insel\ Hiddensee",
"49781", "Offenburg",
"4939388", "Goldbeck\ Altm",
"497844", "Rheinau",
"492573", "Nordwalde",
"4936375", "Kindelbrück",
"4937203", "Gersdorf\ bei\ Chemnitz",
"494883", "Süderstapel",
"498295", "Altenmünster\ Schwaben",
"495209", "Gütersloh\-Friedrichsdorf",
"495586", "Wieda",
"4935324", "Crinitz",
"494356", "Gross\ Wittensee",
"4936451", "Buttelstedt",
"493306", "Gransee",
"494682", "Amrum",
"496186", "Grosskrotzenburg",
"499573", "Staffelstein\ Oberfranken",
"4939994", "Metschow",
"499170", "Schwanstetten",
"498262", "Mittelneufnach",
"495346", "Liebenburg",
"495765", "Raddestorf",
"493735", "Marienberg\ Sachsen",
"496068", "Beerfelden",
"497703", "Bonndorf\ im\ Schwarzwald",
"494734", "Stadland\-Seefeld",
"494323", "Bornhöved",
"497159", "Renningen",
"495971", "Rheine",
"4939265", "Löderburg",
"4935891", "Rothenburg\ OL",
"492401", "Baesweiler",
"499401", "Neutraubling",
"4938204", "Broderstorf",
"4938859", "Alt\ Zachun",
"498564", "Johanniskirchen",
"497373", "Zwiefalten",
"4933089", "Himmelpfort",
"494902", "Jemgum\-Ditzum",
"492864", "Reken",
"4938723", "Kladrum",
"4933336", "Passow\ Kreis\ Uckermark",
"49831", "Kempten\ Allgäu",
"492358", "Meinerzhagen\-Valbert",
"498344", "Westendorf\ bei\ Kaufbeuren",
"499409", "Pielenhofen",
"498584", "Breitenberg\ Niederbayern",
"4935389", "Holzdorf\ Elster",
"4936207", "Plaue\ Thüringen",
"4935691", "Bärenklau\ NL",
"497151", "Waiblingen",
"492409", "Stolberg\-Gressenich",
"499358", "Gössenheim",
"4936733", "Kaulsdorf",
"497524", "Bad\ Waldsee",
"499747", "Geroda\ Bayern",
"492508", "Drensteinfurt",
"495962", "Herzlake",
"498545", "Hofkirchen\ Bayern",
"498385", "Hergatz",
"498808", "Pähl",
"492845", "Neukirchen\-Vluyn",
"499845", "Oberdachstetten",
"495744", "Hüllhorst",
"4933877", "Nitzahn",
"4939482", "Gatersleben",
"497139", "Neuenstadt\ am\ Kocher",
"4936370", "Grossenehrich",
"49571", "Minden\ Westfalen",
"496486", "Katzenelnbogen",
"496322", "Bad\ Dürkheim",
"497325", "Sontheim\ an\ der\ Brenz",
"494754", "Bülkau",
"4935477", "Rietzneuendorf\-Friedrichshof",
"494705", "Wremen",
"492747", "Molzhain",
"4935267", "Diesbar\-Seusslitz",
"493523", "Coswig\ bei\ Dresden",
"498392", "Markt\ Rettenbach",
"4938305", "Gingst",
"499338", "Röttingen\ Unterfranken",
"4938425", "Kirchdorf\ Poel",
"496466", "Dautphetal\-Friedensdorf",
"4939248", "Dobritz",
"497131", "Heilbronn\ Neckar",
"4937321", "Frankenstein\ Sachsen",
"4933677", "Glienicke\ bei\ Beeskow",
"4934342", "Neukieritzsch",
"4939773", "Altwarp",
"4936253", "Georgenthal\ Thüringer\ Wald",
"493591", "Bautzen",
"498365", "Wertach",
"4939883", "Gross\ Dölln",
"492338", "Breckerfeld",
"4939364", "Dolle",
"4934771", "Querfurt",
"499726", "Euerbach",
"498681", "Waging\ am\ See",
"4935932", "Guttau",
"493843", "Güstrow",
"498669", "Traunreut",
"4934465", "Bad\ Bibra",
"494671", "Bredstedt",
"495803", "Rosche",
"494261", "Rotenburg\ Wümme",
"494289", "Kirchtimke",
"494506", "Stockelsdorf\-Krumbeck",
"497621", "Lörrach",
"495602", "Hessisch\ Lichtenau",
"492753", "Erndtebrück",
"496663", "Steinau\ an\ der\ Strasse",
"4935249", "Basslitz",
"4936083", "Uder",
"497451", "Horb\ am\ Neckar",
"4939754", "Löcknitz\ Vorpom",
"4936841", "Schleusingen",
"4934928", "Seegrehna",
"4936464", "Wormstedt",
"495072", "Neustadt\-Mandelsloh",
"498825", "Krün",
"497459", "Nagold\-Hochdorf",
"496683", "Ehrenberg\ Rhön",
"494336", "Owschlag",
"4933933", "Lindow\ Mark",
"4934956", "Zörbig",
"497629", "Tegernau\ Baden",
"492525", "Beckum\-Neubeckum",
"497308", "Nersingen",
"494269", "Ahausen\-Kirchwalsede",
"4933476", "Neuhardenberg",
"499525", "Königsberg\ in\ Bayern",
"498271", "Meitingen",
"4934658", "Hayn\ Harz",
"494281", "Zeven",
"498727", "Falkenberg\ Niederbayern",
"4935876", "Weissenberg\ Sachsen",
"499101", "Langenzenn",
"498661", "Grabenstätt\ Chiemsee",
"4938374", "Lassan\ bei\ Wolgast",
"492267", "Wipperfürth",
"495674", "Grebenstein",
"4938796", "Viesecke",
"496471", "Weilburg",
"492925", "Warstein\-Allagen",
"492677", "Lutzerath",
"497831", "Hausach",
"495264", "Kalletal",
"492688", "Kroppach",
"4939292", "Biederitz",
"494235", "Langwedel\-Etelsen",
"497253", "Bad\ Schönborn",
"497444", "Alpirsbach",
"49741", "Rottweil",
"499677", "Oberviechtach\-Pullenried",
"499925", "Bayerisch\ Eisenstein",
"494463", "Wangerland",
"499267", "Nordhalben",
"4939225", "Altengrabow",
"4936377", "Rastenberg",
"499287", "Selb",
"494483", "Ovelgönne\-Grossenmeer",
"4933870", "Zollchow\ bei\ Rathenow",
"499278", "Weidenberg",
"4939932", "Malchow\ bei\ Waren",
"497938", "Mulfingen\ Jagst",
"494107", "Siek\ Kreis\ Stormarn",
"499145", "Solnhofen",
"496479", "Waldbrunn\ Westerwald",
"497839", "Schapbach",
"496758", "Waldböckelheim",
"495284", "Schwalenberg",
"495055", "Fassberg",
"4935754", "Klettwitz",
"4936701", "Lichte",
"4939978", "Gross\ Roge",
"498635", "Pleiskirchen",
"492801", "Xanten",
"4939267", "Schneidlingen",
"493923", "Zerbst",
"497247", "Linkenheim\-Hochstetten",
"498501", "Thyrnau",
"493772", "Schneeberg\ Erzgebirge",
"499464", "Walderbach",
"4936944", "Rentwertshausen",
"4935248", "Schönfeld\ bei\ Grossenhain",
"494741", "Nordholz\ bei\ Bremerhaven",
"498266", "Kirchheim\ in\ Schwaben",
"4935773", "Schleife",
"492464", "Aldenhoven\ bei\ Jülich",
"493991", "Waren\ Müritz",
"496182", "Seligenstadt",
"493302", "Hennigsdorf",
"496333", "Waldfischbach\-Burgalben",
"496724", "Stromberg\ Hunsrück",
"4934204", "Schkeuditz",
"4935364", "Lebusa",
"494352", "Damp",
"495582", "Sankt\ Andreasberg",
"495467", "Voltlage",
"493437", "Grimma",
"495751", "Rinteln",
"4939721", "Liepen\ bei\ Anklam",
"496503", "Hermeskeil",
"495562", "Dassel\-Markoldendorf",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"494666", "Ladelund",
"4938353", "Gützkow\ bei\ Greifswald",
"495103", "Wennigsen\ Deister",
"496162", "Reinheim\ Odenwald",
"494276", "Borstel\ bei\ Sulingen",
"494749", "Schiffdorf\-Geestenseth",
"492484", "Mechernich\-Eiserfey",
"497165", "Göppingen\-Hohenstaufen",
"498509", "Ruderting",
"498331", "Memmingen",
"499484", "Brennberg",
"4936076", "Niederorschel",
"4934929", "Straach",
"497226", "Bühl\-Sand",
"496195", "Kelkheim\ Taunus",
"4936205", "Gräfenroda",
"499908", "Schöfweg",
"497192", "Murrhardt",};
$areanames{de} = {"4934445", "Stößen",
"494684", "Langeneß\ Hallig",
"4935240", "Tauscha\ bei\ Großenhain",
"4989", "München",
"499567", "Seßlach\-Gemünda",
"498536", "Kößlarn",
"4936072", "Weißenborn\-Lüderode",
"494497", "Barßel\-Harkebrügge",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"496252", "Heppenheim\ Bergstraße",
"495053", "Faßberg\-Müden",
"498633", "Tüßling",
"4935952", "Großröhrsdorf\ OL",
"4939934", "Groß\ Plasten",
"497355", "Hochdorf\ Riß",
"497351", "Biberach\ an\ der\ Riß",
"499242", "Gößweinstein",
"495827", "Unterlüß",
"4934901", "Roßlau\ Elbe",
"4934493", "Gößnitz\ Thüringen",
"49911", "Nürnberg",
"495064", "Groß\ Düngen",
"4935841", "Großschönau\ Sachsen",
"4935938", "Großpostwitz\ OL",
"496321", "Neustadt\ an\ der\ Weinstraße",
"494509", "Groß\ Grönau",
"498807", "Dießen\ am\ Ammersee",
"495384", "Seesen\-Groß\ Rhüden",
"4939976", "Groß\ Bützin",
"497162", "Süßen",
"498367", "Roßhaupten\ Forggensee",
"496364", "Nußbach\ Pfalz",
"499636", "Plößberg",
"4935753", "Großräschen",
"499656", "Moosbach\ bei\ Vohenstrauß",
"49221", "Köln",
"4935726", "Groß\ Särchen",
"4936949", "Obermaßfeld\-Grimmenthal",
"4936484", "Knau\ bei\ Pößneck",
"492339", "Sprockhövel\-Haßlinghausen",
"493647", "Pößneck",
"4938234", "Born\ Darß",
"498170", "Straßlach\-Dingharting",
"499141", "Weißenburg\ in\ Bayern",
"4935248", "Schönfeld\ bei\ Großenhain",
"494483", "Ovelgönne\-Großenmeer",
"496663", "Steinau\ an\ der\ Straße",
"4939883", "Groß\ Dölln",
"492203", "Köln\-Porz",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;