############################################################################
##      Copyright (C) 2005 Subredu Manuel  <diablo@iasi.roedu.net>.        #
##                                                                         #
## This program is free software; you can redistribute it and/or modify    #
## it under the terms of the GNU General Public License as published by    #
## the Free Software Foundation; either version 2 of the License, or       #
## (at your option) any later version.                                     #
##                                                                         #
## This program is distributed in the hope that it will be useful,         #
## but WITHOUT ANY WARRANTY; without even the implied warranty of          #
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           #
## GNU General Public License for more details.                            #
##                                                                         #
## You should have received a copy of the GNU General Public License       #
## along with this program; if not, write to the Free Software             #
## Foundation, Inc., 59 Temple Place - Suite 330, Boston,                  #
## MA 02111-1307,USA.                                                      #
############################################################################

package RoPkg;

use strict;
use warnings;

use vars qw($VERSION);

$VERSION = '0.5.5';

1;

__END__

=head1 NAME

RoPkg - collection of perl classes.

=head1 SYNOPSIS

N.A. - RoPkg is just a central place for information related
to RoPkg modules

=head1 DESCRIPTION

RoPkg contains a collection of base classes 
useful mostly to Simba. This module contains
base exceptions used in all RoPkg related modules
(RoPkg::Exceptions) and general utility methods
(RoPkg::Utils). Also, RoPkg::Object (the base class
for almost all Simba packages) is part of this
collection. This collection (with all the modules)
wants to provide methods and objects to usual
issues.

=head1 SEE ALSO

L<RoPkg::Exceptions> L<RoPkg::Object> L<RoPkg::Utils>

=head1 AUTHOR

Subredu Manuel <diablo@iasi.roedu.net>

=head1 VERSION

The current version for this collection of modules is 0.5.5

=head1 DEPENDENCIES

Each module has his own dependencies. Please refer to the man
page of each module for additional information.

=head1 DIAGNOSTICS

Each module has his own tests. To run those tests, unpack
the source, and run make tests

=head1 SUBROUTINES/METHODS

Please refer to the man page of each module to find out more
about the methods and subroutines made available.

=head1 INCOMPATIBILITIES

None known to me

=head1 BUGS AND LIMITATIONS

Each module may have bugs. Please refer to the man page of each
module for detail information

=head1 CONFIGURATION AND ENVIRONMENT

None of the modules included don't use configuration files
or special environment variables.

=head1 LICENSE AND COPYRIGHT

Copyright (C) 2005 Subredu Manuel.  All Rights Reserved.
This module is free software; you can redistribute it 
and/or modify it under the same terms as Perl itself.
The LICENSE file contains the full text of the license.

=cut
