/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.toolbars;

/** Constraints to be used with the ToolBarLayout.
 *<p>
 * Depending on the orientation of the layout, the two integers majorOrder and minorOrder 
 * express the opposite measures :
 *<ul>
 * <li> in an horizontal layout, majorOrder is the ROW, and minorOrder is the COLUMN
 * <li>in a vertical layout, majorOrder is the COLUMN, and minorOrder is the ROW
 *</ul>
 *<p>
 * Example : To layout two toolbars horizontally on an horizontal layout, use the following constraints 
 * (0,0) and (0,1) (the column is the minor order on an horizontal layout).
 *<p>
 * to layout them in a row (one above the other), use the constraints (0,0) and (1,0) (the row
 * is the major order on an horizontal layout).
 *
 * @author Lilian Chamontin, VLSolutions
 */
public class ToolBarConstraints {
  /** The major order is the row index for horizontal toolbars, and the column index for 
   * vertical toolbars.
   */
  public int majorOrder;
  
  /** The minor order is the column index for horizontal toolbars, and the row index for 
   * vertical toolbars.
   */
  public int minorOrder;
  
  /** Set to -1/0/+1 during drag/drop phase to allow insertion between rows/columns.
   * Do not use it outside drag and drop operations.
   */
  /* package protected */ int majorOffset = 0;

  /** Set to -1/0-31 during drag/drop phase to allow insertion between rows/columns
   * Do not use it outside drag and drop operations.
   */
  /* package protected */ int minorOffset = 0;
      
  /** Constructs a new ToolBarConstraints at (0,0) */
  public ToolBarConstraints() {
  }

  /** Constructs a new ToolBarConstraints at (majorOrder,minorOrder).
   *<p>
   * the majorOrder is the ROW for an horizontal layout, and the columns for a vertical layout.
   */
  public ToolBarConstraints(int majorOrder, int minorOrder) {
    this.majorOrder = majorOrder;
    this.minorOrder = minorOrder;
  }
  
  /** Returns a description of these constraints. */
  public String toString(){
    return "ToolBarConstraints[" + majorOrder + ", " + minorOrder + "]";
  }
  
}
