# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1StatusDetails(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'kind': 'str',
            'causes': 'list[V1StatusCause]',
            'retry_after_seconds': 'int'
        }

        self.attribute_map = {
            'name': 'name',
            'kind': 'kind',
            'causes': 'causes',
            'retry_after_seconds': 'retryAfterSeconds'
        }

        self._name = None
        self._kind = None
        self._causes = None
        self._retry_after_seconds = None

    @property
    def name(self):
        """
        Gets the name of this V1StatusDetails.
        the name attribute of the resource associated with the status StatusReason (when there is a single name which can be described)

        :return: The name of this V1StatusDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this V1StatusDetails.
        the name attribute of the resource associated with the status StatusReason (when there is a single name which can be described)

        :param name: The name of this V1StatusDetails.
        :type: str
        """
        self._name = name

    @property
    def kind(self):
        """
        Gets the kind of this V1StatusDetails.
        the kind attribute of the resource associated with the status StatusReason; on some operations may differ from the requested resource Kind; see http://releases.k8s.io/v1.0.4/docs/api-conventions.md#types-kinds

        :return: The kind of this V1StatusDetails.
        :rtype: str
        """
        return self._kind

    @kind.setter
    def kind(self, kind):
        """
        Sets the kind of this V1StatusDetails.
        the kind attribute of the resource associated with the status StatusReason; on some operations may differ from the requested resource Kind; see http://releases.k8s.io/v1.0.4/docs/api-conventions.md#types-kinds

        :param kind: The kind of this V1StatusDetails.
        :type: str
        """
        self._kind = kind

    @property
    def causes(self):
        """
        Gets the causes of this V1StatusDetails.
        the Causes array includes more details associated with the StatusReason failure; not all StatusReasons may provide detailed causes

        :return: The causes of this V1StatusDetails.
        :rtype: list[V1StatusCause]
        """
        return self._causes

    @causes.setter
    def causes(self, causes):
        """
        Sets the causes of this V1StatusDetails.
        the Causes array includes more details associated with the StatusReason failure; not all StatusReasons may provide detailed causes

        :param causes: The causes of this V1StatusDetails.
        :type: list[V1StatusCause]
        """
        self._causes = causes

    @property
    def retry_after_seconds(self):
        """
        Gets the retry_after_seconds of this V1StatusDetails.
        the number of seconds before the client should attempt to retry this operation

        :return: The retry_after_seconds of this V1StatusDetails.
        :rtype: int
        """
        return self._retry_after_seconds

    @retry_after_seconds.setter
    def retry_after_seconds(self, retry_after_seconds):
        """
        Sets the retry_after_seconds of this V1StatusDetails.
        the number of seconds before the client should attempt to retry this operation

        :param retry_after_seconds: The retry_after_seconds of this V1StatusDetails.
        :type: int
        """
        self._retry_after_seconds = retry_after_seconds

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
