/* Szwrapper.c generated by valac 0.38.4, the Vala compiler
 * generated from Szwrapper.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */
/*Class for communicating with the sz program*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>


#define MOSERIAL_TYPE_SZWRAPPER (moserial_szwrapper_get_type ())
#define MOSERIAL_SZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapper))
#define MOSERIAL_SZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapperClass))
#define MOSERIAL_IS_SZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SZWRAPPER))
#define MOSERIAL_IS_SZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SZWRAPPER))
#define MOSERIAL_SZWRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapperClass))

typedef struct _moserialSzwrapper moserialSzwrapper;
typedef struct _moserialSzwrapperClass moserialSzwrapperClass;
typedef struct _moserialSzwrapperPrivate moserialSzwrapperPrivate;

#define MOSERIAL_SZWRAPPER_TYPE_PROTOCOL (moserial_szwrapper_protocol_get_type ())

#define MOSERIAL_TYPE_SERIAL_CONNECTION (moserial_serial_connection_get_type ())
#define MOSERIAL_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnection))
#define MOSERIAL_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))
#define MOSERIAL_IS_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_IS_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_SERIAL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))

typedef struct _moserialSerialConnection moserialSerialConnection;
typedef struct _moserialSerialConnectionClass moserialSerialConnectionClass;
enum  {
	MOSERIAL_SZWRAPPER_0_PROPERTY,
	MOSERIAL_SZWRAPPER_PROTOCOL_PROPERTY,
	MOSERIAL_SZWRAPPER_SC_PROPERTY,
	MOSERIAL_SZWRAPPER_FILENAME_PROPERTY,
	MOSERIAL_SZWRAPPER_NUM_PROPERTIES
};
static GParamSpec* moserial_szwrapper_properties[MOSERIAL_SZWRAPPER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	MOSERIAL_SZWRAPPER_TRANSFER_COMPLETE_SIGNAL,
	MOSERIAL_SZWRAPPER_UPDATE_STATUS_SIGNAL,
	MOSERIAL_SZWRAPPER_NUM_SIGNALS
};
static guint moserial_szwrapper_signals[MOSERIAL_SZWRAPPER_NUM_SIGNALS] = {0};

struct _moserialSzwrapper {
	GObject parent_instance;
	moserialSzwrapperPrivate * priv;
	gboolean running;
};

struct _moserialSzwrapperClass {
	GObjectClass parent_class;
};

typedef enum  {
	MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM,
	MOSERIAL_SZWRAPPER_PROTOCOL_RAW,
	MOSERIAL_SZWRAPPER_PROTOCOL_NULL
} moserialSzwrapperProtocol;

struct _moserialSzwrapperPrivate {
	moserialSzwrapperProtocol _protocol;
	moserialSerialConnection* _sc;
	GIOChannel* IOChannelInput;
	GIOChannel* IOChannelOutput;
	GIOChannel* IOChannelError;
	guint outputChannelId;
	guint errorChannelId;
	GPid pid;
	gchar* _filename;
};


static gpointer moserial_szwrapper_parent_class = NULL;

GType moserial_szwrapper_get_type (void) G_GNUC_CONST;
GType moserial_szwrapper_protocol_get_type (void) G_GNUC_CONST;
GType moserial_serial_connection_get_type (void) G_GNUC_CONST;
#define MOSERIAL_SZWRAPPER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapperPrivate))
moserialSzwrapper* moserial_szwrapper_new (moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* filename);
moserialSzwrapper* moserial_szwrapper_construct (GType object_type, moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* filename);
void moserial_szwrapper_writeChar (moserialSzwrapper* self, guchar byte);
static void moserial_szwrapper_shutdown (moserialSzwrapper* self);
static gboolean moserial_szwrapper_readError (moserialSzwrapper* self, GIOChannel* source, GIOCondition condition);
gchar* mo_utils_getLastMessage (const gchar* messages);
static gboolean moserial_szwrapper_shutdown_timeout (moserialSzwrapper* self);
static gboolean _moserial_szwrapper_shutdown_timeout_gsource_func (gpointer self);
void moserial_szwrapper_transferCanceled (moserialSzwrapper* self, GObject* o);
moserialSzwrapperProtocol moserial_szwrapper_get_protocol (moserialSzwrapper* self);
moserialSerialConnection* moserial_szwrapper_get_sc (moserialSzwrapper* self);
void moserial_serial_connection_sendByte (moserialSerialConnection* self, guchar byte);
static gboolean moserial_szwrapper_readBytes (moserialSzwrapper* self, GIOChannel* source, GIOCondition condition);
void moserial_serial_connection_sendBytes (moserialSerialConnection* self, gchar* bytes, int bytes_length1, gsize size);
static void moserial_szwrapper_set_protocol (moserialSzwrapper* self, moserialSzwrapperProtocol value);
static void moserial_szwrapper_set_sc (moserialSzwrapper* self, moserialSerialConnection* value);
const gchar* moserial_szwrapper_get_filename (moserialSzwrapper* self);
static void moserial_szwrapper_set_filename (moserialSzwrapper* self, const gchar* value);
static GObject * moserial_szwrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _moserial_szwrapper_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static gboolean _moserial_szwrapper_readError_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static void moserial_szwrapper_finalize (GObject * obj);
static void _vala_moserial_szwrapper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_moserial_szwrapper_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const gchar* MOSERIAL_SZWRAPPER_ProtocolStrings[4] = {N_ ("Xmodem"), N_ ("Ymodem"), N_ ("Zmodem"), N_ ("None (straight binary)")};

GType moserial_szwrapper_protocol_get_type (void) {
	static volatile gsize moserial_szwrapper_protocol_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_szwrapper_protocol_type_id__volatile)) {
		static const GEnumValue values[] = {{MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM, "MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM", "xmodem"}, {MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM, "MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM", "ymodem"}, {MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM, "MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM", "zmodem"}, {MOSERIAL_SZWRAPPER_PROTOCOL_RAW, "MOSERIAL_SZWRAPPER_PROTOCOL_RAW", "raw"}, {MOSERIAL_SZWRAPPER_PROTOCOL_NULL, "MOSERIAL_SZWRAPPER_PROTOCOL_NULL", "null"}, {0, NULL, NULL}};
		GType moserial_szwrapper_protocol_type_id;
		moserial_szwrapper_protocol_type_id = g_enum_register_static ("moserialSzwrapperProtocol", values);
		g_once_init_leave (&moserial_szwrapper_protocol_type_id__volatile, moserial_szwrapper_protocol_type_id);
	}
	return moserial_szwrapper_protocol_type_id__volatile;
}


moserialSzwrapper* moserial_szwrapper_construct (GType object_type, moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* filename) {
	moserialSzwrapper * self = NULL;
	moserialSzwrapperProtocol pro = 0;
	moserialSzwrapperProtocol* _tmp0_;
	moserialSerialConnection* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = protocol;
	pro = *_tmp0_;
	_tmp1_ = sc;
	_tmp2_ = filename;
	self = (moserialSzwrapper*) g_object_new (object_type, "protocol", pro, "sc", _tmp1_, "filename", _tmp2_, NULL);
	return self;
}


moserialSzwrapper* moserial_szwrapper_new (moserialSzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* filename) {
	return moserial_szwrapper_construct (MOSERIAL_TYPE_SZWRAPPER, protocol, sc, filename);
}


void moserial_szwrapper_writeChar (moserialSzwrapper* self, guchar byte) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->running;
	if (_tmp0_) {
		gsize bytesWritten = 0UL;
		gchar* b = NULL;
		gchar* _tmp1_;
		gint b_length1;
		gint _b_size_;
		gchar* _tmp2_;
		gint _tmp2__length1;
		guchar _tmp3_;
		gchar _tmp4_;
		_tmp1_ = g_new0 (gchar, 1);
		b = _tmp1_;
		b_length1 = 1;
		_b_size_ = b_length1;
		_tmp2_ = b;
		_tmp2__length1 = b_length1;
		_tmp3_ = byte;
		_tmp2_[0] = (gchar) _tmp3_;
		_tmp4_ = _tmp2_[0];
		{
			gboolean _tmp5_;
			gboolean _tmp9_;
			_tmp5_ = self->running;
			if (_tmp5_) {
				GIOChannel* _tmp6_;
				gchar* _tmp7_;
				gint _tmp7__length1;
				gsize _tmp8_ = 0UL;
				_tmp6_ = self->priv->IOChannelInput;
				_tmp7_ = b;
				_tmp7__length1 = b_length1;
				g_io_channel_write_chars (_tmp6_, _tmp7_, _tmp7__length1, &_tmp8_, &_inner_error_);
				bytesWritten = _tmp8_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
						goto __catch19_g_io_channel_error;
					}
					if (_inner_error_->domain == G_CONVERT_ERROR) {
						goto __catch19_g_convert_error;
					}
					b = (g_free (b), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp9_ = self->running;
			if (_tmp9_) {
				GIOChannel* _tmp10_;
				_tmp10_ = self->priv->IOChannelInput;
				g_io_channel_flush (_tmp10_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
						goto __catch19_g_io_channel_error;
					}
					if (_inner_error_->domain == G_CONVERT_ERROR) {
						goto __catch19_g_convert_error;
					}
					b = (g_free (b), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		goto __finally19;
		__catch19_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp11_;
			GError* _tmp12_;
			const gchar* _tmp13_;
			e = _inner_error_;
			_inner_error_ = NULL;
			moserial_szwrapper_shutdown (self);
			_tmp11_ = stdout;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			fprintf (_tmp11_, "writeChar() %s\n", _tmp13_);
			_g_error_free0 (e);
		}
		goto __finally19;
		__catch19_g_convert_error:
		{
			GError* e = NULL;
			FILE* _tmp14_;
			GError* _tmp15_;
			const gchar* _tmp16_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp14_ = stdout;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			fprintf (_tmp14_, "%s\n", _tmp16_);
			_g_error_free0 (e);
		}
		__finally19:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			b = (g_free (b), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		b = (g_free (b), NULL);
	}
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gboolean _moserial_szwrapper_shutdown_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = moserial_szwrapper_shutdown_timeout ((moserialSzwrapper*) self);
	return result;
}


static gboolean moserial_szwrapper_readError (moserialSzwrapper* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		_tmp1_ = gtk_events_pending ();
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_;
			_tmp2_ = gdk_events_pending ();
			_tmp0_ = _tmp2_;
		}
		if (!_tmp0_) {
			break;
		}
		gtk_main_iteration_do (FALSE);
	}
	_tmp3_ = self->running;
	if (_tmp3_) {
		gchar* m_buf = NULL;
		gchar* _tmp4_;
		gint m_buf_length1;
		gint _m_buf_size_;
		gchar* messages = NULL;
		gchar* _tmp5_;
		gchar* message = NULL;
		gchar* _tmp6_;
		gsize bytesRead = 0UL;
		GIOCondition _tmp7_;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp42_;
		gint _tmp43_;
		const gchar* _tmp44_;
		gint _tmp45_;
		_tmp4_ = g_new0 (gchar, 1000);
		m_buf = _tmp4_;
		m_buf_length1 = 1000;
		_m_buf_size_ = m_buf_length1;
		_tmp5_ = g_strdup ("");
		messages = _tmp5_;
		_tmp6_ = g_strdup ("");
		message = _tmp6_;
		bytesRead = (gsize) 0;
		_tmp7_ = condition;
		if (!(_tmp7_ == G_IO_IN)) {
			result = TRUE;
			_g_free0 (message);
			_g_free0 (messages);
			m_buf = (g_free (m_buf), NULL);
			return result;
		}
		{
			GIOChannel* _tmp8_;
			gchar* _tmp9_;
			gint _tmp9__length1;
			gsize _tmp10_ = 0UL;
			_tmp8_ = source;
			_tmp9_ = m_buf;
			_tmp9__length1 = m_buf_length1;
			g_io_channel_read_chars (_tmp8_, _tmp9_, _tmp9__length1, &_tmp10_, &_inner_error_);
			bytesRead = _tmp10_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp11_ = FALSE;
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					goto __catch20_g_convert_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch20_g_io_channel_error;
				}
				_g_free0 (message);
				_g_free0 (messages);
				m_buf = (g_free (m_buf), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp11_;
			}
		}
		goto __finally20;
		__catch20_g_convert_error:
		{
			GError* e = NULL;
			FILE* _tmp12_;
			GError* _tmp13_;
			const gchar* _tmp14_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp12_ = stdout;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			fprintf (_tmp12_, "%s\n", _tmp14_);
			_g_error_free0 (e);
		}
		goto __finally20;
		__catch20_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp15_;
			GError* _tmp16_;
			const gchar* _tmp17_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp15_ = stdout;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			fprintf (_tmp15_, "readError() %s\n", _tmp17_);
			_g_error_free0 (e);
		}
		__finally20:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp18_ = FALSE;
			_g_free0 (message);
			_g_free0 (messages);
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp18_;
		}
		{
			gint x = 0;
			x = 0;
			{
				gboolean _tmp19_ = FALSE;
				_tmp19_ = TRUE;
				while (TRUE) {
					gint _tmp21_;
					gsize _tmp22_;
					gunichar c = 0U;
					gchar* _tmp23_;
					gint _tmp23__length1;
					gint _tmp24_;
					gchar _tmp25_;
					gboolean _tmp26_ = FALSE;
					gunichar _tmp27_;
					gboolean _tmp28_;
					if (!_tmp19_) {
						gint _tmp20_;
						_tmp20_ = x;
						x = _tmp20_ + 1;
					}
					_tmp19_ = FALSE;
					_tmp21_ = x;
					_tmp22_ = bytesRead;
					if (!(((gsize) _tmp21_) < _tmp22_)) {
						break;
					}
					_tmp23_ = m_buf;
					_tmp23__length1 = m_buf_length1;
					_tmp24_ = x;
					_tmp25_ = _tmp23_[_tmp24_];
					c = (gunichar) _tmp25_;
					_tmp27_ = c;
					_tmp28_ = g_unichar_isprint (_tmp27_);
					if (_tmp28_) {
						_tmp26_ = TRUE;
					} else {
						gunichar _tmp29_;
						gboolean _tmp30_;
						_tmp29_ = c;
						_tmp30_ = g_unichar_isspace (_tmp29_);
						_tmp26_ = _tmp30_;
					}
					if (_tmp26_) {
						const gchar* _tmp31_;
						gchar* _tmp32_;
						gint _tmp32__length1;
						gint _tmp33_;
						gchar _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						gchar* _tmp37_;
						_tmp31_ = messages;
						_tmp32_ = m_buf;
						_tmp32__length1 = m_buf_length1;
						_tmp33_ = x;
						_tmp34_ = _tmp32_[_tmp33_];
						_tmp35_ = g_strdup_printf ("%c", (gint) _tmp34_);
						_tmp36_ = _tmp35_;
						_tmp37_ = g_strconcat (_tmp31_, _tmp36_, NULL);
						_g_free0 (messages);
						messages = _tmp37_;
						_g_free0 (_tmp36_);
					}
				}
			}
		}
		_tmp38_ = messages;
		_tmp39_ = mo_utils_getLastMessage (_tmp38_);
		_g_free0 (message);
		message = _tmp39_;
		_tmp40_ = message;
		if (!(g_strcmp0 (_tmp40_, "") == 0)) {
			const gchar* _tmp41_;
			_tmp41_ = message;
			g_signal_emit (self, moserial_szwrapper_signals[MOSERIAL_SZWRAPPER_UPDATE_STATUS_SIGNAL], 0, _tmp41_);
		}
		_tmp42_ = messages;
		_tmp43_ = string_index_of (_tmp42_, "Transfer complete", 0);
		if (_tmp43_ >= 0) {
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 2000, _moserial_szwrapper_shutdown_timeout_gsource_func, g_object_ref (self), g_object_unref);
		}
		_tmp44_ = messages;
		_tmp45_ = string_index_of (_tmp44_, "Transfer incomplete", 0);
		if (_tmp45_ >= 0) {
			moserial_szwrapper_shutdown (self);
		}
		result = TRUE;
		_g_free0 (message);
		_g_free0 (messages);
		m_buf = (g_free (m_buf), NULL);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


void moserial_szwrapper_transferCanceled (moserialSzwrapper* self, GObject* o) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	_tmp0_ = self->running;
	if (_tmp0_) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		moserialSzwrapperProtocol _tmp3_;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		moserialSzwrapperProtocol _tmp14_;
		g_signal_emit (self, moserial_szwrapper_signals[MOSERIAL_SZWRAPPER_UPDATE_STATUS_SIGNAL], 0, _ ("canceled"));
		_tmp3_ = self->priv->_protocol;
		if (_tmp3_ == MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM) {
			_tmp2_ = TRUE;
		} else {
			moserialSzwrapperProtocol _tmp4_;
			_tmp4_ = self->priv->_protocol;
			_tmp2_ = _tmp4_ == MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM;
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			moserialSzwrapperProtocol _tmp5_;
			_tmp5_ = self->priv->_protocol;
			_tmp1_ = _tmp5_ == MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM;
		}
		if (_tmp1_) {
			{
				gint x = 0;
				x = 0;
				{
					gboolean _tmp6_ = FALSE;
					_tmp6_ = TRUE;
					while (TRUE) {
						gint _tmp8_;
						moserialSzwrapperProtocol _tmp9_;
						if (!_tmp6_) {
							gint _tmp7_;
							_tmp7_ = x;
							x = _tmp7_ + 1;
						}
						_tmp6_ = FALSE;
						_tmp8_ = x;
						if (!(_tmp8_ < 20)) {
							break;
						}
						_tmp9_ = self->priv->_protocol;
						if (_tmp9_ == MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM) {
							moserialSerialConnection* _tmp10_;
							_tmp10_ = self->priv->_sc;
							moserial_serial_connection_sendByte (_tmp10_, (guchar) ('X' & 037));
							moserial_szwrapper_writeChar (self, (guchar) ('X' & 037));
						} else {
							moserialSerialConnection* _tmp11_;
							_tmp11_ = self->priv->_sc;
							moserial_serial_connection_sendByte (_tmp11_, (guchar) 0x18);
						}
					}
				}
			}
		}
		_tmp14_ = self->priv->_protocol;
		if (_tmp14_ == MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM) {
			_tmp13_ = TRUE;
		} else {
			moserialSzwrapperProtocol _tmp15_;
			_tmp15_ = self->priv->_protocol;
			_tmp13_ = _tmp15_ == MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM;
		}
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			moserialSzwrapperProtocol _tmp16_;
			_tmp16_ = self->priv->_protocol;
			_tmp12_ = _tmp16_ == MOSERIAL_SZWRAPPER_PROTOCOL_RAW;
		}
		if (_tmp12_) {
			moserial_szwrapper_shutdown (self);
		}
	}
}


static gboolean moserial_szwrapper_shutdown_timeout (moserialSzwrapper* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	moserial_szwrapper_shutdown (self);
	result = FALSE;
	return result;
}


static void moserial_szwrapper_shutdown (moserialSzwrapper* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->running;
	if (_tmp0_) {
		guint _tmp1_;
		guint _tmp2_;
		GPid _tmp3_;
		self->running = FALSE;
		_tmp1_ = self->priv->outputChannelId;
		g_source_remove (_tmp1_);
		_tmp2_ = self->priv->errorChannelId;
		g_source_remove (_tmp2_);
		_tmp3_ = self->priv->pid;
		g_spawn_close_pid (_tmp3_);
		g_signal_emit (self, moserial_szwrapper_signals[MOSERIAL_SZWRAPPER_TRANSFER_COMPLETE_SIGNAL], 0);
	}
}


static gboolean moserial_szwrapper_readBytes (moserialSzwrapper* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		_tmp1_ = gtk_events_pending ();
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp2_;
			_tmp2_ = gdk_events_pending ();
			_tmp0_ = _tmp2_;
		}
		if (!_tmp0_) {
			break;
		}
		gtk_main_iteration_do (FALSE);
	}
	_tmp3_ = self->running;
	if (_tmp3_) {
		gchar* m_buf = NULL;
		gchar* _tmp4_;
		gint m_buf_length1;
		gint _m_buf_size_;
		gsize bytesRead = 0UL;
		GIOCondition _tmp5_;
		moserialSerialConnection* _tmp17_;
		gchar* _tmp18_;
		gint _tmp18__length1;
		gsize _tmp19_;
		_tmp4_ = g_new0 (gchar, 1024);
		m_buf = _tmp4_;
		m_buf_length1 = 1024;
		_m_buf_size_ = m_buf_length1;
		bytesRead = (gsize) 0;
		_tmp5_ = condition;
		if (!(_tmp5_ == G_IO_IN)) {
			result = TRUE;
			m_buf = (g_free (m_buf), NULL);
			return result;
		}
		{
			GIOChannel* _tmp6_;
			gchar* _tmp7_;
			gint _tmp7__length1;
			gsize _tmp8_ = 0UL;
			_tmp6_ = source;
			_tmp7_ = m_buf;
			_tmp7__length1 = m_buf_length1;
			g_io_channel_read_chars (_tmp6_, _tmp7_, _tmp7__length1, &_tmp8_, &_inner_error_);
			bytesRead = _tmp8_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp9_ = FALSE;
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					goto __catch21_g_convert_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch21_g_io_channel_error;
				}
				m_buf = (g_free (m_buf), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp9_;
			}
		}
		goto __finally21;
		__catch21_g_convert_error:
		{
			GError* e = NULL;
			FILE* _tmp10_;
			GError* _tmp11_;
			const gchar* _tmp12_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp10_ = stdout;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			fprintf (_tmp10_, "%s\n", _tmp12_);
			_g_error_free0 (e);
		}
		goto __finally21;
		__catch21_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp13_;
			GError* _tmp14_;
			const gchar* _tmp15_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp13_ = stdout;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			fprintf (_tmp13_, "readError() %s\n", _tmp15_);
			_g_error_free0 (e);
		}
		__finally21:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp16_ = FALSE;
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp16_;
		}
		_tmp17_ = self->priv->_sc;
		_tmp18_ = m_buf;
		_tmp18__length1 = m_buf_length1;
		_tmp19_ = bytesRead;
		moserial_serial_connection_sendBytes (_tmp17_, _tmp18_, _tmp18__length1, _tmp19_);
		result = TRUE;
		m_buf = (g_free (m_buf), NULL);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


moserialSzwrapperProtocol moserial_szwrapper_get_protocol (moserialSzwrapper* self) {
	moserialSzwrapperProtocol result;
	moserialSzwrapperProtocol _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_protocol;
	result = _tmp0_;
	return result;
}


static void moserial_szwrapper_set_protocol (moserialSzwrapper* self, moserialSzwrapperProtocol value) {
	g_return_if_fail (self != NULL);
	if (moserial_szwrapper_get_protocol (self) != value) {
		moserialSzwrapperProtocol _tmp0_;
		_tmp0_ = value;
		self->priv->_protocol = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, moserial_szwrapper_properties[MOSERIAL_SZWRAPPER_PROTOCOL_PROPERTY]);
	}
}


moserialSerialConnection* moserial_szwrapper_get_sc (moserialSzwrapper* self) {
	moserialSerialConnection* result;
	moserialSerialConnection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sc;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void moserial_szwrapper_set_sc (moserialSzwrapper* self, moserialSerialConnection* value) {
	g_return_if_fail (self != NULL);
	if (moserial_szwrapper_get_sc (self) != value) {
		moserialSerialConnection* _tmp0_;
		moserialSerialConnection* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_sc);
		self->priv->_sc = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, moserial_szwrapper_properties[MOSERIAL_SZWRAPPER_SC_PROPERTY]);
	}
}


const gchar* moserial_szwrapper_get_filename (moserialSzwrapper* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}


static void moserial_szwrapper_set_filename (moserialSzwrapper* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, moserial_szwrapper_get_filename (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, moserial_szwrapper_properties[MOSERIAL_SZWRAPPER_FILENAME_PROPERTY]);
	}
}


static gboolean _moserial_szwrapper_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = moserial_szwrapper_readBytes ((moserialSzwrapper*) self, source, condition);
	return result;
}


static gboolean _moserial_szwrapper_readError_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = moserial_szwrapper_readError ((moserialSzwrapper*) self, source, condition);
	return result;
}


static GObject * moserial_szwrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	moserialSzwrapper * self;
	gboolean _tmp0_ = FALSE;
	moserialSzwrapperProtocol _tmp1_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (moserial_szwrapper_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapper);
	_tmp1_ = self->priv->_protocol;
	if (_tmp1_ == MOSERIAL_SZWRAPPER_PROTOCOL_NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_filename;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		self->running = FALSE;
	} else {
		gchar** argv = NULL;
		gint argv_length1 = 0;
		gint _argv_size_ = 0;
		moserialSzwrapperProtocol _tmp3_;
		gint output = 0;
		gint _error_ = 0;
		gint input = 0;
		_tmp3_ = self->priv->_protocol;
		if (_tmp3_ == MOSERIAL_SZWRAPPER_PROTOCOL_RAW) {
			gchar** _tmp4_;
			gchar** _tmp5_;
			gint _tmp5__length1;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar** _tmp8_;
			gint _tmp8__length1;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp4_ = g_new0 (gchar*, 2 + 1);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp4_;
			argv_length1 = 2;
			_argv_size_ = argv_length1;
			_tmp5_ = argv;
			_tmp5__length1 = argv_length1;
			_tmp6_ = g_strdup ("cat");
			_g_free0 (_tmp5_[0]);
			_tmp5_[0] = _tmp6_;
			_tmp7_ = _tmp5_[0];
			_tmp8_ = argv;
			_tmp8__length1 = argv_length1;
			_tmp9_ = self->priv->_filename;
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (_tmp8_[1]);
			_tmp8_[1] = _tmp10_;
			_tmp11_ = _tmp8_[1];
		} else {
			gchar** _tmp12_;
			gchar** _tmp13_;
			gint _tmp13__length1;
			gchar* _tmp14_;
			gchar* _tmp15_;
			moserialSzwrapperProtocol _tmp16_;
			gchar** _tmp26_;
			gint _tmp26__length1;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar** _tmp29_;
			gint _tmp29__length1;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp12_ = g_new0 (gchar*, 4 + 1);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp12_;
			argv_length1 = 4;
			_argv_size_ = argv_length1;
			_tmp13_ = argv;
			_tmp13__length1 = argv_length1;
			_tmp14_ = g_strdup ("sz");
			_g_free0 (_tmp13_[0]);
			_tmp13_[0] = _tmp14_;
			_tmp15_ = _tmp13_[0];
			_tmp16_ = self->priv->_protocol;
			switch (_tmp16_) {
				case MOSERIAL_SZWRAPPER_PROTOCOL_XMODEM:
				{
					gchar** _tmp17_;
					gint _tmp17__length1;
					gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp17_ = argv;
					_tmp17__length1 = argv_length1;
					_tmp18_ = g_strdup ("--xmodem");
					_g_free0 (_tmp17_[1]);
					_tmp17_[1] = _tmp18_;
					_tmp19_ = _tmp17_[1];
					break;
				}
				case MOSERIAL_SZWRAPPER_PROTOCOL_YMODEM:
				{
					gchar** _tmp20_;
					gint _tmp20__length1;
					gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp20_ = argv;
					_tmp20__length1 = argv_length1;
					_tmp21_ = g_strdup ("--ymodem");
					_g_free0 (_tmp20_[1]);
					_tmp20_[1] = _tmp21_;
					_tmp22_ = _tmp20_[1];
					break;
				}
				default:
				case MOSERIAL_SZWRAPPER_PROTOCOL_ZMODEM:
				{
					gchar** _tmp23_;
					gint _tmp23__length1;
					gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp23_ = argv;
					_tmp23__length1 = argv_length1;
					_tmp24_ = g_strdup ("--zmodem");
					_g_free0 (_tmp23_[1]);
					_tmp23_[1] = _tmp24_;
					_tmp25_ = _tmp23_[1];
					break;
				}
			}
			_tmp26_ = argv;
			_tmp26__length1 = argv_length1;
			_tmp27_ = g_strdup ("-vv");
			_g_free0 (_tmp26_[2]);
			_tmp26_[2] = _tmp27_;
			_tmp28_ = _tmp26_[2];
			_tmp29_ = argv;
			_tmp29__length1 = argv_length1;
			_tmp30_ = self->priv->_filename;
			_tmp31_ = g_strdup (_tmp30_);
			_g_free0 (_tmp29_[3]);
			_tmp29_[3] = _tmp31_;
			_tmp32_ = _tmp29_[3];
		}
		{
			gchar** _tmp33_;
			gint _tmp33__length1;
			GPid _tmp34_ = 0;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			gint _tmp38_;
			GIOChannel* _tmp39_;
			gint _tmp40_;
			GIOChannel* _tmp41_;
			gint _tmp42_;
			GIOChannel* _tmp43_;
			GIOChannel* _tmp44_;
			GIOChannel* _tmp45_;
			GIOChannel* _tmp46_;
			GIOChannel* _tmp47_;
			GIOChannel* _tmp48_;
			GIOChannel* _tmp49_;
			guint _tmp50_;
			GIOChannel* _tmp51_;
			guint _tmp52_;
			_tmp33_ = argv;
			_tmp33__length1 = argv_length1;
			g_spawn_async_with_pipes (NULL, _tmp33_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp34_, &_tmp35_, &_tmp36_, &_tmp37_, &_inner_error_);
			self->priv->pid = _tmp34_;
			input = _tmp35_;
			output = _tmp36_;
			_error_ = _tmp37_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch22_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch22_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp38_ = output;
			_tmp39_ = g_io_channel_unix_new (_tmp38_);
			_g_io_channel_unref0 (self->priv->IOChannelOutput);
			self->priv->IOChannelOutput = _tmp39_;
			_tmp40_ = input;
			_tmp41_ = g_io_channel_unix_new (_tmp40_);
			_g_io_channel_unref0 (self->priv->IOChannelInput);
			self->priv->IOChannelInput = _tmp41_;
			_tmp42_ = _error_;
			_tmp43_ = g_io_channel_unix_new (_tmp42_);
			_g_io_channel_unref0 (self->priv->IOChannelError);
			self->priv->IOChannelError = _tmp43_;
			_tmp44_ = self->priv->IOChannelOutput;
			g_io_channel_set_encoding (_tmp44_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch22_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch22_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp45_ = self->priv->IOChannelOutput;
			g_io_channel_set_flags (_tmp45_, G_IO_FLAG_NONBLOCK, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch22_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch22_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp46_ = self->priv->IOChannelError;
			g_io_channel_set_encoding (_tmp46_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch22_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch22_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp47_ = self->priv->IOChannelError;
			g_io_channel_set_flags (_tmp47_, G_IO_FLAG_NONBLOCK, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch22_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch22_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp48_ = self->priv->IOChannelInput;
			g_io_channel_set_encoding (_tmp48_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch22_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch22_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp49_ = self->priv->IOChannelOutput;
			_tmp50_ = g_io_add_watch (_tmp49_, G_IO_IN, _moserial_szwrapper_readBytes_gio_func, self);
			self->priv->outputChannelId = _tmp50_;
			_tmp51_ = self->priv->IOChannelError;
			_tmp52_ = g_io_add_watch (_tmp51_, G_IO_IN, _moserial_szwrapper_readError_gio_func, self);
			self->priv->errorChannelId = _tmp52_;
			self->running = TRUE;
		}
		goto __finally22;
		__catch22_g_spawn_error:
		{
			GError* e = NULL;
			FILE* _tmp53_;
			GError* _tmp54_;
			const gchar* _tmp55_;
			GtkMessageDialog* errorDialog = NULL;
			GError* _tmp56_;
			const gchar* _tmp57_;
			GtkMessageDialog* _tmp58_;
			GtkMessageDialog* _tmp59_;
			GtkMessageDialog* _tmp60_;
			e = _inner_error_;
			_inner_error_ = NULL;
			self->running = FALSE;
			_tmp53_ = stdout;
			_tmp54_ = e;
			_tmp55_ = _tmp54_->message;
			fprintf (_tmp53_, "spawn error: %s\n", _tmp55_);
			_tmp56_ = e;
			_tmp57_ = _tmp56_->message;
			_tmp58_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp57_);
			g_object_ref_sink (_tmp58_);
			errorDialog = _tmp58_;
			_tmp59_ = errorDialog;
			gtk_dialog_run ((GtkDialog*) _tmp59_);
			_tmp60_ = errorDialog;
			gtk_widget_destroy ((GtkWidget*) _tmp60_);
			_g_object_unref0 (errorDialog);
			_g_error_free0 (e);
		}
		goto __finally22;
		__catch22_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp61_;
			GError* _tmp62_;
			const gchar* _tmp63_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp61_ = stdout;
			_tmp62_ = e;
			_tmp63_ = _tmp62_->message;
			fprintf (_tmp61_, "readError() %s\n", _tmp63_);
			_g_error_free0 (e);
		}
		__finally22:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	}
	return obj;
}


static void moserial_szwrapper_class_init (moserialSzwrapperClass * klass) {
	moserial_szwrapper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialSzwrapperPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_moserial_szwrapper_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_moserial_szwrapper_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_szwrapper_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_szwrapper_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SZWRAPPER_PROTOCOL_PROPERTY, moserial_szwrapper_properties[MOSERIAL_SZWRAPPER_PROTOCOL_PROPERTY] = g_param_spec_enum ("protocol", "protocol", "protocol", MOSERIAL_SZWRAPPER_TYPE_PROTOCOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SZWRAPPER_SC_PROPERTY, moserial_szwrapper_properties[MOSERIAL_SZWRAPPER_SC_PROPERTY] = g_param_spec_object ("sc", "sc", "sc", MOSERIAL_TYPE_SERIAL_CONNECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_SZWRAPPER_FILENAME_PROPERTY, moserial_szwrapper_properties[MOSERIAL_SZWRAPPER_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	moserial_szwrapper_signals[MOSERIAL_SZWRAPPER_TRANSFER_COMPLETE_SIGNAL] = g_signal_new ("transfer-complete", MOSERIAL_TYPE_SZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	moserial_szwrapper_signals[MOSERIAL_SZWRAPPER_UPDATE_STATUS_SIGNAL] = g_signal_new ("update-status", MOSERIAL_TYPE_SZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void moserial_szwrapper_instance_init (moserialSzwrapper * self) {
	self->priv = MOSERIAL_SZWRAPPER_GET_PRIVATE (self);
	self->running = FALSE;
}


static void moserial_szwrapper_finalize (GObject * obj) {
	moserialSzwrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapper);
	_g_object_unref0 (self->priv->_sc);
	_g_io_channel_unref0 (self->priv->IOChannelInput);
	_g_io_channel_unref0 (self->priv->IOChannelOutput);
	_g_io_channel_unref0 (self->priv->IOChannelError);
	_g_free0 (self->priv->_filename);
	G_OBJECT_CLASS (moserial_szwrapper_parent_class)->finalize (obj);
}


GType moserial_szwrapper_get_type (void) {
	static volatile gsize moserial_szwrapper_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_szwrapper_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialSzwrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_szwrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSzwrapper), 0, (GInstanceInitFunc) moserial_szwrapper_instance_init, NULL };
		GType moserial_szwrapper_type_id;
		moserial_szwrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSzwrapper", &g_define_type_info, 0);
		g_once_init_leave (&moserial_szwrapper_type_id__volatile, moserial_szwrapper_type_id);
	}
	return moserial_szwrapper_type_id__volatile;
}


static void _vala_moserial_szwrapper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialSzwrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapper);
	switch (property_id) {
		case MOSERIAL_SZWRAPPER_PROTOCOL_PROPERTY:
		g_value_set_enum (value, moserial_szwrapper_get_protocol (self));
		break;
		case MOSERIAL_SZWRAPPER_SC_PROPERTY:
		g_value_set_object (value, moserial_szwrapper_get_sc (self));
		break;
		case MOSERIAL_SZWRAPPER_FILENAME_PROPERTY:
		g_value_set_string (value, moserial_szwrapper_get_filename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_moserial_szwrapper_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialSzwrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MOSERIAL_TYPE_SZWRAPPER, moserialSzwrapper);
	switch (property_id) {
		case MOSERIAL_SZWRAPPER_PROTOCOL_PROPERTY:
		moserial_szwrapper_set_protocol (self, g_value_get_enum (value));
		break;
		case MOSERIAL_SZWRAPPER_SC_PROPERTY:
		moserial_szwrapper_set_sc (self, g_value_get_object (value));
		break;
		case MOSERIAL_SZWRAPPER_FILENAME_PROPERTY:
		moserial_szwrapper_set_filename (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



