# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1054-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56718);
 script_cve_id("CVE-2006-2024", "CVE-2006-2025", "CVE-2006-2026", "CVE-2006-2024", "CVE-2006-2025", "CVE-2006-2026");
 script_bugtraq_id(17730,17732,17733);
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1054-1 (tiff)";
 script_name(name);

 desc = "The remote host is missing an update to tiff
announced via advisory DSA 1054-1.

Tavis Ormandy discovered several vulnerabilities in the TIFF library
that can lead to a denial of service or the execution of arbitrary
code.  The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2006-2024

Multiple vulnerabilities allow attackers to cause a denial of
service.

CVE-2006-2025

An integer overflows allows attackers to cause a denial of service
and possibly execute arbitrary code.

CVE-2006-2026

A double-free vulnerability allows attackers to cause a denial of
service and possibly execute arbitrary code.

For the old stable distribution (woody) these problems have been fixed
in version 3.5.5-7woody1.

For the stable distribution (sarge) these problems have been fixed in
version 3.7.2-3sarge1.

For the unstable distribution (sid) these problems will be fixed soon.

We recommend that you upgrade your libtiff packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201054-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1054-1 (tiff)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libtiff-tools", ver:"3.5.5-7woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff3g", ver:"3.5.5-7woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff3g-dev", ver:"3.5.5-7woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-opengl", ver:"3.7.2-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-tools", ver:"3.7.2-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff4", ver:"3.7.2-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff4-dev", ver:"3.7.2-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiffxx0", ver:"3.7.2-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
