###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ortro_mult_vuln_jan10.nasl 6536 2010-01-12 15:22:08Z jan $
#
# Ortro Multiple Unspecified Vulnerabilities
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800981);
  script_version("$Revision: 8165 $: 1.0");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-4519");
  script_name("Ortro Multiple Unspecified Vulnerabilities");
  desc = "
  Overview: The host has Ortro installed and is prone to multiple Unspecified
  vulnerabilities.

  Vulnerability Insight:
  The flaw is caused by unspecified errors with unknown impact and attack
  vectors.

  Impact:
  Successful exploitation will let the remote attacker Disable/Lock a host and
  to perform scp transfer between two remote hosts.

  Impact Level: Application

  Affected Software/OS:
  Ortro version prior to 1.3.4

  Fix: Upgrade to Ortro version 1.3.4
  For Updates Refer, http://www.ortro.net/download

  References:
  http://www.ortro.net/
  http://xforce.iss.net/xforce/xfdb/54026
  http://www.vupen.com/english/advisories/2009/3057

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:N/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Ortro");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_ortro_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

ortroPort = get_http_port(default:80);
if(!ortroPort){
  exit(0);
}

ortroVer = get_kb_item("www/"+ ortroPort + "/Ortro");
if(!ortroVer){
  exit(0);
}

ortroVer  = eregmatch(pattern:"^(.+) under (/.*)$", string:ortroVer);
if(ortroVer[1] != NULL)
{
  # Check for Ortro version prior to 1.3.4
  if(version_is_less(version:ortroVer[1], test_version:"1.3.4")){
    security_hole(ortroPort);
  }
}
