###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ston3d_prdts_detect_win.nasl 2571 2009-06-01 15:57:05Z jun $
#
# StoneTrip Ston3d Products Version Detection (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800573);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("StoneTrip Ston3d Products Version Detection (Win)");
  desc = "
  Overview: This script detects the installed version of StoneTrip Ston3d
  products application and sets the version in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets KB for the version of StoneTrip Ston3d Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

sapVer = registry_get_sz(key:key + "Ston3D Standalone Engine", item:"DisplayVersion");
if(sapVer != NULL)
{
  set_kb_item(name:"Ston3D/Standalone/Player/Win/Ver", value:sapVer);
  security_note(data:"Ston3D Standalone Engine version " + sapVer +
                         " was detected on the host");
}

wpVer = registry_get_sz(key:key + "Ston3D Web Player", item:"DisplayVersion");
if(wpVer != NULL)
{
  set_kb_item(name:"Ston3D/Web/Player/Ver", value:wpVer);
  security_note(data:"Ston3D Web Player version " + wpVer +
                         " was detected on the host");
}
