###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_noticeware_mail_server_dos_vuln.nasl 1045 2009-02-24 17:20:29Z feb $
#
# NoticeWare Email Server Denial of Service Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900463);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_bugtraq_id(31697);
  script_cve_id("CVE-2008-6185");
  script_name("NoticeWare Mail Server Denial of Service Vulnerability");
  desc = "

  Overview: This host is running NoticeWare Mail Server and is prone to Denial
  of Service Vulnerability.

  Vulnerability Insight:
  This flaw is due to an error when handling multiple POP3 connections. The
  server can crash when handling large number of POP3 connections issuing
  login requests.

  Impact:
  Successful exploitation will let the attacker cause denial of service.

  Impact level: Application/Network

  Affected Software/OS:
  NoticeWare Mail Server version 5.1.2.2 and prior.

  Fix: Solution/patch not available as on 24th February 2009. For further
  updates refer, http://www.noticeware.com/noticemail.htm

  References:
  http://secunia.com/advisories/32202
  http://www.milw0rm.com/exploits/6719
  http://xforce.iss.net/xforce/xfdb/45812

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of NoticeWare Mail Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_noticeware_mail_server_detect.nasl");
  script_require_ports("Services/smtp", 25);
  script_require_keys("NoticeWare/Mail/Server/Ver");
  exit(0);
}


include("version_func.inc");

port = get_kb_item("Services/smtp");
if(!port){
  exit(0);
}

noticeVer = get_kb_item("NoticeWare/Mail/Server/Ver");
if(noticeVer != NULL)
{
  # Grep for NoticeWare Email Server version 5.1.2.2 or prior
  if(version_is_less_equal(version:noticeVer, test_version:"5.1.2.2"))
  {
    security_warning(port);
    exit(0);
  }
}
