# *Percona XtraBackup* 8.0.6

*Percona* is glad to announce the release of *Percona XtraBackup* 8.0.6 on May 9, 2019.
Downloads are available from our [download site](https://www.percona.com/downloads/Percona-XtraBackup-LATEST/) and
from apt and yum repositories.

*Percona XtraBackup* enables MySQL backups without blocking user queries, making
it ideal for companies with large data sets and mission-critical applications
that cannot tolerate long periods of downtime. Offered free as an open source
solution, it drives down backup costs while providing unique features for
*MySQL* backups.

In version 8.0.6, *Percona XtraBackup* introduces the support of the MyRocks
storage engine with Percona Server for MySQL version 8.0.15-6 or
higher.

*Percona XtraBackup* 8.0.6 enables saving backups to an Amazon S3,
MinIO, and Google Cloud Storage (using interoperability mode) when
using xbcloud. The following example demonstrates how to use an Amazon
S3 storage to make a full backup:

```
  $ xtrabackup --backup --stream=xbstream --extra-lsndir=/tmp --target-dir=/tmp | \
  xbcloud put --storage=s3 \
  --s3-endpoint='s3.amazonaws.com' \
  --s3-access-key='YOUR-ACCESSKEYID' \
  --s3-secret-key='YOUR-SECRETACCESSKEY' \
  --s3-bucket='mysql_backups'
  --parallel=10 \
  ${date -I}-full_backup

All *Percona* software is open-source and free
```

## New Features


* The MyRocks storage engine is now supported with *Percona XtraBackup*. More
information in [PXB-1754](https://jira.percona.com/browse/PXB-1754).


* Amazon S3 is now supported in xbcloud. More information in [PXB-1813](https://jira.percona.com/browse/PXB-1813).

## Bugs Fixed


* *Percona XtraBackup* could fail to restore the undo tablespace created during or before
incremental backup. Bug fixed [PXB-1780](https://jira.percona.com/browse/PXB-1780).


* A backup could fail if `log_bin_index` was defined in `my.cnf`. Bug
fixed [PXB-1801](https://jira.percona.com/browse/PXB-1801).


* When the row format was changed during the backup, xtrabackup could crash
during the incremental prepare stage. Bug fixed [PXB-1824](https://jira.percona.com/browse/PXB-1824).


* During the `prepare` phase, *Percona XtraBackup* could freeze and never finish
execution. Bug fixed [PXB-1819](https://jira.percona.com/browse/PXB-1819).


* *Percona XtraBackup* could crash during the `prepare` stage when making a backup of a
host running MySQL Server v8.0.16. Bug fixed [PXB-1839](https://jira.percona.com/browse/PXB-1839).

Other bugs fixed:
[PXB-1809](https://jira.percona.com/browse/PXB-1809),
[PXB-1810](https://jira.percona.com/browse/PXB-1810),
[PXB-1832](https://jira.percona.com/browse/PXB-1832),
[PXB-1837](https://jira.percona.com/browse/PXB-1837).
