/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "commandeidea.h"

Resultat commandeidea_initialisation(TRAVAIL(CommandeIdea) commandeidea)
{
	/* Cre une commande d'ide vide.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
	 */ 
	if((S_T(commandeidea)=(STOCKAGE(CommandeIdea))(malloc(SIZEOF(CONTENEUR(CommandeIdea)))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	CHAMP(commandeidea , localisation)=NULL;
	CHAMP(commandeidea , reference)=NULL;
	CHAMP(commandeidea , titre)=NULL;
	CHAMP(commandeidea , texte)=NULL;
	return RESULTAT_OK;
}

Resultat commandeidea_definition_localisationfichier(TRAVAIL(CommandeIdea) commandeidea , TRAVAIL(LocalisationFichier) localisationfichier)
{
	/* Indique la position d'une commande idea.
	 * Renvoie RESULTAT_ERREUR si commandeidea est NULL.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
	 */ 
	DEBUTZONESECURISEE
	if(S_T(commandeidea)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(localisationfichier_copie_commande(localisationfichier,CHAMP_TRAVAIL(commandeidea , localisation)));
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat commandeidea_definition_reference(TRAVAIL(CommandeIdea) commandeidea , TRAVAIL(Flux) reference)
{
	/* Assigne un nom de rfrence  une ide.
	 * Renvoie RESULTAT_ERREUR si commandeidea est NULL.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
	 */ 
	DEBUTZONESECURISEE
	if(S_T(commandeidea)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(flux_copie(reference,CHAMP_TRAVAIL(commandeidea , reference)));
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat commandeidea_definition_titre(TRAVAIL(CommandeIdea) commandeidea , TRAVAIL(Flux) titre)
{
	/* Assigne un titre  une ide.
	 * Renvoie RESULTAT_ERREUR si commandeidea est NULL.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
	 */ 
	DEBUTZONESECURISEE
	if(S_T(commandeidea)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(flux_copie(titre,CHAMP_TRAVAIL(commandeidea , titre)));
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat commandeidea_definition_texte(TRAVAIL(CommandeIdea) commandeidea , TRAVAIL(Flux) texte)
{
	/* Assigne un texte  une ide.
	 * Renvoie RESULTAT_ERREUR si commandeidea est NULL.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
	 */ 
	DEBUTZONESECURISEE
	if(S_T(commandeidea)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(flux_copie(texte,CHAMP_TRAVAIL(commandeidea , texte)));
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat commandeidea_lecture_localisationfichier(TRAVAIL(CommandeIdea) commandeidea , REFERENCE(LocalisationFichier) localisationfichier)
{
	/* Indique la position d'une commande idea.
	 * Renvoie RESULTAT_ERREUR si commandeidea est NULL.
	 */ 
	if(S_T(commandeidea)==NULL)
		return RESULTAT_ERREUR;
	T_R(localisationfichier)=CHAMP_TRAVAIL(commandeidea , localisation);
	return RESULTAT_OK;
}

Resultat commandeidea_lecture_reference(TRAVAIL(CommandeIdea) commandeidea , REFERENCE(Flux) reference)
{
	/* Lit un nom de rfrence  une ide.
	 * Renvoie RESULTAT_ERREUR si commandeidea est NULL.
	 */ 
	if(S_T(commandeidea)==NULL)
		return RESULTAT_ERREUR;
	T_R(reference)=CHAMP_TRAVAIL(commandeidea , reference);
	return RESULTAT_OK;
}

Resultat commandeidea_lecture_titre(TRAVAIL(CommandeIdea) commandeidea , REFERENCE(Flux) titre)
{
	/* Lit un titre  une ide.
	 * Renvoie RESULTAT_ERREUR si commandeidea est NULL.
	 */ 
	if(S_T(commandeidea)==NULL)
		return RESULTAT_ERREUR;
	T_R(titre)=CHAMP_TRAVAIL(commandeidea , titre);
	return RESULTAT_OK;
}

Resultat commandeidea_lecture_texte(TRAVAIL(CommandeIdea) commandeidea , REFERENCE(Flux) texte)
{
	/* Lit un texte  une ide.
	 * Renvoie RESULTAT_ERREUR si commandeidea est NULL.
	 */ 
	if(S_T(commandeidea)==NULL)
		return RESULTAT_ERREUR;
	T_R(texte)=CHAMP_TRAVAIL(commandeidea , texte);
	return RESULTAT_OK;
}

Resultat commandeidea_parcours(TRAVAIL(CommandeIdea) commandeidea , TRAVAIL(ActionFlux) action , TRAVAIL(General) general)
{
	/* Ralise un parcours des flux inclus dans la commande spcifie.
	 * Renvoie les mmes erreurs que flux_parcours,
	 * ainsi que RESULTAT_ERREUR si commande est NULL,
	 * rien ne se passe si action est NULL.
	 */
	DEBUTZONESECURISEE
	if(S_T(commandeidea)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(flux_parcours(CHAMP_TRAVAIL(commandeidea , reference),action,general));
	SECURISE(flux_parcours(CHAMP_TRAVAIL(commandeidea , titre),action,general));
	SECURISE(flux_parcours(CHAMP_TRAVAIL(commandeidea , texte),action,general));
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat commandeidea_copie(TRAVAIL(CommandeIdea) commandeidea , TRAVAIL(CommandeIdea) copie)
{
	/* Cre une copie de la commande idea.
	 * Renvoie RESULTAT_ERREUR si commandeidea est NULL, et
	 * RESULTAT_ERREUR_MEMOIRE si une allocation choue.
	 * Si la copie est non vide, elle est au pralable supprime.
	 */ 
	DEBUTZONESECURISEE
	if(S_T(commandeidea)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(commandeidea_destruction(copie));
	SECURISE(commandeidea_initialisation(copie));
	SECURISE(commandeidea_definition_localisationfichier(copie,CHAMP_TRAVAIL(commandeidea , localisation)));
	SECURISE(commandeidea_definition_reference(copie,CHAMP_TRAVAIL(commandeidea , reference)));
	SECURISE(commandeidea_definition_titre(copie,CHAMP_TRAVAIL(commandeidea , titre)));
	SECURISE(commandeidea_definition_texte(copie,CHAMP_TRAVAIL(commandeidea , texte)));
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat commandeidea_destruction(TRAVAIL(CommandeIdea) commandeidea)
{
	/* Dtruit une ide.
	 */ 
	DEBUTZONESECURISEE
	if(S_T(commandeidea)==NULL)
		return RESULTAT_OK;
	SECURISE(localisationfichier_destruction(CHAMP_TRAVAIL(commandeidea , localisation)));
	SECURISE(flux_destruction(CHAMP_TRAVAIL(commandeidea , reference)));
	SECURISE(flux_destruction(CHAMP_TRAVAIL(commandeidea , titre)));
	SECURISE(flux_destruction(CHAMP_TRAVAIL(commandeidea , texte)));
	free(S_T(commandeidea));
	S_T(commandeidea)=NULL;
	FINZONESECURISEE
	return RESULTAT_OK;
}

