#!/usr/bin/env python2
# -*- coding: utf-8 -*-
# -----------------------------------------------------------------------------
#
#  FreeType high-level python API - Copyright 2011-2012 Nicolas P. Rougier
#  Distributed under the terms of the new BSD license.
#
# -----------------------------------------------------------------------------
"""
Possible values of the language identifier field in the name records of the
TTF 'name' table if the 'platform' identifier code is TT_PLATFORM_MACINTOSH.

TT_MAC_LANGID_LATIN

TT_MAC_LANGID_MALAY_ARABIC_SCRIPT

TT_MAC_LANGID_HINDI

TT_MAC_LANGID_CATALAN

TT_MAC_LANGID_MARATHI

TT_MAC_LANGID_ICELANDIC

TT_MAC_LANGID_ARABIC

TT_MAC_LANGID_SWAHILI

TT_MAC_LANGID_KHMER

TT_MAC_LANGID_UKRAINIAN

TT_MAC_LANGID_FINNISH

TT_MAC_LANGID_POLISH

TT_MAC_LANGID_NEPALI

TT_MAC_LANGID_UZBEK

TT_MAC_LANGID_TELUGU

TT_MAC_LANGID_MALTESE

TT_MAC_LANGID_AFRIKAANS

TT_MAC_LANGID_CHEWA

TT_MAC_LANGID_BASQUE

TT_MAC_LANGID_CZECH

TT_MAC_LANGID_ROMANIAN

TT_MAC_LANGID_QUECHUA

TT_MAC_LANGID_TAGALOG

TT_MAC_LANGID_HUNGARIAN

TT_MAC_LANGID_AZERBAIJANI_CYRILLIC_SCRIPT

TT_MAC_LANGID_TONGAN

TT_MAC_LANGID_SUNDANESE

TT_MAC_LANGID_JAPANESE

TT_MAC_LANGID_MONGOLIAN

TT_MAC_LANGID_ALBANIAN

TT_MAC_LANGID_NORWEGIAN

TT_MAC_LANGID_SLOVAK

TT_MAC_LANGID_MALAGASY

TT_MAC_LANGID_DZONGKHA

TT_MAC_LANGID_DUTCH

TT_MAC_LANGID_MALAY_ROMAN_SCRIPT

TT_MAC_LANGID_SERBIAN

TT_MAC_LANGID_GERMAN

TT_MAC_LANGID_SOMALI

TT_MAC_LANGID_KOREAN

TT_MAC_LANGID_MONGOLIAN_MONGOLIAN_SCRIPT

TT_MAC_LANGID_CROATIAN

TT_MAC_LANGID_TURKISH

TT_MAC_LANGID_MOLDAVIAN

TT_MAC_LANGID_LAO

TT_MAC_LANGID_ORIYA

TT_MAC_LANGID_BRETON

TT_MAC_LANGID_PASHTO

TT_MAC_LANGID_GUARANI

TT_MAC_LANGID_HEBREW

TT_MAC_LANGID_SLOVENIAN

TT_MAC_LANGID_ESTONIAN

TT_MAC_LANGID_RUNDI

TT_MAC_LANGID_URDU

TT_MAC_LANGID_CHINESE_TRADITIONAL

TT_MAC_LANGID_TATAR

TT_MAC_LANGID_CHINESE_SIMPLIFIED

TT_MAC_LANGID_AZERBAIJANI_ARABIC_SCRIPT

TT_MAC_LANGID_SANSKRIT

TT_MAC_LANGID_KURDISH

TT_MAC_LANGID_FAEROESE

TT_MAC_LANGID_MONGOLIAN_CYRILLIC_SCRIPT

TT_MAC_LANGID_TIGRINYA

TT_MAC_LANGID_THAI

TT_MAC_LANGID_DANISH

TT_MAC_LANGID_KAZAKH

TT_MAC_LANGID_YIDDISH

TT_MAC_LANGID_ESPERANTO

TT_MAC_LANGID_LITHUANIAN

TT_MAC_LANGID_FARSI

TT_MAC_LANGID_LETTISH

TT_MAC_LANGID_VIETNAMESE

TT_MAC_LANGID_PORTUGUESE

TT_MAC_LANGID_IRISH

TT_MAC_LANGID_WELSH

TT_MAC_LANGID_PUNJABI

TT_MAC_LANGID_GREEK

TT_MAC_LANGID_INUKTITUT

TT_MAC_LANGID_FRENCH

TT_MAC_LANGID_GREEK_POLYTONIC

TT_MAC_LANGID_AZERBAIJANI

TT_MAC_LANGID_JAVANESE

TT_MAC_LANGID_SWEDISH

TT_MAC_LANGID_UIGHUR

TT_MAC_LANGID_BENGALI

TT_MAC_LANGID_RUANDA

TT_MAC_LANGID_SINDHI

TT_MAC_LANGID_TIBETAN

TT_MAC_LANGID_ENGLISH

TT_MAC_LANGID_SAAMISK

TT_MAC_LANGID_INDONESIAN

TT_MAC_LANGID_MANX_GAELIC

TT_MAC_LANGID_BYELORUSSIAN

TT_MAC_LANGID_BULGARIAN

TT_MAC_LANGID_GEORGIAN

TT_MAC_LANGID_AZERBAIJANI_ROMAN_SCRIPT

TT_MAC_LANGID_ITALIAN

TT_MAC_LANGID_SCOTTISH_GAELIC

TT_MAC_LANGID_ARMENIAN

TT_MAC_LANGID_GALLA

TT_MAC_LANGID_MACEDONIAN

TT_MAC_LANGID_IRISH_GAELIC

TT_MAC_LANGID_KIRGHIZ

TT_MAC_LANGID_TAMIL

TT_MAC_LANGID_SPANISH

TT_MAC_LANGID_BURMESE

TT_MAC_LANGID_KANNADA

TT_MAC_LANGID_GALICIAN

TT_MAC_LANGID_FLEMISH

TT_MAC_LANGID_TAJIKI

TT_MAC_LANGID_ASSAMESE

TT_MAC_LANGID_SINHALESE

TT_MAC_LANGID_GREELANDIC

TT_MAC_LANGID_AMHARIC

TT_MAC_LANGID_KASHMIRI

TT_MAC_LANGID_AYMARA

TT_MAC_LANGID_GUJARATI

TT_MAC_LANGID_RUSSIAN

TT_MAC_LANGID_TURKMEN

TT_MAC_LANGID_MALAYALAM
"""
TT_MAC_LANGIDS = {
    'TT_MAC_LANGID_ENGLISH'                    :   0,
    'TT_MAC_LANGID_FRENCH'                     :   1,
    'TT_MAC_LANGID_GERMAN'                     :   2,
    'TT_MAC_LANGID_ITALIAN'                    :   3,
    'TT_MAC_LANGID_DUTCH'                      :   4,
    'TT_MAC_LANGID_SWEDISH'                    :   5,
    'TT_MAC_LANGID_SPANISH'                    :   6,
    'TT_MAC_LANGID_DANISH'                     :   7,
    'TT_MAC_LANGID_PORTUGUESE'                 :   8,
    'TT_MAC_LANGID_NORWEGIAN'                  :   9,
    'TT_MAC_LANGID_HEBREW'                     :  10,
    'TT_MAC_LANGID_JAPANESE'                   :  11,
    'TT_MAC_LANGID_ARABIC'                     :  12,
    'TT_MAC_LANGID_FINNISH'                    :  13,
    'TT_MAC_LANGID_GREEK'                      :  14,
    'TT_MAC_LANGID_ICELANDIC'                  :  15,
    'TT_MAC_LANGID_MALTESE'                    :  16,
    'TT_MAC_LANGID_TURKISH'                    :  17,
    'TT_MAC_LANGID_CROATIAN'                   :  18,
    'TT_MAC_LANGID_CHINESE_TRADITIONAL'        :  19,
    'TT_MAC_LANGID_URDU'                       :  20,
    'TT_MAC_LANGID_HINDI'                      :  21,
    'TT_MAC_LANGID_THAI'                       :  22,
    'TT_MAC_LANGID_KOREAN'                     :  23,
    'TT_MAC_LANGID_LITHUANIAN'                 :  24,
    'TT_MAC_LANGID_POLISH'                     :  25,
    'TT_MAC_LANGID_HUNGARIAN'                  :  26,
    'TT_MAC_LANGID_ESTONIAN'                   :  27,
    'TT_MAC_LANGID_LETTISH'                    :  28,
    'TT_MAC_LANGID_SAAMISK'                    :  29,
    'TT_MAC_LANGID_FAEROESE'                   :  30,
    'TT_MAC_LANGID_FARSI'                      :  31,
    'TT_MAC_LANGID_RUSSIAN'                    :  32,
    'TT_MAC_LANGID_CHINESE_SIMPLIFIED'         :  33,
    'TT_MAC_LANGID_FLEMISH'                    :  34,
    'TT_MAC_LANGID_IRISH'                      :  35,
    'TT_MAC_LANGID_ALBANIAN'                   :  36,
    'TT_MAC_LANGID_ROMANIAN'                   :  37,
    'TT_MAC_LANGID_CZECH'                      :  38,
    'TT_MAC_LANGID_SLOVAK'                     :  39,
    'TT_MAC_LANGID_SLOVENIAN'                  :  40,
    'TT_MAC_LANGID_YIDDISH'                    :  41,
    'TT_MAC_LANGID_SERBIAN'                    :  42,
    'TT_MAC_LANGID_MACEDONIAN'                 :  43,
    'TT_MAC_LANGID_BULGARIAN'                  :  44,
    'TT_MAC_LANGID_UKRAINIAN'                  :  45,
    'TT_MAC_LANGID_BYELORUSSIAN'               :  46,
    'TT_MAC_LANGID_UZBEK'                      :  47,
    'TT_MAC_LANGID_KAZAKH'                     :  48,
    'TT_MAC_LANGID_AZERBAIJANI'                :  49,
    'TT_MAC_LANGID_AZERBAIJANI_CYRILLIC_SCRIPT':  49,
    'TT_MAC_LANGID_AZERBAIJANI_ARABIC_SCRIPT'  :  50,
    'TT_MAC_LANGID_ARMENIAN'                   :  51,
    'TT_MAC_LANGID_GEORGIAN'                   :  52,
    'TT_MAC_LANGID_MOLDAVIAN'                  :  53,
    'TT_MAC_LANGID_KIRGHIZ'                    :  54,
    'TT_MAC_LANGID_TAJIKI'                     :  55,
    'TT_MAC_LANGID_TURKMEN'                    :  56,
    'TT_MAC_LANGID_MONGOLIAN'                  :  57,
    'TT_MAC_LANGID_MONGOLIAN_MONGOLIAN_SCRIPT' :  57,
    'TT_MAC_LANGID_MONGOLIAN_CYRILLIC_SCRIPT'  :  58,
    'TT_MAC_LANGID_PASHTO'                     :  59,
    'TT_MAC_LANGID_KURDISH'                    :  60,
    'TT_MAC_LANGID_KASHMIRI'                   :  61,
    'TT_MAC_LANGID_SINDHI'                     :  62,
    'TT_MAC_LANGID_TIBETAN'                    :  63,
    'TT_MAC_LANGID_NEPALI'                     :  64,
    'TT_MAC_LANGID_SANSKRIT'                   :  65,
    'TT_MAC_LANGID_MARATHI'                    :  66,
    'TT_MAC_LANGID_BENGALI'                    :  67,
    'TT_MAC_LANGID_ASSAMESE'                   :  68,
    'TT_MAC_LANGID_GUJARATI'                   :  69,
    'TT_MAC_LANGID_PUNJABI'                    :  70,
    'TT_MAC_LANGID_ORIYA'                      :  71,
    'TT_MAC_LANGID_MALAYALAM'                  :  72,
    'TT_MAC_LANGID_KANNADA'                    :  73,
    'TT_MAC_LANGID_TAMIL'                      :  74,
    'TT_MAC_LANGID_TELUGU'                     :  75,
    'TT_MAC_LANGID_SINHALESE'                  :  76,
    'TT_MAC_LANGID_BURMESE'                    :  77,
    'TT_MAC_LANGID_KHMER'                      :  78,
    'TT_MAC_LANGID_LAO'                        :  79,
    'TT_MAC_LANGID_VIETNAMESE'                 :  80,
    'TT_MAC_LANGID_INDONESIAN'                 :  81,
    'TT_MAC_LANGID_TAGALOG'                    :  82,
    'TT_MAC_LANGID_MALAY_ROMAN_SCRIPT'         :  83,
    'TT_MAC_LANGID_MALAY_ARABIC_SCRIPT'        :  84,
    'TT_MAC_LANGID_AMHARIC'                    :  85,
    'TT_MAC_LANGID_TIGRINYA'                   :  86,
    'TT_MAC_LANGID_GALLA'                      :  87,
    'TT_MAC_LANGID_SOMALI'                     :  88,
    'TT_MAC_LANGID_SWAHILI'                    :  89,
    'TT_MAC_LANGID_RUANDA'                     :  90,
    'TT_MAC_LANGID_RUNDI'                      :  91,
    'TT_MAC_LANGID_CHEWA'                      :  92,
    'TT_MAC_LANGID_MALAGASY'                   :  93,
    'TT_MAC_LANGID_ESPERANTO'                  :  94,
    'TT_MAC_LANGID_WELSH'                      : 128,
    'TT_MAC_LANGID_BASQUE'                     : 129,
    'TT_MAC_LANGID_CATALAN'                    : 130,
    'TT_MAC_LANGID_LATIN'                      : 131,
    'TT_MAC_LANGID_QUECHUA'                    : 132,
    'TT_MAC_LANGID_GUARANI'                    : 133,
    'TT_MAC_LANGID_AYMARA'                     : 134,
    'TT_MAC_LANGID_TATAR'                      : 135,
    'TT_MAC_LANGID_UIGHUR'                     : 136,
    'TT_MAC_LANGID_DZONGKHA'                   : 137,
    'TT_MAC_LANGID_JAVANESE'                   : 138,
    'TT_MAC_LANGID_SUNDANESE'                  : 139,
    'TT_MAC_LANGID_GALICIAN'                   : 140,
    'TT_MAC_LANGID_AFRIKAANS'                  : 141,
    'TT_MAC_LANGID_BRETON'                     : 142,
    'TT_MAC_LANGID_INUKTITUT'                  : 143,
    'TT_MAC_LANGID_SCOTTISH_GAELIC'            : 144,
    'TT_MAC_LANGID_MANX_GAELIC'                : 145,
    'TT_MAC_LANGID_IRISH_GAELIC'               : 146,
    'TT_MAC_LANGID_TONGAN'                     : 147,
    'TT_MAC_LANGID_GREEK_POLYTONIC'            : 148,
    'TT_MAC_LANGID_GREELANDIC'                 : 149,
    'TT_MAC_LANGID_AZERBAIJANI_ROMAN_SCRIPT'   : 150 }
globals().update(TT_MAC_LANGIDS)


